/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.sta10.util;

import java.util.List;
import org.opengis.cite.sta10.util.EntityType;
import org.testng.Assert;

public class ServiceURLBuilder {
    public static String buildURLString(String rootURI, EntityType parentEntityType, long parentId, EntityType relationEntityType, String property) {
        Object urlString = rootURI;
        if (relationEntityType == null) {
            switch (parentEntityType) {
                case THING: {
                    urlString = (String)urlString + "/Things";
                    break;
                }
                case LOCATION: {
                    urlString = (String)urlString + "/Locations";
                    break;
                }
                case HISTORICAL_LOCATION: {
                    urlString = (String)urlString + "/HistoricalLocations";
                    break;
                }
                case DATASTREAM: {
                    urlString = (String)urlString + "/Datastreams";
                    break;
                }
                case SENSOR: {
                    urlString = (String)urlString + "/Sensors";
                    break;
                }
                case OBSERVATION: {
                    urlString = (String)urlString + "/Observations";
                    break;
                }
                case OBSERVED_PROPERTY: {
                    urlString = (String)urlString + "/ObservedProperties";
                    break;
                }
                case FEATURE_OF_INTEREST: {
                    urlString = (String)urlString + "/FeaturesOfInterest";
                    break;
                }
                default: {
                    Assert.fail("Entity type is not recognized in SensorThings API : " + parentEntityType);
                    return null;
                }
            }
            if (parentId != -1L) {
                urlString = (String)urlString + "(" + parentId + ")";
            }
        } else {
            block10 : switch (parentEntityType) {
                case THING: {
                    urlString = (String)urlString + "/Things(" + parentId + ")";
                    switch (relationEntityType) {
                        case LOCATION: {
                            urlString = (String)urlString + "/Locations";
                            break block10;
                        }
                        case HISTORICAL_LOCATION: {
                            urlString = (String)urlString + "/HistoricalLocations";
                            break block10;
                        }
                        case DATASTREAM: {
                            urlString = (String)urlString + "/Datastreams";
                            break block10;
                        }
                    }
                    Assert.fail("Entity type relation is not recognized in SensorThings API : " + parentEntityType + " and " + relationEntityType);
                    break;
                }
                case LOCATION: {
                    urlString = (String)urlString + "/Locations(" + parentId + ")";
                    switch (relationEntityType) {
                        case THING: {
                            urlString = (String)urlString + "/Things";
                            break block10;
                        }
                        case HISTORICAL_LOCATION: {
                            urlString = (String)urlString + "/HistoricalLocations";
                            break block10;
                        }
                    }
                    Assert.fail("Entity type relation is not recognized in SensorThings API : " + parentEntityType + " and " + relationEntityType);
                    break;
                }
                case HISTORICAL_LOCATION: {
                    urlString = (String)urlString + "/HistoricalLocations(" + parentId + ")";
                    switch (relationEntityType) {
                        case THING: {
                            urlString = (String)urlString + "/Thing";
                            break block10;
                        }
                        case LOCATION: {
                            urlString = (String)urlString + "/Locations";
                            break block10;
                        }
                    }
                    Assert.fail("Entity type relation is not recognized in SensorThings API : " + parentEntityType + " and " + relationEntityType);
                    break;
                }
                case DATASTREAM: {
                    urlString = (String)urlString + "/Datastreams(" + parentId + ")";
                    switch (relationEntityType) {
                        case THING: {
                            urlString = (String)urlString + "/Thing";
                            break block10;
                        }
                        case SENSOR: {
                            urlString = (String)urlString + "/Sensor";
                            break block10;
                        }
                        case OBSERVATION: {
                            urlString = (String)urlString + "/Observations";
                            break block10;
                        }
                        case OBSERVED_PROPERTY: {
                            urlString = (String)urlString + "/ObservedProperty";
                            break block10;
                        }
                    }
                    Assert.fail("Entity type relation is not recognized in SensorThings API : " + parentEntityType + " and " + relationEntityType);
                    break;
                }
                case SENSOR: {
                    urlString = (String)urlString + "/Sensors(" + parentId + ")";
                    switch (relationEntityType) {
                        case DATASTREAM: {
                            urlString = (String)urlString + "/Datastreams";
                            break block10;
                        }
                    }
                    Assert.fail("Entity type relation is not recognized in SensorThings API : " + parentEntityType + " and " + relationEntityType);
                    break;
                }
                case OBSERVATION: {
                    urlString = (String)urlString + "/Observations(" + parentId + ")";
                    switch (relationEntityType) {
                        case THING: 
                        case DATASTREAM: {
                            urlString = (String)urlString + "/Datastream";
                            break block10;
                        }
                        case FEATURE_OF_INTEREST: {
                            urlString = (String)urlString + "/FeatureOfInterest";
                            break block10;
                        }
                    }
                    Assert.fail("Entity type relation is not recognized in SensorThings API : " + parentEntityType + " and " + relationEntityType);
                    break;
                }
                case OBSERVED_PROPERTY: {
                    urlString = (String)urlString + "/ObservedProperties(" + parentId + ")";
                    switch (relationEntityType) {
                        case DATASTREAM: {
                            urlString = (String)urlString + "/Datastreams";
                            break block10;
                        }
                    }
                    Assert.fail("Entity type relation is not recognized in SensorThings API : " + parentEntityType + " and " + relationEntityType);
                    break;
                }
                case FEATURE_OF_INTEREST: {
                    urlString = (String)urlString + "/FeaturesOfInterest(" + parentId + ")";
                    switch (relationEntityType) {
                        case OBSERVATION: {
                            urlString = (String)urlString + "/Observations";
                            break block10;
                        }
                    }
                    Assert.fail("Entity type relation is not recognized in SensorThings API : " + parentEntityType + " and " + relationEntityType);
                    break;
                }
                default: {
                    Assert.fail("Entity type is not recognized in SensorThings API : " + parentEntityType);
                }
            }
        }
        if (property != null) {
            urlString = property.indexOf(63) >= 0 ? (String)urlString + property : (String)urlString + "/" + property;
        }
        return urlString;
    }

    public static String buildURLString(String rootURI, List<String> entityTypes, List<Long> ids, String property) {
        Object urlString = rootURI;
        if (entityTypes.size() != ids.size() && entityTypes.size() != ids.size() + 1) {
            Assert.fail("There is problem with the path of entities!!!");
        }
        if (((String)urlString).charAt(((String)urlString).length() - 1) != '/') {
            urlString = (String)urlString + "/";
        }
        for (int i = 0; i < entityTypes.size(); ++i) {
            urlString = (String)urlString + entityTypes.get(i);
            if (i >= ids.size()) continue;
            urlString = ids.get(i) == null ? (String)urlString + "/" : (String)urlString + "(" + ids.get(i) + ")/";
        }
        if (((String)urlString).charAt(((String)urlString).length() - 1) == '/') {
            urlString = ((String)urlString).substring(0, ((String)urlString).length() - 1);
        }
        if (property != null) {
            urlString = property.indexOf(63) >= 0 ? (String)urlString + property : (String)urlString + "/" + property;
        }
        return urlString;
    }
}

