/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.sta10.sensingCore;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.opengis.cite.sta10.SuiteAttribute;
import org.opengis.cite.sta10.util.EntityType;
import org.opengis.cite.sta10.util.HTTPMethods;
import org.opengis.cite.sta10.util.ServiceURLBuilder;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class Capability1Tests {
    public String rootUri;
    private final int resourcePathLevel = 4;

    @BeforeClass
    public void obtainTestSubject(ITestContext testContext) {
        Object obj = testContext.getSuite().getAttribute(SuiteAttribute.LEVEL.getName());
        if (null != obj) {
            Integer level = (Integer)Integer.class.cast(obj);
            Assert.assertTrue((level > 0 ? 1 : 0) != 0, (String)("Conformance level 1 will not be checked since ics = " + level));
        }
        this.rootUri = testContext.getSuite().getAttribute(SuiteAttribute.TEST_SUBJECT.getName()).toString();
        this.rootUri = this.rootUri.trim();
        if (this.rootUri.lastIndexOf(47) == this.rootUri.length() - 1) {
            this.rootUri = this.rootUri.substring(0, this.rootUri.length() - 1);
        }
    }

    @Test(description="GET Entities", groups={"level-1"})
    public void readEntitiesAndCheckResponse() {
        String response = this.getEntities(EntityType.THING);
        this.checkEntitiesAllAspectsForResponse(EntityType.THING, response);
        response = this.getEntities(EntityType.LOCATION);
        this.checkEntitiesAllAspectsForResponse(EntityType.LOCATION, response);
        response = this.getEntities(EntityType.HISTORICAL_LOCATION);
        this.checkEntitiesAllAspectsForResponse(EntityType.HISTORICAL_LOCATION, response);
        response = this.getEntities(EntityType.DATASTREAM);
        this.checkEntitiesAllAspectsForResponse(EntityType.DATASTREAM, response);
        response = this.getEntities(EntityType.SENSOR);
        this.checkEntitiesAllAspectsForResponse(EntityType.SENSOR, response);
        response = this.getEntities(EntityType.OBSERVATION);
        this.checkEntitiesAllAspectsForResponse(EntityType.OBSERVATION, response);
        response = this.getEntities(EntityType.OBSERVED_PROPERTY);
        this.checkEntitiesAllAspectsForResponse(EntityType.OBSERVED_PROPERTY, response);
        response = this.getEntities(EntityType.FEATURE_OF_INTEREST);
        this.checkEntitiesAllAspectsForResponse(EntityType.FEATURE_OF_INTEREST, response);
    }

    @Test(description="GET nonexistent Entity", groups={"level-1"})
    public void readNonexistentEntity() {
        this.readNonexistentEntityWithEntityType(EntityType.THING);
        this.readNonexistentEntityWithEntityType(EntityType.LOCATION);
        this.readNonexistentEntityWithEntityType(EntityType.HISTORICAL_LOCATION);
        this.readNonexistentEntityWithEntityType(EntityType.DATASTREAM);
        this.readNonexistentEntityWithEntityType(EntityType.SENSOR);
        this.readNonexistentEntityWithEntityType(EntityType.OBSERVATION);
        this.readNonexistentEntityWithEntityType(EntityType.OBSERVED_PROPERTY);
        this.readNonexistentEntityWithEntityType(EntityType.FEATURE_OF_INTEREST);
    }

    @Test(description="GET Specific Entity", groups={"level-1"})
    public void readEntityAndCheckResponse() {
        String response = this.readEntityWithEntityType(EntityType.THING);
        this.checkEntityAllAspectsForResponse(EntityType.THING, response);
        response = this.readEntityWithEntityType(EntityType.LOCATION);
        this.checkEntityAllAspectsForResponse(EntityType.LOCATION, response);
        response = this.readEntityWithEntityType(EntityType.HISTORICAL_LOCATION);
        this.checkEntityAllAspectsForResponse(EntityType.HISTORICAL_LOCATION, response);
        response = this.readEntityWithEntityType(EntityType.DATASTREAM);
        this.checkEntityAllAspectsForResponse(EntityType.DATASTREAM, response);
        response = this.readEntityWithEntityType(EntityType.SENSOR);
        this.checkEntityAllAspectsForResponse(EntityType.SENSOR, response);
        response = this.readEntityWithEntityType(EntityType.OBSERVATION);
        this.checkEntityAllAspectsForResponse(EntityType.OBSERVATION, response);
        response = this.readEntityWithEntityType(EntityType.OBSERVED_PROPERTY);
        this.checkEntityAllAspectsForResponse(EntityType.OBSERVED_PROPERTY, response);
        response = this.readEntityWithEntityType(EntityType.FEATURE_OF_INTEREST);
        this.checkEntityAllAspectsForResponse(EntityType.FEATURE_OF_INTEREST, response);
    }

    @Test(description="GET Property of an Entity", groups={"level-1"})
    public void readPropertyOfEntityAndCheckResponse() {
        this.readPropertyOfEntityWithEntityType(EntityType.THING);
        this.readPropertyOfEntityWithEntityType(EntityType.LOCATION);
        this.readPropertyOfEntityWithEntityType(EntityType.HISTORICAL_LOCATION);
        this.readPropertyOfEntityWithEntityType(EntityType.DATASTREAM);
        this.readPropertyOfEntityWithEntityType(EntityType.OBSERVED_PROPERTY);
        this.readPropertyOfEntityWithEntityType(EntityType.SENSOR);
        this.readPropertyOfEntityWithEntityType(EntityType.OBSERVATION);
        this.readPropertyOfEntityWithEntityType(EntityType.FEATURE_OF_INTEREST);
    }

    private void readPropertyOfEntityWithEntityType(EntityType entityType) {
        try {
            String response = this.getEntities(entityType);
            Long id = new JSONObject(response).getJSONArray("value").getJSONObject(0).getLong("@iot.id");
            for (String property : entityType.getProperties()) {
                this.checkGetPropertyOfEntity(entityType, id, property);
                this.checkGetPropertyValueOfEntity(entityType, id, property);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
            Assert.fail((String)("An Exception occurred during testing!:\n" + e.getMessage()));
        }
    }

    private void checkGetPropertyOfEntity(EntityType entityType, long id, String property) {
        try {
            Map<String, Object> responseMap = this.getEntity(entityType, id, property);
            int responseCode = Integer.parseInt(responseMap.get("response-code").toString());
            Assert.assertEquals((int)responseCode, (int)200, (String)("Reading property \"" + property + "\" of the existing " + entityType.name() + " with id " + id + " failed."));
            String response = responseMap.get("response").toString();
            JSONObject entity = null;
            entity = new JSONObject(response.toString());
            try {
                Assert.assertNotNull((Object)entity.get(property), (String)("Reading property \"" + property + "\"of \"" + entityType + "\" fails."));
            }
            catch (JSONException e) {
                Assert.fail((String)("Reading property \"" + property + "\"of \"" + entityType + "\" fails."));
            }
            Assert.assertEquals((int)entity.length(), (int)1, (String)("The response for getting property " + property + " of a " + entityType + " returns more properties!"));
        }
        catch (JSONException e) {
            e.printStackTrace();
            Assert.fail((String)("An Exception occurred during testing!:\n" + e.getMessage()));
        }
    }

    private void checkGetPropertyValueOfEntity(EntityType entityType, long id, String property) {
        Map<String, Object> responseMap = this.getEntity(entityType, id, property + "/$value");
        int responseCode = Integer.parseInt(responseMap.get("response-code").toString());
        Assert.assertEquals((int)responseCode, (int)200, (String)("Reading property value of \"" + property + "\" of the exitixting " + entityType.name() + " with id " + id + " failed."));
        String response = responseMap.get("response").toString();
        if (!(property.equals("location") || property.equals("feature") || property.equals("unitOfMeasurement"))) {
            Assert.assertEquals((int)response.indexOf("{"), (int)-1, (String)("Reading property value of \"" + property + "\"of \"" + entityType + "\" fails."));
        } else {
            Assert.assertEquals((int)response.indexOf("{"), (int)0, (String)("Reading property value of \"" + property + "\"of \"" + entityType + "\" fails."));
        }
    }

    @Test(description="Check Resource Path", groups={"level-1"})
    public void checkResourcePaths() {
        this.readRelatedEntityOfEntityWithEntityType(EntityType.THING);
        this.readRelatedEntityOfEntityWithEntityType(EntityType.LOCATION);
        this.readRelatedEntityOfEntityWithEntityType(EntityType.HISTORICAL_LOCATION);
        this.readRelatedEntityOfEntityWithEntityType(EntityType.DATASTREAM);
        this.readRelatedEntityOfEntityWithEntityType(EntityType.OBSERVED_PROPERTY);
        this.readRelatedEntityOfEntityWithEntityType(EntityType.SENSOR);
        this.readRelatedEntityOfEntityWithEntityType(EntityType.OBSERVATION);
        this.readRelatedEntityOfEntityWithEntityType(EntityType.FEATURE_OF_INTEREST);
    }

    private void readRelatedEntityOfEntityWithEntityType(EntityType entityType) {
        ArrayList<String> entityTypes = new ArrayList<String>();
        ArrayList<Long> ids = new ArrayList<Long>();
        entityTypes.add(entityType.plural);
        this.readRelatedEntity(entityTypes, ids);
    }

    private void readRelatedEntity(List<String> entityTypes, List<Long> ids) {
        if (entityTypes.size() > 4) {
            return;
        }
        try {
            Long id;
            String headName = entityTypes.get(entityTypes.size() - 1);
            EntityType headEntity = EntityType.getForRelation(headName);
            boolean isPlural = EntityType.isPlural(headName);
            String urlString = ServiceURLBuilder.buildURLString(this.rootUri, entityTypes, ids, null);
            Map<String, Object> responseMap = HTTPMethods.doGet(urlString);
            Assert.assertEquals((Object)responseMap.get("response-code"), (Object)200, (String)("Reading relation of the entity from request: " + urlString + " failed with type: " + entityTypes.toString()));
            String response = responseMap.get("response").toString();
            if (isPlural) {
                JSONArray jsonValueArray = new JSONObject(response).getJSONArray("value");
                if (jsonValueArray == null || jsonValueArray.length() == 0) {
                    Assert.fail((String)("Expecting a non-empty list for request: " + urlString));
                }
                id = jsonValueArray.getJSONObject(0).getLong("@iot.id");
            } else {
                id = new JSONObject(response).getLong("@iot.id");
            }
            urlString = ServiceURLBuilder.buildURLString(this.rootUri, entityTypes, ids, "$ref");
            responseMap = HTTPMethods.doGet(urlString);
            Assert.assertEquals((Object)responseMap.get("response-code"), (Object)200, (String)("Reading relation of the entity from request: " + urlString + " failed with type: " + entityTypes.toString()));
            response = responseMap.get("response").toString();
            this.checkAssociationLinks(response, entityTypes, ids);
            if (entityTypes.size() == 4) {
                return;
            }
            if (EntityType.isPlural(headName)) {
                ids.add(id);
            } else {
                ids.add(null);
            }
            for (String relation : headEntity.getRelations()) {
                entityTypes.add(relation);
                this.readRelatedEntity(entityTypes, ids);
                entityTypes.remove(entityTypes.size() - 1);
            }
            ids.remove(ids.size() - 1);
        }
        catch (JSONException e) {
            e.printStackTrace();
            Assert.fail((String)("An Exception occurred during testing!:\n" + e.getMessage()));
        }
    }

    private void checkAssociationLinks(String response, List<String> entityTypes, List<Long> ids) {
        block8: {
            try {
                if (EntityType.isPlural(entityTypes.get(entityTypes.size() - 1))) {
                    Assert.assertTrue((boolean)response.contains("value"), (String)("The GET entities Association Link response does not match SensorThings API : missing \"value\" in response.: " + entityTypes.toString() + ids.toString()));
                    JSONArray value = new JSONObject(response).getJSONArray("value");
                    int count = 0;
                    for (int i = 0; i < value.length() && count < 2; ++i) {
                        ++count;
                        JSONObject obj = value.getJSONObject(i);
                        try {
                            Assert.assertNotNull((Object)obj.get("@iot.selfLink"), (String)("The Association Link does not contain self-links.: " + entityTypes.toString() + ids.toString()));
                        }
                        catch (JSONException e) {
                            Assert.fail((String)("The Association Link does not contain self-links.: " + entityTypes.toString() + ids.toString()));
                        }
                        Assert.assertEquals((int)obj.length(), (int)1, (String)("The Association Link contains properties other than self-link.: " + entityTypes.toString() + ids.toString()));
                    }
                    break block8;
                }
                JSONObject obj = new JSONObject(response);
                try {
                    Assert.assertNotNull((Object)obj.get("@iot.selfLink"), (String)("The Association Link does not contain self-links.: " + entityTypes.toString() + ids.toString()));
                }
                catch (JSONException e) {
                    Assert.fail((String)("The Association Link does not contain self-links.: " + entityTypes.toString() + ids.toString()));
                }
                Assert.assertEquals((int)obj.length(), (int)1, (String)("The Association Link contains properties other than self-link.: " + entityTypes.toString() + ids.toString()));
            }
            catch (JSONException e) {
                e.printStackTrace();
                Assert.fail((String)("An Exception occurred during testing!:\n" + e.getMessage()));
            }
        }
    }

    private String readEntityWithEntityType(EntityType entityType) {
        try {
            String response = this.getEntities(entityType);
            Long id = new JSONObject(response.toString()).getJSONArray("value").getJSONObject(0).getLong("@iot.id");
            Map<String, Object> responseMap = this.getEntity(entityType, id, null);
            int responseCode = Integer.parseInt(responseMap.get("response-code").toString());
            Assert.assertEquals((int)responseCode, (int)200, (String)("Reading existing " + entityType.name() + " with id " + id + " failed."));
            response = responseMap.get("response").toString();
            return response;
        }
        catch (JSONException e) {
            e.printStackTrace();
            Assert.fail((String)("An Exception occurred during testing!:\n" + e.getMessage()));
            return null;
        }
    }

    private void readNonexistentEntityWithEntityType(EntityType entityType) {
        long id = Long.MAX_VALUE;
        int responseCode = Integer.parseInt(this.getEntity(entityType, id, null).get("response-code").toString());
        Assert.assertEquals((int)responseCode, (int)404, (String)("Reading non-existing " + entityType.name() + " with id " + id + " failed."));
    }

    @Test(description="Check Service Root UI", groups={"level-1"})
    public void checkServiceRootUri() {
        try {
            String response = this.getEntities(null);
            JSONObject jsonResponse = new JSONObject(response.toString());
            JSONArray entities = jsonResponse.getJSONArray("value");
            HashMap<String, Boolean> addedLinks = new HashMap<String, Boolean>();
            addedLinks.put("Things", false);
            addedLinks.put("Locations", false);
            addedLinks.put("HistoricalLocations", false);
            addedLinks.put("Datastreams", false);
            addedLinks.put("Sensors", false);
            addedLinks.put("Observations", false);
            addedLinks.put("ObservedProperties", false);
            addedLinks.put("FeaturesOfInterest", false);
            block26: for (int i = 0; i < entities.length(); ++i) {
                JSONObject entity = entities.getJSONObject(i);
                try {
                    Assert.assertNotNull((Object)entity.get("name"));
                    Assert.assertNotNull((Object)entity.get("url"));
                }
                catch (JSONException e) {
                    Assert.fail((String)"Service root URI does not have proper JSON keys: name and value.");
                }
                String name = entity.getString("name");
                String nameUrl = entity.getString("url");
                switch (name) {
                    case "Things": {
                        Assert.assertEquals((String)nameUrl, (String)(this.rootUri + "/Things"), (String)"The URL for Things in Service Root URI is not compliant to SensorThings API.");
                        addedLinks.remove("Things");
                        addedLinks.put(name, true);
                        continue block26;
                    }
                    case "Locations": {
                        Assert.assertEquals((String)nameUrl, (String)(this.rootUri + "/Locations"), (String)"The URL for Locations in Service Root URI is not compliant to SensorThings API.");
                        addedLinks.remove("Locations");
                        addedLinks.put(name, true);
                        continue block26;
                    }
                    case "HistoricalLocations": {
                        Assert.assertEquals((String)nameUrl, (String)(this.rootUri + "/HistoricalLocations"), (String)"The URL for HistoricalLocations in Service Root URI is not compliant to SensorThings API.");
                        addedLinks.remove("HistoricalLocations");
                        addedLinks.put(name, true);
                        continue block26;
                    }
                    case "Datastreams": {
                        Assert.assertEquals((String)nameUrl, (String)(this.rootUri + "/Datastreams"), (String)"The URL for Datastreams in Service Root URI is not compliant to SensorThings API.");
                        addedLinks.remove("Datastreams");
                        addedLinks.put(name, true);
                        continue block26;
                    }
                    case "Sensors": {
                        Assert.assertEquals((String)nameUrl, (String)(this.rootUri + "/Sensors"), (String)"The URL for Sensors in Service Root URI is not compliant to SensorThings API.");
                        addedLinks.remove("Sensors");
                        addedLinks.put(name, true);
                        continue block26;
                    }
                    case "Observations": {
                        Assert.assertEquals((String)nameUrl, (String)(this.rootUri + "/Observations"), (String)"The URL for Observations in Service Root URI is not compliant to SensorThings API.");
                        addedLinks.remove("Observations");
                        addedLinks.put(name, true);
                        continue block26;
                    }
                    case "ObservedProperties": {
                        Assert.assertEquals((String)nameUrl, (String)(this.rootUri + "/ObservedProperties"), (String)"The URL for ObservedProperties in Service Root URI is not compliant to SensorThings API.");
                        addedLinks.remove("ObservedProperties");
                        addedLinks.put(name, true);
                        continue block26;
                    }
                    case "FeaturesOfInterest": {
                        Assert.assertEquals((String)nameUrl, (String)(this.rootUri + "/FeaturesOfInterest"), (String)"The URL for FeaturesOfInterest in Service Root URI is not compliant to SensorThings API.");
                        addedLinks.remove("FeaturesOfInterest");
                        addedLinks.put(name, true);
                        continue block26;
                    }
                    case "MultiDatastreams": {
                        Assert.assertEquals((String)nameUrl, (String)(this.rootUri + "/MultiDatastreams"), (String)"The URL for MultiDatastreams in Service Root URI is not compliant to SensorThings API.");
                        continue block26;
                    }
                    default: {
                        Assert.fail((String)("There is a component in Service Root URI response that is not in SensorThings API : " + name));
                    }
                }
            }
            for (String key : addedLinks.keySet()) {
                Assert.assertTrue((boolean)((Boolean)addedLinks.get(key)), (String)("The Service Root URI response does not contain " + key));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("An Exception occurred during testing!:\n" + e.getMessage()));
        }
    }

    private String getEntities(EntityType entityType) {
        String urlString = this.rootUri;
        if (entityType != null) {
            urlString = ServiceURLBuilder.buildURLString(this.rootUri, entityType, -1L, null, null);
        }
        Map<String, Object> responseMap = HTTPMethods.doGet(urlString);
        String response = responseMap.get("response").toString();
        int responseCode = Integer.parseInt(responseMap.get("response-code").toString());
        Assert.assertEquals((int)responseCode, (int)200, (String)("Error during getting entities: " + (entityType != null ? entityType.name() : "root URI")));
        if (entityType != null) {
            Assert.assertTrue((response.indexOf("value") != -1 ? 1 : 0) != 0, (String)("The GET entities response for entity type \"" + entityType + "\" does not match SensorThings API : missing \"value\" in response."));
        } else {
            Assert.assertTrue((response.indexOf("value") != -1 ? 1 : 0) != 0, (String)"The GET entities response for service root URI does not match SensorThings API : missing \"value\" in response.");
        }
        return response.toString();
    }

    private Map<String, Object> getEntity(EntityType entityType, long id, String property) {
        if (id == -1L) {
            return null;
        }
        String urlString = ServiceURLBuilder.buildURLString(this.rootUri, entityType, id, null, property);
        return HTTPMethods.doGet(urlString);
    }

    private void checkEntitiesAllAspectsForResponse(EntityType entityType, String response) {
        this.checkEntitiesControlInformation(response);
        this.checkEntitiesProperties(entityType, response);
        this.checkEntitiesRelations(entityType, response);
    }

    private void checkEntityAllAspectsForResponse(EntityType entityType, String response) {
        this.checkEntityControlInformation(response);
        this.checkEntityProperties(entityType, response);
        this.checkEntityRelations(entityType, response);
    }

    private void checkEntitiesControlInformation(String response) {
        try {
            JSONObject jsonResponse = new JSONObject(response.toString());
            JSONArray entities = jsonResponse.getJSONArray("value");
            int count = 0;
            for (int i = 0; i < entities.length() && count < 2; ++count, ++i) {
                JSONObject entity = entities.getJSONObject(i);
                this.checkEntityControlInformation(entity);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
            Assert.fail((String)("An Exception occurred during testing!:\n" + e.getMessage()));
        }
    }

    private void checkEntityControlInformation(Object response) {
        try {
            JSONObject entity = new JSONObject(response.toString());
            try {
                Assert.assertNotNull((Object)entity.get("@iot.id"), (String)"The entity does not have mandatory control information : @iot.id");
            }
            catch (JSONException e) {
                Assert.fail((String)"The entity does not have mandatory control information : @iot.id");
            }
            try {
                Assert.assertNotNull((Object)entity.get("@iot.selfLink"), (String)"The entity does not have mandatory control information : @iot.selfLink");
            }
            catch (JSONException e) {
                Assert.fail((String)"The entity does not have mandatory control information : @iot.selfLink");
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
            Assert.fail((String)("An Exception occurred during testing!:\n" + e.getMessage()));
        }
    }

    private void checkEntitiesProperties(EntityType entityType, String response) {
        try {
            JSONObject jsonResponse = new JSONObject(response.toString());
            JSONArray entities = jsonResponse.getJSONArray("value");
            int count = 0;
            for (int i = 0; i < entities.length() && count < 2; ++count, ++i) {
                JSONObject entity = entities.getJSONObject(i);
                this.checkEntityProperties(entityType, entity);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
            Assert.fail((String)("An Exception occurred during testing!:\n" + e.getMessage()));
        }
    }

    private void checkEntityProperties(EntityType entityType, Object response) {
        try {
            JSONObject entity = new JSONObject(response.toString());
            for (String property : entityType.getProperties()) {
                try {
                    Assert.assertNotNull((Object)entity.get(property), (String)("Entity type \"" + entityType + "\" does not have mandatory property: \"" + property + "\"."));
                }
                catch (JSONException e) {
                    Assert.fail((String)("Entity type \"" + entityType + "\" does not have mandatory property: \"" + property + "\"."));
                }
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
            Assert.fail((String)("An Exception occurred during testing!:\n" + e.getMessage()));
        }
    }

    private void checkEntitiesRelations(EntityType entityType, String response) {
        try {
            JSONObject jsonResponse = new JSONObject(response);
            JSONArray entities = jsonResponse.getJSONArray("value");
            int count = 0;
            for (int i = 0; i < entities.length() && count < 2; ++count, ++i) {
                JSONObject entity = entities.getJSONObject(i);
                this.checkEntityRelations(entityType, entity);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
            Assert.fail((String)("An Exception occurred during testing!:\n" + e.getMessage() + " [Response] " + response.toString()));
        }
    }

    private void checkEntityRelations(EntityType entityType, Object response) {
        try {
            JSONObject entity = new JSONObject(response.toString());
            for (String relation : entityType.getRelations()) {
                try {
                    Assert.assertNotNull((Object)entity.get(relation + "@iot.navigationLink"), (String)("Entity type \"" + entityType + "\" does not have mandatory relation: \"" + relation + "\". [Response] " + response.toString()));
                }
                catch (JSONException e) {
                    Assert.fail((String)("Entity type \"" + entityType + "\" does not have mandatory relation: \"" + relation + "\". [Response] " + response.toString()));
                }
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
            Assert.fail((String)("An Exception occurred during testing!:\n" + e.getMessage() + " [Response] " + response.toString()));
        }
    }
}

