/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.swecommon20.level1;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.Validator;
import net.sf.saxon.s9api.SaxonApiException;
import org.apache.xerces.xs.XSModel;
import org.opengis.cite.swecommon20.SuiteAttribute;
import org.opengis.cite.swecommon20.util.NamespaceBindings;
import org.opengis.cite.swecommon20.util.ValidationUtils;
import org.opengis.cite.swecommon20.util.XMLUtils;
import org.opengis.cite.validation.XmlSchemaCompiler;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.annotations.BeforeClass;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class DataFixture {
    protected File dataFile;
    protected Document originalSubject;
    protected Document testSubject;
    protected URI testSubjectUri;
    protected String Resource_GML_Path = "/org/opengis/cite/swecommon20/xsd/opengis/gml/3.2.1/gml-3.2.1.xsd";
    protected String Resource_SWE_Path = "/org/opengis/cite/swecommon20/xsd/opengis/swe_2.0.1_flatten/swe_2.0.1.xsd";
    protected XSModel model;

    public Validator CreateValidator(URL xsdPath) throws XMLStreamException, SAXException, IOException {
        Set<URI> schemaRefs = ValidationUtils.extractSchemaReferences(new StreamSource(this.dataFile), this.testSubjectUri.toString());
        XmlSchemaCompiler xsdCompiler = new XmlSchemaCompiler(xsdPath);
        Schema schema = xsdCompiler.compileXmlSchema(schemaRefs.toArray(new URI[schemaRefs.size()]));
        return schema.newValidator();
    }

    public String CheckXPath2(String xpath) {
        Object xdmValue = null;
        try {
            xdmValue = XMLUtils.evaluateXPath2(new DOMSource(this.testSubject), xpath, NamespaceBindings.getStandardBindings());
        }
        catch (SaxonApiException e) {
            e.printStackTrace();
        }
        return xdmValue.toString();
    }

    @BeforeClass(alwaysRun=true)
    public void obtainTestSubject(ITestContext testContext) {
        Object uriObj;
        Assert.assertTrue(testContext.getSuite().getAttributeNames().contains(SuiteAttribute.XML.getName()), "No data to validate.");
        this.dataFile = (File)testContext.getSuite().getAttribute(SuiteAttribute.XML.getName());
        this.model = (XSModel)testContext.getSuite().getAttribute(SuiteAttribute.XSMODEL.getName());
        Object obj = testContext.getSuite().getAttribute(SuiteAttribute.TEST_SUBJECT.getName());
        if (null != obj && Document.class.isAssignableFrom(obj.getClass())) {
            this.testSubject = (Document)Document.class.cast(obj);
            this.originalSubject = (Document)Document.class.cast(obj);
        }
        if (null != (uriObj = testContext.getSuite().getAttribute(SuiteAttribute.TEST_SUBJECT_URI.getName()))) {
            this.testSubjectUri = (URI)URI.class.cast(uriObj);
        }
    }

    public void setDataFile(File dataFile) {
        this.dataFile = dataFile;
    }

    public void setSchemaModel(XSModel xsModel) {
        this.model = xsModel;
    }

    public String generateXPathExpression(List<QName> elemNames, Map<String, String> namespaceBindings) {
        StringBuilder xpath = new StringBuilder();
        ListIterator<QName> itr = elemNames.listIterator();
        while (itr.hasNext()) {
            QName qName = itr.next();
            String namespace = qName.getNamespaceURI();
            String prefix = namespaceBindings.get(namespace);
            if (null == prefix) {
                prefix = namespace.equals("http://www.opengis.net/swe/2.0") ? "swe" : "ns" + itr.previousIndex();
                namespaceBindings.put(namespace, prefix);
            }
            xpath.append("//").append(prefix).append(":");
            xpath.append(qName.getLocalPart());
            if (!itr.hasNext()) continue;
            xpath.append(" | ");
        }
        return xpath.toString();
    }
}

