/*
 * Decompiled with CFR 0.152.
 */
package com.occamlab.te.parsers;

import com.occamlab.te.ErrorHandlerImpl;
import com.occamlab.te.parsers.XmlErrorHandler;
import com.thaiopensource.util.PropertyMap;
import com.thaiopensource.util.PropertyMapBuilder;
import com.thaiopensource.validate.SchemaReader;
import com.thaiopensource.validate.SchemaReaderLoader;
import com.thaiopensource.validate.ValidateProperty;
import com.thaiopensource.validate.ValidationDriver;
import com.thaiopensource.validate.prop.schematron.SchematronProperty;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SchematronValidatingParser {
    private static final Logger LOGR = Logger.getLogger(SchematronValidatingParser.class.getName());
    private PropertyMapBuilder configPropBuilder = null;
    private String schemaLocation = null;
    private File schemaFile = null;
    private String phase = null;
    private String type = null;
    private PrintWriter outputLogger = null;
    public static final String SCHEMATRON_NS_URI = "http://www.ascc.net/xml/schematron";

    public SchematronValidatingParser() {
    }

    public SchematronValidatingParser(Document schema_link) throws Exception {
        this.getFileType(schema_link.getDocumentElement());
    }

    public String getFileType(Element schema_links) throws Exception {
        Document d = schema_links.getOwnerDocument();
        NodeList nodes = d.getElementsByTagNameNS("http://www.occamlab.com/te/parsers", "schema");
        String localType2 = null;
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element e = (Element)nodes.item(i);
            localType2 = e.getAttribute("type");
            this.type = e.getAttribute("type");
            this.phase = e.getAttribute("phase");
            this.schemaLocation = e.getTextContent().trim();
        }
        return localType2;
    }

    public InputStream DocumentToInputStream(Document edoc) throws IOException {
        final Document doc = edoc;
        final PipedOutputStream pos = new PipedOutputStream();
        PipedInputStream pis = new PipedInputStream();
        pis.connect(pos);
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    TransformerFactory tFactory = TransformerFactory.newInstance();
                    tFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
                    Transformer transformer = tFactory.newTransformer();
                    transformer.setOutputProperty("encoding", "ISO-8859-1");
                    transformer.setOutputProperty("indent", "yes");
                    transformer.transform(new DOMSource(doc), new StreamResult(pos));
                }
                catch (Exception _ex) {
                    throw new RuntimeException("Failed to tranform org.w3c.dom.Document to PipedOutputStream", _ex);
                }
                finally {
                    try {
                        pos.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }, "MyClassName.convert(org.w3c.dom.Document edoc)").start();
        return pis;
    }

    public boolean checkSchematronRules(Document doc, String schemaFile, String phase) throws Exception {
        boolean isValid;
        block4: {
            isValid = false;
            if (doc == null || doc.getDocumentElement() == null) {
                return isValid;
            }
            try {
                ClassLoader loader = this.getClass().getClassLoader();
                URL url = loader.getResource(schemaFile);
                this.schemaFile = new File(URLDecoder.decode(url.getFile(), "UTF-8"));
            }
            catch (Exception e) {
                if ($assertionsDisabled) break block4;
                throw new AssertionError((Object)("Entity body not found. " + e.toString()));
            }
        }
        this.phase = phase;
        Document returnDoc = this.parse(doc, null, null);
        if (returnDoc != null) {
            isValid = true;
        }
        return isValid;
    }

    public boolean checkSchematronRulesAdv(InputSource inputDoc, File schemaFile, String phase) throws Exception {
        boolean isValid = false;
        if (inputDoc == null) {
            return isValid;
        }
        this.schemaFile = schemaFile;
        this.phase = phase;
        Document returnDoc = this.parse(inputDoc, null, null);
        if (returnDoc != null) {
            isValid = true;
        }
        return isValid;
    }

    public boolean executeSchematronDriver(InputSource inputDoc, File schemaFile, String phase) {
        boolean isValid;
        block10: {
            isValid = false;
            ValidationDriver driver = this.createSchematronDriver(phase);
            assert (null != driver) : "Unable to create Schematron ValidationDriver";
            InputSource is = null;
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(schemaFile);
                is = new InputSource(fis);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                if (driver.loadSchema(is)) {
                    isValid = driver.validate(inputDoc);
                    fis.close();
                } else assert (false) : "Failed to load Schematron schema: " + schemaFile + "\nIs the schema valid? Is the phase defined?";
            }
            catch (SAXException e) {
                assert (false) : e.toString();
            }
            catch (IOException e) {
                if ($assertionsDisabled) break block10;
                throw new AssertionError((Object)e.toString());
            }
        }
        return isValid;
    }

    ValidationDriver createSchematronDriver(String phase) {
        SchemaReaderLoader loader = new SchemaReaderLoader();
        SchemaReader schReader = loader.createSchemaReader(SCHEMATRON_NS_URI);
        this.configPropBuilder = new PropertyMapBuilder();
        SchematronProperty.DIAGNOSE.add(this.configPropBuilder);
        if (this.outputLogger == null) {
            this.outputLogger = new PrintWriter(System.out);
        }
        if (null != phase && !phase.isEmpty()) {
            this.configPropBuilder.put(SchematronProperty.PHASE, phase);
        }
        ErrorHandlerImpl eh = new ErrorHandlerImpl("Schematron", this.outputLogger);
        this.configPropBuilder.put(ValidateProperty.ERROR_HANDLER, eh);
        ValidationDriver validator = new ValidationDriver(this.configPropBuilder.toPropertyMap(), schReader);
        return validator;
    }

    public Document parse(URLConnection uc, Element instruction, PrintWriter logger) throws Exception {
        return this.parse(uc.getInputStream(), instruction, logger);
    }

    Document parse(InputStream is, Element instruction, PrintWriter logger) throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        dbf.setExpandEntityReferences(false);
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = null;
        try {
            doc = db.parse(is);
        }
        catch (Exception e) {
            logger.println(e.getMessage());
        }
        return this.parse(doc, instruction, logger);
    }

    Document parse(InputSource is, Element instruction, PrintWriter logger) throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        dbf.setExpandEntityReferences(false);
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = null;
        try {
            doc = db.parse(is);
        }
        catch (Exception e) {
            logger.println(e.getMessage());
        }
        return this.parse(doc, instruction, logger);
    }

    Document parse(Document doc, Element instruction, PrintWriter logger) throws Exception {
        this.outputLogger = logger;
        if (instruction != null) {
            this.getFileType(instruction);
            if (this.type.equals("url")) {
                URL schemaURL = new URL(this.schemaLocation);
                this.schemaFile = new File(schemaURL.toURI());
            } else if (this.type.equals("file")) {
                this.schemaFile = new File(this.schemaLocation);
            } else if (this.type.equals("resource")) {
                URL url = this.getClass().getResource(this.schemaLocation);
                this.schemaFile = new File(URLDecoder.decode(url.getFile(), "UTF-8"));
            }
        }
        boolean isValid = false;
        if (doc != null) {
            InputSource xmlInputSource = null;
            try {
                InputStream inputStream = this.DocumentToInputStream(doc);
                xmlInputSource = new InputSource(inputStream);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            isValid = this.executeSchematronDriver(xmlInputSource, this.schemaFile, this.phase);
        }
        if (!isValid) {
            return null;
        }
        return doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeList validate(Document xmlEntity, String schemaRef, String phase) {
        if (xmlEntity == null || xmlEntity.getDocumentElement() == null) {
            throw new IllegalArgumentException("No XML entity supplied (null).");
        }
        InputSource xmlInputSource = null;
        try {
            InputStream inputStream = this.DocumentToInputStream(xmlEntity);
            xmlInputSource = new InputSource(inputStream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        PropertyMapBuilder builder = new PropertyMapBuilder();
        SchematronProperty.DIAGNOSE.add(builder);
        if (null != phase && !phase.isEmpty()) {
            builder.put(SchematronProperty.PHASE, phase);
        }
        XmlErrorHandler errHandler = new XmlErrorHandler();
        builder.put(ValidateProperty.ERROR_HANDLER, errHandler);
        ValidationDriver driver = this.createDriver(builder.toPropertyMap());
        InputStream schStream = this.getClass().getResourceAsStream(schemaRef.trim());
        try {
            InputSource input = new InputSource(schStream);
            try {
                boolean loaded = driver.loadSchema(input);
                if (!loaded) {
                    throw new Exception("Failed to load schema at " + schemaRef.trim() + "\nIs the schema valid? Is the phase defined?");
                }
            }
            finally {
                schStream.close();
            }
            driver.validate(xmlInputSource);
        }
        catch (Exception e) {
            throw new RuntimeException("Schematron validation failed.", e);
        }
        NodeList errList = errHandler.toNodeList();
        if (LOGR.isLoggable(Level.FINER)) {
            LOGR.finer(String.format("Found %d Schematron rule violation(s):%n %s", errList.getLength(), errHandler.toString()));
        }
        return errList;
    }

    ValidationDriver createDriver(PropertyMap configProps) {
        SchemaReaderLoader loader = new SchemaReaderLoader();
        SchemaReader schReader = loader.createSchemaReader(SCHEMATRON_NS_URI);
        ValidationDriver validator = new ValidationDriver(configProps, schReader);
        return validator;
    }
}

