/*
 * Decompiled with CFR 0.152.
 */
package com.occamlab.te.web;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;

public class CoverageMonitor {
    private static final Logger LOGR = Logger.getLogger(CoverageMonitor.class.getPackage().getName());
    private static final Map<URI, String> ICS_MAP = CoverageMonitor.createICSMap();
    private URI requestId;
    private Document coverageDoc;
    private File testSessionDir;

    public CoverageMonitor(String uri) {
        this.requestId = URI.create(uri);
        String icsPath = "/coverage/" + (String)ICS_MAP.get(this.requestId);
        try {
            DocumentBuilderFactory df = DocumentBuilderFactory.newInstance();
            df.setNamespaceAware(true);
            df.setExpandEntityReferences(false);
            DocumentBuilder docBuilder = df.newDocumentBuilder();
            InputStream is = this.getClass().getResourceAsStream(icsPath);
            this.coverageDoc = docBuilder.parse(is, null);
            is.close();
        }
        catch (Exception e) {
            LOGR.warning(e.getMessage());
        }
        LOGR.config("Created coverage monitor using ICS at " + icsPath);
    }

    private static Map<URI, String> createICSMap() {
        HashMap<URI, String> icsMap = new HashMap<URI, String>();
        icsMap.put(URI.create("urn:wms_client_test_suite/GetCapabilities"), "WMS-GetCapabilities.xml");
        icsMap.put(URI.create("urn:wms_client_test_suite/GetMap"), "WMS-GetMap.xml");
        icsMap.put(URI.create("urn:wms_client_test_suite/GetFeatureInfo"), "WMS-GetFeatureInfo.xml");
        return icsMap;
    }

    public File getTestSessionDir() {
        return this.testSessionDir;
    }

    public void setTestSessionDir(File sessionDir) {
        if (!sessionDir.isDirectory()) {
            throw new IllegalArgumentException("Not a directory: " + this.testSessionDir);
        }
        this.testSessionDir = sessionDir;
    }

    void inspectQuery(String query) {
        HashMap<String, String> qryParams = new HashMap<String, String>();
        for (String param : query.split("&")) {
            String[] nvp = param.split("=");
            if (nvp.length > 1) {
                qryParams.put(nvp[0].toLowerCase(), nvp[1]);
                continue;
            }
            qryParams.put(nvp[0].toLowerCase(), "");
        }
        String reqType = (String)qryParams.get("request");
        XPath xpath = XPathFactory.newInstance().newXPath();
        for (Map.Entry paramEntry : qryParams.entrySet()) {
            String[] paramValues = ((String)paramEntry.getValue()).split(",");
            for (int i = 0; i < paramValues.length; ++i) {
                String expr = String.format("//request[@name='%s']/param[@name='%s']/value[text() = '%s']", reqType, paramEntry.getKey(), paramValues[i]);
                NodeList result = null;
                try {
                    result = (NodeList)xpath.evaluate(expr, this.coverageDoc, XPathConstants.NODESET);
                }
                catch (XPathExpressionException xpe) {
                    LOGR.log(Level.WARNING, "Failed to evaluate expression " + expr, xpe);
                }
                if (null == result || result.getLength() <= 0) continue;
                for (int j = 0; j < result.getLength(); ++j) {
                    Node value = result.item(j);
                    Element param = (Element)value.getParentNode();
                    param.removeChild(value);
                    if (param.getElementsByTagName("value").getLength() != 0) continue;
                    Node request = param.getParentNode();
                    request.removeChild(param);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeCoverageResults() {
        File coverageFile = new File(this.testSessionDir, (String)ICS_MAP.get(this.requestId));
        if (coverageFile.exists()) {
            return;
        }
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(coverageFile, false);
            this.writeDocument((OutputStream)fos, this.coverageDoc);
        }
        catch (FileNotFoundException ioe) {
        }
        finally {
            try {
                if (fos != null) {
                    ((OutputStream)fos).close();
                    LOGR.config("Wrote coverage results to " + coverageFile.getCanonicalPath());
                }
            }
            catch (IOException ioe) {
                LOGR.warning(ioe.getMessage());
            }
        }
    }

    void writeDocument(OutputStream outStream, Document doc) {
        DOMImplementationRegistry domRegistry = null;
        try {
            domRegistry = DOMImplementationRegistry.newInstance();
            DOMImplementationLS impl = (DOMImplementationLS)((Object)domRegistry.getDOMImplementation("LS"));
            LSSerializer writer = impl.createLSSerializer();
            writer.getDomConfig().setParameter("xml-declaration", false);
            writer.getDomConfig().setParameter("format-pretty-print", true);
            LSOutput output = impl.createLSOutput();
            output.setEncoding("UTF-8");
            output.setByteStream(outStream);
            writer.write(doc, output);
        }
        catch (Exception e) {
            LOGR.warning(e.getMessage());
        }
    }
}

