/*
 * Decompiled with CFR 0.152.
 */
package com.occamlab.te.web;

import com.occamlab.te.util.DomUtils;
import com.occamlab.te.util.StringUtils;
import java.io.File;
import java.io.PrintStream;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TestSession {
    String sessionId;
    String sourcesName;
    String description;
    String suiteName = null;
    String currentDate;
    ArrayList<String> profiles = new ArrayList();

    public void save(File logdir) throws Exception {
        File sessionDir = new File(logdir, this.sessionId);
        sessionDir.mkdir();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd  HH:mm:ss");
        Date date = new Date();
        this.currentDate = dateFormat.format(date);
        PrintStream out = new PrintStream(new File(sessionDir, "session.xml"));
        out.println("<session id=\"" + this.sessionId + "\" sourcesId=\"" + this.sourcesName + "\" date=\"" + this.currentDate + "\"  >");
        out.println("<suite>" + this.suiteName + "</suite>");
        for (String profile : this.profiles) {
            out.println("<profile>" + profile + "</profile>");
        }
        String description_data = StringUtils.escapeXML(this.description);
        out.println("<description>" + description_data + "</description>");
        out.println("</session>");
        out.close();
    }

    public void load(File logdir, String sessionId) throws Exception {
        this.sessionId = sessionId;
        File sessionDir = new File(logdir, sessionId);
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        dbf.setExpandEntityReferences(false);
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.parse(new File(sessionDir, "session.xml"));
        Element session = (Element)doc.getElementsByTagName("session").item(0);
        this.setSourcesName(session.getAttribute("sourcesId"));
        if (null != session.getAttribute("date")) {
            this.setCurrentDate(session.getAttribute("date"));
        } else {
            this.setCurrentDate("");
        }
        Element suite = DomUtils.getElementByTagName(session, "suite");
        this.setSuiteName(suite.getTextContent());
        for (Element profile : DomUtils.getElementsByTagName(session, "profile")) {
            this.profiles.add(profile.getTextContent());
        }
        Element description = (Element)session.getElementsByTagName("description").item(0);
        this.description = description.getTextContent();
    }

    public List<TestSession> getSortedMap(List<TestSession> testData) {
        Collections.sort(testData, new /* Unavailable Anonymous Inner Class!! */);
        return testData;
    }

    public static Date convertStringToDate(String dateString) throws ParseException {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy/MM/dd  HH:mm:ss");
        Date date = ((DateFormat)formatter).parse(dateString);
        return date;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ArrayList<String> getProfiles() {
        return this.profiles;
    }

    public void setProfiles(ArrayList<String> profiles) {
        this.profiles = profiles;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public String getSourcesName() {
        return this.sourcesName;
    }

    public void setSourcesName(String sourcesName) {
        this.sourcesName = sourcesName;
    }

    public String getCurrentDate() {
        return this.currentDate;
    }

    public void setCurrentDate(String currentDate) {
        this.currentDate = currentDate;
    }

    public String getSuiteName() {
        return this.suiteName;
    }

    public void setSuiteName(String suiteName) {
        this.suiteName = suiteName;
    }
}

