/*
 * Decompiled with CFR 0.152.
 */
package com.occamlab.te.web.listeners;

import com.occamlab.te.SetupOptions;
import com.occamlab.te.realm.PasswordStorage;
import java.io.File;
import java.io.FileOutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.annotation.WebListener;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;

@WebListener
public class CleartextPasswordContextListener
implements ServletContextListener {
    private static final Logger LOGR = Logger.getLogger(CleartextPasswordContextListener.class.getPackage().getName());

    @Override
    public void contextDestroyed(ServletContextEvent evt) {
    }

    @Override
    public void contextInitialized(ServletContextEvent evt) {
        File usersDir = new File(SetupOptions.getBaseConfigDirectory(), "users");
        if (!usersDir.isDirectory()) {
            return;
        }
        DocumentBuilder domBuilder = null;
        try {
            domBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            LOGR.warning(e.getMessage());
            return;
        }
        DOMImplementationLS lsFactory = this.buildDOM3LoadAndSaveFactory();
        LSSerializer serializer = lsFactory.createLSSerializer();
        serializer.getDomConfig().setParameter("xml-declaration", Boolean.FALSE);
        serializer.getDomConfig().setParameter("format-pretty-print", Boolean.TRUE);
        LSOutput output = lsFactory.createLSOutput();
        output.setEncoding("UTF-8");
        for (File userDir : usersDir.listFiles()) {
            File userFile = new File(userDir, "user.xml");
            if (!userFile.isFile()) continue;
            try {
                Document doc = domBuilder.parse(userFile);
                Node pwNode = doc.getElementsByTagName("password").item(0);
                if (null == pwNode) continue;
                String password = pwNode.getTextContent();
                if (password.split(":").length == 5) break;
                pwNode.setTextContent(PasswordStorage.createHash(password));
                FileOutputStream os = new FileOutputStream(userFile, false);
                output.setByteStream(os);
                serializer.write(doc, output);
                os.close();
            }
            catch (Exception e) {
                LOGR.info(e.getMessage());
            }
        }
    }

    DOMImplementationLS buildDOM3LoadAndSaveFactory() {
        DOMImplementationLS factory = null;
        try {
            DOMImplementationRegistry domRegistry = DOMImplementationRegistry.newInstance();
            factory = (DOMImplementationLS)((Object)domRegistry.getDOMImplementation("LS 3.0"));
        }
        catch (Exception e) {
            LOGR.log(Level.WARNING, "Failed to create DOMImplementationLS", e);
        }
        return factory;
    }
}

