/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.core.reference;

import com.sun.org.apache.xml.internal.security.keys.content.x509.XMLX509IssuerSerial;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.core.ReferenceElement;
import com.sun.xml.wss.impl.XMLUtil;
import java.math.BigInteger;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import org.w3c.dom.Document;

public class X509IssuerSerial
extends ReferenceElement {
    private static Logger log = Logger.getLogger("javax.enterprise.resource.xml.webservices.security", "com.sun.xml.wss.logging.LogStrings");
    private XMLX509IssuerSerial delegate;
    private X509Certificate cert = null;
    private Document ownerDoc;

    public X509IssuerSerial(SOAPElement element) throws XWSSecurityException {
        Iterator serialNumbers;
        Iterator issuerNames;
        SOAPElement issuerSerialElement;
        boolean throwAnException = false;
        if (!element.getLocalName().equals("X509Data") || !XMLUtil.inSignatureNS(element)) {
            throwAnException = true;
        }
        try {
            issuerSerialElement = (SOAPElement)element.getChildElements(soapFactory.createName("X509IssuerSerial", "ds", "http://www.w3.org/2000/09/xmldsig#")).next();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "WSS0750.soap.exception", new Object[]{"ds:X509IssuerSerial", e.getMessage()});
            throw new XWSSecurityException(e);
        }
        try {
            issuerNames = issuerSerialElement.getChildElements(soapFactory.createName("X509IssuerName", "ds", "http://www.w3.org/2000/09/xmldsig#"));
        }
        catch (SOAPException e) {
            log.log(Level.SEVERE, "WSS0758.soap.exception", new Object[]{"ds:X509IssuerName", e.getMessage()});
            throw new XWSSecurityException(e);
        }
        if (!issuerNames.hasNext()) {
            throwAnException = true;
        }
        SOAPElement issuerNameElement = (SOAPElement)issuerNames.next();
        String issuerName = XMLUtil.getFullTextFromChildren(issuerNameElement);
        try {
            serialNumbers = issuerSerialElement.getChildElements(soapFactory.createName("X509SerialNumber", "ds", "http://www.w3.org/2000/09/xmldsig#"));
        }
        catch (SOAPException e) {
            log.log(Level.SEVERE, "WSS0758.soap.exception", new Object[]{"ds:X509SerialNumber", e.getMessage()});
            throw new XWSSecurityException(e);
        }
        if (!serialNumbers.hasNext()) {
            throwAnException = true;
        }
        SOAPElement serialNumberElement = (SOAPElement)serialNumbers.next();
        String serialNumberString = XMLUtil.getFullTextFromChildren(serialNumberElement);
        BigInteger serialNumber = new BigInteger(serialNumberString);
        if (throwAnException) {
            log.log(Level.SEVERE, "WSS0759.error.creating.issuerserial");
            throw new XWSSecurityException("Cannot create X509IssuerSerial object out of given element");
        }
        this.ownerDoc = element.getOwnerDocument();
        this.delegate = new XMLX509IssuerSerial(this.ownerDoc, issuerName, serialNumber);
    }

    public X509IssuerSerial(Document doc, String X509IssuerName, BigInteger X509SerialNumber) {
        this.delegate = new XMLX509IssuerSerial(doc, X509IssuerName, X509SerialNumber);
        this.ownerDoc = doc;
    }

    public X509IssuerSerial(Document doc, String X509IssuerName, String X509SerialNumber) {
        this.delegate = new XMLX509IssuerSerial(doc, X509IssuerName, X509SerialNumber);
        this.ownerDoc = doc;
    }

    public X509IssuerSerial(Document doc, String X509IssuerName, int X509SerialNumber) {
        this.delegate = new XMLX509IssuerSerial(doc, X509IssuerName, X509SerialNumber);
        this.ownerDoc = doc;
    }

    public X509IssuerSerial(Document doc, X509Certificate x509certificate) {
        this.delegate = new XMLX509IssuerSerial(doc, x509certificate);
        this.ownerDoc = doc;
    }

    public BigInteger getSerialNumber() throws XWSSecurityException {
        try {
            return this.delegate.getSerialNumber();
        }
        catch (Exception e) {
            throw new XWSSecurityException(e);
        }
    }

    public int getSerialNumberInteger() throws XWSSecurityException {
        try {
            return this.delegate.getSerialNumberInteger();
        }
        catch (Exception e) {
            throw new XWSSecurityException(e);
        }
    }

    public String getIssuerName() throws XWSSecurityException {
        try {
            return this.delegate.getIssuerName();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "WSS0763.exception.issuername", new Object[]{e.getMessage()});
            throw new XWSSecurityException(e);
        }
    }

    @Override
    public SOAPElement getAsSoapElement() throws XWSSecurityException {
        try {
            SOAPElement issuerSerialElement = (SOAPElement)this.delegate.getElement();
            SOAPElement x509DataElement = (SOAPElement)this.ownerDoc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:X509Data");
            x509DataElement.addNamespaceDeclaration("ds", "http://www.w3.org/2000/09/xmldsig#");
            x509DataElement.addChildElement(issuerSerialElement);
            this.setSOAPElement(x509DataElement);
            return x509DataElement;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "WSS0750.soap.exception", new Object[]{"ds:X509IssuerSerial", e.getMessage()});
            throw new XWSSecurityException(e);
        }
    }

    public void setCertificate(X509Certificate cert) {
        this.cert = cert;
    }

    public X509Certificate getCertificate() {
        return this.cert;
    }
}

