/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.pattern;

import com.thaiopensource.relaxng.pattern.BuiltinDatatypeLibrary;
import com.thaiopensource.relaxng.pattern.CompatibilityDatatypeLibrary;
import java.util.HashMap;
import java.util.Map;
import org.relaxng.datatype.DatatypeLibrary;
import org.relaxng.datatype.DatatypeLibraryFactory;

class BuiltinDatatypeLibraryFactory
implements DatatypeLibraryFactory {
    private final Map<String, DatatypeLibrary> cache = new HashMap<String, DatatypeLibrary>();
    private final DatatypeLibraryFactory factory;
    private final DatatypeLibrary builtinDatatypeLibrary = new BuiltinDatatypeLibrary();
    private DatatypeLibrary lastDatatypeLibrary = null;
    private String lastDatatypeLibraryUri = null;

    BuiltinDatatypeLibraryFactory(DatatypeLibraryFactory datatypeLibraryFactory) {
        this.factory = datatypeLibraryFactory;
        this.cache.put("http://relaxng.org/ns/compatibility/datatypes/1.0", new CompatibilityDatatypeLibrary(this));
    }

    public DatatypeLibrary createDatatypeLibrary(String string2) {
        if (string2.equals("")) {
            return this.builtinDatatypeLibrary;
        }
        if (string2.equals(this.lastDatatypeLibraryUri)) {
            return this.lastDatatypeLibrary;
        }
        DatatypeLibrary datatypeLibrary = this.cache.get(string2);
        if (datatypeLibrary == null) {
            if (this.factory == null) {
                return null;
            }
            datatypeLibrary = this.factory.createDatatypeLibrary(string2);
            if (datatypeLibrary == null) {
                return null;
            }
            this.cache.put(string2, datatypeLibrary);
        }
        this.lastDatatypeLibraryUri = string2;
        this.lastDatatypeLibrary = datatypeLibrary;
        return this.lastDatatypeLibrary;
    }
}

