/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.catalog.types;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.catalog.types.BaseTypeIdImpl;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.util.IdUtil;

public class UserDefinedTypeIdImpl
extends BaseTypeIdImpl {
    protected String className;

    public UserDefinedTypeIdImpl() {
    }

    public UserDefinedTypeIdImpl(String string2) throws StandardException {
        if (string2.charAt(0) == '\"') {
            String[] stringArray = IdUtil.parseMultiPartSQLIdentifier(string2);
            this.schemaName = stringArray[0];
            this.unqualifiedName = stringArray[1];
            string2 = null;
        } else {
            this.schemaName = null;
            this.unqualifiedName = string2;
            this.className = string2;
        }
        this.JDBCTypeId = 2000;
    }

    public UserDefinedTypeIdImpl(String string2, String string3, String string4) {
        super(string2, string3);
        this.className = string4;
        this.JDBCTypeId = 2000;
    }

    public String getClassName() {
        return this.className;
    }

    public boolean userType() {
        return true;
    }

    public boolean isBound() {
        return this.className != null;
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        this.className = objectInput.readUTF();
        this.JDBCTypeId = 2000;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        if (this.className == null) {
            throw new IOException("Internal error: class name for user defined type has not been determined yet.");
        }
        objectOutput.writeUTF(this.className);
    }

    public int getTypeFormatId() {
        return 264;
    }
}

