/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.bytecode;

import java.io.IOException;
import java.util.Arrays;
import org.apache.derby.iapi.services.classfile.CONSTANT_Index_info;
import org.apache.derby.iapi.services.classfile.CONSTANT_Utf8_info;
import org.apache.derby.iapi.services.classfile.ClassFormatOutput;
import org.apache.derby.iapi.services.classfile.ClassHolder;
import org.apache.derby.iapi.services.classfile.ClassMember;
import org.apache.derby.iapi.services.io.ArrayOutputStream;
import org.apache.derby.impl.services.bytecode.BCClass;
import org.apache.derby.impl.services.bytecode.BCMethod;

final class CodeChunk {
    private static final int CODE_OFFSET = 8;
    static final short[] LOAD_VARIABLE = new short[]{21, 21, 21, 22, 23, 24, 21, 25};
    static final short[] LOAD_VARIABLE_FAST = new short[]{26, 26, 26, 30, 34, 38, 26, 42};
    static final short[] STORE_VARIABLE = new short[]{54, 54, 54, 55, 56, 57, 54, 58};
    static final short[] STORE_VARIABLE_FAST = new short[]{59, 59, 59, 63, 67, 71, 59, 75};
    static final short[] ARRAY_ACCESS = new short[]{51, 53, 46, 47, 48, 49, 52, 50};
    static final short[] ARRAY_STORE = new short[]{84, 86, 79, 80, 81, 82, 85, 83};
    static final short[] RETURN_OPCODE = new short[]{172, 172, 172, 173, 174, 175, 172, 176};
    static final short[][][] CAST_CONVERSION_INFO = new short[][][]{new short[][]{{0, 0}, {0, 1}, {0, 2}, {0, 2}, {0, 2}, {0, 2}, {0, 6}, {-999, 7}}, new short[][]{{0, 0}, {0, 1}, {0, 2}, {0, 2}, {0, 2}, {0, 2}, {0, 6}, {-999, 7}}, new short[][]{{145, 0}, {147, 1}, {0, 2}, {133, 3}, {134, 4}, {135, 5}, {145, 6}, {-999, 7}}, new short[][]{{136, 2}, {136, 2}, {136, 2}, {0, 3}, {137, 4}, {138, 5}, {136, 2}, {-999, 7}}, new short[][]{{139, 2}, {139, 2}, {139, 2}, {140, 3}, {0, 4}, {141, 5}, {139, 2}, {-999, 7}}, new short[][]{{142, 2}, {142, 2}, {142, 2}, {143, 3}, {144, 4}, {0, 5}, {142, 2}, {-999, 7}}, new short[][]{{0, 0}, {0, 1}, {0, 2}, {0, 2}, {0, 2}, {0, 2}, {0, 6}, {-999, 7}}, new short[][]{{-999, 0}, {-999, 1}, {-999, 2}, {-999, 3}, {-999, 4}, {-999, 5}, {-999, 6}, {0, 7}}};
    private static final byte[] push1_1i = new byte[]{1, 1};
    private static final byte[] push2_1i = new byte[]{2, 1};
    private static final byte[] NS = new byte[]{0, -1};
    private static final byte VARIABLE_STACK = -128;
    private static final byte[][] OPCODE_ACTION = new byte[][]{{0, 1}, push1_1i, push1_1i, push1_1i, push1_1i, push1_1i, push1_1i, push1_1i, push1_1i, push2_1i, push2_1i, push1_1i, push1_1i, push1_1i, push2_1i, push2_1i, {1, 2}, {1, 3}, {1, 2}, {1, 3}, {2, 3}, {1, 2}, {2, 2}, {1, 2}, {2, 2}, {1, 2}, push1_1i, push1_1i, push1_1i, push1_1i, push2_1i, push2_1i, push2_1i, push2_1i, push1_1i, push1_1i, push1_1i, push1_1i, push2_1i, push2_1i, push2_1i, push2_1i, push1_1i, push1_1i, push1_1i, push1_1i, {-1, 1}, {0, 1}, {-1, 1}, {0, 1}, {-1, 1}, {-1, 1}, {-1, 1}, {-1, 1}, {-1, 2}, {-2, 2}, {-1, 2}, {-2, 2}, {-1, 2}, {-1, 1}, {-1, 1}, {-1, 1}, {-1, 1}, {-2, 1}, {-2, 1}, {-2, 1}, {-2, 1}, {-1, 1}, {-1, 1}, {-1, 1}, {-1, 1}, {-2, 1}, {-2, 1}, {-2, 1}, {-2, 1}, {-1, 1}, {-1, 1}, {-1, 1}, {-1, 1}, {-3, 1}, {-4, 1}, {-3, 1}, {-4, 1}, {-3, 1}, {-3, 1}, {-3, 1}, {-3, 1}, {-1, 1}, {-2, 1}, push1_1i, push1_1i, push1_1i, push2_1i, push2_1i, push2_1i, {0, 1}, NS, NS, {-1, 1}, {-2, 1}, NS, NS, {-1, 1}, {-2, 1}, NS, NS, {-1, 1}, {-2, 1}, NS, NS, {-1, 1}, {-2, 1}, {-1, 1}, {-2, 1}, {-1, 1}, {-2, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {-1, 1}, NS, NS, NS, NS, NS, {-1, 1}, NS, {-1, 1}, NS, NS, NS, NS, push1_1i, {0, 1}, push1_1i, {-1, 1}, {-1, 1}, {0, 1}, {0, 1}, push2_1i, push1_1i, {-1, 1}, {0, 1}, {-1, 1}, {0, 1}, {0, 1}, {0, 1}, NS, {-1, 1}, {-1, 1}, {-3, 1}, {-3, 1}, {-1, 3}, {-1, 3}, {-1, 3}, {-1, 3}, {-1, 3}, {-1, 3}, NS, NS, NS, NS, NS, NS, NS, NS, {0, 3}, NS, NS, NS, NS, {-1, 1}, {-2, 1}, {-1, 1}, {-2, 1}, {-1, 1}, {0, 1}, {-128, 3}, {-128, 3}, {-128, 3}, {-128, 3}, {-128, 3}, {-128, 3}, {-128, 3}, {-128, 5}, NS, {1, 3}, {0, 2}, {0, 3}, {0, 1}, NS, {0, 3}, {0, 3}, NS, NS, NS, NS, {-1, 3}, {-1, 3}, {0, 5}, NS, NS};
    private final int pcDelta;
    final BCClass cb;
    private final ClassFormatOutput cout;

    private void limitHit(IOException iOException) {
        this.cb.addLimitExceeded(iOException.toString());
    }

    void addInstr(short s) {
        try {
            this.cout.putU1(s);
        }
        catch (IOException iOException) {
            this.limitHit(iOException);
        }
    }

    void addInstrU2(short s, int n) {
        try {
            this.cout.putU1(s);
            this.cout.putU2(n);
        }
        catch (IOException iOException) {
            this.limitHit(iOException);
        }
    }

    void addInstrU4(short s, int n) {
        try {
            this.cout.putU1(s);
            this.cout.putU4(n);
        }
        catch (IOException iOException) {
            this.limitHit(iOException);
        }
    }

    void addInstrU1(short s, int n) {
        try {
            this.cout.putU1(s);
            this.cout.putU1(n);
        }
        catch (IOException iOException) {
            this.limitHit(iOException);
        }
    }

    void addInstrCPE(short s, int n) {
        if (n < 256) {
            this.addInstrU1(s, n);
        } else {
            this.addInstrU2((short)(s + 1), n);
        }
    }

    void addInstrWide(short s, int n) {
        if (n < 256) {
            this.addInstrU1(s, n);
        } else {
            this.addInstr((short)196);
            this.addInstrU2(s, n);
        }
    }

    void addInstrU2U1U1(short s, int n, short s2, short s3) {
        try {
            this.cout.putU1(s);
            this.cout.putU2(n);
            this.cout.putU1(s2);
            this.cout.putU1(s3);
        }
        catch (IOException iOException) {
            this.limitHit(iOException);
        }
    }

    int getPC() {
        return this.cout.size() + this.pcDelta;
    }

    private static int instructionLength(short s) {
        byte by = OPCODE_ACTION[s][1];
        return by;
    }

    CodeChunk(BCClass bCClass) {
        this.cb = bCClass;
        this.cout = new ClassFormatOutput();
        try {
            this.cout.putU2(0);
            this.cout.putU2(0);
            this.cout.putU4(0);
        }
        catch (IOException iOException) {
            this.limitHit(iOException);
        }
        this.pcDelta = -8;
    }

    private CodeChunk(CodeChunk codeChunk, int n, int n2) {
        this.cb = codeChunk.cb;
        ArrayOutputStream arrayOutputStream = new ArrayOutputStream(codeChunk.cout.getData());
        try {
            arrayOutputStream.setPosition(8 + n);
            arrayOutputStream.setLimit(n2);
        }
        catch (IOException iOException) {
            this.limitHit(iOException);
        }
        this.cout = new ClassFormatOutput(arrayOutputStream);
        this.pcDelta = n;
    }

    private void fixLengths(BCMethod bCMethod, int n, int n2, int n3) {
        byte[] byArray = this.cout.getData();
        if (bCMethod != null && n > 65535) {
            this.cb.addLimitExceeded(bCMethod, "max_stack", 65535, n);
        }
        byArray[0] = (byte)(n >> 8);
        byArray[1] = (byte)n;
        if (bCMethod != null && n2 > 65535) {
            this.cb.addLimitExceeded(bCMethod, "max_locals", 65535, n2);
        }
        byArray[2] = (byte)(n2 >> 8);
        byArray[3] = (byte)n2;
        if (bCMethod != null && n3 > 65535) {
            this.cb.addLimitExceeded(bCMethod, "code_length", 65535, n3);
        }
        byArray[4] = (byte)(n3 >> 24);
        byArray[5] = (byte)(n3 >> 16);
        byArray[6] = (byte)(n3 >> 8);
        byArray[7] = (byte)n3;
    }

    void complete(BCMethod bCMethod, ClassHolder classHolder, ClassMember classMember, int n, int n2) {
        int n3 = this.getPC();
        ClassFormatOutput classFormatOutput = this.cout;
        try {
            classFormatOutput.putU2(0);
            classFormatOutput.putU2(0);
        }
        catch (IOException iOException) {
            this.limitHit(iOException);
        }
        this.fixLengths(bCMethod, n, n2, n3);
        classMember.addAttribute("Code", classFormatOutput);
    }

    short getOpcode(int n) {
        return (short)(this.cout.getData()[8 + n] & 0xFF);
    }

    private int getU2(int n) {
        byte[] byArray = this.cout.getData();
        int n2 = 8 + n + 1;
        return (byArray[n2] & 0xFF) << 8 | byArray[n2 + 1] & 0xFF;
    }

    private int getU4(int n) {
        byte[] byArray = this.cout.getData();
        int n2 = 8 + n + 1;
        return (byArray[n2] & 0xFF) << 24 | (byArray[n2 + 1] & 0xFF) << 16 | (byArray[n2 + 2] & 0xFF) << 8 | byArray[n2 + 3] & 0xFF;
    }

    CodeChunk insertCodeSpace(int n, int n2) {
        short s = this.getOpcode(n);
        int n3 = CodeChunk.instructionLength(s);
        if (n2 > 0) {
            int n4 = this.getPC() - n - n3;
            for (int i = 0; i < n2; ++i) {
                this.addInstr((short)0);
            }
            byte[] byArray = this.cout.getData();
            int n5 = 8 + n + n3;
            System.arraycopy(byArray, n5, byArray, n5 + n2, n4);
            Arrays.fill(byArray, n5, n5 + n2, (byte)0);
        }
        return new CodeChunk(this, n, n2 += n3);
    }

    private int findMaxStack(ClassHolder classHolder, int n, int n2) {
        int n3 = n + n2;
        int n4 = 0;
        int n5 = 0;
        while (n < n3) {
            int[] nArray;
            short s = this.getOpcode(n);
            int n6 = this.stackWordDelta(classHolder, n, s);
            if ((n4 += n6) > n5) {
                n5 = n4;
            }
            if ((nArray = this.findConditionalPCs(n, s)) != null && nArray[3] != -1) {
                int n7 = this.findMaxStack(classHolder, nArray[1], nArray[2]);
                if (n4 + n7 > n5) {
                    n5 = n4 + n7;
                }
                n = nArray[3];
                continue;
            }
            n += CodeChunk.instructionLength(s);
        }
        return n5;
    }

    private int stackWordDelta(ClassHolder classHolder, int n, short s) {
        int n2 = OPCODE_ACTION[s][0];
        if (n2 == -128) {
            n2 = this.getVariableStackDelta(classHolder, n, s);
        }
        return n2;
    }

    private String getTypeDescriptor(ClassHolder classHolder, int n) {
        int n2 = this.getU2(n);
        CONSTANT_Index_info cONSTANT_Index_info = (CONSTANT_Index_info)classHolder.getEntry(n2);
        int n3 = cONSTANT_Index_info.getI2();
        cONSTANT_Index_info = (CONSTANT_Index_info)classHolder.getEntry(n3);
        int n4 = cONSTANT_Index_info.getI2();
        CONSTANT_Utf8_info cONSTANT_Utf8_info = (CONSTANT_Utf8_info)classHolder.getEntry(n4);
        String string2 = cONSTANT_Utf8_info.toString();
        return string2;
    }

    private static int getDescriptorWordCount(String string2) {
        int n;
        if ("D".equals(string2)) {
            n = 2;
        } else if ("J".equals(string2)) {
            n = 2;
        } else if (string2.charAt(0) == '(') {
            switch (string2.charAt(string2.length() - 1)) {
                case 'D': 
                case 'J': {
                    n = 2;
                    break;
                }
                case 'V': {
                    n = 0;
                    break;
                }
                default: {
                    n = 1;
                    break;
                }
            }
        } else {
            n = 1;
        }
        return n;
    }

    private int getVariableStackDelta(ClassHolder classHolder, int n, int n2) {
        String string2 = this.getTypeDescriptor(classHolder, n);
        int n3 = CodeChunk.getDescriptorWordCount(string2);
        int n4 = 0;
        switch (n2) {
            case 178: {
                n4 = n3;
                break;
            }
            case 180: {
                n4 = n3 - 1;
                break;
            }
            case 179: {
                n4 = -n3;
                break;
            }
            case 181: {
                n4 = -n3 - 1;
                break;
            }
            case 182: 
            case 183: {
                n4 = -1;
            }
            case 184: {
                n4 += n3 - CodeChunk.parameterWordCount(string2);
                break;
            }
            case 185: {
                n4 = n3 - this.getOpcode(n + 3);
                break;
            }
            default: {
                System.out.println("WHO IS THIS ");
            }
        }
        return n4;
    }

    private static int parameterWordCount(String string2) {
        int n = 0;
        int n2 = 1;
        while (true) {
            switch (string2.charAt(n2)) {
                case ')': {
                    return n;
                }
                case 'D': 
                case 'J': {
                    n += 2;
                    break;
                }
                case '[': {
                    while (string2.charAt(++n2) == '[') {
                    }
                    if (string2.charAt(n2) != 'L') {
                        ++n;
                        break;
                    }
                }
                case 'L': {
                    while (string2.charAt(++n2) != ';') {
                    }
                    ++n;
                    break;
                }
                default: {
                    ++n;
                }
            }
            ++n2;
        }
    }

    private int[] findConditionalPCs(int n, short s) {
        int[] nArray;
        int n2;
        int n3;
        int n4;
        switch (s) {
            default: {
                return null;
            }
            case 153: 
            case 154: 
            case 198: 
            case 199: 
        }
        int n5 = this.getU2(n);
        if (n5 == 8 && this.getOpcode(n + 3) == 200) {
            n4 = n + 3 + 5;
            n3 = n + 3 + this.getU4(n + 3);
        } else {
            n4 = n + 3;
            n3 = n + n5;
        }
        int n6 = -1;
        int n7 = n4;
        while (n7 < n3) {
            n2 = this.getOpcode(n7);
            nArray = this.findConditionalPCs(n7, (short)n2);
            if (nArray != null) {
                n7 = nArray[5];
                continue;
            }
            if (n2 == 167) {
                if (n7 != n3 - 3) continue;
                n6 = n7 + this.getU2(n7);
                break;
            }
            if (n2 == 200) {
                if (n7 != n3 - 5) continue;
                n6 = n7 + this.getU4(n7);
                break;
            }
            n7 += CodeChunk.instructionLength((short)n2);
        }
        if (n6 == -1) {
            n6 = n3;
            n3 = -1;
            n2 = n6 - n4;
            n7 = -1;
        } else {
            n2 = n3 - n4;
            n7 = n6 - n3;
        }
        nArray = new int[]{n, n4, n2, n3, n7, n6};
        return nArray;
    }

    final int splitZeroStack(BCMethod bCMethod, ClassHolder classHolder, int n, int n2) {
        int n3 = CodeChunk.splitMinLength(bCMethod);
        int n4 = 0;
        int n5 = -1;
        int n6 = -1;
        int n7 = this.getPC();
        int n8 = n;
        while (n8 < n7) {
            short s = this.getOpcode(n8);
            int n9 = this.stackWordDelta(classHolder, n8, s);
            n4 += n9;
            int[] nArray = this.findConditionalPCs(n8, s);
            if (nArray != null) {
                if (nArray[3] != -1) {
                    n8 = nArray[3];
                    continue;
                }
                if (n6 == -1) {
                    n6 = nArray[5];
                }
            }
            n8 += CodeChunk.instructionLength(s);
            if (n6 != -1) {
                if (n8 <= n6) continue;
                n6 = -1;
                continue;
            }
            if (n4 != 0) continue;
            int n10 = n8 - n;
            if (n10 < n2) {
                n5 = n10;
                continue;
            }
            if (n10 > 65534) {
                n10 = -1;
            } else if (CodeChunk.isReturn(s)) {
                n10 = -1;
            }
            if (n10 == -1) {
                if (n5 == -1) {
                    return -1;
                }
                if (n5 <= n3) {
                    return -1;
                }
                n10 = n5;
            }
            BCMethod bCMethod2 = this.startSubMethod(bCMethod, "void", n, n10);
            return this.splitCodeIntoSubMethod(bCMethod, classHolder, bCMethod2, n, n10);
        }
        return -1;
    }

    private BCMethod startSubMethod(BCMethod bCMethod, String string2, int n, int n2) {
        boolean bl = this.usesParameters(bCMethod, n, n2);
        return bCMethod.getNewSubMethod(string2, bl);
    }

    private boolean usesParameters(BCMethod bCMethod, int n, int n2) {
        if (bCMethod.parameters == null) {
            return false;
        }
        boolean bl = (bCMethod.myEntry.getModifier() & 8) != 0;
        int n3 = n + n2;
        while (n < n3) {
            short s = this.getOpcode(n);
            switch (s) {
                case 26: 
                case 30: 
                case 34: 
                case 38: {
                    return true;
                }
                case 42: {
                    if (!bl) break;
                    return true;
                }
                case 27: 
                case 31: 
                case 35: 
                case 39: 
                case 43: {
                    return true;
                }
                case 28: 
                case 32: 
                case 36: 
                case 40: 
                case 44: {
                    return true;
                }
                case 29: 
                case 33: 
                case 37: 
                case 41: 
                case 45: {
                    return true;
                }
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: {
                    return true;
                }
            }
            n += CodeChunk.instructionLength(s);
        }
        return false;
    }

    private int splitCodeIntoSubMethod(BCMethod bCMethod, ClassHolder classHolder, BCMethod bCMethod2, int n, int n2) {
        CodeChunk codeChunk = bCMethod2.myCode;
        byte[] byArray = this.cout.getData();
        try {
            codeChunk.cout.write(byArray, 8 + n, n2);
        }
        catch (IOException iOException) {
            this.limitHit(iOException);
        }
        if (bCMethod2.myReturnType.equals("void")) {
            codeChunk.addInstr((short)177);
        } else {
            codeChunk.addInstr((short)176);
        }
        if (this.cb.limitMsg != null) {
            return -1;
        }
        bCMethod2.maxStack = codeChunk.findMaxStack(classHolder, 0, codeChunk.getPC());
        bCMethod2.complete();
        return this.removePushedCode(bCMethod, classHolder, bCMethod2, n, n2);
    }

    private int removePushedCode(BCMethod bCMethod, ClassHolder classHolder, BCMethod bCMethod2, int n, int n2) {
        CodeChunk codeChunk;
        int n3 = this.getPC();
        bCMethod.myCode = codeChunk = new CodeChunk(bCMethod.cb);
        bCMethod.maxStack = 0;
        byte[] byArray = this.cout.getData();
        if (n != 0) {
            try {
                codeChunk.cout.write(byArray, 8, n);
            }
            catch (IOException iOException) {
                this.limitHit(iOException);
            }
        }
        bCMethod.callSubMethod(bCMethod2);
        int n4 = codeChunk.getPC();
        int n5 = n + n2;
        int n6 = n3 - n2 - n;
        try {
            codeChunk.cout.write(byArray, 8 + n5, n6);
        }
        catch (IOException iOException) {
            this.limitHit(iOException);
        }
        if (this.cb.limitMsg != null) {
            return -1;
        }
        bCMethod.maxStack = codeChunk.findMaxStack(classHolder, 0, codeChunk.getPC());
        return n4;
    }

    final int splitExpressionOut(BCMethod bCMethod, ClassHolder classHolder, int n, int n2) {
        int n3 = -1;
        int n4 = -1;
        String string2 = null;
        int n5 = CodeChunk.splitMinLength(bCMethod);
        int[] nArray = new int[n2 + 1];
        int n6 = 0;
        int n7 = -1;
        int n8 = this.getPC();
        int n9 = 0;
        block10: while (n9 < n8) {
            int n10;
            int n11;
            int n12;
            int n13;
            String string3;
            short s = this.getOpcode(n9);
            int n14 = this.stackWordDelta(classHolder, n9, s);
            n6 += n14;
            int[] nArray2 = this.findConditionalPCs(n9, s);
            if (nArray2 != null) {
                return -1;
            }
            n9 += CodeChunk.instructionLength(s);
            if (n7 != -1) {
                if (n9 <= n7) continue;
                n7 = -1;
                continue;
            }
            int n15 = n9 - CodeChunk.instructionLength(s);
            switch (s) {
                default: {
                    Arrays.fill(nArray, 0, n6 + 1, -1);
                    continue block10;
                }
                case 0: 
                case 119: 
                case 139: 
                case 143: 
                case 190: 
                case 192: {
                    continue block10;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 11: 
                case 12: 
                case 13: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 23: 
                case 25: 
                case 42: 
                case 43: 
                case 44: 
                case 45: {
                    nArray[n6] = n15;
                    continue block10;
                }
                case 9: 
                case 10: 
                case 14: 
                case 15: 
                case 20: 
                case 22: 
                case 30: 
                case 31: 
                case 32: 
                case 33: {
                    nArray[n6 - 1] = nArray[n6] = n15;
                    continue block10;
                }
                case 87: 
                case 88: {
                    continue block10;
                }
                case 95: {
                    nArray[n6] = nArray[n6 - 1];
                    continue block10;
                }
                case 133: {
                    nArray[n6] = nArray[n6 - 1];
                    continue block10;
                }
                case 180: {
                    string3 = this.getTypeDescriptor(classHolder, n15);
                    n13 = CodeChunk.getDescriptorWordCount(string3);
                    if (n13 != 2) continue block10;
                    nArray[n6] = nArray[n6 - 1];
                    continue block10;
                }
                case 182: 
                case 185: 
            }
            string3 = this.getTypeDescriptor(classHolder, n15);
            n13 = CodeChunk.getDescriptorWordCount(string3);
            if (n13 == 0) {
                n12 = -1;
            } else if (n13 == 1) {
                n12 = nArray[n6];
            } else {
                n12 = -1;
                nArray[n6] = nArray[n6 - 1];
            }
            if (n12 == -1 || (n11 = n9 - n12) <= n5 || n11 > 65534 || string3.charAt((n10 = string3.lastIndexOf(41)) + 1) != 'L') continue;
            String string4 = string3.substring(n10 + 2, string3.length() - 1);
            string4 = string4.replace('/', '.');
            if (n11 >= n) {
                BCMethod bCMethod2 = this.startSubMethod(bCMethod, string4, n12, n11);
                return this.splitCodeIntoSubMethod(bCMethod, classHolder, bCMethod2, n12, n11);
            }
            if (n11 <= n4) continue;
            n3 = n12;
            n4 = n11;
            string2 = string4;
        }
        if (n4 != -1) {
            BCMethod bCMethod3 = this.startSubMethod(bCMethod, string2, n3, n4);
            return this.splitCodeIntoSubMethod(bCMethod, classHolder, bCMethod3, n3, n4);
        }
        return -1;
    }

    private static boolean isReturn(short s) {
        switch (s) {
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 177: {
                return true;
            }
        }
        return false;
    }

    private static int splitMinLength(BCMethod bCMethod) {
        int n = 4;
        if (bCMethod.parameters != null) {
            int n2 = bCMethod.parameters.length;
            n += n2;
            if (n2 > 3) {
                n += n2 - 3;
            }
        }
        return n;
    }
}

