/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.jce;

import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.crypto.CipherProvider;
import org.apache.derby.impl.services.jce.JCECipherFactory;

class JCECipherProvider
implements CipherProvider {
    private Cipher cipher;
    private int mode;
    private boolean ivUsed = true;
    private final IvParameterSpec ivspec;
    private final int encryptionBlockSize;
    private boolean sunjce;
    private SecretKey cryptixKey;

    JCECipherProvider(int n, SecretKey secretKey, byte[] byArray, String string2, String string3) throws StandardException {
        GeneralSecurityException generalSecurityException;
        this.ivspec = new IvParameterSpec(byArray);
        try {
            block28: {
                if (string3 == null) {
                    this.cipher = Cipher.getInstance(string2);
                    if ("SunJCE".equals(this.cipher.getProvider().getName())) {
                        this.sunjce = true;
                    }
                } else {
                    if (string3.equals("SunJCE")) {
                        this.sunjce = true;
                    } else if (string3.equals("BouncyCastleProvider")) {
                        string3 = "BC";
                    }
                    this.cipher = Cipher.getInstance(string2, string3);
                }
                this.encryptionBlockSize = this.cipher.getBlockSize();
                this.mode = n;
                try {
                    if (n == 1) {
                        if (string2.indexOf("/ECB") > -1) {
                            this.cipher.init(1, secretKey);
                        } else {
                            this.cipher.init(1, (Key)secretKey, this.ivspec);
                        }
                        break block28;
                    }
                    if (n == 2) {
                        if (string2.indexOf("/ECB") > -1) {
                            this.cipher.init(2, secretKey);
                        } else {
                            this.cipher.init(2, (Key)secretKey, this.ivspec);
                        }
                        break block28;
                    }
                    throw StandardException.newException("XBCX1.S");
                }
                catch (InvalidKeyException invalidKeyException) {
                    if (string2.startsWith("DES")) {
                        SecretKeyFactory secretKeyFactory = string3 == null ? SecretKeyFactory.getInstance(secretKey.getAlgorithm()) : SecretKeyFactory.getInstance(secretKey.getAlgorithm(), string3);
                        secretKey = secretKeyFactory.translateKey(new SecretKeySpec(secretKey.getEncoded(), secretKey.getAlgorithm()));
                        if (n == 1) {
                            if (string2.indexOf("/ECB") > -1) {
                                this.cipher.init(1, secretKey);
                            } else {
                                this.cipher.init(1, (Key)secretKey, this.ivspec);
                            }
                        } else if (n == 2) {
                            if (string2.indexOf("/ECB") > -1) {
                                this.cipher.init(2, secretKey);
                            } else {
                                this.cipher.init(2, (Key)secretKey, this.ivspec);
                            }
                        }
                    }
                    throw StandardException.newException("XBCX0.S", invalidKeyException);
                }
            }
            this.cryptixKey = secretKey;
            if (this.cipher.getIV() == null) {
                this.ivUsed = false;
            }
            return;
        }
        catch (InvalidKeyException invalidKeyException) {
            generalSecurityException = invalidKeyException;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw StandardException.newException("XBCXC.S", (Object)string2, (Object)JCECipherFactory.providerErrorName(string3));
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw StandardException.newException("XBCXG.S", JCECipherFactory.providerErrorName(string3));
        }
        catch (GeneralSecurityException generalSecurityException2) {
            generalSecurityException = generalSecurityException2;
        }
        throw StandardException.newException("XBCX0.S", generalSecurityException);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int encrypt(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws StandardException {
        int n4 = 0;
        try {
            JCECipherProvider jCECipherProvider = this;
            synchronized (jCECipherProvider) {
                if (!this.sunjce) {
                    try {
                        if (this.mode == 1) {
                            if (this.ivUsed) {
                                this.cipher.init(1, (Key)this.cryptixKey, this.ivspec);
                            } else {
                                this.cipher.init(1, this.cryptixKey);
                            }
                        } else if (this.mode == 2) {
                            if (this.ivUsed) {
                                this.cipher.init(2, (Key)this.cryptixKey, this.ivspec);
                            } else {
                                this.cipher.init(2, this.cryptixKey);
                            }
                        }
                    }
                    catch (InvalidKeyException invalidKeyException) {
                        System.out.println("A " + invalidKeyException);
                        throw StandardException.newException("XBCX0.S", invalidKeyException);
                    }
                }
                n4 = this.cipher.doFinal(byArray, n, n2, byArray2, n3);
            }
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (GeneralSecurityException generalSecurityException) {
            System.out.println("B " + generalSecurityException);
            throw StandardException.newException("XBCX0.S", generalSecurityException);
        }
        return n4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int decrypt(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws StandardException {
        int n4 = 0;
        try {
            JCECipherProvider jCECipherProvider = this;
            synchronized (jCECipherProvider) {
                if (!this.sunjce) {
                    try {
                        if (this.mode == 1) {
                            if (this.ivUsed) {
                                this.cipher.init(1, (Key)this.cryptixKey, this.ivspec);
                            } else {
                                this.cipher.init(1, this.cryptixKey);
                            }
                        } else if (this.mode == 2) {
                            if (this.ivUsed) {
                                this.cipher.init(2, (Key)this.cryptixKey, this.ivspec);
                            } else {
                                this.cipher.init(2, this.cryptixKey);
                            }
                        }
                    }
                    catch (InvalidKeyException invalidKeyException) {
                        System.out.println("C " + invalidKeyException);
                        throw StandardException.newException("XBCX0.S", invalidKeyException);
                    }
                }
                n4 = this.cipher.doFinal(byArray, n, n2, byArray2, n3);
            }
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (GeneralSecurityException generalSecurityException) {
            System.out.println("D " + generalSecurityException);
            throw StandardException.newException("XBCX0.S", generalSecurityException);
        }
        return n4;
    }

    boolean verifyIV(byte[] byArray) {
        byte[] byArray2 = this.cipher.getIV();
        if (byArray2 == null) {
            return !this.ivUsed;
        }
        if (byArray2.length != byArray.length) {
            return false;
        }
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray2[i] == byArray[i]) continue;
            return false;
        }
        return true;
    }

    public int getEncryptionBlockSize() {
        return this.encryptionBlockSize;
    }
}

