/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.reflect;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectStreamClass;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Properties;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.services.io.FileUtil;
import org.apache.derby.iapi.services.loader.ClassFactory;
import org.apache.derby.iapi.services.loader.ClassInspector;
import org.apache.derby.iapi.services.loader.GeneratedClass;
import org.apache.derby.iapi.services.monitor.ModuleControl;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.stream.HeaderPrintWriter;
import org.apache.derby.iapi.util.ByteArray;
import org.apache.derby.impl.services.reflect.JarLoader;
import org.apache.derby.impl.services.reflect.LoadedGeneratedClass;
import org.apache.derby.impl.services.reflect.UpdateLoader;

abstract class DatabaseClasses
implements ClassFactory,
ModuleControl {
    private ClassInspector classInspector;
    private UpdateLoader applicationLoader;

    DatabaseClasses() {
    }

    public void boot(boolean bl, Properties properties) throws StandardException {
        this.classInspector = this.makeClassInspector(this);
        String string2 = null;
        if (properties != null) {
            string2 = properties.getProperty("derby.__rt.database.classpath");
        }
        if (string2 != null) {
            this.applicationLoader = new UpdateLoader(string2, this, true, true);
        }
    }

    public void stop() {
        if (this.applicationLoader != null) {
            this.applicationLoader.close();
        }
    }

    protected ClassInspector makeClassInspector(DatabaseClasses databaseClasses) {
        return new ClassInspector(databaseClasses);
    }

    public final GeneratedClass loadGeneratedClass(String string2, ByteArray byteArray) throws StandardException {
        try {
            return this.loadGeneratedClassFromData(string2, byteArray);
        }
        catch (LinkageError linkageError) {
            DatabaseClasses.WriteClassFile(string2, byteArray, linkageError);
            throw StandardException.newException("XBCM1.S", linkageError, (Object)string2);
        }
        catch (VirtualMachineError virtualMachineError) {
            DatabaseClasses.WriteClassFile(string2, byteArray, virtualMachineError);
            throw virtualMachineError;
        }
    }

    private static void WriteClassFile(String string2, ByteArray byteArray, Throwable throwable) {
        int n = string2.lastIndexOf(46);
        String string3 = string2.substring(n + 1, string2.length()).concat(".class");
        Object object = Monitor.getMonitor().getEnvironment();
        File file = object instanceof File ? (File)object : null;
        final File file2 = FileUtil.newFile(file, string3);
        HeaderPrintWriter headerPrintWriter = Monitor.getStream();
        try {
            FileOutputStream fileOutputStream;
            try {
                fileOutputStream = (FileOutputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws IOException {
                        return new FileOutputStream(file2);
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw (IOException)privilegedActionException.getCause();
            }
            fileOutputStream.write(byteArray.getArray(), byteArray.getOffset(), byteArray.getLength());
            fileOutputStream.flush();
            if (throwable != null) {
                headerPrintWriter.printlnWithHeader(MessageService.getTextMessage("C000", string2, file2, throwable));
            }
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public ClassInspector getClassInspector() {
        return this.classInspector;
    }

    public final Class loadApplicationClass(String string2) throws ClassNotFoundException {
        Throwable throwable;
        if (string2.startsWith("org.apache.derby.")) {
            try {
                return Class.forName(string2);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        try {
            try {
                return this.loadClassNotInDatabaseJar(string2);
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (this.applicationLoader == null) {
                    throw classNotFoundException;
                }
                Class clazz = this.applicationLoader.loadClass(string2, true);
                if (clazz == null) {
                    throw classNotFoundException;
                }
                return clazz;
            }
        }
        catch (SecurityException securityException) {
            throwable = securityException;
        }
        catch (LinkageError linkageError) {
            throwable = linkageError;
        }
        throw new ClassNotFoundException(string2 + " : " + throwable.getMessage());
    }

    abstract Class loadClassNotInDatabaseJar(String var1) throws ClassNotFoundException;

    public final Class loadApplicationClass(ObjectStreamClass objectStreamClass) throws ClassNotFoundException {
        return this.loadApplicationClass(objectStreamClass.getName());
    }

    public boolean isApplicationClass(Class clazz) {
        return clazz.getClassLoader() instanceof JarLoader;
    }

    public void notifyModifyJar(boolean bl) throws StandardException {
        if (this.applicationLoader != null) {
            this.applicationLoader.modifyJar(bl);
        }
    }

    public void notifyModifyClasspath(String string2) throws StandardException {
        if (this.applicationLoader != null) {
            this.applicationLoader.modifyClasspath(string2);
        }
    }

    public int getClassLoaderVersion() {
        if (this.applicationLoader != null) {
            return this.applicationLoader.getClassLoaderVersion();
        }
        return -1;
    }

    abstract LoadedGeneratedClass loadGeneratedClassFromData(String var1, ByteArray var2);
}

