/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.catalog;

import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.uuid.UUIDFactory;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.PermissionsDescriptor;
import org.apache.derby.iapi.sql.dictionary.RoutinePermsDescriptor;
import org.apache.derby.iapi.sql.dictionary.SystemColumn;
import org.apache.derby.iapi.sql.dictionary.TupleDescriptor;
import org.apache.derby.iapi.sql.execute.ExecIndexRow;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.ExecutionFactory;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.DataValueFactory;
import org.apache.derby.iapi.types.SQLChar;
import org.apache.derby.impl.sql.catalog.PermissionsCatalogRowFactory;
import org.apache.derby.impl.sql.catalog.SystemColumnImpl;

public class SYSROUTINEPERMSRowFactory
extends PermissionsCatalogRowFactory {
    static final String TABLENAME_STRING = "SYSROUTINEPERMS";
    private static final int ROUTINEPERMSID_COL_NUM = 1;
    private static final int GRANTEE_COL_NUM = 2;
    private static final int GRANTOR_COL_NUM = 3;
    private static final int ALIASID_COL_NUM = 4;
    private static final int GRANTOPTION_COL_NUM = 5;
    private static final int COLUMN_COUNT = 5;
    static final int GRANTEE_ALIAS_GRANTOR_INDEX_NUM = 0;
    public static final int ROUTINEPERMSID_INDEX_NUM = 1;
    public static final int ALIASID_INDEX_NUM = 2;
    private static final int[][] indexColumnPositions = new int[][]{{2, 4, 3}, {1}, {4}};
    public static final int GRANTEE_COL_NUM_IN_GRANTEE_ALIAS_GRANTOR_INDEX = 1;
    private static final boolean[] indexUniqueness = new boolean[]{true, true, false};
    private static final String[] uuids = new String[]{"2057c01b-0103-0e39-b8e7-00000010f010", "185e801c-0103-0e39-b8e7-00000010f010", "c065801d-0103-0e39-b8e7-00000010f010", "40f70088-010c-4c2f-c8de-0000000f43a0", "08264012-010c-bc85-060d-000000109ab8"};

    SYSROUTINEPERMSRowFactory(UUIDFactory uUIDFactory, ExecutionFactory executionFactory, DataValueFactory dataValueFactory) {
        super(uUIDFactory, executionFactory, dataValueFactory);
        this.initInfo(5, TABLENAME_STRING, indexColumnPositions, indexUniqueness, uuids);
    }

    public ExecRow makeRow(TupleDescriptor tupleDescriptor, TupleDescriptor tupleDescriptor2) throws StandardException {
        Object object;
        String string2 = null;
        DataValueDescriptor dataValueDescriptor = null;
        DataValueDescriptor dataValueDescriptor2 = null;
        String string3 = null;
        if (tupleDescriptor == null) {
            dataValueDescriptor = this.getNullAuthorizationID();
            dataValueDescriptor2 = this.getNullAuthorizationID();
        } else {
            object = (RoutinePermsDescriptor)tupleDescriptor;
            UUID uUID = ((PermissionsDescriptor)object).getUUID();
            if (uUID == null) {
                uUID = this.getUUIDFactory().createUUID();
                ((PermissionsDescriptor)object).setUUID(uUID);
            }
            string2 = uUID.toString();
            dataValueDescriptor = this.getAuthorizationID(((PermissionsDescriptor)object).getGrantee());
            dataValueDescriptor2 = this.getAuthorizationID(((PermissionsDescriptor)object).getGrantor());
            if (((RoutinePermsDescriptor)object).getRoutineUUID() != null) {
                string3 = ((RoutinePermsDescriptor)object).getRoutineUUID().toString();
            }
        }
        object = this.getExecutionFactory().getValueRow(5);
        object.setColumn(1, new SQLChar(string2));
        object.setColumn(2, dataValueDescriptor);
        object.setColumn(3, dataValueDescriptor2);
        object.setColumn(4, new SQLChar(string3));
        object.setColumn(5, new SQLChar("N"));
        return object;
    }

    public TupleDescriptor buildDescriptor(ExecRow execRow, TupleDescriptor tupleDescriptor, DataDictionary dataDictionary) throws StandardException {
        String string2 = execRow.getColumn(1).getString();
        UUID uUID = this.getUUIDFactory().recreateUUID(string2);
        String string3 = execRow.getColumn(4).getString();
        UUID uUID2 = this.getUUIDFactory().recreateUUID(string3);
        RoutinePermsDescriptor routinePermsDescriptor = new RoutinePermsDescriptor(dataDictionary, this.getAuthorizationID(execRow, 2), this.getAuthorizationID(execRow, 3), uUID2);
        routinePermsDescriptor.setUUID(uUID);
        return routinePermsDescriptor;
    }

    public SystemColumn[] buildColumnList() throws StandardException {
        return new SystemColumn[]{SystemColumnImpl.getUUIDColumn("ROUTINEPERMSID", false), SystemColumnImpl.getIdentifierColumn("GRANTEE", false), SystemColumnImpl.getIdentifierColumn("GRANTOR", false), SystemColumnImpl.getUUIDColumn("ALIASID", false), SystemColumnImpl.getIndicatorColumn("GRANTOPTION")};
    }

    public ExecIndexRow buildIndexKeyRow(int n, PermissionsDescriptor permissionsDescriptor) throws StandardException {
        ExecIndexRow execIndexRow = null;
        switch (n) {
            case 0: {
                execIndexRow = this.getExecutionFactory().getIndexableRow(2);
                execIndexRow.setColumn(1, this.getAuthorizationID(permissionsDescriptor.getGrantee()));
                String string2 = ((RoutinePermsDescriptor)permissionsDescriptor).getRoutineUUID().toString();
                execIndexRow.setColumn(2, new SQLChar(string2));
                break;
            }
            case 1: {
                execIndexRow = this.getExecutionFactory().getIndexableRow(1);
                String string3 = permissionsDescriptor.getObjectID().toString();
                execIndexRow.setColumn(1, new SQLChar(string3));
                break;
            }
            case 2: {
                execIndexRow = this.getExecutionFactory().getIndexableRow(1);
                String string4 = ((RoutinePermsDescriptor)permissionsDescriptor).getRoutineUUID().toString();
                execIndexRow.setColumn(1, new SQLChar(string4));
            }
        }
        return execIndexRow;
    }

    public int getPrimaryKeyIndexNumber() {
        return 0;
    }

    public int orPermissions(ExecRow execRow, PermissionsDescriptor permissionsDescriptor, boolean[] blArray) throws StandardException {
        return 0;
    }

    public int removePermissions(ExecRow execRow, PermissionsDescriptor permissionsDescriptor, boolean[] blArray) throws StandardException {
        return -1;
    }

    public void setUUIDOfThePassedDescriptor(ExecRow execRow, PermissionsDescriptor permissionsDescriptor) throws StandardException {
        DataValueDescriptor dataValueDescriptor = execRow.getColumn(1);
        permissionsDescriptor.setUUID(this.getUUIDFactory().recreateUUID(dataValueDescriptor.getString()));
    }
}

