/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Properties;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.monitor.ModuleControl;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.sql.compile.CostEstimate;
import org.apache.derby.iapi.sql.compile.JoinStrategy;
import org.apache.derby.iapi.sql.compile.OptimizableList;
import org.apache.derby.iapi.sql.compile.OptimizablePredicateList;
import org.apache.derby.iapi.sql.compile.Optimizer;
import org.apache.derby.iapi.sql.compile.OptimizerFactory;
import org.apache.derby.iapi.sql.compile.RequiredRowOrdering;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.impl.sql.compile.CostEstimateImpl;
import org.apache.derby.impl.sql.compile.HashJoinStrategy;
import org.apache.derby.impl.sql.compile.NestedLoopJoinStrategy;
import org.apache.derby.impl.sql.compile.OptimizerImpl;

public class OptimizerFactoryImpl
implements ModuleControl,
OptimizerFactory {
    protected String optimizerId = null;
    protected boolean ruleBasedOptimization = false;
    protected boolean noTimeout = false;
    protected boolean useStatistics = true;
    protected int maxMemoryPerTable = 0x100000;
    protected JoinStrategy[] joinStrategySet;

    public void boot(boolean bl, Properties properties) throws StandardException {
        String string2;
        int n;
        this.ruleBasedOptimization = Boolean.valueOf(PropertyUtil.getSystemProperty("derby.optimizer.ruleBasedOptimization"));
        this.noTimeout = Boolean.valueOf(PropertyUtil.getSystemProperty("derby.optimizer.noTimeout"));
        String string3 = PropertyUtil.getSystemProperty("derby.language.maxMemoryPerTable");
        if (string3 != null && (n = Integer.parseInt(string3)) >= 0) {
            this.maxMemoryPerTable = n * 1024;
        }
        if ((string2 = PropertyUtil.getSystemProperty("derby.language.useStatistics")) != null) {
            this.useStatistics = Boolean.valueOf(string2);
        }
    }

    public void stop() {
    }

    public Optimizer getOptimizer(OptimizableList optimizableList, OptimizablePredicateList optimizablePredicateList, DataDictionary dataDictionary, RequiredRowOrdering requiredRowOrdering, int n, LanguageConnectionContext languageConnectionContext) throws StandardException {
        if (this.joinStrategySet == null) {
            JoinStrategy[] joinStrategyArray = new JoinStrategy[]{new NestedLoopJoinStrategy(), new HashJoinStrategy()};
            this.joinStrategySet = joinStrategyArray;
        }
        return this.getOptimizerImpl(optimizableList, optimizablePredicateList, dataDictionary, requiredRowOrdering, n, languageConnectionContext);
    }

    public CostEstimate getCostEstimate() throws StandardException {
        return new CostEstimateImpl();
    }

    public boolean supportsOptimizerTrace() {
        return false;
    }

    protected Optimizer getOptimizerImpl(OptimizableList optimizableList, OptimizablePredicateList optimizablePredicateList, DataDictionary dataDictionary, RequiredRowOrdering requiredRowOrdering, int n, LanguageConnectionContext languageConnectionContext) throws StandardException {
        return new OptimizerImpl(optimizableList, optimizablePredicateList, dataDictionary, this.ruleBasedOptimization, this.noTimeout, this.useStatistics, this.maxMemoryPerTable, this.joinStrategySet, languageConnectionContext.getLockEscalationThreshold(), requiredRowOrdering, n);
    }

    public int getMaxMemoryPerTable() {
        return this.maxMemoryPerTable;
    }
}

