/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.HashMap;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.compile.AccessPath;
import org.apache.derby.iapi.sql.compile.CostEstimate;
import org.apache.derby.iapi.sql.compile.JoinStrategy;
import org.apache.derby.iapi.sql.compile.Optimizable;
import org.apache.derby.iapi.sql.compile.OptimizableList;
import org.apache.derby.iapi.sql.compile.OptimizablePredicate;
import org.apache.derby.iapi.sql.compile.OptimizablePredicateList;
import org.apache.derby.iapi.sql.compile.Optimizer;
import org.apache.derby.iapi.sql.compile.RequiredRowOrdering;
import org.apache.derby.iapi.sql.compile.RowOrdering;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.impl.sql.compile.BaseTableNumbersVisitor;
import org.apache.derby.impl.sql.compile.CostEstimateImpl;
import org.apache.derby.impl.sql.compile.FromTable;
import org.apache.derby.impl.sql.compile.Predicate;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.RowOrderingImpl;

public class OptimizerImpl
implements Optimizer {
    DataDictionary dDictionary;
    int numTablesInQuery;
    int numOptimizables;
    protected JBitSet assignedTableMap;
    protected OptimizableList optimizableList;
    OptimizablePredicateList predicateList;
    JBitSet nonCorrelatedTableMap;
    protected int[] proposedJoinOrder;
    protected int[] bestJoinOrder;
    protected int joinPosition;
    boolean desiredJoinOrderFound;
    private static final int NO_JUMP = 0;
    private static final int READY_TO_JUMP = 1;
    private static final int JUMPING = 2;
    private static final int WALK_HIGH = 3;
    private static final int WALK_LOW = 4;
    private int permuteState;
    private int[] firstLookOrder;
    private boolean ruleBasedOptimization;
    private CostEstimateImpl outermostCostEstimate;
    protected CostEstimateImpl currentCost;
    protected CostEstimateImpl currentSortAvoidanceCost;
    protected CostEstimateImpl bestCost;
    protected long timeOptimizationStarted;
    protected long currentTime;
    protected boolean timeExceeded;
    private boolean noTimeout;
    private boolean useStatistics;
    private int tableLockThreshold;
    private JoinStrategy[] joinStrategies;
    protected RequiredRowOrdering requiredRowOrdering;
    private boolean foundABestPlan;
    protected CostEstimate sortCost;
    private RowOrdering currentRowOrdering = new RowOrderingImpl();
    private RowOrdering bestRowOrdering = new RowOrderingImpl();
    private boolean conglomerate_OneRowResultSet;
    protected boolean optimizerTrace;
    protected boolean optimizerTraceHtml;
    protected int maxMemoryPerTable;
    private boolean reloadBestPlan;
    private HashMap savedJoinOrders;
    protected double timeLimit;
    CostEstimate finalCostEstimate;
    private boolean usingPredsPushedFromAbove;
    private boolean bestJoinOrderUsedPredsFromAbove;

    protected OptimizerImpl(OptimizableList optimizableList, OptimizablePredicateList optimizablePredicateList, DataDictionary dataDictionary, boolean bl, boolean bl2, boolean bl3, int n, JoinStrategy[] joinStrategyArray, int n2, RequiredRowOrdering requiredRowOrdering, int n3) throws StandardException {
        int n4;
        this.outermostCostEstimate = this.getNewCostEstimate(0.0, 1.0, 1.0);
        this.currentCost = this.getNewCostEstimate(0.0, 0.0, 0.0);
        this.currentSortAvoidanceCost = this.getNewCostEstimate(0.0, 0.0, 0.0);
        this.bestCost = this.getNewCostEstimate(Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE);
        optimizableList.verifyProperties(dataDictionary);
        this.numTablesInQuery = n3;
        this.numOptimizables = optimizableList.size();
        this.proposedJoinOrder = new int[this.numOptimizables];
        if (this.initJumpState() == 1) {
            this.firstLookOrder = new int[this.numOptimizables];
        }
        for (n4 = 0; n4 < this.numOptimizables; ++n4) {
            this.proposedJoinOrder[n4] = -1;
        }
        this.bestJoinOrder = new int[this.numOptimizables];
        this.joinPosition = -1;
        this.optimizableList = optimizableList;
        this.predicateList = optimizablePredicateList;
        this.dDictionary = dataDictionary;
        this.ruleBasedOptimization = bl;
        this.noTimeout = bl2;
        this.maxMemoryPerTable = n;
        this.joinStrategies = joinStrategyArray;
        this.tableLockThreshold = n2;
        this.requiredRowOrdering = requiredRowOrdering;
        this.useStatistics = bl3;
        this.assignedTableMap = new JBitSet(n3);
        this.nonCorrelatedTableMap = new JBitSet(n3);
        for (n4 = 0; n4 < this.numOptimizables; ++n4) {
            Optimizable optimizable = optimizableList.getOptimizable(n4);
            this.nonCorrelatedTableMap.or(optimizable.getReferencedTableMap());
        }
        this.timeOptimizationStarted = System.currentTimeMillis();
        this.reloadBestPlan = false;
        this.savedJoinOrders = null;
        this.timeLimit = Double.MAX_VALUE;
        this.usingPredsPushedFromAbove = false;
        this.bestJoinOrderUsedPredsFromAbove = false;
    }

    public void prepForNextRound() {
        this.reloadBestPlan = false;
        this.bestCost = this.getNewCostEstimate(Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE);
        this.usingPredsPushedFromAbove = false;
        if (this.predicateList != null && this.predicateList.size() > 0) {
            for (int i = this.predicateList.size() - 1; i >= 0; --i) {
                if (!((Predicate)this.predicateList.getOptPredicate(i)).isScopedForPush()) continue;
                this.usingPredsPushedFromAbove = true;
                break;
            }
        }
        if (this.usingPredsPushedFromAbove) {
            this.timeOptimizationStarted = System.currentTimeMillis();
            this.timeExceeded = false;
        }
        this.desiredJoinOrderFound = false;
        this.initJumpState();
    }

    private int initJumpState() {
        this.permuteState = this.numTablesInQuery >= 6 ? 1 : 0;
        return this.permuteState;
    }

    public int getMaxMemoryPerTable() {
        return this.maxMemoryPerTable;
    }

    public boolean getNextPermutation() throws StandardException {
        boolean bl;
        int n;
        if (this.numOptimizables < 1) {
            if (this.optimizerTrace) {
                this.trace(3, 0, 0, 0.0, null);
            }
            this.endOfRoundCleanup();
            return false;
        }
        this.optimizableList.initAccessPaths(this);
        if (!this.timeExceeded && this.numTablesInQuery > 6 && !this.noTimeout) {
            this.currentTime = System.currentTimeMillis();
            boolean bl2 = this.timeExceeded = (double)(this.currentTime - this.timeOptimizationStarted) > this.timeLimit;
            if (this.optimizerTrace && this.timeExceeded) {
                this.trace(2, 0, 0, 0.0, null);
            }
        }
        if (this.bestCost.isUninitialized() && this.foundABestPlan && (!this.usingPredsPushedFromAbove && !this.bestJoinOrderUsedPredsFromAbove || this.timeExceeded)) {
            if (this.permuteState != 2) {
                if (this.firstLookOrder == null) {
                    this.firstLookOrder = new int[this.numOptimizables];
                }
                for (n = 0; n < this.numOptimizables; ++n) {
                    this.firstLookOrder[n] = this.bestJoinOrder[n];
                }
                this.permuteState = 2;
                if (this.joinPosition >= 0) {
                    this.rewindJoinOrder();
                    this.joinPosition = -1;
                }
            }
            this.timeExceeded = false;
        }
        n = 0;
        boolean bl3 = bl = !this.bestCost.isUninitialized() && this.currentCost.compare(this.bestCost) > 0.0 && (this.requiredRowOrdering == null || this.currentSortAvoidanceCost.compare(this.bestCost) > 0.0);
        if (this.joinPosition < this.numOptimizables - 1 && !bl && !this.timeExceeded) {
            if (this.joinPosition < 0 || this.optimizableList.getOptimizable(this.proposedJoinOrder[this.joinPosition]).getBestAccessPath().getCostEstimate() != null) {
                ++this.joinPosition;
                n = 1;
                this.bestRowOrdering.copy(this.currentRowOrdering);
            }
        } else {
            if (this.optimizerTrace && this.joinPosition < this.numOptimizables - 1) {
                this.trace(8, 0, 0, 0.0, null);
            }
            if (this.joinPosition < this.numOptimizables - 1) {
                this.reloadBestPlan = true;
            }
        }
        if (this.permuteState == 2 && n == 0 && this.joinPosition >= 0) {
            this.reloadBestPlan = true;
            this.rewindJoinOrder();
            this.permuteState = 0;
        }
        while (this.joinPosition >= 0) {
            int n2;
            int n3;
            int n4;
            int n5 = this.proposedJoinOrder[this.joinPosition] + 1;
            if (this.proposedJoinOrder[this.joinPosition] >= 0) {
                this.pullOptimizableFromJoinOrder();
            }
            if (this.desiredJoinOrderFound || this.timeExceeded) {
                n5 = this.numOptimizables;
            } else if (this.permuteState == 2) {
                n5 = n4 = this.firstLookOrder[this.joinPosition];
                n3 = this.numOptimizables;
                n2 = -1;
                Optimizable optimizable = this.optimizableList.getOptimizable(n5);
                while (!optimizable.legalJoinOrder(this.assignedTableMap)) {
                    if (n2 >= 0) {
                        this.firstLookOrder[this.joinPosition] = n4;
                        this.firstLookOrder[n3] = n2;
                    }
                    if (n3 <= this.joinPosition + 1) {
                        if (this.joinPosition > 0) {
                            --this.joinPosition;
                            this.reloadBestPlan = true;
                            this.rewindJoinOrder();
                        }
                        this.permuteState = 0;
                        break;
                    }
                    this.firstLookOrder[this.joinPosition] = n2 = this.firstLookOrder[--n3];
                    this.firstLookOrder[n3] = n4;
                    n5 = n2;
                    optimizable = this.optimizableList.getOptimizable(n5);
                }
                if (this.permuteState == 0) continue;
                if (this.joinPosition == this.numOptimizables - 1) {
                    this.permuteState = 3;
                }
            } else {
                while (n5 < this.numOptimizables) {
                    n4 = 0;
                    for (n3 = 0; n3 < this.joinPosition; ++n3) {
                        if (this.proposedJoinOrder[n3] != n5) continue;
                        n4 = 1;
                        break;
                    }
                    if (n4 == 0) {
                        if (n5 >= this.numOptimizables || this.joinOrderMeetsDependencies(n5)) break;
                        if (this.optimizerTrace) {
                            this.trace(9, n5, 0, 0.0, null);
                        }
                        if (!this.optimizableList.optimizeJoinOrder()) {
                            if (this.optimizerTrace) {
                                this.trace(10, 0, 0, 0.0, null);
                            }
                            throw StandardException.newException("42Y70");
                        }
                    }
                    ++n5;
                }
            }
            if (n5 >= this.numOptimizables) {
                if (!this.optimizableList.optimizeJoinOrder()) {
                    if (!this.optimizableList.legalJoinOrder(this.numTablesInQuery)) {
                        if (this.optimizerTrace) {
                            this.trace(10, 0, 0, 0.0, null);
                        }
                        throw StandardException.newException("42Y70");
                    }
                    if (this.optimizerTrace) {
                        this.trace(11, 0, 0, 0.0, null);
                    }
                    this.desiredJoinOrderFound = true;
                }
                if (this.permuteState == 1 && this.joinPosition > 0 && this.joinPosition == this.numOptimizables - 1) {
                    this.permuteState = 2;
                    double[] dArray = new double[this.numOptimizables];
                    for (n3 = 0; n3 < this.numOptimizables; ++n3) {
                        this.firstLookOrder[n3] = n3;
                        CostEstimate costEstimate = this.optimizableList.getOptimizable(n3).getBestAccessPath().getCostEstimate();
                        if (costEstimate == null) {
                            this.permuteState = 1;
                            break;
                        }
                        dArray[n3] = costEstimate.singleScanRowCount();
                    }
                    if (this.permuteState == 2) {
                        n3 = 0;
                        for (int i = 0; i < this.numOptimizables; ++i) {
                            int n6 = i;
                            for (int j = i + 1; j < this.numOptimizables; ++j) {
                                if (!(dArray[j] < dArray[n6])) continue;
                                n6 = j;
                            }
                            if (n6 == i) continue;
                            dArray[n6] = dArray[i];
                            n2 = this.firstLookOrder[i];
                            this.firstLookOrder[i] = this.firstLookOrder[n6];
                            this.firstLookOrder[n6] = n2;
                            n3 = 1;
                        }
                        if (n3 != 0) {
                            --this.joinPosition;
                            this.rewindJoinOrder();
                            continue;
                        }
                        this.permuteState = 0;
                    }
                }
                --this.joinPosition;
                if (this.joinPosition >= 0 || this.permuteState != 3) continue;
                this.joinPosition = 0;
                this.permuteState = 4;
                continue;
            }
            this.proposedJoinOrder[this.joinPosition] = n5;
            if (this.permuteState == 4) {
                n4 = 1;
                for (n3 = 0; n3 < this.numOptimizables; ++n3) {
                    if (this.proposedJoinOrder[n3] < this.firstLookOrder[n3]) {
                        n4 = 0;
                        break;
                    }
                    if (this.proposedJoinOrder[n3] > this.firstLookOrder[n3]) break;
                }
                if (n4 != 0) {
                    this.proposedJoinOrder[this.joinPosition] = -1;
                    --this.joinPosition;
                    if (this.joinPosition >= 0) {
                        this.reloadBestPlan = true;
                        this.rewindJoinOrder();
                        this.joinPosition = -1;
                    }
                    this.permuteState = 1;
                    this.endOfRoundCleanup();
                    return false;
                }
            }
            this.optimizableList.getOptimizable(n5).getBestAccessPath().setCostEstimate(null);
            if (this.optimizerTrace) {
                this.trace(12, 0, 0, 0.0, null);
            }
            Optimizable optimizable = this.optimizableList.getOptimizable(n5);
            this.assignedTableMap.or(optimizable.getReferencedTableMap());
            optimizable.startOptimizing(this, this.currentRowOrdering);
            this.pushPredicates(this.optimizableList.getOptimizable(n5), this.assignedTableMap);
            return true;
        }
        this.endOfRoundCleanup();
        return false;
    }

    private void rewindJoinOrder() throws StandardException {
        while (true) {
            Optimizable optimizable = this.optimizableList.getOptimizable(this.proposedJoinOrder[this.joinPosition]);
            optimizable.pullOptPredicates(this.predicateList);
            if (this.reloadBestPlan) {
                optimizable.updateBestPlanMap((short)2, this);
            }
            this.proposedJoinOrder[this.joinPosition] = -1;
            if (this.joinPosition == 0) break;
            --this.joinPosition;
        }
        this.currentCost.setCost(0.0, 0.0, 0.0);
        this.currentSortAvoidanceCost.setCost(0.0, 0.0, 0.0);
        this.assignedTableMap.clearAll();
    }

    private void endOfRoundCleanup() throws StandardException {
        for (int i = 0; i < this.numOptimizables; ++i) {
            this.optimizableList.getOptimizable(i).updateBestPlanMap((short)0, this);
        }
    }

    private double recoverCostFromProposedJoinOrder(boolean bl) throws StandardException {
        double d = 0.0;
        for (int i = 0; i < this.joinPosition; ++i) {
            if (bl) {
                d += this.optimizableList.getOptimizable(this.proposedJoinOrder[i]).getBestSortAvoidancePath().getCostEstimate().getEstimatedCost();
                continue;
            }
            d += this.optimizableList.getOptimizable(this.proposedJoinOrder[i]).getBestAccessPath().getCostEstimate().getEstimatedCost();
        }
        return d;
    }

    private boolean joinOrderMeetsDependencies(int n) throws StandardException {
        Optimizable optimizable = this.optimizableList.getOptimizable(n);
        return optimizable.legalJoinOrder(this.assignedTableMap);
    }

    private void pullOptimizableFromJoinOrder() throws StandardException {
        double d;
        double d2;
        Optimizable optimizable = this.optimizableList.getOptimizable(this.proposedJoinOrder[this.joinPosition]);
        int n = 0;
        if (this.joinPosition == 0) {
            d2 = this.outermostCostEstimate.rowCount();
            d = this.outermostCostEstimate.singleScanRowCount();
        } else {
            n = this.proposedJoinOrder[this.joinPosition - 1];
            CostEstimate costEstimate = this.optimizableList.getOptimizable(n).getBestAccessPath().getCostEstimate();
            d2 = costEstimate.rowCount();
            d = costEstimate.singleScanRowCount();
        }
        double d3 = this.currentCost.getEstimatedCost();
        double d4 = 0.0;
        CostEstimate costEstimate = optimizable.getBestAccessPath().getCostEstimate();
        if (costEstimate != null && (d3 -= (d4 = costEstimate.getEstimatedCost())) <= 0.0) {
            d3 = this.joinPosition == 0 ? 0.0 : this.recoverCostFromProposedJoinOrder(false);
        }
        if (this.joinPosition == 0) {
            d3 = this.outermostCostEstimate != null ? this.outermostCostEstimate.getEstimatedCost() : 0.0;
        }
        this.currentCost.setCost(d3, d2, d);
        if (this.requiredRowOrdering != null && optimizable.considerSortAvoidancePath()) {
            AccessPath accessPath = optimizable.getBestSortAvoidancePath();
            double d5 = 0.0;
            if (this.joinPosition == 0) {
                d2 = this.outermostCostEstimate.rowCount();
                d = this.outermostCostEstimate.singleScanRowCount();
                d5 = this.outermostCostEstimate.getEstimatedCost();
            } else {
                CostEstimate costEstimate2 = this.optimizableList.getOptimizable(n).getBestSortAvoidancePath().getCostEstimate();
                d2 = costEstimate2.rowCount();
                d = costEstimate2.singleScanRowCount();
                d5 = this.currentSortAvoidanceCost.getEstimatedCost() - accessPath.getCostEstimate().getEstimatedCost();
            }
            if (d5 <= 0.0) {
                d5 = this.joinPosition == 0 ? 0.0 : this.recoverCostFromProposedJoinOrder(true);
            }
            this.currentSortAvoidanceCost.setCost(d5, d2, d);
            this.bestRowOrdering.removeOptimizable(optimizable.getTableNumber());
            this.bestRowOrdering.copy(this.currentRowOrdering);
        }
        optimizable.pullOptPredicates(this.predicateList);
        if (this.reloadBestPlan) {
            optimizable.updateBestPlanMap((short)2, this);
        }
        this.proposedJoinOrder[this.joinPosition] = -1;
        this.assignedTableMap.xor(optimizable.getReferencedTableMap());
    }

    void pushPredicates(Optimizable optimizable, JBitSet jBitSet) throws StandardException {
        int n = this.predicateList.size();
        JBitSet jBitSet2 = new JBitSet(this.numTablesInQuery);
        JBitSet jBitSet3 = null;
        BaseTableNumbersVisitor baseTableNumbersVisitor = null;
        boolean bl = false;
        for (int i = n - 1; i >= 0; --i) {
            Predicate predicate = (Predicate)this.predicateList.getOptPredicate(i);
            if (!this.isPushable(predicate)) continue;
            jBitSet2.setTo(predicate.getReferencedMap());
            for (int j = 0; j < jBitSet2.size(); ++j) {
                if (!jBitSet.get(j)) continue;
                jBitSet2.clear(j);
            }
            jBitSet2.and(this.nonCorrelatedTableMap);
            boolean bl2 = bl = jBitSet2.getFirstSetBit() == -1;
            if (bl && predicate.isScopedForPush() && this.numOptimizables > 1) {
                if (baseTableNumbersVisitor == null) {
                    jBitSet3 = new JBitSet(this.numTablesInQuery);
                    baseTableNumbersVisitor = new BaseTableNumbersVisitor(jBitSet3);
                }
                int n2 = ((FromTable)optimizable).getTableNumber();
                jBitSet3.clearAll();
                baseTableNumbersVisitor.setTableMap(jBitSet3);
                ((FromTable)optimizable).accept(baseTableNumbersVisitor);
                if (n2 >= 0) {
                    jBitSet3.set(n2);
                }
                baseTableNumbersVisitor.setTableMap(jBitSet2);
                predicate.accept(baseTableNumbersVisitor);
                jBitSet2.and(jBitSet3);
                if (jBitSet2.getFirstSetBit() == -1) {
                    bl = false;
                }
            }
            if (!bl || !optimizable.pushOptPredicate(predicate)) continue;
            this.predicateList.removeOptPredicate(i);
        }
    }

    public boolean getNextDecoratedPermutation() throws StandardException {
        Optimizable optimizable = this.optimizableList.getOptimizable(this.proposedJoinOrder[this.joinPosition]);
        double d = 0.0;
        boolean bl = optimizable.nextAccessPath(this, null, this.currentRowOrdering);
        if (optimizable.getBestAccessPath().getCostEstimate() != null && optimizable.getCurrentAccessPath().getCostEstimate() != null) {
            if (optimizable.getBestAccessPath().getCostEstimate().compare(optimizable.getCurrentAccessPath().getCostEstimate()) != 0.0) {
                optimizable.updateBestPlanMap((short)2, optimizable);
            } else if (optimizable.getBestAccessPath().getCostEstimate().rowCount() < optimizable.getCurrentAccessPath().getCostEstimate().rowCount()) {
                optimizable.updateBestPlanMap((short)2, optimizable);
            }
        }
        optimizable.updateBestPlanMap((short)0, optimizable);
        CostEstimate costEstimate = optimizable.getBestAccessPath().getCostEstimate();
        if (!bl && costEstimate != null) {
            this.currentCost.setCost(this.currentCost.getEstimatedCost() + costEstimate.getEstimatedCost(), costEstimate.rowCount(), costEstimate.singleScanRowCount());
            if (optimizable.considerSortAvoidancePath() && this.requiredRowOrdering != null) {
                costEstimate = optimizable.getBestSortAvoidancePath().getCostEstimate();
                this.currentSortAvoidanceCost.setCost(this.currentSortAvoidanceCost.getEstimatedCost() + costEstimate.getEstimatedCost(), costEstimate.rowCount(), costEstimate.singleScanRowCount());
            }
            if (this.optimizerTrace) {
                this.trace(13, 0, 0, 0.0, null);
                if (optimizable.considerSortAvoidancePath()) {
                    this.trace(14, 0, 0, 0.0, null);
                }
            }
            if (this.joinPosition == this.numOptimizables - 1) {
                if (this.optimizerTrace) {
                    this.trace(4, 0, 0, 0.0, null);
                }
                if (this.requiredRowOrdering != null) {
                    boolean bl2 = false;
                    if (this.sortCost == null) {
                        this.sortCost = this.newCostEstimate();
                    } else if (this.requiredRowOrdering.getSortNeeded()) {
                        if (this.bestCost.rowCount() > this.currentCost.rowCount()) {
                            this.requiredRowOrdering.estimateCost(this.bestCost.rowCount(), this.bestRowOrdering, this.sortCost);
                            double d2 = this.sortCost.getEstimatedCost();
                            this.requiredRowOrdering.estimateCost(this.currentCost.rowCount(), this.bestRowOrdering, this.sortCost);
                            bl2 = true;
                            this.bestCost.setCost(this.bestCost.getEstimatedCost() - d2 + this.sortCost.getEstimatedCost(), this.sortCost.rowCount(), this.currentCost.singleScanRowCount());
                        } else if (this.bestCost.rowCount() < this.currentCost.rowCount()) {
                            this.currentCost.setCost(this.currentCost.getEstimatedCost(), this.bestCost.rowCount(), this.currentCost.singleScanRowCount());
                        }
                    }
                    if (!bl2) {
                        this.requiredRowOrdering.estimateCost(this.currentCost.rowCount(), this.bestRowOrdering, this.sortCost);
                    }
                    d = this.currentCost.rowCount();
                    this.currentCost.setCost(this.currentCost.getEstimatedCost() + this.sortCost.getEstimatedCost(), this.sortCost.rowCount(), this.currentCost.singleScanRowCount());
                    if (this.optimizerTrace) {
                        this.trace(5, 0, 0, 0.0, null);
                        this.trace(15, 0, 0, 0.0, null);
                    }
                }
                if (!this.foundABestPlan || this.currentCost.compare(this.bestCost) < 0.0 || this.bestCost.isUninitialized()) {
                    this.rememberBestCost(this.currentCost, 1);
                    this.reloadBestPlan = false;
                } else {
                    this.reloadBestPlan = true;
                }
                if (this.requiredRowOrdering != null) {
                    double d3 = this.currentCost.getEstimatedCost() - this.sortCost.getEstimatedCost();
                    if (d3 < 0.0) {
                        d3 = 0.0;
                    }
                    this.currentCost.setCost(d3, d, this.currentCost.singleScanRowCount());
                }
                if (this.requiredRowOrdering != null && optimizable.considerSortAvoidancePath() && this.requiredRowOrdering.sortRequired(this.bestRowOrdering, this.optimizableList, this.proposedJoinOrder) == 3) {
                    if (this.optimizerTrace) {
                        this.trace(16, 0, 0, 0.0, null);
                    }
                    if (this.currentSortAvoidanceCost.compare(this.bestCost) <= 0.0 || this.bestCost.isUninitialized()) {
                        this.rememberBestCost(this.currentSortAvoidanceCost, 2);
                    }
                }
            }
        }
        return bl;
    }

    private void rememberBestCost(CostEstimate costEstimate, int n) throws StandardException {
        int n2;
        this.foundABestPlan = true;
        if (this.optimizerTrace) {
            this.trace(17, 0, 0, 0.0, null);
            this.trace(18, n, 0, 0.0, null);
            this.trace(19, 0, 0, 0.0, null);
        }
        this.bestCost.setCost(costEstimate);
        if (this.bestCost.getEstimatedCost() < this.timeLimit) {
            this.timeLimit = this.bestCost.getEstimatedCost();
        }
        this.bestJoinOrderUsedPredsFromAbove = this.usingPredsPushedFromAbove;
        for (n2 = 0; n2 < this.numOptimizables; ++n2) {
            this.bestJoinOrder[n2] = this.proposedJoinOrder[n2];
        }
        for (n2 = 0; n2 < this.numOptimizables; ++n2) {
            this.optimizableList.getOptimizable(this.bestJoinOrder[n2]).rememberAsBest(n, this);
        }
        if (this.requiredRowOrdering != null) {
            if (n == 2) {
                this.requiredRowOrdering.sortNotNeeded();
            } else {
                this.requiredRowOrdering.sortNeeded();
            }
        }
        if (this.optimizerTrace) {
            if (this.requiredRowOrdering != null) {
                this.trace(20, n, 0, 0.0, null);
            }
            this.trace(21, 0, 0, 0.0, null);
        }
    }

    public void costPermutation() throws StandardException {
        CostEstimate costEstimate = this.joinPosition == 0 ? this.outermostCostEstimate : this.optimizableList.getOptimizable(this.proposedJoinOrder[this.joinPosition - 1]).getBestAccessPath().getCostEstimate();
        Optimizable optimizable = this.optimizableList.getOptimizable(this.proposedJoinOrder[this.joinPosition]);
        if (!optimizable.feasibleJoinStrategy(this.predicateList, this)) {
            return;
        }
        optimizable.optimizeIt(this, this.predicateList, costEstimate, this.currentRowOrdering);
    }

    public void costOptimizable(Optimizable optimizable, TableDescriptor tableDescriptor, ConglomerateDescriptor conglomerateDescriptor, OptimizablePredicateList optimizablePredicateList, CostEstimate costEstimate) throws StandardException {
        if (!optimizable.feasibleJoinStrategy(optimizablePredicateList, this)) {
            return;
        }
        if (this.ruleBasedOptimization) {
            this.ruleBasedCostOptimizable(optimizable, tableDescriptor, conglomerateDescriptor, optimizablePredicateList, costEstimate);
        } else {
            this.costBasedCostOptimizable(optimizable, tableDescriptor, conglomerateDescriptor, optimizablePredicateList, costEstimate);
        }
    }

    private void ruleBasedCostOptimizable(Optimizable optimizable, TableDescriptor tableDescriptor, ConglomerateDescriptor conglomerateDescriptor, OptimizablePredicateList optimizablePredicateList, CostEstimate costEstimate) throws StandardException {
        Object var6_6 = null;
        ConglomerateDescriptor conglomerateDescriptor2 = null;
        AccessPath accessPath = optimizable.getBestAccessPath();
        int n = optimizable.getCurrentAccessPath().getLockMode();
        if (optimizablePredicateList != null && optimizablePredicateList.useful(optimizable, conglomerateDescriptor)) {
            boolean bl = optimizable.isCoveringIndex(conglomerateDescriptor);
            if (!accessPath.getCoveringIndexScan() || accessPath.getNonMatchingIndexScan() || bl) {
                accessPath.setCostEstimate(this.estimateTotalCost(optimizablePredicateList, conglomerateDescriptor, costEstimate, optimizable));
                accessPath.setConglomerateDescriptor(conglomerateDescriptor);
                accessPath.setNonMatchingIndexScan(false);
                accessPath.setCoveringIndexScan(bl);
                accessPath.setLockMode(optimizable.getCurrentAccessPath().getLockMode());
                optimizable.rememberJoinStrategyAsBest(accessPath);
            }
            return;
        }
        if (optimizable.isCoveringIndex(conglomerateDescriptor)) {
            accessPath.setCostEstimate(this.estimateTotalCost(optimizablePredicateList, conglomerateDescriptor, costEstimate, optimizable));
            accessPath.setConglomerateDescriptor(conglomerateDescriptor);
            accessPath.setNonMatchingIndexScan(true);
            accessPath.setCoveringIndexScan(true);
            accessPath.setLockMode(optimizable.getCurrentAccessPath().getLockMode());
            optimizable.rememberJoinStrategyAsBest(accessPath);
            return;
        }
        if (!accessPath.getCoveringIndexScan() && accessPath.getNonMatchingIndexScan() && !conglomerateDescriptor.isIndex()) {
            accessPath.setCostEstimate(this.estimateTotalCost(optimizablePredicateList, conglomerateDescriptor, costEstimate, optimizable));
            accessPath.setConglomerateDescriptor(conglomerateDescriptor);
            accessPath.setLockMode(optimizable.getCurrentAccessPath().getLockMode());
            optimizable.rememberJoinStrategyAsBest(accessPath);
            return;
        }
        conglomerateDescriptor2 = accessPath.getConglomerateDescriptor();
        if (conglomerateDescriptor2 == null) {
            accessPath.setCostEstimate(this.estimateTotalCost(optimizablePredicateList, conglomerateDescriptor, costEstimate, optimizable));
            accessPath.setConglomerateDescriptor(conglomerateDescriptor);
            accessPath.setCoveringIndexScan(false);
            accessPath.setNonMatchingIndexScan(conglomerateDescriptor.isIndex());
            accessPath.setLockMode(optimizable.getCurrentAccessPath().getLockMode());
            optimizable.rememberJoinStrategyAsBest(accessPath);
        }
    }

    private void costBasedCostOptimizable(Optimizable optimizable, TableDescriptor tableDescriptor, ConglomerateDescriptor conglomerateDescriptor, OptimizablePredicateList optimizablePredicateList, CostEstimate costEstimate) throws StandardException {
        CostEstimate costEstimate2 = this.estimateTotalCost(optimizablePredicateList, conglomerateDescriptor, costEstimate, optimizable);
        optimizable.getCurrentAccessPath().setCostEstimate(costEstimate2);
        if (!optimizable.memoryUsageOK(costEstimate2.rowCount() / costEstimate.rowCount(), this.maxMemoryPerTable)) {
            if (this.optimizerTrace) {
                this.trace(22, 0, 0, 0.0, null);
            }
            return;
        }
        AccessPath accessPath = optimizable.getBestAccessPath();
        CostEstimate costEstimate3 = accessPath.getCostEstimate();
        if (costEstimate3 == null || costEstimate3.isUninitialized() || costEstimate2.compare(costEstimate3) < 0.0) {
            accessPath.setConglomerateDescriptor(conglomerateDescriptor);
            accessPath.setCostEstimate(costEstimate2);
            accessPath.setCoveringIndexScan(optimizable.isCoveringIndex(conglomerateDescriptor));
            accessPath.setNonMatchingIndexScan(optimizablePredicateList == null || !optimizablePredicateList.useful(optimizable, conglomerateDescriptor));
            accessPath.setLockMode(optimizable.getCurrentAccessPath().getLockMode());
            optimizable.rememberJoinStrategyAsBest(accessPath);
        }
        if (this.requiredRowOrdering != null && (this.joinPosition == 0 || this.optimizableList.getOptimizable(this.proposedJoinOrder[this.joinPosition - 1]).considerSortAvoidancePath()) && this.requiredRowOrdering.sortRequired(this.currentRowOrdering, this.assignedTableMap, this.optimizableList, this.proposedJoinOrder) == 3 && ((costEstimate3 = (accessPath = optimizable.getBestSortAvoidancePath()).getCostEstimate()) == null || costEstimate3.isUninitialized() || costEstimate2.compare(costEstimate3) < 0.0)) {
            accessPath.setConglomerateDescriptor(conglomerateDescriptor);
            accessPath.setCostEstimate(costEstimate2);
            accessPath.setCoveringIndexScan(optimizable.isCoveringIndex(conglomerateDescriptor));
            accessPath.setNonMatchingIndexScan(optimizablePredicateList == null || !optimizablePredicateList.useful(optimizable, conglomerateDescriptor));
            accessPath.setLockMode(optimizable.getCurrentAccessPath().getLockMode());
            optimizable.rememberJoinStrategyAsBest(accessPath);
            optimizable.rememberSortAvoidancePath();
            this.currentRowOrdering.copy(this.bestRowOrdering);
        }
    }

    public void considerCost(Optimizable optimizable, OptimizablePredicateList optimizablePredicateList, CostEstimate costEstimate, CostEstimate costEstimate2) throws StandardException {
        if (!optimizable.feasibleJoinStrategy(optimizablePredicateList, this)) {
            return;
        }
        optimizable.getCurrentAccessPath().setCostEstimate(costEstimate);
        if (!optimizable.memoryUsageOK(costEstimate.rowCount() / costEstimate2.rowCount(), this.maxMemoryPerTable)) {
            if (this.optimizerTrace) {
                this.trace(22, 0, 0, 0.0, null);
            }
            return;
        }
        AccessPath accessPath = optimizable.getBestAccessPath();
        CostEstimate costEstimate3 = accessPath.getCostEstimate();
        if (costEstimate3 == null || costEstimate3.isUninitialized() || costEstimate.compare(costEstimate3) <= 0.0) {
            accessPath.setCostEstimate(costEstimate);
            optimizable.rememberJoinStrategyAsBest(accessPath);
        }
        if (this.requiredRowOrdering != null && (this.joinPosition == 0 || this.optimizableList.getOptimizable(this.proposedJoinOrder[this.joinPosition - 1]).considerSortAvoidancePath()) && this.requiredRowOrdering.sortRequired(this.currentRowOrdering, this.assignedTableMap, this.optimizableList, this.proposedJoinOrder) == 3 && ((costEstimate3 = (accessPath = optimizable.getBestSortAvoidancePath()).getCostEstimate()) == null || costEstimate3.isUninitialized() || costEstimate.compare(costEstimate3) < 0.0)) {
            accessPath.setCostEstimate(costEstimate);
            optimizable.rememberJoinStrategyAsBest(accessPath);
            optimizable.rememberSortAvoidancePath();
            this.currentRowOrdering.copy(this.bestRowOrdering);
        }
    }

    public DataDictionary getDataDictionary() {
        return this.dDictionary;
    }

    public void modifyAccessPaths() throws StandardException {
        if (this.optimizerTrace) {
            this.trace(7, 0, 0, 0.0, null);
        }
        if (!this.foundABestPlan) {
            if (this.optimizerTrace) {
                this.trace(6, 0, 0, 0.0, null);
            }
            throw StandardException.newException("42Y69");
        }
        this.optimizableList.reOrder(this.bestJoinOrder);
        JBitSet jBitSet = new JBitSet(this.numOptimizables);
        for (int i = 0; i < this.numOptimizables; ++i) {
            Optimizable optimizable = this.optimizableList.getOptimizable(i);
            jBitSet.or(optimizable.getReferencedTableMap());
            this.pushPredicates(optimizable, jBitSet);
            this.optimizableList.setOptimizable(i, optimizable.modifyAccessPath(jBitSet));
        }
    }

    public CostEstimate newCostEstimate() {
        return new CostEstimateImpl();
    }

    public CostEstimate getOptimizedCost() {
        return this.bestCost;
    }

    public CostEstimate getFinalCost() {
        if (this.finalCostEstimate != null) {
            return this.finalCostEstimate;
        }
        this.finalCostEstimate = this.getNewCostEstimate(0.0, 0.0, 0.0);
        CostEstimate costEstimate = null;
        for (int i = 0; i < this.bestJoinOrder.length; ++i) {
            costEstimate = this.optimizableList.getOptimizable(this.bestJoinOrder[i]).getTrulyTheBestAccessPath().getCostEstimate();
            this.finalCostEstimate.setCost(this.finalCostEstimate.getEstimatedCost() + costEstimate.getEstimatedCost(), costEstimate.rowCount(), costEstimate.singleScanRowCount());
        }
        return this.finalCostEstimate;
    }

    public void setOuterRows(double d) {
        this.outermostCostEstimate.setCost(this.outermostCostEstimate.getEstimatedCost(), d, this.outermostCostEstimate.singleScanRowCount());
    }

    public int tableLockThreshold() {
        return this.tableLockThreshold;
    }

    public int getNumberOfJoinStrategies() {
        return this.joinStrategies.length;
    }

    public JoinStrategy getJoinStrategy(int n) {
        return this.joinStrategies[n];
    }

    public JoinStrategy getJoinStrategy(String string2) {
        JoinStrategy joinStrategy = null;
        String string3 = StringUtil.SQLToUpperCase(string2);
        for (int i = 0; i < this.joinStrategies.length; ++i) {
            if (!string3.equals(this.joinStrategies[i].getName())) continue;
            joinStrategy = this.joinStrategies[i];
        }
        return joinStrategy;
    }

    public double uniqueJoinWithOuterTable(OptimizablePredicateList optimizablePredicateList) throws StandardException {
        double d = -1.0;
        double d2 = 1.0;
        double d3 = this.currentCost.rowCount();
        if (optimizablePredicateList != null) {
            for (int i = this.joinPosition - 1; i >= 0; --i) {
                Optimizable optimizable = this.optimizableList.getOptimizable(this.proposedJoinOrder[i]);
                double d4 = optimizable.uniqueJoin(optimizablePredicateList);
                if (!(d4 > 0.0)) continue;
                d2 *= optimizable.uniqueJoin(optimizablePredicateList);
            }
        }
        if (d2 != 1.0) {
            d = d2 / d3;
        }
        return d;
    }

    private boolean isPushable(OptimizablePredicate optimizablePredicate) {
        return !optimizablePredicate.hasSubquery();
    }

    private CostEstimate estimateTotalCost(OptimizablePredicateList optimizablePredicateList, ConglomerateDescriptor conglomerateDescriptor, CostEstimate costEstimate, Optimizable optimizable) throws StandardException {
        CostEstimate costEstimate2 = optimizable.estimateCost(optimizablePredicateList, conglomerateDescriptor, costEstimate, this, this.currentRowOrdering);
        return costEstimate2;
    }

    public int getLevel() {
        return 1;
    }

    public CostEstimateImpl getNewCostEstimate(double d, double d2, double d3) {
        return new CostEstimateImpl(d, d2, d3);
    }

    public void trace(int n, int n2, int n3, double d, Object object) {
    }

    public boolean useStatistics() {
        return this.useStatistics && this.optimizableList.useStatistics();
    }

    protected void updateBestPlanMaps(short s, Object object) throws StandardException {
        block9: {
            int n;
            int[] nArray;
            block10: {
                if (this.numOptimizables <= 1) break block9;
                nArray = null;
                if (s != 0) break block10;
                if (this.savedJoinOrders == null) break block9;
                this.savedJoinOrders.remove(object);
                if (this.savedJoinOrders.size() != 0) break block9;
                this.savedJoinOrders = null;
                break block9;
            }
            if (s == 1) {
                if (this.savedJoinOrders == null) {
                    this.savedJoinOrders = new HashMap();
                } else {
                    nArray = (int[])this.savedJoinOrders.get(object);
                }
                if (nArray == null) {
                    nArray = new int[this.numOptimizables];
                }
                for (n = 0; n < this.bestJoinOrder.length; ++n) {
                    nArray[n] = this.bestJoinOrder[n];
                }
                this.savedJoinOrders.put(object, nArray);
            } else if (this.savedJoinOrders != null && (nArray = (int[])this.savedJoinOrders.get(object)) != null) {
                for (n = 0; n < nArray.length; ++n) {
                    this.bestJoinOrder[n] = nArray[n];
                }
            }
        }
        for (int i = this.optimizableList.size() - 1; i >= 0; --i) {
            this.optimizableList.getOptimizable(i).updateBestPlanMap(s, object);
        }
    }

    protected void addScopedPredicatesToList(PredicateList predicateList) throws StandardException {
        int n;
        if (predicateList == null || predicateList == this.predicateList) {
            return;
        }
        if (this.predicateList == null) {
            this.predicateList = new PredicateList();
        }
        Predicate predicate = null;
        for (n = this.predicateList.size() - 1; n >= 0; --n) {
            predicate = (Predicate)this.predicateList.getOptPredicate(n);
            if (!predicate.isScopedForPush()) continue;
            this.predicateList.removeOptPredicate(n);
        }
        for (n = predicateList.size() - 1; n >= 0; --n) {
            predicate = (Predicate)predicateList.getOptPredicate(n);
            if (!predicate.isScopedToSourceResultSet()) continue;
            predicate.clearScanFlags();
            this.predicateList.addOptPredicate(predicate);
            predicateList.removeOptPredicate(n);
        }
    }
}

