/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute.rts;

import java.util.Enumeration;
import java.util.Properties;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.services.io.FormatableProperties;
import org.apache.derby.iapi.sql.execute.xplain.XPLAINVisitor;
import org.apache.derby.iapi.util.PropertyUtil;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.impl.sql.catalog.XPLAINResultSetDescriptor;
import org.apache.derby.impl.sql.catalog.XPLAINScanPropsDescriptor;
import org.apache.derby.impl.sql.execute.rts.RealNoPutResultSetStatistics;
import org.apache.derby.impl.sql.execute.xplain.XPLAINUtil;

public class RealHashScanStatistics
extends RealNoPutResultSetStatistics {
    public boolean isConstraint;
    public int hashtableSize;
    public int[] hashKeyColumns;
    public String isolationLevel;
    public String lockString;
    public String tableName;
    public String indexName;
    public String nextQualifiers;
    public String scanQualifiers;
    public String startPosition = null;
    public String stopPosition = null;
    public FormatableProperties scanProperties;

    public RealHashScanStatistics(int n, int n2, int n3, long l, long l2, long l3, long l4, int n4, String string2, String string3, boolean bl, int n5, int[] nArray, String string4, String string5, Properties properties, String string6, String string7, String string8, String string9, double d, double d2) {
        super(n, n2, n3, l, l2, l3, l4, n4, d, d2);
        this.tableName = string2;
        this.indexName = string3;
        this.isConstraint = bl;
        this.hashtableSize = n5;
        this.hashKeyColumns = nArray;
        this.scanQualifiers = string4;
        this.nextQualifiers = string5;
        this.scanProperties = new FormatableProperties();
        if (properties != null) {
            Enumeration<Object> enumeration = properties.keys();
            while (enumeration.hasMoreElements()) {
                String string10 = (String)enumeration.nextElement();
                this.scanProperties.put(string10, properties.get(string10));
            }
        }
        this.startPosition = string6;
        this.stopPosition = string7;
        this.isolationLevel = string8;
        this.lockString = string9;
    }

    public String getStatementExecutionPlanText(int n) {
        String string2;
        Object var3_2 = null;
        this.initFormatInfo(n);
        String string3 = this.indexName != null ? this.indent + MessageService.getTextMessage("43X51.U", this.tableName, this.isConstraint ? "constraint" : "index", this.indexName) : this.indent + MessageService.getTextMessage("43X52.U", this.tableName);
        string3 = string3 + " " + MessageService.getTextMessage("43X27.U", this.isolationLevel, this.lockString) + ": \n";
        String string4 = this.indent + MessageService.getTextMessage("43X28.U") + ": \n" + PropertyUtil.sortProperties(this.scanProperties, this.subIndent);
        if (this.hashKeyColumns.length == 1) {
            string2 = MessageService.getTextMessage("43X53.U") + " " + this.hashKeyColumns[0];
        } else {
            string2 = MessageService.getTextMessage("43X54.U") + " (" + this.hashKeyColumns[0];
            for (int i = 1; i < this.hashKeyColumns.length; ++i) {
                string2 = string2 + "," + this.hashKeyColumns[i];
            }
            string2 = string2 + ")";
        }
        return string3 + this.indent + MessageService.getTextMessage("43X03.U") + " = " + this.numOpens + "\n" + this.indent + MessageService.getTextMessage("43X31.U") + " = " + this.hashtableSize + "\n" + this.indent + string2 + "\n" + this.indent + MessageService.getTextMessage("43X04.U") + " = " + this.rowsSeen + "\n" + this.indent + MessageService.getTextMessage("43X32.U") + " = " + this.rowsFiltered + "\n" + this.dumpTimeStats(this.indent, this.subIndent) + "\n" + (this.rowsSeen > 0 ? this.subIndent + MessageService.getTextMessage("43X33.U") + " = " + this.nextTime / (long)this.rowsSeen + "\n" : "") + "\n" + string4 + this.subIndent + MessageService.getTextMessage("43X34.U") + ":\n" + StringUtil.ensureIndent(this.startPosition, n + 2) + "\n" + this.subIndent + MessageService.getTextMessage("43X35.U") + ":\n" + StringUtil.ensureIndent(this.stopPosition, n + 2) + "\n" + this.subIndent + MessageService.getTextMessage("43X36.U") + ":\n" + StringUtil.ensureIndent(this.scanQualifiers, n + 2) + "\n" + this.subIndent + MessageService.getTextMessage("43X37.U") + ":\n" + StringUtil.ensureIndent(this.nextQualifiers, n + 2) + "\n" + this.dumpEstimatedCosts(this.subIndent);
    }

    public String getScanStatisticsText(String string2, int n) {
        if (string2 == null || string2.equals(this.tableName)) {
            return this.getStatementExecutionPlanText(n);
        }
        return "";
    }

    public String toString() {
        return this.getStatementExecutionPlanText(0);
    }

    public String getNodeOn() {
        return MessageService.getTextMessage("43X38.U", this.tableName, this.indexName);
    }

    public String getNodeName() {
        return MessageService.getTextMessage("43X55.U");
    }

    public void accept(XPLAINVisitor xPLAINVisitor) {
        xPLAINVisitor.setNumberOfChildren(0);
        xPLAINVisitor.visit(this);
    }

    public String getRSXplainType() {
        return "HASHSCAN";
    }

    public String getRSXplainDetails() {
        if (this.indexName != null) {
            return (this.isConstraint ? "C: " : "I: ") + this.indexName;
        }
        return "T: " + this.tableName;
    }

    public Object getScanPropsDescriptor(Object object) {
        String string2;
        String string3;
        if (this.indexName != null) {
            if (this.isConstraint) {
                string3 = "C";
                string2 = this.indexName;
            } else {
                string3 = "I";
                string2 = this.indexName;
            }
        } else {
            string3 = "T";
            string2 = this.tableName;
        }
        String string4 = XPLAINUtil.getIsolationLevelCode(this.isolationLevel);
        String string5 = XPLAINUtil.getHashKeyColumnNumberString(this.hashKeyColumns);
        XPLAINScanPropsDescriptor xPLAINScanPropsDescriptor = new XPLAINScanPropsDescriptor((UUID)object, string2, string3, null, string4, null, null, null, null, null, null, null, null, this.startPosition, this.stopPosition, this.scanQualifiers, this.nextQualifiers, string5, new Integer(this.hashtableSize));
        FormatableProperties formatableProperties = this.scanProperties;
        return XPLAINUtil.extractScanProps(xPLAINScanPropsDescriptor, formatableProperties);
    }

    public Object getResultSetDescriptor(Object object, Object object2, Object object3, Object object4, Object object5, Object object6) {
        String string2 = XPLAINUtil.getLockModeCode(this.lockString);
        String string3 = XPLAINUtil.getLockGranularityCode(this.lockString);
        return new XPLAINResultSetDescriptor((UUID)object, this.getRSXplainType(), this.getRSXplainDetails(), new Integer(this.numOpens), null, string2, string3, (UUID)object2, new Double(this.optimizerEstimatedRowCount), new Double(this.optimizerEstimatedCost), null, null, null, new Integer(this.rowsSeen), null, new Integer(this.rowsFiltered), new Integer(this.rowsSeen - this.rowsFiltered), null, null, (UUID)object3, (UUID)object4, (UUID)object5, (UUID)object6);
    }
}

