/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.access;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.daemon.Serviceable;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.io.Storable;
import org.apache.derby.iapi.services.locks.CompatibilitySpace;
import org.apache.derby.iapi.store.access.AccessFactory;
import org.apache.derby.iapi.store.access.BackingStoreHashtable;
import org.apache.derby.iapi.store.access.ColumnOrdering;
import org.apache.derby.iapi.store.access.ConglomerateController;
import org.apache.derby.iapi.store.access.DatabaseInstant;
import org.apache.derby.iapi.store.access.DynamicCompiledOpenConglomInfo;
import org.apache.derby.iapi.store.access.FileResource;
import org.apache.derby.iapi.store.access.GroupFetchScanController;
import org.apache.derby.iapi.store.access.Qualifier;
import org.apache.derby.iapi.store.access.RowLocationRetRowSource;
import org.apache.derby.iapi.store.access.ScanController;
import org.apache.derby.iapi.store.access.SortController;
import org.apache.derby.iapi.store.access.SortCostController;
import org.apache.derby.iapi.store.access.SortObserver;
import org.apache.derby.iapi.store.access.StaticCompiledOpenConglomInfo;
import org.apache.derby.iapi.store.access.StoreCostController;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.store.access.XATransactionController;
import org.apache.derby.iapi.store.access.conglomerate.Conglomerate;
import org.apache.derby.iapi.store.access.conglomerate.ConglomerateFactory;
import org.apache.derby.iapi.store.access.conglomerate.MethodFactory;
import org.apache.derby.iapi.store.access.conglomerate.ScanControllerRowSource;
import org.apache.derby.iapi.store.access.conglomerate.ScanManager;
import org.apache.derby.iapi.store.access.conglomerate.Sort;
import org.apache.derby.iapi.store.access.conglomerate.SortFactory;
import org.apache.derby.iapi.store.access.conglomerate.TransactionManager;
import org.apache.derby.iapi.store.raw.LockingPolicy;
import org.apache.derby.iapi.store.raw.Loggable;
import org.apache.derby.iapi.store.raw.Transaction;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.util.ReuseFactory;
import org.apache.derby.impl.store.access.BackingStoreHashTableFromScan;
import org.apache.derby.impl.store.access.RAMAccessManager;
import org.apache.derby.impl.store.access.RAMTransactionContext;
import org.apache.derby.impl.store.access.conglomerate.ConglomerateUtil;

public class RAMTransaction
implements XATransactionController,
TransactionManager {
    protected Transaction rawtran;
    protected RAMAccessManager accessmanager;
    protected RAMTransactionContext context;
    protected RAMTransaction parent_tran;
    private ArrayList scanControllers;
    private ArrayList conglomerateControllers;
    private ArrayList sorts;
    private ArrayList sortControllers;
    private ArrayList freeSortIds;
    protected HashMap tempCongloms;
    private long nextTempConglomId = -1L;
    private boolean alterTableCallMade = false;
    private int transaction_lock_level;

    private final void init(RAMAccessManager rAMAccessManager, Transaction transaction, RAMTransaction rAMTransaction) {
        this.rawtran = transaction;
        this.parent_tran = rAMTransaction;
        this.accessmanager = rAMAccessManager;
        this.scanControllers = new ArrayList();
        this.conglomerateControllers = new ArrayList();
        this.sorts = null;
        this.freeSortIds = null;
        this.sortControllers = null;
        this.tempCongloms = rAMTransaction != null ? rAMTransaction.tempCongloms : null;
    }

    protected RAMTransaction(RAMAccessManager rAMAccessManager, Transaction transaction, RAMTransaction rAMTransaction) throws StandardException {
        this.init(rAMAccessManager, transaction, rAMTransaction);
    }

    RAMTransaction(RAMAccessManager rAMAccessManager, RAMTransaction rAMTransaction, int n, byte[] byArray, byte[] byArray2) throws StandardException {
        this.init(rAMAccessManager, rAMTransaction.getRawStoreXact(), null);
        this.context = rAMTransaction.context;
        this.context.setTransaction(this);
        this.rawtran.createXATransactionFromLocalTransaction(n, byArray, byArray2);
        rAMTransaction.rawtran = null;
    }

    RAMTransaction() {
    }

    protected void closeControllers(boolean bl) throws StandardException {
        Object object;
        int n;
        if (!this.scanControllers.isEmpty()) {
            for (n = this.scanControllers.size() - 1; n >= 0; --n) {
                object = (ScanManager)this.scanControllers.get(n);
                if (!object.closeForEndTransaction(bl)) continue;
            }
            if (bl) {
                this.scanControllers.clear();
            }
        }
        if (!this.conglomerateControllers.isEmpty()) {
            for (n = this.conglomerateControllers.size() - 1; n >= 0; --n) {
                object = (ConglomerateController)this.conglomerateControllers.get(n);
                if (!object.closeForEndTransaction(bl)) continue;
            }
            if (bl) {
                this.conglomerateControllers.clear();
            }
        }
        if (this.sortControllers != null && !this.sortControllers.isEmpty() && bl) {
            for (n = this.sortControllers.size() - 1; n >= 0; --n) {
                object = (SortController)this.sortControllers.get(n);
                object.completedInserts();
            }
            this.sortControllers.clear();
        }
        if (this.sorts != null && !this.sorts.isEmpty() && bl) {
            for (n = this.sorts.size() - 1; n >= 0; --n) {
                object = (Sort)this.sorts.get(n);
                if (object == null) continue;
                object.drop(this);
            }
            this.sorts.clear();
            this.freeSortIds.clear();
        }
    }

    private LockingPolicy determine_locking_policy(int n, int n2) {
        LockingPolicy lockingPolicy = this.accessmanager.getSystemLockLevel() == 7 || n == 7 ? this.accessmanager.table_level_policy[n2] : this.accessmanager.record_level_policy[n2];
        return lockingPolicy;
    }

    private int determine_lock_level(int n) {
        int n2 = this.accessmanager.getSystemLockLevel() == 7 || n == 7 ? 7 : 6;
        return n2;
    }

    private Conglomerate findExistingConglomerate(long l) throws StandardException {
        Conglomerate conglomerate = this.findConglomerate(l);
        if (conglomerate == null) {
            throw StandardException.newException("XSAI2.S", new Long(l));
        }
        return conglomerate;
    }

    private Conglomerate findConglomerate(long l) throws StandardException {
        Conglomerate conglomerate = null;
        if (l >= 0L) {
            conglomerate = this.accessmanager.conglomCacheFind(this, l);
        } else if (this.tempCongloms != null) {
            conglomerate = (Conglomerate)this.tempCongloms.get(new Long(l));
        }
        return conglomerate;
    }

    void setContext(RAMTransactionContext rAMTransactionContext) {
        this.context = rAMTransactionContext;
    }

    private ConglomerateController openConglomerate(Conglomerate conglomerate, boolean bl, int n, int n2, int n3, StaticCompiledOpenConglomInfo staticCompiledOpenConglomInfo, DynamicCompiledOpenConglomInfo dynamicCompiledOpenConglomInfo) throws StandardException {
        ConglomerateController conglomerateController = conglomerate.open(this, this.rawtran, bl, n, this.determine_lock_level(n2), this.determine_locking_policy(n2, n3), staticCompiledOpenConglomInfo, dynamicCompiledOpenConglomInfo);
        this.conglomerateControllers.add(conglomerateController);
        return conglomerateController;
    }

    private ScanController openScan(Conglomerate conglomerate, boolean bl, int n, int n2, int n3, FormatableBitSet formatableBitSet, DataValueDescriptor[] dataValueDescriptorArray, int n4, Qualifier[][] qualifierArray, DataValueDescriptor[] dataValueDescriptorArray2, int n5, StaticCompiledOpenConglomInfo staticCompiledOpenConglomInfo, DynamicCompiledOpenConglomInfo dynamicCompiledOpenConglomInfo) throws StandardException {
        ScanManager scanManager = conglomerate.openScan(this, this.rawtran, bl, n, this.determine_lock_level(n2), this.determine_locking_policy(n2, n3), n3, formatableBitSet, dataValueDescriptorArray, n4, qualifierArray, dataValueDescriptorArray2, n5, staticCompiledOpenConglomInfo, dynamicCompiledOpenConglomInfo);
        this.scanControllers.add(scanManager);
        return scanManager;
    }

    protected void invalidateConglomerateCache() throws StandardException {
        if (this.alterTableCallMade) {
            this.accessmanager.conglomCacheInvalidate();
            this.alterTableCallMade = false;
        }
    }

    public void addColumnToConglomerate(long l, int n, Storable storable, int n2) throws StandardException {
        boolean bl = l < 0L;
        Conglomerate conglomerate = this.findConglomerate(l);
        if (conglomerate == null) {
            throw StandardException.newException("XSAM2.S", new Long(l));
        }
        ConglomerateController conglomerateController = conglomerate.open(this, this.rawtran, false, 4, 7, this.accessmanager.table_level_policy[5], null, null);
        conglomerate.addColumn(this, n, storable, n2);
        if (!bl) {
            this.alterTableCallMade = true;
        }
        conglomerateController.close();
    }

    public StaticCompiledOpenConglomInfo getStaticCompiledConglomInfo(long l) throws StandardException {
        return this.findExistingConglomerate(l).getStaticCompiledConglomInfo(this, l);
    }

    public DynamicCompiledOpenConglomInfo getDynamicCompiledConglomInfo(long l) throws StandardException {
        return this.findExistingConglomerate(l).getDynamicCompiledConglomInfo();
    }

    private final int countCreatedSorts() {
        int n = 0;
        if (this.sorts != null) {
            for (int i = 0; i < this.sorts.size(); ++i) {
                if (this.sorts.get(i) == null) continue;
                ++n;
            }
        }
        return n;
    }

    public int countOpens(int n) throws StandardException {
        int n2 = -1;
        switch (n) {
            case 1: {
                n2 = this.conglomerateControllers.size();
                break;
            }
            case 2: {
                n2 = this.scanControllers.size();
                break;
            }
            case 3: {
                n2 = this.countCreatedSorts();
                break;
            }
            case 4: {
                n2 = this.sortControllers != null ? this.sortControllers.size() : 0;
                break;
            }
            case 5: {
                n2 = this.conglomerateControllers.size() + this.scanControllers.size() + (this.sortControllers != null ? this.sortControllers.size() : 0) + this.countCreatedSorts();
            }
        }
        return n2;
    }

    public long createConglomerate(String string2, DataValueDescriptor[] dataValueDescriptorArray, ColumnOrdering[] columnOrderingArray, int[] nArray, Properties properties, int n) throws StandardException {
        long l;
        long l2;
        int n2;
        MethodFactory methodFactory = this.accessmanager.findMethodFactoryByImpl(string2);
        if (methodFactory == null || !(methodFactory instanceof ConglomerateFactory)) {
            throw StandardException.newException("XSAM3.S", string2);
        }
        ConglomerateFactory conglomerateFactory = (ConglomerateFactory)methodFactory;
        if ((n & 1) == 1) {
            n2 = -1;
            l2 = 0L;
        } else {
            n2 = 0;
            l2 = this.accessmanager.getNextConglomId(conglomerateFactory.getConglomerateFactoryId());
        }
        Conglomerate conglomerate = conglomerateFactory.createConglomerate(this, n2, l2, dataValueDescriptorArray, columnOrderingArray, nArray, properties, n);
        if ((n & 1) == 1) {
            l = this.nextTempConglomId--;
            if (this.tempCongloms == null) {
                this.tempCongloms = new HashMap();
            }
            this.tempCongloms.put(new Long(l), conglomerate);
        } else {
            l = conglomerate.getContainerid();
            this.accessmanager.conglomCacheAddEntry(l, conglomerate);
        }
        return l;
    }

    public long createAndLoadConglomerate(String string2, DataValueDescriptor[] dataValueDescriptorArray, ColumnOrdering[] columnOrderingArray, int[] nArray, Properties properties, int n, RowLocationRetRowSource rowLocationRetRowSource, long[] lArray) throws StandardException {
        return this.recreateAndLoadConglomerate(string2, true, dataValueDescriptorArray, columnOrderingArray, nArray, properties, n, 0L, rowLocationRetRowSource, lArray);
    }

    public long recreateAndLoadConglomerate(String string2, boolean bl, DataValueDescriptor[] dataValueDescriptorArray, ColumnOrdering[] columnOrderingArray, int[] nArray, Properties properties, int n, long l, RowLocationRetRowSource rowLocationRetRowSource, long[] lArray) throws StandardException {
        long l2 = this.createConglomerate(string2, dataValueDescriptorArray, columnOrderingArray, nArray, properties, n);
        long l3 = this.loadConglomerate(l2, true, rowLocationRetRowSource);
        if (lArray != null) {
            lArray[0] = l3;
        }
        if (!bl && l3 == 0L) {
            this.dropConglomerate(l2);
            l2 = l;
        }
        return l2;
    }

    public String debugOpened() throws StandardException {
        String string2 = null;
        return string2;
    }

    public boolean conglomerateExists(long l) throws StandardException {
        Conglomerate conglomerate = this.findConglomerate(l);
        return conglomerate != null;
    }

    public void dropConglomerate(long l) throws StandardException {
        Conglomerate conglomerate = this.findExistingConglomerate(l);
        conglomerate.drop(this);
        if (l < 0L) {
            if (this.tempCongloms != null) {
                this.tempCongloms.remove(new Long(l));
            }
        } else {
            this.accessmanager.conglomCacheRemoveEntry(l);
        }
    }

    public boolean fetchMaxOnBtree(long l, int n, int n2, int n3, FormatableBitSet formatableBitSet, DataValueDescriptor[] dataValueDescriptorArray) throws StandardException {
        Conglomerate conglomerate = this.findExistingConglomerate(l);
        return conglomerate.fetchMaxOnBTree(this, this.rawtran, l, n, n2, this.determine_locking_policy(n2, n3), n3, formatableBitSet, dataValueDescriptorArray);
    }

    public Properties getUserCreateConglomPropList() {
        Properties properties = ConglomerateUtil.createUserRawStorePropertySet(null);
        return properties;
    }

    public boolean isIdle() {
        return this.rawtran.isIdle();
    }

    public boolean isGlobal() {
        return this.rawtran.getGlobalId() != null;
    }

    public boolean isPristine() {
        return this.rawtran.isPristine();
    }

    public Object createXATransactionFromLocalTransaction(int n, byte[] byArray, byte[] byArray2) throws StandardException {
        this.getRawStoreXact().createXATransactionFromLocalTransaction(n, byArray, byArray2);
        return this;
    }

    public long loadConglomerate(long l, boolean bl, RowLocationRetRowSource rowLocationRetRowSource) throws StandardException {
        Conglomerate conglomerate = this.findExistingConglomerate(l);
        return conglomerate.load(this, bl, rowLocationRetRowSource);
    }

    public void loadConglomerate(long l, RowLocationRetRowSource rowLocationRetRowSource) throws StandardException {
        this.loadConglomerate(l, false, rowLocationRetRowSource);
    }

    public void logAndDo(Loggable loggable) throws StandardException {
        this.rawtran.logAndDo(loggable);
    }

    public ConglomerateController openCompiledConglomerate(boolean bl, int n, int n2, int n3, StaticCompiledOpenConglomInfo staticCompiledOpenConglomInfo, DynamicCompiledOpenConglomInfo dynamicCompiledOpenConglomInfo) throws StandardException {
        return this.openConglomerate((Conglomerate)staticCompiledOpenConglomInfo.getConglom(), bl, n, n2, n3, staticCompiledOpenConglomInfo, dynamicCompiledOpenConglomInfo);
    }

    public ConglomerateController openConglomerate(long l, boolean bl, int n, int n2, int n3) throws StandardException {
        return this.openConglomerate(this.findExistingConglomerate(l), bl, n, n2, n3, null, null);
    }

    public long findConglomid(long l) throws StandardException {
        return l;
    }

    public long findContainerid(long l) throws StandardException {
        return l;
    }

    public BackingStoreHashtable createBackingStoreHashtableFromScan(long l, int n, int n2, int n3, FormatableBitSet formatableBitSet, DataValueDescriptor[] dataValueDescriptorArray, int n4, Qualifier[][] qualifierArray, DataValueDescriptor[] dataValueDescriptorArray2, int n5, long l2, int[] nArray, boolean bl, long l3, long l4, int n6, float f, boolean bl2, boolean bl3, boolean bl4) throws StandardException {
        return new BackingStoreHashTableFromScan(this, l, n, n2, n3, formatableBitSet, dataValueDescriptorArray, n4, qualifierArray, dataValueDescriptorArray2, n5, l2, nArray, bl, l3, l4, n6, f, bl2, bl3, bl4);
    }

    public GroupFetchScanController openGroupFetchScan(long l, boolean bl, int n, int n2, int n3, FormatableBitSet formatableBitSet, DataValueDescriptor[] dataValueDescriptorArray, int n4, Qualifier[][] qualifierArray, DataValueDescriptor[] dataValueDescriptorArray2, int n5) throws StandardException {
        Conglomerate conglomerate = this.findExistingConglomerate(l);
        ScanManager scanManager = conglomerate.openScan(this, this.rawtran, bl, n, this.determine_lock_level(n2), this.determine_locking_policy(n2, n3), n3, formatableBitSet, dataValueDescriptorArray, n4, qualifierArray, dataValueDescriptorArray2, n5, null, null);
        this.scanControllers.add(scanManager);
        return scanManager;
    }

    public void purgeConglomerate(long l) throws StandardException {
        this.findExistingConglomerate(l).purgeConglomerate(this, this.rawtran);
    }

    public void compressConglomerate(long l) throws StandardException {
        this.findExistingConglomerate(l).compressConglomerate(this, this.rawtran);
    }

    public GroupFetchScanController defragmentConglomerate(long l, boolean bl, boolean bl2, int n, int n2, int n3) throws StandardException {
        Conglomerate conglomerate = this.findExistingConglomerate(l);
        ScanManager scanManager = conglomerate.defragmentConglomerate(this, this.rawtran, bl2, n, this.determine_lock_level(n2), this.determine_locking_policy(n2, n3), n3);
        this.scanControllers.add(scanManager);
        return scanManager;
    }

    public ScanController openScan(long l, boolean bl, int n, int n2, int n3, FormatableBitSet formatableBitSet, DataValueDescriptor[] dataValueDescriptorArray, int n4, Qualifier[][] qualifierArray, DataValueDescriptor[] dataValueDescriptorArray2, int n5) throws StandardException {
        return this.openScan(this.findExistingConglomerate(l), bl, n, n2, n3, formatableBitSet, dataValueDescriptorArray, n4, qualifierArray, dataValueDescriptorArray2, n5, null, null);
    }

    public ScanController openCompiledScan(boolean bl, int n, int n2, int n3, FormatableBitSet formatableBitSet, DataValueDescriptor[] dataValueDescriptorArray, int n4, Qualifier[][] qualifierArray, DataValueDescriptor[] dataValueDescriptorArray2, int n5, StaticCompiledOpenConglomInfo staticCompiledOpenConglomInfo, DynamicCompiledOpenConglomInfo dynamicCompiledOpenConglomInfo) throws StandardException {
        return this.openScan((Conglomerate)staticCompiledOpenConglomInfo.getConglom(), bl, n, n2, n3, formatableBitSet, dataValueDescriptorArray, n4, qualifierArray, dataValueDescriptorArray2, n5, staticCompiledOpenConglomInfo, dynamicCompiledOpenConglomInfo);
    }

    public StoreCostController openStoreCost(long l) throws StandardException {
        Conglomerate conglomerate = this.findExistingConglomerate(l);
        StoreCostController storeCostController = conglomerate.openStoreCost(this, this.rawtran);
        return storeCostController;
    }

    public long createSort(Properties properties, DataValueDescriptor[] dataValueDescriptorArray, ColumnOrdering[] columnOrderingArray, SortObserver sortObserver, boolean bl, long l, int n) throws StandardException {
        int n2;
        MethodFactory methodFactory;
        String string2 = null;
        if (properties != null) {
            string2 = properties.getProperty("implType");
        }
        if (string2 == null) {
            string2 = "sort external";
        }
        if ((methodFactory = this.accessmanager.findMethodFactoryByImpl(string2)) == null || !(methodFactory instanceof SortFactory)) {
            throw StandardException.newException("XSAM0.S", string2);
        }
        SortFactory sortFactory = (SortFactory)methodFactory;
        int n3 = 0;
        Sort sort = sortFactory.createSort(this, n3, properties, dataValueDescriptorArray, columnOrderingArray, sortObserver, bl, l, n);
        if (this.sorts == null) {
            this.sorts = new ArrayList();
            this.freeSortIds = new ArrayList();
        }
        if (this.freeSortIds.isEmpty()) {
            n2 = this.sorts.size();
            this.sorts.add(sort);
        } else {
            n2 = (Integer)this.freeSortIds.remove(this.freeSortIds.size() - 1);
            this.sorts.set(n2, sort);
        }
        return n2;
    }

    public void dropSort(long l) throws StandardException {
        Sort sort = (Sort)this.sorts.get((int)l);
        if (sort != null) {
            sort.drop(this);
            this.sorts.set((int)l, null);
            this.freeSortIds.add(ReuseFactory.getInteger((int)l));
        }
    }

    public Serializable getProperty(String string2) throws StandardException {
        return this.accessmanager.getTransactionalProperties().getProperty(this, string2);
    }

    public Serializable getPropertyDefault(String string2) throws StandardException {
        return this.accessmanager.getTransactionalProperties().getPropertyDefault(this, string2);
    }

    public void setProperty(String string2, Serializable serializable, boolean bl) throws StandardException {
        this.accessmanager.getTransactionalProperties().setProperty(this, string2, serializable, bl);
    }

    public void setPropertyDefault(String string2, Serializable serializable) throws StandardException {
        this.accessmanager.getTransactionalProperties().setPropertyDefault(this, string2, serializable);
    }

    public boolean propertyDefaultIsVisible(String string2) throws StandardException {
        return this.accessmanager.getTransactionalProperties().propertyDefaultIsVisible(this, string2);
    }

    public Properties getProperties() throws StandardException {
        return this.accessmanager.getTransactionalProperties().getProperties(this);
    }

    public SortController openSort(long l) throws StandardException {
        Sort sort;
        if (this.sorts == null || l >= (long)this.sorts.size() || (sort = (Sort)this.sorts.get((int)l)) == null) {
            throw StandardException.newException("XSAM4.S", new Long(l));
        }
        SortController sortController = sort.open(this);
        if (this.sortControllers == null) {
            this.sortControllers = new ArrayList();
        }
        this.sortControllers.add(sortController);
        return sortController;
    }

    public SortCostController openSortCostController() throws StandardException {
        MethodFactory methodFactory;
        String string2 = null;
        if (string2 == null) {
            string2 = "sort external";
        }
        if ((methodFactory = this.accessmanager.findMethodFactoryByImpl(string2)) == null || !(methodFactory instanceof SortFactory)) {
            throw StandardException.newException("XSAM0.S", string2);
        }
        SortFactory sortFactory = (SortFactory)methodFactory;
        return sortFactory.openSortCostController();
    }

    public ScanController openSortScan(long l, boolean bl) throws StandardException {
        Sort sort;
        if (this.sorts == null || l >= (long)this.sorts.size() || (sort = (Sort)this.sorts.get((int)l)) == null) {
            throw StandardException.newException("XSAM4.S", new Long(l));
        }
        ScanController scanController = sort.openSortScan(this, bl);
        this.scanControllers.add(scanController);
        return scanController;
    }

    public RowLocationRetRowSource openSortRowSource(long l) throws StandardException {
        Sort sort;
        if (this.sorts == null || l >= (long)this.sorts.size() || (sort = (Sort)this.sorts.get((int)l)) == null) {
            throw StandardException.newException("XSAM4.S", new Long(l));
        }
        ScanControllerRowSource scanControllerRowSource = sort.openSortRowSource(this);
        this.scanControllers.add(scanControllerRowSource);
        return scanControllerRowSource;
    }

    public void commit() throws StandardException {
        this.closeControllers(false);
        this.rawtran.commit();
        this.alterTableCallMade = false;
    }

    public DatabaseInstant commitNoSync(int n) throws StandardException {
        this.closeControllers(false);
        return this.rawtran.commitNoSync(n);
    }

    public void abort() throws StandardException {
        this.invalidateConglomerateCache();
        this.closeControllers(true);
        this.rawtran.abort();
        if (this.parent_tran != null) {
            this.parent_tran.abort();
        }
    }

    public ContextManager getContextManager() {
        return this.context.getContextManager();
    }

    public int setSavePoint(String string2, Object object) throws StandardException {
        return this.rawtran.setSavePoint(string2, object);
    }

    public int releaseSavePoint(String string2, Object object) throws StandardException {
        return this.rawtran.releaseSavePoint(string2, object);
    }

    public int rollbackToSavePoint(String string2, boolean bl, Object object) throws StandardException {
        if (bl) {
            this.closeControllers(true);
        }
        return this.rawtran.rollbackToSavePoint(string2, object);
    }

    public void destroy() {
        try {
            this.closeControllers(true);
            if (this.rawtran != null) {
                this.rawtran.destroy();
                this.rawtran = null;
            }
            if (this.context != null) {
                this.context.popMe();
            }
            this.context = null;
            this.accessmanager = null;
            this.tempCongloms = null;
        }
        catch (StandardException standardException) {
            this.rawtran = null;
            this.context = null;
            this.accessmanager = null;
            this.tempCongloms = null;
        }
    }

    public boolean anyoneBlocked() {
        return this.rawtran.anyoneBlocked();
    }

    public void xa_commit(boolean bl) throws StandardException {
        this.rawtran.xa_commit(bl);
    }

    public int xa_prepare() throws StandardException {
        return this.rawtran.xa_prepare();
    }

    public void xa_rollback() throws StandardException {
        this.rawtran.xa_rollback();
    }

    public void addPostCommitWork(Serviceable serviceable) {
        this.rawtran.addPostCommitWork(serviceable);
    }

    public boolean checkVersion(int n, int n2, String string2) throws StandardException {
        return this.accessmanager.getRawStore().checkVersion(n, n2, string2);
    }

    public void closeMe(ConglomerateController conglomerateController) {
        this.conglomerateControllers.remove(conglomerateController);
    }

    public void closeMe(SortController sortController) {
        this.sortControllers.remove(sortController);
    }

    public void closeMe(ScanManager scanManager) {
        this.scanControllers.remove(scanManager);
    }

    public AccessFactory getAccessManager() {
        return this.accessmanager;
    }

    public TransactionManager getInternalTransaction() throws StandardException {
        ContextManager contextManager = this.getContextManager();
        Transaction transaction = this.accessmanager.getRawStore().startInternalTransaction(contextManager);
        RAMTransaction rAMTransaction = new RAMTransaction(this.accessmanager, transaction, null);
        RAMTransactionContext rAMTransactionContext = new RAMTransactionContext(contextManager, "RAMInternalContext", rAMTransaction, true);
        transaction.setDefaultLockingPolicy(this.accessmanager.getDefaultLockingPolicy());
        return rAMTransaction;
    }

    public TransactionController startNestedUserTransaction(boolean bl, boolean bl2) throws StandardException {
        ContextManager contextManager = this.getContextManager();
        Transaction transaction = bl ? this.accessmanager.getRawStore().startNestedReadOnlyUserTransaction(this.getLockSpace(), contextManager, "nestedReadOnlyUserTransaction") : this.accessmanager.getRawStore().startNestedUpdateUserTransaction(contextManager, "nestedUpdateUserTransaction", bl2);
        RAMTransaction rAMTransaction = new RAMTransaction(this.accessmanager, transaction, this);
        RAMTransactionContext rAMTransactionContext = new RAMTransactionContext(contextManager, "RAMChildContext", rAMTransaction, true);
        transaction.setDefaultLockingPolicy(this.accessmanager.getDefaultLockingPolicy());
        return rAMTransaction;
    }

    public Transaction getRawStoreXact() {
        return this.rawtran;
    }

    public FileResource getFileHandler() {
        return this.rawtran.getFileHandler();
    }

    public CompatibilitySpace getLockSpace() {
        return this.rawtran.getCompatibilitySpace();
    }

    public void setNoLockWait(boolean bl) {
        this.rawtran.setNoLockWait(bl);
    }

    public String getTransactionIdString() {
        return this.rawtran.toString();
    }

    public String getActiveStateTxIdString() {
        return this.rawtran.getActiveStateTxIdString();
    }

    public String toString() {
        String string2 = null;
        return string2;
    }
}

