/*
 * Decompiled with CFR 0.152.
 */
package org.testng.mustache;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.testng.collections.Lists;
import org.testng.mustache.BaseChunk;
import org.testng.mustache.Model;
import org.testng.mustache.StringChunk;
import org.testng.mustache.Value;
import org.testng.mustache.VariableChunk;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Mustache {
    public String run(String template, Map<String, Object> m) throws IOException {
        return this.run(template, new Model(m));
    }

    String run(String template, Model model) throws IOException {
        int lineNumber = 0;
        List<BaseChunk> chunks = Lists.newArrayList();
        int ti = 0;
        while (ti < template.length()) {
            if (template.charAt(ti) == '\n') {
                ++lineNumber;
            }
            if (template.charAt(ti) == '{' && ti + 1 < template.length() && template.charAt(ti + 1) == '{') {
                int index;
                int start = index = ti + 2;
                boolean foundEnd = false;
                while (index < template.length() && !foundEnd) {
                    foundEnd = template.charAt(++index) == '}' && index + 1 < template.length() && template.charAt(index + 1) == '}';
                }
                if (foundEnd) {
                    int end = index;
                    String variable = template.substring(start, end);
                    this.p("Found variable:" + variable);
                    if (variable.startsWith("#")) {
                        String conditionalVariable = variable.substring(1);
                        Value value = model.resolveValue(conditionalVariable);
                        int endIndex = this.findClosingIndex(template, ti, conditionalVariable);
                        Object v = value.get();
                        if (v != null) {
                            if (v instanceof Iterable) {
                                Iterable it = (Iterable)v;
                                String subTemplate = template.substring(ti + variable.length() + 4, endIndex);
                                for (Object o : it) {
                                    model.push(conditionalVariable, o);
                                    String r = new Mustache().run(subTemplate, model);
                                    model.popSubModel();
                                    chunks.add(new StringChunk(model, r));
                                }
                            } else {
                                String subTemplate = template.substring(ti + variable.length() + 4, endIndex);
                                model.push(conditionalVariable, v);
                                String r = new Mustache().run(subTemplate, model);
                                model.popSubModel();
                                chunks.add(new StringChunk(model, r));
                            }
                        }
                        ti = endIndex + variable.length() + 4;
                        continue;
                    }
                    chunks.add(new VariableChunk(model, variable));
                    ti += variable.length() + 4;
                    continue;
                }
                throw new RuntimeException("Unclosed variable at line " + lineNumber);
            }
            chunks.add(new StringChunk(model, "" + template.charAt(ti)));
            ++ti;
        }
        this.p("******************** Final composition, chunks:");
        StringBuilder result = new StringBuilder();
        this.p("*** Template:" + template);
        for (BaseChunk bc : chunks) {
            this.p("***  " + bc);
        }
        for (BaseChunk bc : chunks) {
            String c = bc.compose();
            result.append(c);
        }
        this.p("*** Final result:" + result);
        return result.toString();
    }

    private int findClosingIndex(String template, int ti, String conditionalVariable) {
        int result = template.lastIndexOf("{{/" + conditionalVariable);
        return result;
    }

    private void p(String string2) {
    }

    public static void main(String[] args) throws IOException {
    }
}

