/*
 * Decompiled with CFR 0.152.
 */
package com.occamlab.te.index;

import com.occamlab.te.index.TemplateEntry;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Element;

public class TestEntry
extends TemplateEntry {
    private static final Logger LOGR = Logger.getLogger(TestEntry.class.getName());
    int defaultResult = 1;
    int result = 1;
    String context;
    String type;
    String assertion;
    String isConformanceClass;
    String isBasic;

    public TestEntry() {
    }

    TestEntry(Element test) {
        super(test);
        if (this.usesContext()) {
            this.setContext(test.getElementsByTagName("context").item(0).getTextContent());
        }
        this.setType(test.getElementsByTagName("type").item(0).getTextContent());
        this.setAssertion(test.getElementsByTagName("assertion").item(0).getTextContent());
        String defaultResultName = test.getElementsByTagName("defaultResult").item(0).getTextContent();
        this.setDefaultResult(defaultResultName.equals("BestPractice") ? 0 : 1);
        this.setResult(this.getDefaultResult());
        if (null != test.getAttribute("isConformanceClass") && !test.getAttribute("isConformanceClass").isEmpty()) {
            this.setIsConformanceClass(test.getAttribute("isConformanceClass"));
        }
        if (null != test.getAttribute("isBasic") && !test.getAttribute("isBasic").isEmpty()) {
            this.setIsBasic(test.getAttribute("isBasic"));
        }
    }

    public String getIsConformanceClass() {
        return this.isConformanceClass;
    }

    public void setIsConformanceClass(String isConformanceClass) {
        this.isConformanceClass = isConformanceClass;
    }

    public String getIsBasic() {
        return this.isBasic;
    }

    public void setIsBasic(String isBasic) {
        this.isBasic = isBasic;
    }

    public int getDefaultResult() {
        return this.defaultResult;
    }

    public void setDefaultResult(int defaultResult) {
        this.defaultResult = defaultResult;
    }

    public int getResult() {
        return this.result;
    }

    public void setResult(int result) {
        if (LOGR.isLoggable(Level.FINE)) {
            LOGR.fine(String.format("Setting test result for %s: %d", this.getQName(), result));
        }
        this.result = result;
    }

    public String getContext() {
        return this.context;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getAssertion() {
        return this.assertion;
    }

    public void setAssertion(String assertion) {
        this.assertion = assertion;
    }

    @Override
    public String toString() {
        return super.toString() + "[result=" + this.result + "]";
    }
}

