/*
 * Decompiled with CFR 0.152.
 */
package com.occamlab.te.parsers;

import java.io.PrintWriter;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.TransformerException;

public class XSLTransformationErrorHandler
implements ErrorListener {
    PrintWriter logger;
    boolean ignoreErrors;
    boolean ignoreWarnings;
    int errorCount;
    int warningCount;

    public XSLTransformationErrorHandler(PrintWriter logger, boolean ignoreErrors, boolean ignoreWarnings) {
        this.logger = logger;
        this.ignoreErrors = ignoreErrors;
        this.ignoreWarnings = ignoreWarnings;
    }

    @Override
    public void error(TransformerException e) throws TransformerException {
        if (!this.ignoreErrors) {
            this.logger.println("Error: " + e.getMessageAndLocation());
        }
        ++this.errorCount;
    }

    @Override
    public void fatalError(TransformerException e) throws TransformerException {
        this.logger.println("Fatal Error: " + e.getMessageAndLocation());
    }

    @Override
    public void warning(TransformerException e) throws TransformerException {
        if (!this.ignoreWarnings) {
            this.logger.println("Warning: " + e.getMessageAndLocation());
        }
        ++this.warningCount;
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public int getWarningCount() {
        return this.warningCount;
    }
}

