/*
 * Decompiled with CFR 0.152.
 */
package com.occamlab.te.util;

import com.occamlab.te.NullErrorListener;
import com.occamlab.te.util.DomUtils;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.s9api.Axis;
import net.sf.saxon.s9api.XdmNode;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LogUtils {
    private static final Logger LOGR = Logger.getLogger(LogUtils.class.getName());

    public static PrintWriter createLog(File logDir, String callpath) throws Exception {
        if (logDir != null) {
            File dir = new File(logDir, callpath);
            String path = logDir.toString() + "/" + callpath.split("/")[0];
            System.setProperty("PATH", path);
            dir.mkdir();
            File f = new File(dir, "log.xml");
            f.delete();
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(f), "UTF-8"));
            return new PrintWriter(writer);
        }
        return null;
    }

    public static Document readLog(File logDir, String callpath) throws Exception {
        File dir = new File(logDir, callpath);
        File f = new File(dir, "log.xml");
        if (f.exists()) {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            dbf.setExpandEntityReferences(false);
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.newDocument();
            TransformerFactory tf = TransformerFactory.newInstance();
            tf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            Transformer t = tf.newTransformer();
            t.setErrorListener(new NullErrorListener());
            try {
                t.transform(new StreamSource(f), new DOMResult(doc));
            }
            catch (Exception e) {
                RandomAccessFile raf = new RandomAccessFile(f, "r");
                int l = new Long(raf.length()).intValue();
                byte[] buf = new byte[l + 8];
                raf.read(buf);
                raf.close();
                buf[l] = 10;
                buf[l + 1] = 60;
                buf[l + 2] = 47;
                buf[l + 3] = 108;
                buf[l + 4] = 111;
                buf[l + 5] = 103;
                buf[l + 6] = 62;
                buf[l + 7] = 10;
                doc = db.newDocument();
                tf.newTransformer().transform(new StreamSource(new ByteArrayInputStream(buf)), new DOMResult(doc));
            }
            return doc;
        }
        return null;
    }

    public static String getTestIdFromLog(Document log) throws Exception {
        Element starttest = DomUtils.getElementByTagName(log, "starttest");
        String namespace = starttest.getAttribute("namespace-uri");
        String localName = starttest.getAttribute("local-name");
        return "{" + namespace + "}" + localName;
    }

    public static int getResultFromLog(Document log) throws Exception {
        Element endtest;
        if (log != null && (endtest = DomUtils.getElementByTagName(log, "endtest")) != null) {
            return Integer.parseInt(endtest.getAttribute("result"));
        }
        return -1;
    }

    public static List<String> getParamListFromLog(net.sf.saxon.s9api.DocumentBuilder builder, Document log) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        Element starttest = (Element)log.getElementsByTagName("starttest").item(0);
        for (Element param : DomUtils.getElementsByTagName(starttest, "param")) {
            String value = DomUtils.getElementByTagName(param, "value").getTextContent();
            list.add(param.getAttribute("local-name") + "=" + value);
        }
        return list;
    }

    public static XdmNode getParamsFromLog(net.sf.saxon.s9api.DocumentBuilder builder, Document log) throws Exception {
        Element starttest = (Element)log.getElementsByTagName("starttest").item(0);
        NodeList nl = starttest.getElementsByTagName("params");
        if (nl == null || nl.getLength() == 0) {
            return null;
        }
        Document doc = DomUtils.createDocument(nl.item(0));
        return builder.build((Source)new DOMSource(doc));
    }

    public static XdmNode getContextFromLog(net.sf.saxon.s9api.DocumentBuilder builder, Document log) throws Exception {
        Element starttest = (Element)log.getElementsByTagName("starttest").item(0);
        NodeList nl = starttest.getElementsByTagName("context");
        if (nl == null || nl.getLength() == 0) {
            return null;
        }
        Element context = (Element)nl.item(0);
        Element value = (Element)context.getElementsByTagName("value").item(0);
        nl = value.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeType() == 2) {
                String s = DomUtils.serializeNode(value);
                XdmNode xn = builder.build((Source)new StreamSource(new CharArrayReader(s.toCharArray())));
                return (XdmNode)xn.axisIterator(Axis.ATTRIBUTE).next();
            }
            if (n.getNodeType() != 1) continue;
            Document doc = DomUtils.createDocument(n);
            return builder.build((Source)new DOMSource(doc));
        }
        return null;
    }

    private static Element makeTestListElement(DocumentBuilder db, Document owner, File logdir, String path) throws Exception {
        File log = new File(new File(logdir, path), "log.xml");
        Document logdoc = LogUtils.readLog(log.getParentFile(), ".");
        if (logdoc == null) {
            return null;
        }
        Element log_e = DomUtils.getElementByTagName(logdoc, "log");
        if (log_e == null) {
            return null;
        }
        Element test = owner.createElement("test");
        int result = 1;
        String type = "Mandatory";
        boolean complete = false;
        boolean childrenFailed = false;
        boolean hasCache = false;
        for (Element e : DomUtils.getChildElements(log_e)) {
            if (e.getNodeName().equals("starttest")) {
                NamedNodeMap atts = e.getAttributes();
                for (int j = 0; j < atts.getLength(); ++j) {
                    String nodeName = atts.item(j).getNodeName();
                    String nodeValue = atts.item(j).getNodeValue();
                    if ("defaultResult".equals(nodeName)) {
                        result = Integer.parseInt(nodeValue);
                    } else if ("type".equals(nodeName)) {
                        type = nodeValue;
                    }
                    test.setAttribute(nodeName, nodeValue);
                }
                continue;
            }
            if (e.getNodeName().equals("endtest")) {
                complete = true;
                int code = Integer.parseInt(e.getAttribute("result"));
                if (childrenFailed) {
                    result = 5;
                    continue;
                }
                result = code;
                continue;
            }
            if (e.getNodeName().equals("testcall")) {
                String newpath = e.getAttribute("path");
                Element child = LogUtils.makeTestListElement(db, owner, logdir, newpath);
                if (child == null) continue;
                child.setAttribute("path", newpath);
                int code = Integer.parseInt(child.getAttribute("result"));
                if (code == 6 || code == 5) {
                    childrenFailed = true;
                }
                test.appendChild(child);
                continue;
            }
            if (!e.getNodeName().equals("cache")) continue;
            hasCache = true;
        }
        test.setAttribute("result", Integer.toString(result));
        test.setAttribute("complete", complete ? "yes" : "no");
        test.setAttribute("hasCache", hasCache ? "yes" : "no");
        return test;
    }

    public static Document makeTestList(File logdir, String path, List<List<QName>> excludes) throws Exception {
        boolean updated;
        Document doc;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        dbf.setExpandEntityReferences(false);
        DocumentBuilder db = dbf.newDocumentBuilder();
        File testListFile = new File(logdir, path + File.separator + "testlist.xml");
        long testListDate = testListFile.lastModified();
        File rootlog = new File(logdir, path + File.separator + "log.xml");
        if (testListFile.exists() && testListDate >= rootlog.lastModified()) {
            try {
                doc = db.parse(testListFile);
                updated = LogUtils.updateTestListElement(db, doc.getDocumentElement(), logdir, testListDate) != null;
            }
            catch (Exception e) {
                if (e.toString().contains("Premature end of file")) {
                    return null;
                }
                throw new Exception("Error while writting the 'testlist.xml' file." + e);
            }
        } else {
            doc = db.newDocument();
            Element test = LogUtils.makeTestListElement(db, doc, logdir, path);
            if (test != null) {
                doc.appendChild(test);
                doc.getDocumentElement().setAttribute("path", path);
            }
            updated = true;
        }
        if (updated) {
            TransformerFactory tf = TransformerFactory.newInstance();
            tf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            Transformer t = tf.newTransformer();
            t.setOutputProperty("indent", "yes");
            t.transform(new DOMSource(doc), new StreamResult(testListFile));
        }
        if (excludes.size() > 0) {
            LogUtils.removeExcludes(doc.getDocumentElement(), new ArrayList<QName>(), excludes);
            LogUtils.updateTestListElement(db, doc.getDocumentElement(), logdir, 0L);
        }
        if (LOGR.isLoggable(Level.CONFIG)) {
            StringBuilder msg = new StringBuilder("Read source test list in ");
            msg.append(testListFile.getParent()).append("\n");
            msg.append(DomUtils.serializeNode(doc));
            LOGR.config(msg.toString());
        }
        return doc;
    }

    public static Document makeTestList(File logdir, String path) throws Exception {
        ArrayList<List<QName>> excludes = new ArrayList<List<QName>>();
        return LogUtils.makeTestList(logdir, path, excludes);
    }

    private static Element updateTestListElement(DocumentBuilder db, Element test, File logdir, long testListDate) throws Exception {
        String path = test.getAttribute("path");
        long logdate = 0L;
        if (testListDate > 0L) {
            logdate = new File(logdir, path + File.separator + "log.xml").lastModified();
        }
        if (logdate > testListDate) {
            Element newtest = LogUtils.makeTestListElement(db, test.getOwnerDocument(), logdir, path);
            test.getParentNode().replaceChild(newtest, test);
            return newtest;
        }
        boolean updated = false;
        boolean childrenFailed = false;
        for (Element subtest : DomUtils.getChildElements(test)) {
            Element newsubtest = LogUtils.updateTestListElement(db, subtest, logdir, testListDate);
            if (newsubtest == null) continue;
            updated = true;
            int code = Integer.parseInt(newsubtest.getAttribute("result"));
            if (code != 6 && code != 5) continue;
            childrenFailed = true;
        }
        if (updated || testListDate == 0L) {
            int result = Integer.parseInt(test.getAttribute("result"));
            int newresult = 1;
            if (result == 6) {
                newresult = 6;
            } else if (childrenFailed) {
                newresult = 5;
            } else if (result == 4) {
                newresult = 4;
            }
            if (newresult != result) {
                test.setAttribute("result", Integer.toString(newresult));
                return test;
            }
        }
        return null;
    }

    private static void removeExcludes(Element test, List<QName> pathQName, List<List<QName>> excludes) throws Exception {
        ArrayList<QName> testQName = new ArrayList<QName>();
        testQName.addAll(pathQName);
        String namespaceURI = test.getAttribute("namespace-uri");
        String localPart = test.getAttribute("local-name");
        String prefix = test.getAttribute("prefix");
        QName qname = new QName(namespaceURI, localPart, prefix);
        testQName.add(qname);
        if (excludes.contains(testQName)) {
            test.getParentNode().removeChild(test);
        } else {
            for (Element subtest : DomUtils.getChildElements(test)) {
                LogUtils.removeExcludes(subtest, testQName, excludes);
            }
        }
    }

    public static String generateSessionId(File logDir) {
        int i = 1;
        String session = "s0001";
        while (new File(logDir, session).exists() && i < 10000) {
            session = "s" + Integer.toString(10000 + ++i).substring(1);
        }
        return session;
    }

    public static void createFullReportLog(String sessionLogDir) throws Exception {
        File xml_logs_report_file = new File(sessionLogDir + File.separator + "report_logs.xml");
        if (xml_logs_report_file.exists()) {
            xml_logs_report_file.delete();
            xml_logs_report_file.createNewFile();
        }
        xml_logs_report_file = new File(sessionLogDir + File.separator + "report_logs.xml");
        FileOutputStream report_logs = new FileOutputStream(xml_logs_report_file);
        List<File> files = null;
        Document result = null;
        files = LogUtils.getFileListing(new File(sessionLogDir));
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setExpandEntityReferences(false);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.newDocument();
        Element execution = doc.createElement("execution");
        execution.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xi", "http://www.w3.org/2001/XInclude");
        doc.appendChild(execution);
        for (File file : files) {
            Element include = doc.createElementNS("http://www.w3.org/2001/XInclude", "xi:include");
            include.setAttribute("href", file.getAbsolutePath());
            execution.appendChild(include);
        }
        TransformerFactory xformFactory = TransformerFactory.newInstance();
        xformFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        Transformer idTransform = xformFactory.newTransformer();
        DOMSource input = new DOMSource(doc);
        StreamResult output = new StreamResult(report_logs);
        idTransform.transform(input, output);
        ((OutputStream)report_logs).close();
        result = doc;
    }

    private static List<File> getFileListing(File logDir) throws Exception {
        List<File> result = LogUtils.getFileListingLogs(logDir);
        return result;
    }

    private static List<File> getFileListingLogs(File aStartingDir) throws Exception {
        ArrayList<File> result = new ArrayList<File>();
        File[] logfiles = aStartingDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isFile();
            }
        });
        List<File> logFilesList = Arrays.asList(logfiles);
        File[] allDirs = aStartingDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        });
        for (File file : logFilesList) {
            if (!file.getName().equals("log.xml")) continue;
            result.add(file);
        }
        List<File> allDirsList = Arrays.asList(allDirs);
        Collections.sort(allDirsList, new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                if (o1.lastModified() > o2.lastModified()) {
                    return 1;
                }
                if (o1.lastModified() < o2.lastModified()) {
                    return -1;
                }
                return 0;
            }
        });
        for (File file : allDirsList) {
            if (file.isFile()) continue;
            List<File> deeperList = LogUtils.getFileListingLogs(file);
            result.addAll(deeperList);
        }
        return result;
    }
}

