/*
 * Decompiled with CFR 0.152.
 */
package com.occamlab.te.realm;

import com.occamlab.te.realm.PasswordStorage;
import java.io.File;
import java.lang.reflect.Constructor;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.catalina.Realm;
import org.apache.catalina.realm.GenericPrincipal;
import org.apache.catalina.realm.RealmBase;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class PBKDF2Realm
extends RealmBase {
    private static final Logger LOGR = Logger.getLogger(PBKDF2Realm.class.getName());
    private String rootPath = null;
    private DocumentBuilder DB = null;
    private HashMap<String, Principal> principals = new HashMap();

    public String getRoot() {
        return this.rootPath;
    }

    public Principal authenticate(String username, String credentials) {
        GenericPrincipal principal = (GenericPrincipal)this.getPrincipal(username);
        if (null != principal) {
            try {
                if (!PasswordStorage.verifyPassword(credentials, principal.getPassword())) {
                    principal = null;
                }
            }
            catch (PasswordStorage.CannotPerformOperationException | PasswordStorage.InvalidHashException e) {
                LOGR.log(Level.WARNING, e.getMessage());
                principal = null;
            }
        }
        return principal;
    }

    protected String getPassword(String username) {
        GenericPrincipal principal = (GenericPrincipal)this.getPrincipal(username);
        if (principal == null) {
            return null;
        }
        return principal.getPassword();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Principal getPrincipal(String username) {
        HashMap<String, Principal> hashMap;
        Object principal;
        if (username.startsWith("*") && (principal = this.readPrincipal(username.substring(1))) != null) {
            hashMap = this.principals;
            synchronized (hashMap) {
                this.principals.put(username.substring(1), (Principal)principal);
            }
        }
        hashMap = this.principals;
        synchronized (hashMap) {
            principal = this.principals.get(username);
        }
        if (principal == null && (principal = this.readPrincipal(username)) != null) {
            hashMap = this.principals;
            synchronized (hashMap) {
                this.principals.put(username, (Principal)principal);
            }
        }
        return principal;
    }

    protected String getName() {
        return "UserFilesRealm";
    }

    public void setRoot(String root) {
        this.rootPath = root;
    }

    private GenericPrincipal readPrincipal(String username) {
        File userfile;
        ArrayList<String> roles = new ArrayList<String>();
        File usersdir = new File(this.rootPath);
        if (!usersdir.isDirectory()) {
            usersdir = new File(System.getProperty("TE_BASE"), "users");
        }
        if (!(userfile = new File(new File(usersdir, username), "user.xml")).canRead()) {
            return null;
        }
        Document userInfo = null;
        try {
            if (this.DB == null) {
                this.DB = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            }
            userInfo = this.DB.parse(userfile);
        }
        catch (Exception e) {
            LOGR.log(Level.WARNING, "Failed to read user info at " + userfile.getAbsolutePath(), e);
            return null;
        }
        Element userElement = (Element)userInfo.getElementsByTagName("user").item(0);
        Element passwordElement = (Element)userElement.getElementsByTagName("password").item(0);
        String password = passwordElement.getTextContent();
        Element rolesElement = (Element)userElement.getElementsByTagName("roles").item(0);
        NodeList roleElements = rolesElement.getElementsByTagName("name");
        for (int i = 0; i < roleElements.getLength(); ++i) {
            String name = ((Element)roleElements.item(i)).getTextContent();
            roles.add(name);
        }
        GenericPrincipal principal = this.createGenericPrincipal(username, password, roles);
        return principal;
    }

    GenericPrincipal createGenericPrincipal(String username, String password, List<String> roles) {
        Class<?> klass = null;
        try {
            klass = Class.forName("org.apache.catalina.realm.GenericPrincipal");
        }
        catch (ClassNotFoundException ex) {
            LOGR.log(Level.SEVERE, ex.getMessage());
            return null;
        }
        Constructor<?>[] ctors = klass.getConstructors();
        Class<?> firstParamType = ctors[0].getParameterTypes()[0];
        Class[] paramTypes = new Class[]{Realm.class, String.class, String.class, List.class};
        Object[] ctorArgs = new Object[]{this, username, password, roles};
        GenericPrincipal principal = null;
        try {
            if (Realm.class.isAssignableFrom(firstParamType)) {
                Constructor<?> ctor = klass.getConstructor(paramTypes);
                principal = (GenericPrincipal)ctor.newInstance(ctorArgs);
            } else {
                Constructor<?> ctor = klass.getConstructor(Arrays.copyOfRange(paramTypes, 1, paramTypes.length));
                principal = (GenericPrincipal)ctor.newInstance(Arrays.copyOfRange(ctorArgs, 1, ctorArgs.length));
            }
        }
        catch (Exception ex) {
            LOGR.log(Level.WARNING, ex.getMessage());
        }
        return principal;
    }
}

