/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.impl;

import com.sun.org.apache.xml.internal.security.exceptions.Base64DecodingException;
import com.sun.org.apache.xml.internal.security.keys.content.X509Data;
import com.sun.org.apache.xml.internal.security.keys.content.keyvalues.DSAKeyValue;
import com.sun.org.apache.xml.internal.security.keys.content.keyvalues.RSAKeyValue;
import com.sun.xml.wss.WSITXMLFactory;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.impl.misc.Base64;
import com.sun.xml.wss.logging.LogStringsMessages;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.KeyFactory;
import java.security.cert.X509Certificate;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public class XMLUtil {
    protected static final Logger logger = Logger.getLogger("javax.enterprise.resource.xml.webservices.security", "com.sun.xml.wss.logging.LogStrings");
    protected static SOAPFactory soapFactory;
    private static boolean validating;

    public static SOAPElement convertToSoapElement(Document doc, Element elem) throws DOMException, ClassCastException {
        if (elem instanceof SOAPElement) {
            return (SOAPElement)elem;
        }
        return (SOAPElement)doc.importNode(elem, true);
    }

    public static List getElementsByTagNameNS1(Element element, String nsName, String tagName) {
        ArrayList<Node> list = new ArrayList<Node>();
        if (element != null) {
            NodeList nl = element.getChildNodes();
            int length = nl.getLength();
            Node child = null;
            for (int i = 0; i < length; ++i) {
                child = nl.item(i);
                String childName = child.getLocalName();
                String childNS = child.getNamespaceURI();
                if (childName == null || !childName.equals(tagName) || childNS == null || !childNS.equals(nsName)) continue;
                list.add(child);
            }
        }
        return list;
    }

    public static String getFullTextFromChildren(Element element) {
        if (element == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer(1000);
        NodeList nl = element.getChildNodes();
        Node child = null;
        int length = nl.getLength();
        for (int i = 0; i < length; ++i) {
            child = nl.item(i);
            if (child.getNodeType() != 3) continue;
            sb.append(child.getNodeValue());
        }
        return sb.toString().trim();
    }

    public static boolean inEncryptionNS(SOAPElement element) {
        return element.getNamespaceURI().equals("http://www.w3.org/2001/04/xmlenc#");
    }

    public static boolean inSamlNSv1_0(SOAPElement element) {
        return element.getNamespaceURI().equals("urn:oasis:names:tc:SAML:1.0:assertion");
    }

    public static boolean inSamlNSv2_0(SOAPElement element) {
        return element.getNamespaceURI().equals("urn:oasis:names:tc:SAML:2.0:assertion");
    }

    public static boolean inSamlNSv1_1(SOAPElement element) {
        return element.getNamespaceURI().equals("urn:oasis:names:tc:SAML:1.0:assertion");
    }

    public static boolean inSignatureNS(SOAPElement element) {
        return element.getNamespaceURI().equals("http://www.w3.org/2000/09/xmldsig#");
    }

    public static boolean inWsseNS(SOAPElement element) {
        return element.getNamespaceURI().equals("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
    }

    public static boolean inWsscNS(SOAPElement element) {
        return element.getNamespaceURI().equals("http://schemas.xmlsoap.org/ws/2005/02/sc");
    }

    public static boolean inWsse11NS(SOAPElement element) {
        return element.getNamespaceURI().equals("http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd");
    }

    public static boolean inWSS11_NS(SOAPElement element) {
        return element.getNamespaceURI().equals("http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1");
    }

    public static boolean inWsuNS(SOAPElement element) {
        return element.getNamespaceURI().equals("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
    }

    public static String resolveXPath(Node element) throws Exception {
        if (element.getOwnerDocument() == null) {
            logger.log(Level.SEVERE, LogStringsMessages.WSS_0424_NULL_OWNER_DOCUMENT_ELEMENT());
            throw new Exception("Element does not have an owner document");
        }
        StringBuffer xpath = new StringBuffer();
        String prefix = element.getPrefix();
        String lcname = element.getLocalName();
        String lxpath = prefix + ":" + lcname;
        xpath.append(lxpath);
        for (Node parentNode = element.getParentNode(); parentNode != null && parentNode.getNodeType() != 9; parentNode = parentNode.getParentNode()) {
            prefix = parentNode.getPrefix();
            lcname = parentNode.getLocalName();
            lxpath = prefix + ":" + lcname + "/";
            xpath.insert(0, lxpath);
        }
        xpath.insert(0, "./");
        return xpath.toString();
    }

    public static Element prependChildElement(Element parent, Element child, boolean addWhitespace, Document doc) {
        Node firstChild = parent.getFirstChild();
        if (firstChild == null) {
            parent.appendChild(child);
        } else {
            parent.insertBefore(child, firstChild);
        }
        if (addWhitespace) {
            Text whitespaceText = doc.createTextNode("\n");
            parent.insertBefore(whitespaceText, child);
        }
        return child;
    }

    public static Element prependChildElement(Element parent, Element child, Document doc) {
        return XMLUtil.prependChildElement(parent, child, true, doc);
    }

    public static String print(Node node) {
        if (node == null) {
            return null;
        }
        StringBuffer xml = new StringBuffer(100);
        short type = node.getNodeType();
        switch (type) {
            case 1: {
                xml.append('<');
                xml.append(node.getNodeName());
                NamedNodeMap attrs = node.getAttributes();
                int length = attrs.getLength();
                for (int i = 0; i < length; ++i) {
                    Attr attr = (Attr)attrs.item(i);
                    xml.append(' ');
                    xml.append(attr.getNodeName());
                    xml.append("=\"");
                    xml.append(attr.getNodeValue());
                    xml.append('\"');
                }
                xml.append('>');
                NodeList children = node.getChildNodes();
                if (children == null) break;
                int len = children.getLength();
                for (int i = 0; i < len; ++i) {
                    xml.append(XMLUtil.print(children.item(i)));
                }
                break;
            }
            case 5: {
                NodeList children = node.getChildNodes();
                if (children == null) break;
                int len = children.getLength();
                for (int i = 0; i < len; ++i) {
                    xml.append(XMLUtil.print(children.item(i)));
                }
                break;
            }
            case 4: {
                xml.append("<![CDATA[");
                xml.append(node.getNodeValue());
                xml.append("]]>");
                break;
            }
            case 3: {
                xml.append(node.getNodeValue());
                break;
            }
            case 7: {
                xml.append("<?");
                xml.append(node.getNodeName());
                String data = node.getNodeValue();
                if (data != null && data.length() > 0) {
                    xml.append(' ');
                    xml.append(data);
                }
                xml.append("?>");
                break;
            }
        }
        if (type == 1) {
            xml.append("</");
            xml.append(node.getNodeName());
            xml.append('>');
        }
        return xml.toString();
    }

    public static void setWsuIdAttr(Element element, String wsuId) {
        element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:wsu", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
        element.setAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:Id", wsuId);
    }

    public static void setIdAttr(Element element, String Id2) {
        element.setAttribute("Id", Id2);
        element.setIdAttribute("Id", true);
    }

    public static Document toDOMDocument(InputStream is) {
        DocumentBuilderFactory dbFactory = null;
        try {
            dbFactory = WSITXMLFactory.createDocumentBuilderFactory(WSITXMLFactory.DISABLE_SECURE_PROCESSING);
            dbFactory.setValidating(validating);
            dbFactory.setNamespaceAware(true);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            DocumentBuilder documentBuilder = dbFactory.newDocumentBuilder();
            if (documentBuilder == null) {
                return null;
            }
            documentBuilder.setEntityResolver(new XMLHandler());
            return documentBuilder.parse(is);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Document toDOMDocument(String xmlString) {
        if (xmlString == null) {
            return null;
        }
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(xmlString.getBytes("UTF-8"));
            return XMLUtil.toDOMDocument(is);
        }
        catch (UnsupportedEncodingException uee) {
            return null;
        }
    }

    public static Document newDocument() throws ParserConfigurationException {
        DocumentBuilderFactory dbFactory = WSITXMLFactory.createDocumentBuilderFactory(WSITXMLFactory.DISABLE_SECURE_PROCESSING);
        dbFactory.setNamespaceAware(true);
        dbFactory.setValidating(validating);
        return dbFactory.newDocumentBuilder().newDocument();
    }

    public static boolean hasElementChild(Node node) {
        NodeList nl = node.getChildNodes();
        Node child = null;
        int length = nl.getLength();
        for (int i = 0; i < length; ++i) {
            child = nl.item(i);
            if (child.getNodeType() != 1) continue;
            return true;
        }
        return false;
    }

    public static DSAKeyValue getDSAKeyValue(Document doc, X509Certificate cert) throws XWSSecurityException {
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("DSA");
            DSAPublicKeySpec dsaPkSpec = keyFactory.getKeySpec(cert.getPublicKey(), DSAPublicKeySpec.class);
            return new DSAKeyValue(doc, dsaPkSpec.getP(), dsaPkSpec.getQ(), dsaPkSpec.getG(), dsaPkSpec.getY());
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, LogStringsMessages.WSS_0426_FAILED_DSA_KEY_VALUE(), e);
            throw new XWSSecurityException(e);
        }
    }

    public static RSAKeyValue getRSAKeyValue(Document doc, X509Certificate cert) throws XWSSecurityException {
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            RSAPublicKeySpec rsaPkSpec = keyFactory.getKeySpec(cert.getPublicKey(), RSAPublicKeySpec.class);
            return new RSAKeyValue(doc, rsaPkSpec.getModulus(), rsaPkSpec.getPublicExponent());
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, LogStringsMessages.WSS_0293_FAILED_RSA_KEY_VALUE(), e);
            throw new XWSSecurityException(e);
        }
    }

    public static X509Data getX509Data(Document doc, X509Certificate cert) throws XWSSecurityException {
        try {
            X509Data x509Data = new X509Data(doc);
            x509Data.addCertificate(cert);
            return x509Data;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, LogStringsMessages.WSS_0294_FAILED_X_509_DATA(), e);
            throw new XWSSecurityException(e);
        }
    }

    public static String convertToXpath(String qname) {
        QName name = QName.valueOf(qname);
        if ("".equals(name.getNamespaceURI())) {
            return "//" + name.getLocalPart();
        }
        return "//*[local-name()='" + name.getLocalPart() + "' and namespace-uri()='" + name.getNamespaceURI() + "']";
    }

    public static byte[] getDecodedBase64EncodedData(String encodedData) throws XWSSecurityException {
        try {
            return Base64.decode(encodedData);
        }
        catch (Base64DecodingException e) {
            logger.log(Level.SEVERE, LogStringsMessages.WSS_0427_UNABLETO_DECODE_BASE_64(), e);
            throw new XWSSecurityException("Unable to decode Base64 encoded data", e);
        }
    }

    public static Document getOwnerDocument(Node node) {
        if (node.getNodeType() == 9) {
            return (Document)node;
        }
        return node.getOwnerDocument();
    }

    public static Element getFirstChildElement(Node node) {
        Node child;
        for (child = node.getFirstChild(); child != null && child.getNodeType() != 1; child = child.getNextSibling()) {
        }
        return (Element)child;
    }

    public static Element createElement(Document doc, String tag, String nsURI, String prefix) {
        String qName = prefix == null ? tag : prefix + ":" + tag;
        return doc.createElementNS(nsURI, qName);
    }

    static {
        try {
            soapFactory = SOAPFactory.newInstance();
        }
        catch (SOAPException sOAPException) {
            // empty catch block
        }
        validating = false;
    }

    static class XMLHandler
    extends DefaultHandler {
        XMLHandler() {
        }

        String read(Reader aReader) {
            StringBuffer sb = new StringBuffer();
            try {
                BufferedReader bReader = new BufferedReader(aReader);
                char[] data = new char[2048];
                int count = 0;
                while ((count = bReader.read(data)) != -1) {
                    sb.append(data, 0, count);
                }
                bReader.close();
                aReader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return sb.toString();
        }

        String read(String fileName) {
            return this.read(fileName, XMLUtil.class);
        }

        String read(String fileName, Class cl) {
            String data = "";
            try {
                InputStream in = cl.getResourceAsStream(fileName);
                if (in == null) {
                    try {
                        in = new FileInputStream(fileName);
                    }
                    catch (FileNotFoundException e) {
                        String directoryURL = cl.getProtectionDomain().getCodeSource().getLocation().toString();
                        String fileURL = directoryURL + fileName;
                        URL url = new URL(fileURL);
                        in = url.openStream();
                    }
                }
                data = this.read(new InputStreamReader(in));
                in.close();
            }
            catch (MalformedURLException e) {
            }
            catch (IOException e) {
                // empty catch block
            }
            return data;
        }

        @Override
        public InputSource resolveEntity(String aPublicID, String aSystemID) {
            String sysid = aSystemID.trim();
            if (sysid.toLowerCase().startsWith("jar://")) {
                String dtdname = sysid.substring(5);
                String dtdValue = this.read(dtdname).trim();
                return new InputSource(new StringReader(dtdValue));
            }
            return null;
        }
    }
}

