/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.datatype.xsd;

import com.thaiopensource.datatype.Datatype2;
import com.thaiopensource.datatype.xsd.DatatypeBuilderImpl;
import com.thaiopensource.datatype.xsd.Measure;
import com.thaiopensource.datatype.xsd.OrderRelation;
import com.thaiopensource.util.Localizer;
import org.relaxng.datatype.DatatypeException;
import org.relaxng.datatype.DatatypeStreamingValidator;
import org.relaxng.datatype.ValidationContext;
import org.relaxng.datatype.helpers.StreamingValidatorImpl;

abstract class DatatypeBase
implements Datatype2 {
    private final int whiteSpace;
    static final int WHITE_SPACE_PRESERVE = 0;
    static final int WHITE_SPACE_REPLACE = 1;
    static final int WHITE_SPACE_COLLAPSE = 2;

    abstract boolean lexicallyAllows(String var1);

    DatatypeBase() {
        this.whiteSpace = 2;
    }

    DatatypeBase(int n) {
        this.whiteSpace = n;
    }

    int getWhiteSpace() {
        return this.whiteSpace;
    }

    public boolean isValid(String string2, ValidationContext validationContext) {
        return this.lexicallyAllows(string2 = this.normalizeWhiteSpace(string2)) && this.allowsValue(string2, validationContext);
    }

    public void checkValid(String string2, ValidationContext validationContext) throws DatatypeException {
        string2 = this.normalizeWhiteSpace(string2);
        this.checkLexicallyAllows(string2);
        this.getValue(string2, validationContext);
    }

    public Object createValue(String string2, ValidationContext validationContext) {
        if (!this.lexicallyAllows(string2 = this.normalizeWhiteSpace(string2))) {
            return null;
        }
        try {
            return this.getValue(string2, validationContext);
        }
        catch (DatatypeException datatypeException) {
            return null;
        }
    }

    final String normalizeWhiteSpace(String string2) {
        switch (this.whiteSpace) {
            case 2: {
                return DatatypeBase.collapseWhiteSpace(string2);
            }
            case 1: {
                return DatatypeBase.replaceWhiteSpace(string2);
            }
        }
        return string2;
    }

    void checkLexicallyAllows(String string2) throws DatatypeException {
        if (!this.lexicallyAllows(string2)) {
            throw this.createLexicallyInvalidException();
        }
    }

    String getDescriptionForRestriction() {
        return this.getLexicalSpaceDescription(this.getLexicalSpaceKey());
    }

    final String getLexicalSpaceDescription(String string2) {
        return DatatypeBase.localizer().message("lexical_space_" + string2);
    }

    abstract String getLexicalSpaceKey();

    DatatypeException createLexicallyInvalidException() {
        return new DatatypeException(DatatypeBase.localizer().message("lexical_violation", this.getLexicalSpaceDescription(this.getLexicalSpaceKey())));
    }

    boolean allowsValue(String string2, ValidationContext validationContext) {
        try {
            this.getValue(string2, validationContext);
            return true;
        }
        catch (DatatypeException datatypeException) {
            return false;
        }
    }

    abstract Object getValue(String var1, ValidationContext var2) throws DatatypeException;

    OrderRelation getOrderRelation() {
        return null;
    }

    Measure getMeasure() {
        return null;
    }

    private static String collapseWhiteSpace(String string2) {
        int n = DatatypeBase.collapseStart(string2);
        if (n < 0) {
            return string2;
        }
        StringBuffer stringBuffer = new StringBuffer(string2.substring(0, n));
        boolean bl = n == 0 || string2.charAt(n - 1) == ' ';
        int n2 = string2.length();
        while (n < n2) {
            char c = string2.charAt(n);
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    if (bl) break;
                    stringBuffer.append(' ');
                    bl = true;
                    break;
                }
                default: {
                    bl = false;
                    stringBuffer.append(c);
                }
            }
            ++n;
        }
        if (stringBuffer.length() > 0 && stringBuffer.charAt(stringBuffer.length() - 1) == ' ') {
            stringBuffer.setLength(stringBuffer.length() - 1);
        }
        return stringBuffer.toString();
    }

    private static int collapseStart(String string2) {
        int n = string2.length();
        block4: for (int i = 0; i < n; ++i) {
            switch (string2.charAt(i)) {
                case ' ': {
                    if (i != 0 && string2.charAt(i - 1) != ' ' && i != n - 1) continue block4;
                    return i;
                }
                case '\t': 
                case '\n': 
                case '\r': {
                    return i;
                }
            }
        }
        return -1;
    }

    private static String replaceWhiteSpace(String string2) {
        int n = string2.length();
        for (int i = 0; i < n; ++i) {
            switch (string2.charAt(i)) {
                case '\t': 
                case '\n': 
                case '\r': {
                    char[] cArray = string2.toCharArray();
                    cArray[i] = 32;
                    ++i;
                    while (i < n) {
                        switch (cArray[i]) {
                            case '\t': 
                            case '\n': 
                            case '\r': {
                                cArray[i] = 32;
                            }
                        }
                        ++i;
                    }
                    return new String(cArray);
                }
            }
        }
        return string2;
    }

    DatatypeBase getPrimitive() {
        return this;
    }

    public boolean isContextDependent() {
        return false;
    }

    public boolean alwaysValid() {
        return false;
    }

    public int getIdType() {
        return 0;
    }

    public int valueHashCode(Object object) {
        return object.hashCode();
    }

    public boolean sameValue(Object object, Object object2) {
        return object.equals(object2);
    }

    public DatatypeStreamingValidator createStreamingValidator(ValidationContext validationContext) {
        return new StreamingValidatorImpl(this, validationContext);
    }

    protected static Localizer localizer() {
        return DatatypeBuilderImpl.localizer;
    }
}

