/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.pattern;

import com.thaiopensource.relaxng.pattern.AbstractPatternFunction;
import com.thaiopensource.relaxng.pattern.AfterPattern;
import com.thaiopensource.relaxng.pattern.AttributePattern;
import com.thaiopensource.relaxng.pattern.ChoicePattern;
import com.thaiopensource.relaxng.pattern.DataExceptPattern;
import com.thaiopensource.relaxng.pattern.DataPattern;
import com.thaiopensource.relaxng.pattern.ElementPattern;
import com.thaiopensource.relaxng.pattern.EmptyPattern;
import com.thaiopensource.relaxng.pattern.ErrorPattern;
import com.thaiopensource.relaxng.pattern.GroupPattern;
import com.thaiopensource.relaxng.pattern.InterleavePattern;
import com.thaiopensource.relaxng.pattern.ListPattern;
import com.thaiopensource.relaxng.pattern.NameClass;
import com.thaiopensource.relaxng.pattern.NameClassVisitor;
import com.thaiopensource.relaxng.pattern.NotAllowedPattern;
import com.thaiopensource.relaxng.pattern.OneOrMorePattern;
import com.thaiopensource.relaxng.pattern.Pattern;
import com.thaiopensource.relaxng.pattern.PatternFunction;
import com.thaiopensource.relaxng.pattern.RefPattern;
import com.thaiopensource.relaxng.pattern.SimpleNameClass;
import com.thaiopensource.relaxng.pattern.TextPattern;
import com.thaiopensource.relaxng.pattern.ValuePattern;
import com.thaiopensource.util.VoidValue;
import com.thaiopensource.xml.util.Name;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class PatternDumper {
    private static final String INTERNAL_NAMESPACE = "http://www.thaiopensource.com/relaxng/internal";
    private boolean startTagOpen = false;
    private final ArrayList<String> tagStack = new ArrayList();
    private final StringBuilder buf;
    private int level = 0;
    private boolean suppressIndent = false;
    private final List<ElementPattern> patternList = new ArrayList<ElementPattern>();
    private final Map<String, Integer> localNamePatternCount = new HashMap<String, Integer>();
    private int otherPatternCount;
    private final Map<ElementPattern, String> patternNameMap = new HashMap<ElementPattern, String>();
    private final PatternFunction<VoidValue> dumper = new Dumper();
    private final PatternFunction<VoidValue> elementDumper = new ElementDumper();
    private final PatternFunction<VoidValue> optionalDumper = new OptionalDumper();
    private final PatternFunction<VoidValue> groupDumper = new GroupDumper();
    private final PatternFunction<VoidValue> choiceDumper = new ChoiceDumper();
    private final PatternFunction<VoidValue> interleaveDumper = new InterleaveDumper();
    private final NameClassVisitor nameClassDumper = new NameClassDumper();
    private final NameClassVisitor choiceNameClassDumper = new ChoiceNameClassDumper();

    public static String toString(Pattern pattern) {
        return new PatternDumper().dump(pattern).getSchema();
    }

    private PatternDumper() {
        this.buf = new StringBuilder();
    }

    private String getSchema() {
        return this.buf.toString();
    }

    private PatternDumper dump(Pattern pattern) {
        this.write("<?xml version=\"1.0\"?>");
        this.startElement("grammar");
        this.attribute("xmlns", "http://relaxng.org/ns/structure/1.0");
        this.startElement("start");
        pattern.apply(this.dumper);
        this.endElement();
        for (int i = 0; i < this.patternList.size(); ++i) {
            this.startElement("define");
            ElementPattern elementPattern = this.patternList.get(i);
            this.attribute("name", this.getName(elementPattern));
            elementPattern.apply(this.elementDumper);
            this.endElement();
        }
        this.endElement();
        this.write('\n');
        return this;
    }

    private String getName(ElementPattern elementPattern) {
        String string2 = this.patternNameMap.get(elementPattern);
        if (string2 == null) {
            NameClass nameClass = elementPattern.getNameClass();
            if (nameClass instanceof SimpleNameClass) {
                String string3 = ((SimpleNameClass)nameClass).getName().getLocalName();
                Integer n = this.localNamePatternCount.get(string3);
                if (n == null) {
                    n = 1;
                    string2 = string3;
                    int n2 = string2.lastIndexOf(95);
                    if (n2 >= 0) {
                        try {
                            if (Integer.valueOf(string2.substring(n2 + 1, string2.length())) > 0) {
                                string2 = string2 + "_1";
                            }
                        }
                        catch (NumberFormatException numberFormatException) {}
                    }
                } else {
                    n = n + 1;
                    string2 = string3 + "_" + n;
                }
                this.localNamePatternCount.put(string3, n);
            } else {
                string2 = "_" + ++this.otherPatternCount;
            }
            this.patternList.add(elementPattern);
            this.patternNameMap.put(elementPattern, string2);
        }
        return string2;
    }

    private void startElement(String string2) {
        this.closeStartTag();
        this.indent(this.level);
        this.write('<');
        this.write(string2);
        this.push(string2);
        this.startTagOpen = true;
        ++this.level;
    }

    private void closeStartTag() {
        if (this.startTagOpen) {
            this.startTagOpen = false;
            this.write('>');
        }
    }

    private void attribute(String string2, String string3) {
        this.write(' ');
        this.write(string2);
        this.write('=');
        this.write('\"');
        this.chars(string3, true);
        this.write('\"');
    }

    private void data(String string2) {
        if (string2.length() > 0) {
            this.closeStartTag();
            this.chars(string2, false);
            this.suppressIndent = true;
        }
    }

    private void chars(String string2, boolean bl) {
        int n = string2.length();
        block9: for (int i = 0; i < n; ++i) {
            char c = string2.charAt(i);
            switch (c) {
                case '&': {
                    this.write("&amp;");
                    continue block9;
                }
                case '<': {
                    this.write("&lt;");
                    continue block9;
                }
                case '>': {
                    this.write("&gt;");
                    continue block9;
                }
                case '\r': {
                    this.write("&#xD;");
                    continue block9;
                }
                case '\n': {
                    if (bl) {
                        this.write("&#xA;");
                        continue block9;
                    }
                    this.write(c);
                    continue block9;
                }
                case '\t': {
                    if (bl) {
                        this.write("&#x9;");
                        continue block9;
                    }
                    this.write(c);
                    continue block9;
                }
                case '\"': {
                    if (bl) {
                        this.write("&quot;");
                        continue block9;
                    }
                    this.write(c);
                    continue block9;
                }
                default: {
                    this.write(c);
                }
            }
        }
    }

    private void endElement() {
        --this.level;
        if (this.startTagOpen) {
            this.startTagOpen = false;
            this.write("/>");
            this.pop();
        } else {
            if (!this.suppressIndent) {
                this.indent(this.level);
            }
            this.write("</");
            this.write(this.pop());
            this.write(">");
        }
        this.suppressIndent = false;
    }

    private void indent(int n) {
        this.write('\n');
        for (int i = 0; i < n; ++i) {
            this.write("  ");
        }
    }

    private void write(String string2) {
        this.buf.append(string2);
    }

    private void write(char c) {
        this.buf.append(c);
    }

    private void push(String string2) {
        this.tagStack.add(string2);
    }

    private String pop() {
        return this.tagStack.remove(this.tagStack.size() - 1);
    }

    class ChoiceNameClassDumper
    extends NameClassDumper {
        ChoiceNameClassDumper() {
        }

        public void visitChoice(NameClass nameClass, NameClass nameClass2) {
            nameClass.accept(this);
            nameClass2.accept(this);
        }
    }

    class NameClassDumper
    implements NameClassVisitor {
        NameClassDumper() {
        }

        public void visitChoice(NameClass nameClass, NameClass nameClass2) {
            PatternDumper.this.startElement("choice");
            nameClass.accept(PatternDumper.this.choiceNameClassDumper);
            nameClass2.accept(PatternDumper.this.choiceNameClassDumper);
            PatternDumper.this.endElement();
        }

        public void visitNsName(String string2) {
            PatternDumper.this.startElement("nsName");
            PatternDumper.this.attribute("ns", string2);
            PatternDumper.this.endElement();
        }

        public void visitNsNameExcept(String string2, NameClass nameClass) {
            PatternDumper.this.startElement("nsName");
            PatternDumper.this.attribute("ns", string2);
            PatternDumper.this.startElement("except");
            nameClass.accept(PatternDumper.this.nameClassDumper);
            PatternDumper.this.endElement();
            PatternDumper.this.endElement();
        }

        public void visitAnyName() {
            PatternDumper.this.startElement("anyName");
            PatternDumper.this.endElement();
        }

        public void visitAnyNameExcept(NameClass nameClass) {
            PatternDumper.this.startElement("anyName");
            PatternDumper.this.startElement("except");
            nameClass.accept(PatternDumper.this.nameClassDumper);
            PatternDumper.this.endElement();
            PatternDumper.this.endElement();
        }

        public void visitName(Name name) {
            PatternDumper.this.startElement("name");
            PatternDumper.this.attribute("ns", name.getNamespaceUri());
            PatternDumper.this.data(name.getLocalName());
            PatternDumper.this.endElement();
        }

        public void visitError() {
            PatternDumper.this.startElement("error");
            PatternDumper.this.endElement();
        }

        public void visitNull() {
            this.visitAnyName();
        }
    }

    class InterleaveDumper
    extends Dumper {
        InterleaveDumper() {
        }

        public VoidValue caseInterleave(InterleavePattern interleavePattern) {
            interleavePattern.getOperand1().apply(this);
            interleavePattern.getOperand2().apply(this);
            return VoidValue.VOID;
        }
    }

    class ChoiceDumper
    extends Dumper {
        ChoiceDumper() {
        }

        protected void choice(Pattern pattern, Pattern pattern2) {
            pattern.apply(this);
            pattern2.apply(this);
        }
    }

    class GroupDumper
    extends Dumper {
        GroupDumper() {
        }

        public VoidValue caseGroup(GroupPattern groupPattern) {
            groupPattern.getOperand1().apply(this);
            groupPattern.getOperand2().apply(this);
            return VoidValue.VOID;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class OptionalDumper
    extends AbstractPatternFunction<VoidValue> {
        OptionalDumper() {
        }

        @Override
        public VoidValue caseOther(Pattern pattern) {
            PatternDumper.this.startElement("optional");
            pattern.apply(PatternDumper.this.dumper);
            PatternDumper.this.endElement();
            return VoidValue.VOID;
        }

        @Override
        public VoidValue caseOneOrMore(OneOrMorePattern oneOrMorePattern) {
            PatternDumper.this.startElement("zeroOrMore");
            oneOrMorePattern.getOperand().apply(PatternDumper.this.dumper);
            PatternDumper.this.endElement();
            return VoidValue.VOID;
        }
    }

    class ElementDumper
    extends Dumper {
        ElementDumper() {
        }

        public VoidValue caseElement(ElementPattern elementPattern) {
            PatternDumper.this.startElement("element");
            this.outputName(elementPattern.getNameClass());
            elementPattern.getContent().apply(PatternDumper.this.dumper);
            PatternDumper.this.endElement();
            return VoidValue.VOID;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Dumper
    implements PatternFunction<VoidValue> {
        Dumper() {
        }

        @Override
        public VoidValue caseEmpty(EmptyPattern emptyPattern) {
            PatternDumper.this.startElement("empty");
            PatternDumper.this.endElement();
            return VoidValue.VOID;
        }

        @Override
        public VoidValue caseNotAllowed(NotAllowedPattern notAllowedPattern) {
            PatternDumper.this.startElement("notAllowed");
            PatternDumper.this.endElement();
            return VoidValue.VOID;
        }

        @Override
        public VoidValue caseGroup(GroupPattern groupPattern) {
            PatternDumper.this.startElement("group");
            groupPattern.getOperand1().apply(PatternDumper.this.groupDumper);
            groupPattern.getOperand2().apply(PatternDumper.this.groupDumper);
            PatternDumper.this.endElement();
            return VoidValue.VOID;
        }

        @Override
        public VoidValue caseInterleave(InterleavePattern interleavePattern) {
            PatternDumper.this.startElement("interleave");
            interleavePattern.getOperand1().apply(PatternDumper.this.interleaveDumper);
            interleavePattern.getOperand2().apply(PatternDumper.this.interleaveDumper);
            PatternDumper.this.endElement();
            return VoidValue.VOID;
        }

        @Override
        public VoidValue caseChoice(ChoicePattern choicePattern) {
            Pattern pattern = choicePattern.getOperand1();
            Pattern pattern2 = choicePattern.getOperand2();
            if (pattern instanceof EmptyPattern) {
                pattern2.apply(PatternDumper.this.optionalDumper);
            } else if (pattern2 instanceof EmptyPattern) {
                pattern.apply(PatternDumper.this.optionalDumper);
            } else {
                this.choice(pattern, pattern2);
            }
            return VoidValue.VOID;
        }

        protected void choice(Pattern pattern, Pattern pattern2) {
            PatternDumper.this.startElement("choice");
            pattern.apply(PatternDumper.this.choiceDumper);
            pattern2.apply(PatternDumper.this.choiceDumper);
            PatternDumper.this.endElement();
        }

        @Override
        public VoidValue caseOneOrMore(OneOrMorePattern oneOrMorePattern) {
            PatternDumper.this.startElement("oneOrMore");
            oneOrMorePattern.getOperand().apply(PatternDumper.this.dumper);
            PatternDumper.this.endElement();
            return VoidValue.VOID;
        }

        @Override
        public VoidValue caseElement(ElementPattern elementPattern) {
            PatternDumper.this.startElement("ref");
            PatternDumper.this.attribute("name", PatternDumper.this.getName(elementPattern));
            PatternDumper.this.endElement();
            return VoidValue.VOID;
        }

        @Override
        public VoidValue caseAttribute(AttributePattern attributePattern) {
            PatternDumper.this.startElement("attribute");
            this.outputName(attributePattern.getNameClass());
            attributePattern.getContent().apply(PatternDumper.this.dumper);
            PatternDumper.this.endElement();
            return VoidValue.VOID;
        }

        protected void outputName(NameClass nameClass) {
            if (nameClass instanceof SimpleNameClass) {
                Name name = ((SimpleNameClass)nameClass).getName();
                PatternDumper.this.attribute("name", name.getLocalName());
                PatternDumper.this.attribute("ns", name.getNamespaceUri());
            } else {
                nameClass.accept(PatternDumper.this.nameClassDumper);
            }
        }

        @Override
        public VoidValue caseData(DataPattern dataPattern) {
            this.startData(dataPattern);
            PatternDumper.this.endElement();
            return VoidValue.VOID;
        }

        private void startData(DataPattern dataPattern) {
            PatternDumper.this.startElement("data");
            Name name = dataPattern.getDatatypeName();
            PatternDumper.this.attribute("type", name.getLocalName());
            PatternDumper.this.attribute("datatypeLibrary", name.getNamespaceUri());
            Iterator<String> iterator = dataPattern.getParams().iterator();
            while (iterator.hasNext()) {
                PatternDumper.this.startElement("param");
                PatternDumper.this.attribute("name", iterator.next());
                PatternDumper.this.data(iterator.next());
                PatternDumper.this.endElement();
            }
        }

        @Override
        public VoidValue caseDataExcept(DataExceptPattern dataExceptPattern) {
            this.startData(dataExceptPattern);
            PatternDumper.this.startElement("except");
            dataExceptPattern.getExcept().apply(PatternDumper.this.dumper);
            PatternDumper.this.endElement();
            PatternDumper.this.endElement();
            return VoidValue.VOID;
        }

        @Override
        public VoidValue caseValue(ValuePattern valuePattern) {
            PatternDumper.this.startElement("value");
            Name name = valuePattern.getDatatypeName();
            PatternDumper.this.attribute("type", name.getLocalName());
            PatternDumper.this.attribute("datatypeLibrary", name.getNamespaceUri());
            String string2 = valuePattern.getStringValue();
            Object object = valuePattern.getValue();
            String string3 = "";
            if (object instanceof Name) {
                string3 = ((Name)object).getNamespaceUri();
                int n = string2.indexOf(58);
                if (n < 0) {
                    string2 = string2.substring(n + 1, string2.length());
                }
            }
            PatternDumper.this.attribute("ns", string3);
            PatternDumper.this.data(string2);
            PatternDumper.this.endElement();
            return VoidValue.VOID;
        }

        @Override
        public VoidValue caseText(TextPattern textPattern) {
            PatternDumper.this.startElement("text");
            PatternDumper.this.endElement();
            return VoidValue.VOID;
        }

        @Override
        public VoidValue caseList(ListPattern listPattern) {
            PatternDumper.this.startElement("list");
            listPattern.getOperand().apply(PatternDumper.this.dumper);
            PatternDumper.this.endElement();
            return VoidValue.VOID;
        }

        @Override
        public VoidValue caseRef(RefPattern refPattern) {
            return refPattern.getPattern().apply(this);
        }

        @Override
        public VoidValue caseAfter(AfterPattern afterPattern) {
            PatternDumper.this.startElement("i:after");
            PatternDumper.this.attribute("xmlns:i", PatternDumper.INTERNAL_NAMESPACE);
            afterPattern.getOperand1().apply(this);
            afterPattern.getOperand2().apply(this);
            PatternDumper.this.endElement();
            return VoidValue.VOID;
        }

        @Override
        public VoidValue caseError(ErrorPattern errorPattern) {
            PatternDumper.this.startElement("i:error");
            PatternDumper.this.attribute("xmlns:i", PatternDumper.INTERNAL_NAMESPACE);
            PatternDumper.this.endElement();
            return VoidValue.VOID;
        }
    }
}

