/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.util;

import com.thaiopensource.util.Utf16;
import com.thaiopensource.util.Utf8;

public class UriEncoder {
    private static final int C0_CONTROL = 1;
    private static final int SPACE = 2;
    private static final int DELIM = 4;
    private static final int UNWISE = 8;
    private static final int DELETE = 16;
    private static final int C1_CONTROL = 32;
    private static final int NON_ASCII_SEPARATOR = 64;
    private static final int OTHER_NON_ASCII = 128;
    private static final int ASCII_CONTROL = 17;
    private static final int CONTROL = 49;
    private static final int SEPARATOR = 66;
    private static final int ASCII_GRAPHIC_FORBIDDEN = 12;
    private static final int ASCII_PRINTABLE_FORBIDDEN = 14;
    private static final int ASCII_FORBIDDEN = 31;
    private static final int NON_ASCII = 224;
    private static final int JAVA_URI_FORBIDDEN = 127;
    private static final int URI_FORBIDDEN = 255;
    private static final String hexDigits = "0123456789ABCDEF";

    public static String encode(String string2) {
        return UriEncoder.encode(string2, 127);
    }

    public static String encodeAsAscii(String string2) {
        return UriEncoder.encode(string2, 255);
    }

    private static String encode(String string2, int n) {
        StringBuffer stringBuffer = null;
        int n2 = string2.length();
        for (int i = 0; i < n2; ++i) {
            boolean bl;
            int n3 = string2.charAt(i);
            block0 : switch (n3) {
                case 34: 
                case 60: 
                case 62: {
                    bl = (n & 4) != 0;
                    break;
                }
                case 92: 
                case 94: 
                case 96: 
                case 123: 
                case 124: 
                case 125: {
                    bl = (n & 8) != 0;
                    break;
                }
                case 32: {
                    bl = (n & 2) != 0;
                    break;
                }
                case 127: {
                    bl = (n & 0x10) != 0;
                    break;
                }
                default: {
                    if (n3 < 32) {
                        bl = (n & 1) != 0;
                        break;
                    }
                    if (n3 < 128) {
                        bl = false;
                        break;
                    }
                    switch (n & 0xE0) {
                        case 224: {
                            bl = true;
                            break block0;
                        }
                        case 0: {
                            bl = false;
                            break block0;
                        }
                    }
                    if (Character.isISOControl((char)n3)) {
                        bl = (n & 0x20) != 0;
                        break;
                    }
                    if (Character.isSpaceChar((char)n3)) {
                        bl = (n & 0x40) != 0;
                        break;
                    }
                    boolean bl2 = bl = (n & 0x80) != 0;
                }
            }
            if (bl) {
                if (stringBuffer == null) {
                    stringBuffer = new StringBuffer(string2.substring(0, i));
                }
                int n4 = Utf16.isSurrogate1((char)n3) && i + 1 < n2 && Utf16.isSurrogate2(string2.charAt(i + 1)) ? Utf16.scalarValue((char)n3, string2.charAt(++i)) : n3;
                stringBuffer.append(UriEncoder.percentEncode(Utf8.encode(n4)));
                continue;
            }
            if (stringBuffer == null) continue;
            stringBuffer.append((char)n3);
        }
        if (stringBuffer != null) {
            return stringBuffer.toString();
        }
        return string2;
    }

    static char[] percentEncode(byte[] byArray) {
        char[] cArray = new char[byArray.length * 3];
        int n = 0;
        for (int i = 0; i < byArray.length; ++i) {
            byte by = byArray[i];
            cArray[n++] = 37;
            cArray[n++] = hexDigits.charAt(by >> 4 & 0xF);
            cArray[n++] = hexDigits.charAt(by & 0xF);
        }
        return cArray;
    }
}

