/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.util;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;

public class UriOrFile {
    private UriOrFile() {
    }

    public static String toUri(String string2) {
        String string3 = UriOrFile.getScheme(string2);
        return string3 != null && string3.length() > 1 ? string2 : UriOrFile.fileToUri(string2);
    }

    private static String getScheme(String string2) {
        int n = string2.length();
        if (n == 0) {
            return null;
        }
        if (!UriOrFile.isAlpha(string2.charAt(0))) {
            return null;
        }
        block4: for (int i = 1; i < n; ++i) {
            char c = string2.charAt(i);
            switch (c) {
                case ':': {
                    return string2.substring(0, i);
                }
                case '+': 
                case '-': {
                    continue block4;
                }
                default: {
                    if (UriOrFile.isAlnum(c)) continue block4;
                    return null;
                }
            }
        }
        return null;
    }

    private static boolean isAlpha(char c) {
        return 'a' <= c && c <= 'z' || 'A' <= c && c <= 'Z';
    }

    private static boolean isAlnum(char c) {
        return UriOrFile.isAlpha(c) || '0' <= c && c <= '9';
    }

    public static String fileToUri(String string2) {
        return UriOrFile.fileToUri(new File(string2));
    }

    public static String fileToUri(File file) {
        return file.toURI().toString();
    }

    public static String uriToUriOrFile(String string2) {
        if ("file".equalsIgnoreCase(UriOrFile.getScheme(string2))) {
            try {
                return new File(new URI(string2)).toString();
            }
            catch (URISyntaxException uRISyntaxException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return string2;
    }
}

