/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.validate.picl;

import com.thaiopensource.util.Localizer;
import com.thaiopensource.util.PropertyMap;
import com.thaiopensource.util.SinglePropertyMap;
import com.thaiopensource.validate.IncorrectSchemaException;
import com.thaiopensource.validate.Schema;
import com.thaiopensource.validate.ValidateProperty;
import com.thaiopensource.validate.Validator;
import com.thaiopensource.validate.auto.SchemaFuture;
import com.thaiopensource.validate.picl.Constraint;
import com.thaiopensource.validate.picl.InvalidPatternException;
import com.thaiopensource.validate.picl.KeyConstraint;
import com.thaiopensource.validate.picl.KeyRefConstraint;
import com.thaiopensource.validate.picl.MultiConstraint;
import com.thaiopensource.validate.picl.NamespaceContext;
import com.thaiopensource.validate.picl.Pattern;
import com.thaiopensource.validate.picl.PatternParser;
import com.thaiopensource.validate.picl.SchemaImpl;
import com.thaiopensource.xml.sax.CountingErrorHandler;
import com.thaiopensource.xml.sax.DelegatingContentHandler;
import java.util.Stack;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

class SchemaParser
extends DelegatingContentHandler
implements SchemaFuture,
NamespaceContext {
    private final Vector constraints = new Vector();
    private final PropertyMap properties;
    private final CountingErrorHandler ceh;
    private Locator locator;
    private final Stack prefixes = new Stack();
    private final Localizer localizer = new Localizer(SchemaParser.class);
    private final PatternParser patternParser;

    SchemaParser(PropertyMap propertyMap, Schema schema) {
        this.properties = propertyMap;
        this.ceh = new CountingErrorHandler(propertyMap.get(ValidateProperty.ERROR_HANDLER));
        Validator validator = schema.createValidator(SinglePropertyMap.newInstance(ValidateProperty.ERROR_HANDLER, this.ceh));
        this.setDelegate(validator.getContentHandler());
        this.patternParser = new PatternParser(this.ceh, this.localizer);
    }

    public void setDocumentLocator(Locator locator) {
        super.setDocumentLocator(locator);
        this.locator = locator;
    }

    public void startDocument() throws SAXException {
        super.startDocument();
        this.prefixes.push("xml");
        this.prefixes.push("http://www.w3.org/XML/1998/namespace");
    }

    public void startPrefixMapping(String string2, String string3) throws SAXException {
        if (string2 == null) {
            string2 = "";
        }
        this.prefixes.push(string2);
        if (string3 != null && string3.length() == 0) {
            string3 = null;
        }
        this.prefixes.push(string3);
        super.startPrefixMapping(string2, string3);
    }

    public void endPrefixMapping(String string2) throws SAXException {
        this.prefixes.pop();
        this.prefixes.pop();
        super.endPrefixMapping(string2);
    }

    public void startElement(String string2, String string3, String string4, Attributes attributes) throws SAXException {
        super.startElement(string2, string3, string4, attributes);
        if (this.ceh.getHadErrorOrFatalError()) {
            return;
        }
        if (!string3.equals("constraint")) {
            return;
        }
        String string5 = attributes.getValue("", "key");
        try {
            Pattern pattern = this.patternParser.parse(string5, this.locator, this);
            String string6 = attributes.getValue("", "ref");
            if (string6 != null) {
                Pattern pattern2 = this.patternParser.parse(string6, this.locator, this);
                this.constraints.addElement(new KeyRefConstraint(pattern, pattern2));
            } else {
                this.constraints.addElement(new KeyConstraint(pattern));
            }
        }
        catch (InvalidPatternException invalidPatternException) {
            // empty catch block
        }
    }

    public Schema getSchema() throws IncorrectSchemaException {
        Constraint constraint;
        if (this.ceh.getHadErrorOrFatalError()) {
            throw new IncorrectSchemaException();
        }
        if (this.constraints.size() == 1) {
            constraint = (Constraint)this.constraints.elementAt(0);
        } else {
            Constraint[] constraintArray = new Constraint[this.constraints.size()];
            for (int i = 0; i < constraintArray.length; ++i) {
                constraintArray[i] = (Constraint)this.constraints.elementAt(i);
            }
            constraint = new MultiConstraint(constraintArray);
        }
        return new SchemaImpl(this.properties, constraint);
    }

    public RuntimeException unwrapException(RuntimeException runtimeException) {
        return runtimeException;
    }

    public String getNamespaceUri(String string2) {
        for (int i = this.prefixes.size(); i > 0; i -= 2) {
            if (!this.prefixes.elementAt(i - 2).equals(string2)) continue;
            return (String)this.prefixes.elementAt(i - 1);
        }
        return null;
    }

    public String defaultPrefix() {
        return "";
    }
}

