/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.validate.schematron;

import com.thaiopensource.util.Localizer;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

class OutputHandler
extends DefaultHandler {
    private final ErrorHandler eh;
    private int lineNumber = -1;
    private int columnNumber = -1;
    private String systemId = null;
    private final StringBuffer message = new StringBuffer();
    private boolean inMessage = false;
    private final String lineSeparator;
    private static final String indent = "  ";
    private final Localizer localizer = new Localizer(OutputHandler.class);

    OutputHandler(ErrorHandler errorHandler) {
        this.eh = errorHandler;
        this.lineSeparator = System.getProperty("line.separator");
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.inMessage) {
            block3: for (int i = 0; i < n2; ++i) {
                char c = cArray[n + i];
                switch (c) {
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': {
                        if (this.message.length() != 0 && this.message.charAt(this.message.length() - 1) == ' ') continue block3;
                        this.message.append(' ');
                        continue block3;
                    }
                    default: {
                        this.message.append(c);
                    }
                }
            }
        }
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        this.characters(cArray, n, n2);
    }

    public void startElement(String string2, String string3, String string4, Attributes attributes) throws SAXException {
        if (string3.equals("failed-assertion") || string3.equals("report")) {
            this.lineNumber = OutputHandler.toInteger(attributes.getValue("", "line-number"));
            this.columnNumber = OutputHandler.toInteger(attributes.getValue("", "column-number"));
            this.systemId = attributes.getValue("", "system-id");
            if ("".equals(this.systemId)) {
                this.systemId = null;
            }
            this.message.append(this.localizer.message(string3.equals("failed-assertion") ? "failed_assertion" : "report"));
        } else if (string3.equals("statement") || string3.equals("diagnostic")) {
            this.inMessage = true;
            this.message.append(this.lineSeparator);
            this.message.append(indent);
        }
    }

    private static int toInteger(String string2) {
        if (string2 == null) {
            return -1;
        }
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    public void endElement(String string2, String string3, String string4) throws SAXException {
        if (string3.equals("statement") || string3.equals("diagnostic")) {
            if (this.message.length() > 0 && this.message.charAt(this.message.length() - 1) == ' ') {
                this.message.setLength(this.message.length() - 1);
            }
            this.inMessage = false;
        } else if (string3.equals("failed-assertion") || string3.equals("report")) {
            this.eh.error(new SAXParseException(this.message.toString(), null, this.systemId, this.lineNumber, this.columnNumber));
            this.message.setLength(0);
        }
    }
}

