/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.validate.schematron;

import com.thaiopensource.util.Localizer;
import com.thaiopensource.util.PropertyId;
import com.thaiopensource.util.PropertyMap;
import com.thaiopensource.util.PropertyMapBuilder;
import com.thaiopensource.validate.AbstractSchemaReader;
import com.thaiopensource.validate.IncorrectSchemaException;
import com.thaiopensource.validate.Option;
import com.thaiopensource.validate.ResolverFactory;
import com.thaiopensource.validate.Schema;
import com.thaiopensource.validate.ValidateProperty;
import com.thaiopensource.validate.Validator;
import com.thaiopensource.validate.prop.rng.RngProperty;
import com.thaiopensource.validate.prop.schematron.SchematronProperty;
import com.thaiopensource.validate.rng.CompactSchemaReader;
import com.thaiopensource.validate.schematron.IfValidHandler;
import com.thaiopensource.validate.schematron.SchemaImpl;
import com.thaiopensource.validate.schematron.TransformerFactoryInitializer;
import com.thaiopensource.xml.sax.CountingErrorHandler;
import com.thaiopensource.xml.sax.DelegatingContentHandler;
import com.thaiopensource.xml.sax.DraconianErrorHandler;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TemplatesHandler;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamSource;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SchemaReaderImpl
extends AbstractSchemaReader {
    static final String SCHEMATRON_URI = "http://www.ascc.net/xml/schematron";
    private static final String LOCATION_URI = "http://www.thaiopensource.com/ns/location";
    private static final String ERROR_URI = "http://www.thaiopensource.com/ns/error";
    private final Localizer localizer = new Localizer(SchemaReaderImpl.class);
    private final Class<? extends SAXTransformerFactory> transformerFactoryClass;
    private final TransformerFactoryInitializer transformerFactoryInitializer;
    private final Templates schematron;
    private final Schema schematronSchema;
    private static final String SCHEMATRON_SCHEMA = "schematron.rnc";
    private static final String SCHEMATRON_STYLESHEET = "schematron.xsl";
    private static final String SCHEMATRON_XSLTC_STYLESHEET = "schematron-xsltc.xsl";
    private static final PropertyId<?>[] supportedPropertyIds = new PropertyId[]{ValidateProperty.ERROR_HANDLER, ValidateProperty.XML_READER_CREATOR, ValidateProperty.ENTITY_RESOLVER, ValidateProperty.URI_RESOLVER, ValidateProperty.RESOLVER, SchematronProperty.DIAGNOSE, SchematronProperty.PHASE};

    SchemaReaderImpl(SAXTransformerFactory sAXTransformerFactory, TransformerFactoryInitializer transformerFactoryInitializer) throws TransformerConfigurationException, IncorrectSchemaException {
        this.transformerFactoryClass = sAXTransformerFactory.getClass();
        this.transformerFactoryInitializer = transformerFactoryInitializer;
        boolean bl = SchemaReaderImpl.isXsltc(this.transformerFactoryClass);
        String string2 = bl ? SCHEMATRON_XSLTC_STYLESHEET : SCHEMATRON_STYLESHEET;
        String string3 = SchemaReaderImpl.fullResourceName(string2);
        StreamSource streamSource = new StreamSource(SchemaReaderImpl.getResourceAsStream(string3));
        this.initTransformerFactory(sAXTransformerFactory);
        this.schematron = sAXTransformerFactory.newTemplates(streamSource);
        InputSource inputSource = new InputSource(SchemaReaderImpl.getResourceAsStream(SchemaReaderImpl.fullResourceName(SCHEMATRON_SCHEMA)));
        PropertyMapBuilder propertyMapBuilder = new PropertyMapBuilder();
        propertyMapBuilder.put(ValidateProperty.ERROR_HANDLER, new DraconianErrorHandler());
        RngProperty.CHECK_ID_IDREF.add(propertyMapBuilder);
        try {
            this.schematronSchema = CompactSchemaReader.getInstance().createSchema(inputSource, propertyMapBuilder.toPropertyMap());
        }
        catch (SAXException sAXException) {
            throw new IncorrectSchemaException();
        }
        catch (IOException iOException) {
            throw new IncorrectSchemaException();
        }
    }

    static boolean isXsltc(Class<? extends SAXTransformerFactory> clazz) {
        return clazz.getName().indexOf(".xsltc.") >= 0;
    }

    @Override
    public Option getOption(String string2) {
        return SchematronProperty.getOption(string2);
    }

    private void initTransformerFactory(TransformerFactory transformerFactory) {
        this.transformerFactoryInitializer.initTransformerFactory(transformerFactory);
    }

    @Override
    public Schema createSchema(SAXSource sAXSource, PropertyMap propertyMap) throws IOException, SAXException, IncorrectSchemaException {
        ErrorHandler errorHandler = propertyMap.get(ValidateProperty.ERROR_HANDLER);
        CountingErrorHandler countingErrorHandler = new CountingErrorHandler(errorHandler);
        InputSource inputSource = sAXSource.getInputSource();
        String string2 = inputSource.getSystemId();
        IfValidHandler ifValidHandler = new IfValidHandler();
        ifValidHandler.setErrorHandler(countingErrorHandler);
        try {
            boolean bl;
            SAXTransformerFactory sAXTransformerFactory = this.transformerFactoryClass.newInstance();
            this.initTransformerFactory(sAXTransformerFactory);
            TransformerHandler transformerHandler = sAXTransformerFactory.newTransformerHandler(this.schematron);
            ifValidHandler.setDelegate(transformerHandler);
            Transformer transformer = transformerHandler.getTransformer();
            String string3 = propertyMap.get(SchematronProperty.PHASE);
            if (string3 != null) {
                transformer.setParameter("phase", string3);
            }
            if (bl = propertyMap.contains(SchematronProperty.DIAGNOSE)) {
                transformer.setParameter("diagnose", Boolean.TRUE);
            }
            PropertyMapBuilder propertyMapBuilder = new PropertyMapBuilder(propertyMap);
            propertyMapBuilder.put(ValidateProperty.ERROR_HANDLER, ifValidHandler);
            Validator validator = this.schematronSchema.createValidator(propertyMapBuilder.toPropertyMap());
            ifValidHandler.setValidator(validator.getContentHandler());
            XMLReader xMLReader = sAXSource.getXMLReader();
            if (xMLReader == null) {
                xMLReader = ResolverFactory.createResolver(propertyMap).createXMLReader();
            }
            xMLReader.setContentHandler(ifValidHandler);
            xMLReader.setDTDHandler(validator.getDTDHandler());
            sAXTransformerFactory.setErrorListener(new SAXErrorListener(countingErrorHandler, string2));
            TemplatesHandler templatesHandler = sAXTransformerFactory.newTemplatesHandler();
            templatesHandler.setSystemId(string2);
            LocationFilter locationFilter = new LocationFilter(new ErrorFilter(templatesHandler, countingErrorHandler, this.localizer), string2);
            transformerHandler.setResult(new SAXResult(locationFilter));
            xMLReader.setErrorHandler(countingErrorHandler);
            xMLReader.parse(inputSource);
            SAXException sAXException = locationFilter.getException();
            if (sAXException != null) {
                throw sAXException;
            }
            if (countingErrorHandler.getHadErrorOrFatalError()) {
                throw new IncorrectSchemaException();
            }
            Templates templates = templatesHandler.getTemplates();
            if (countingErrorHandler.getHadErrorOrFatalError()) {
                throw new IncorrectSchemaException();
            }
            return new SchemaImpl(templates, this.transformerFactoryClass, propertyMap, supportedPropertyIds);
        }
        catch (SAXException sAXException) {
            throw SchemaReaderImpl.cleanupSAXException(sAXException);
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            throw new SAXException(this.localizer.message("unexpected_schema_creation_error"));
        }
        catch (InstantiationException instantiationException) {
            throw new SAXException(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new SAXException(illegalAccessException);
        }
    }

    private static String fullResourceName(String string2) {
        String string3 = SchemaReaderImpl.class.getName();
        return string3.substring(0, string3.lastIndexOf(46)).replace('.', '/') + "/resources/" + string2;
    }

    private static InputStream getResourceAsStream(String string2) {
        ClassLoader classLoader = SchemaReaderImpl.class.getClassLoader();
        if (classLoader == null) {
            return ClassLoader.getSystemResourceAsStream(string2);
        }
        return classLoader.getResourceAsStream(string2);
    }

    private static SAXException cleanupSAXException(SAXException sAXException) {
        if (SchemaReaderImpl.exceptionHasLocation(sAXException)) {
            return sAXException;
        }
        Exception exception = sAXException.getException();
        if (exception instanceof SAXException && exception.getMessage() == null) {
            return SchemaReaderImpl.cleanupSAXException((SAXException)exception);
        }
        if (exception instanceof TransformerException) {
            return SchemaReaderImpl.cleanupTransformerException((TransformerException)exception);
        }
        return sAXException;
    }

    private static SAXException cleanupTransformerException(TransformerException transformerException) {
        String string2 = transformerException.getMessage();
        Throwable throwable = transformerException.getException();
        SourceLocator sourceLocator = transformerException.getLocator();
        if (string2 != null && throwable != null && string2.equals(throwable.toString())) {
            string2 = null;
        }
        if (string2 == null && throwable instanceof SAXException && sourceLocator == null) {
            return SchemaReaderImpl.cleanupSAXException((SAXException)throwable);
        }
        if (throwable instanceof TransformerException && sourceLocator == null) {
            return SchemaReaderImpl.cleanupTransformerException((TransformerException)throwable);
        }
        Exception exception = null;
        if (throwable instanceof Exception) {
            exception = (Exception)throwable;
        }
        String string3 = null;
        String string4 = null;
        int n = -1;
        int n2 = -1;
        if (sourceLocator != null) {
            string3 = sourceLocator.getPublicId();
            string4 = sourceLocator.getSystemId();
            n = sourceLocator.getLineNumber();
            n2 = sourceLocator.getColumnNumber();
        }
        if (string3 != null || string4 != null || n >= 0 || n2 >= 0) {
            return new SAXParseException(string2, string3, string4, n, n2, exception);
        }
        return new SAXException(string2, exception);
    }

    private static boolean exceptionHasLocation(SAXException sAXException) {
        if (!(sAXException instanceof SAXParseException)) {
            return false;
        }
        SAXParseException sAXParseException = (SAXParseException)sAXException;
        return sAXParseException.getPublicId() != null || sAXParseException.getSystemId() != null || sAXParseException.getLineNumber() >= 0 || sAXParseException.getColumnNumber() >= 0;
    }

    static class SAXErrorListener
    implements ErrorListener {
        private final ErrorHandler eh;
        private final String systemId;
        private boolean hadError = false;

        SAXErrorListener(ErrorHandler errorHandler, String string2) {
            this.eh = errorHandler;
            this.systemId = string2;
        }

        boolean getHadError() {
            return this.hadError;
        }

        public void warning(TransformerException transformerException) throws TransformerException {
            SAXParseException sAXParseException = this.transform(transformerException);
            try {
                this.eh.warning(sAXParseException);
            }
            catch (SAXException sAXException) {
                throw new TransformerException(new UserException(sAXException));
            }
        }

        public void error(TransformerException transformerException) throws TransformerException {
            this.hadError = true;
            SAXParseException sAXParseException = this.transform(transformerException);
            try {
                this.eh.error(sAXParseException);
            }
            catch (SAXException sAXException) {
                throw new TransformerException(new UserException(sAXException));
            }
        }

        public void fatalError(TransformerException transformerException) throws TransformerException {
            this.hadError = true;
            SAXParseException sAXParseException = this.transform(transformerException);
            try {
                this.eh.fatalError(sAXParseException);
            }
            catch (SAXException sAXException) {
                throw new TransformerException(new UserException(sAXException));
            }
        }

        SAXParseException transform(TransformerException transformerException) throws TransformerException {
            Throwable throwable = transformerException.getException();
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof SAXException || throwable instanceof IncorrectSchemaException || throwable instanceof IOException) {
                throw transformerException;
            }
            SourceLocator sourceLocator = transformerException.getLocator();
            if (sourceLocator == null) {
                return new SAXParseException(transformerException.getMessage(), null);
            }
            String string2 = sourceLocator.getSystemId();
            if (string2 == null) {
                string2 = this.systemId;
            }
            return new SAXParseException(transformerException.getMessage(), sourceLocator.getPublicId(), string2, sourceLocator.getLineNumber(), sourceLocator.getColumnNumber());
        }
    }

    static class LocationFilter
    extends DelegatingContentHandler
    implements Locator {
        private final String mainSystemId;
        private String systemId = null;
        private int lineNumber = -1;
        private int columnNumber = -1;
        private SAXException exception = null;

        LocationFilter(ContentHandler contentHandler, String string2) {
            super(contentHandler);
            this.mainSystemId = string2;
        }

        SAXException getException() {
            return this.exception;
        }

        public void setDocumentLocator(Locator locator) {
        }

        public void startDocument() throws SAXException {
            this.getDelegate().setDocumentLocator(this);
            super.startDocument();
        }

        public void startElement(String string2, String string3, String string4, Attributes attributes) throws SAXException {
            this.systemId = LocationFilter.getLocationAttribute(attributes, "system-id");
            this.lineNumber = LocationFilter.toInteger(LocationFilter.getLocationAttribute(attributes, "line-number"));
            this.columnNumber = LocationFilter.toInteger(LocationFilter.getLocationAttribute(attributes, "column-number"));
            try {
                super.startElement(string2, string3, string4, attributes);
            }
            catch (SAXException sAXException) {
                this.exception = sAXException;
                this.setDelegate(null);
            }
            this.systemId = null;
            this.lineNumber = -1;
            this.columnNumber = -1;
        }

        private static String getLocationAttribute(Attributes attributes, String string2) {
            return attributes.getValue(SchemaReaderImpl.LOCATION_URI, string2);
        }

        private static int toInteger(String string2) {
            if (string2 == null) {
                return -1;
            }
            try {
                return Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                return -1;
            }
        }

        public String getPublicId() {
            return null;
        }

        public String getSystemId() {
            if (this.systemId != null && !this.systemId.equals("")) {
                return this.systemId;
            }
            return this.mainSystemId;
        }

        public int getLineNumber() {
            return this.lineNumber;
        }

        public int getColumnNumber() {
            return this.columnNumber;
        }
    }

    static class ErrorFilter
    extends DelegatingContentHandler {
        private final ErrorHandler eh;
        private final Localizer localizer;
        private Locator locator;

        ErrorFilter(ContentHandler contentHandler, ErrorHandler errorHandler, Localizer localizer) {
            super(contentHandler);
            this.eh = errorHandler;
            this.localizer = localizer;
        }

        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
            super.setDocumentLocator(locator);
        }

        public void startElement(String string2, String string3, String string4, Attributes attributes) throws SAXException {
            if (string2.equals(SchemaReaderImpl.ERROR_URI) && string3.equals("error")) {
                this.eh.error(new SAXParseException(this.localizer.message(attributes.getValue("", "message"), attributes.getValue("", "arg")), this.locator));
            }
            super.startElement(string2, string3, string4, attributes);
        }
    }

    static class UserWrapErrorHandler
    extends CountingErrorHandler {
        UserWrapErrorHandler(ErrorHandler errorHandler) {
            super(errorHandler);
        }

        public void warning(SAXParseException sAXParseException) throws SAXException {
            try {
                super.warning(sAXParseException);
            }
            catch (SAXException sAXException) {
                throw new SAXException(new UserException(sAXException));
            }
        }

        public void error(SAXParseException sAXParseException) throws SAXException {
            try {
                super.error(sAXParseException);
            }
            catch (SAXException sAXException) {
                throw new SAXException(new UserException(sAXException));
            }
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            try {
                super.fatalError(sAXParseException);
            }
            catch (SAXException sAXException) {
                throw new SAXException(new UserException(sAXException));
            }
        }
    }

    static class UserException
    extends Exception {
        private final SAXException exception;

        UserException(SAXException sAXException) {
            this.exception = sAXException;
        }

        SAXException getException() {
            return this.exception;
        }
    }
}

