/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Date;
import java.util.Properties;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.AugmentedSource;
import net.sf.saxon.CollectionURIResolver;
import net.sf.saxon.Configuration;
import net.sf.saxon.Transform;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.PathMap;
import net.sf.saxon.instruct.TerminationException;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.query.DynamicQueryContext;
import net.sf.saxon.query.ModuleURIResolver;
import net.sf.saxon.query.QueryReader;
import net.sf.saxon.query.QueryResult;
import net.sf.saxon.query.StaticQueryContext;
import net.sf.saxon.query.XQueryExpression;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trace.TraceListener;
import net.sf.saxon.trace.XQueryTraceListener;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.UntypedAtomicValue;
import org.xml.sax.InputSource;

public class Query {
    protected Configuration config;
    protected boolean showTime = false;
    protected int repeat = 1;
    protected String sourceFileName = null;
    protected String queryFileName = null;
    protected boolean useURLs = false;
    protected String outputFileName = null;
    protected String moduleURIResolverClass = null;
    protected String uriResolverClass = null;
    protected boolean explain = false;
    protected boolean wrap = false;
    protected boolean pullMode = false;
    protected boolean projection = false;
    protected String explainOutputFileName = null;
    private boolean schemaAware = false;

    protected Configuration makeConfiguration(boolean schemaAware, String className) {
        if (schemaAware) {
            this.config = Configuration.makeSchemaAwareConfiguration(null, className);
        } else {
            this.config = new Configuration();
            this.config.setAllNodesUntyped(true);
        }
        return this.config;
    }

    protected Configuration getConfiguration() {
        return this.config;
    }

    public static void main(String[] args) throws Exception {
        new Query().doQuery(args, "java net.sf.saxon.Query");
    }

    protected void doQuery(String[] args, String command) {
        this.schemaAware = this.testIfSchemaAware(args);
        this.config = this.makeConfiguration(this.schemaAware, null);
        this.config.setHostLanguage(51);
        StaticQueryContext staticEnv = new StaticQueryContext(this.config);
        DynamicQueryContext dynamicEnv = new DynamicQueryContext(this.config);
        Properties outputProps = new Properties();
        try {
            int r;
            XQueryExpression exp;
            this.parseOptions(args, command, dynamicEnv, outputProps);
            if (this.moduleURIResolverClass != null) {
                Object mr = this.config.getInstance(this.moduleURIResolverClass, null);
                if (!(mr instanceof ModuleURIResolver)) {
                    this.badUsage(command, this.moduleURIResolverClass + " is not a ModuleURIResolver");
                }
                staticEnv.setModuleURIResolver((ModuleURIResolver)mr);
            }
            if (this.uriResolverClass != null) {
                this.config.setURIResolver(this.config.makeURIResolver(this.uriResolverClass));
                dynamicEnv.setURIResolver(this.config.makeURIResolver(this.uriResolverClass));
            }
            this.config.displayLicenseMessage();
            if (this.pullMode) {
                // empty if block
            }
            if (this.explain) {
                this.config.setOptimizerTracing(true);
            }
            Source sourceInput = null;
            if (this.sourceFileName != null) {
                sourceInput = this.processSourceFile(this.sourceFileName, this.useURLs);
            }
            long startTime = new Date().getTime();
            if (this.showTime) {
                System.err.println("Analyzing query from " + this.queryFileName);
            }
            try {
                exp = this.compileQuery(staticEnv, this.queryFileName, this.useURLs);
                if (this.showTime) {
                    long endTime = new Date().getTime();
                    System.err.println("Analysis time: " + (endTime - startTime) + " milliseconds");
                    startTime = endTime;
                }
            }
            catch (XPathException err) {
                int line = -1;
                String module = null;
                if (err.getLocator() != null) {
                    line = err.getLocator().getLineNumber();
                    module = err.getLocator().getSystemId();
                }
                if (err.hasBeenReported()) {
                    Query.quit("Static error(s) in query", 2);
                } else if (line == -1) {
                    System.err.println("Static error in query: " + err.getMessage());
                } else {
                    System.err.println("Static error at line " + line + " of " + module + ':');
                    System.err.println(err.getMessage());
                }
                exp = null;
                System.exit(2);
            }
            if (this.explain) {
                this.explain(exp);
            }
            exp.setAllowDocumentProjection(this.projection);
            this.processSource(sourceInput, exp, dynamicEnv);
            long totalTime = 0L;
            for (r = 0; r < this.repeat; ++r) {
                try {
                    OutputStream destination;
                    if (this.outputFileName != null) {
                        File outputFile = new File(this.outputFileName);
                        if (outputFile.isDirectory()) {
                            Query.quit("Output is a directory", 2);
                        }
                        destination = new FileOutputStream(outputFile);
                    } else {
                        destination = System.out;
                    }
                    this.runQuery(exp, dynamicEnv, destination, outputProps);
                }
                catch (TerminationException err) {
                    throw err;
                }
                catch (XPathException err) {
                    if (err.hasBeenReported()) {
                        throw new XPathException("Run-time errors were reported");
                    }
                    throw err;
                }
                if (!this.showTime) continue;
                long endTime = new Date().getTime();
                if (r > 3) {
                    totalTime += endTime - startTime;
                }
                if (this.repeat != 100) {
                    System.err.println("Execution time: " + (endTime - startTime) + " milliseconds");
                } else if (totalTime > 100000L) break;
                startTime = endTime;
            }
            if (this.repeat > 3) {
                System.err.println("Average execution time: " + (double)totalTime / (double)(r - 3) + " milliseconds");
            }
        }
        catch (TerminationException err) {
            Query.quit(err.getMessage(), 1);
        }
        catch (XPathException err) {
            Query.quit("Query processing failed: " + err.getMessage(), 2);
        }
        catch (TransformerFactoryConfigurationError err) {
            err.printStackTrace();
            Query.quit("Query processing failed", 2);
        }
        catch (Exception err2) {
            err2.printStackTrace();
            Query.quit("Fatal error during query: " + err2.getClass().getName() + ": " + (err2.getMessage() == null ? " (no message)" : err2.getMessage()), 2);
        }
    }

    protected boolean testIfSchemaAware(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equals("-sa") && !args[i].startsWith("-val:") && !args[i].equals("-val") && !args[i].equals("-vlax") && !args[i].equals("-p") && !args[i].startsWith("-projection:")) continue;
            return true;
        }
        return false;
    }

    protected void parseOptions(String[] args, String command, DynamicQueryContext dynamicEnv, Properties outputProps) throws TransformerException {
        int i = 0;
        while (i < args.length && args[i].charAt(0) == '-') {
            TraceListener traceListener;
            String option;
            String value = null;
            int colon = args[i].indexOf(58);
            if (colon > 0 && colon < args[i].length() - 1) {
                option = args[i].substring(1, colon);
                value = args[i].substring(colon + 1);
            } else {
                option = args[i].substring(1);
            }
            if (option.equals("cr")) {
                Object resolver2;
                ++i;
                if (value == null) {
                    if (args.length < i + 2) {
                        this.badUsage(command, "No resolver after -cr");
                    }
                    value = args[i++];
                }
                if (!((resolver2 = this.config.getInstance(value, null)) instanceof CollectionURIResolver)) {
                    Query.quit(value + " is not a CollectionURIResolver", 2);
                }
                this.config.setCollectionURIResolver((CollectionURIResolver)resolver2);
                continue;
            }
            if (option.equals("ds")) {
                this.config.setTreeModel(0);
                ++i;
                continue;
            }
            if (option.equals("dt")) {
                this.config.setTreeModel(1);
                ++i;
                continue;
            }
            if (option.equals("dtd")) {
                if (!"on".equals(value) && !"off".equals(value)) {
                    this.badUsage(command, "-dtd option must be -dtd:on or -dtd:off");
                }
                this.config.setValidation("on".equals(value));
                ++i;
                continue;
            }
            if (option.equals("e")) {
                this.explain = true;
                ++i;
                continue;
            }
            if (option.equals("expand")) {
                if (!"on".equals(value) && !"off".equals(value)) {
                    this.badUsage(command, "-expand option must be 'on' or 'off'");
                }
                this.config.setExpandAttributeDefaults("on".equals(value));
                ++i;
                continue;
            }
            if (option.equals("explain")) {
                this.explain = true;
                ++i;
                continue;
            }
            if (option.startsWith("explain:")) {
                this.explain = true;
                this.explainOutputFileName = value;
                ++i;
                continue;
            }
            if (option.equals("ext")) {
                if (!"on".equals(value) && !"off".equals(value)) {
                    this.badUsage(command, "-ext option must be -ext:on or -ext:off");
                }
                this.config.setAllowExternalFunctions("on".equals(value));
                ++i;
                continue;
            }
            if (option.equals("l")) {
                if (value != null && !"on".equals(value) && !"off".equals(value)) {
                    this.badUsage(command, "-l option must be -l:on or -l:off");
                }
                this.config.setLineNumbering(!"off".equals(value));
                ++i;
                continue;
            }
            if (option.equals("mr")) {
                ++i;
                if (value == null) {
                    if (args.length < i + 2) {
                        this.badUsage(command, "No resolver after -cr");
                    }
                    value = args[i++];
                }
                this.moduleURIResolverClass = value;
                continue;
            }
            if (option.equals("-noext")) {
                ++i;
                this.config.setAllowExternalFunctions(false);
                continue;
            }
            if (option.equals("o")) {
                ++i;
                if (value == null) {
                    if (args.length < i + 2) {
                        this.badUsage(command, "No output file name after -o");
                    }
                    value = args[i++];
                }
                this.outputFileName = value;
                continue;
            }
            if (option.equals("outval")) {
                if (this.schemaAware) {
                    if (value != null && !"recover".equals(value) && !"fatal".equals(value)) {
                        this.badUsage(command, "-outval option must be 'recover' or 'fatal'");
                    }
                    this.config.setValidationWarnings("recover".equals(value));
                } else {
                    Query.quit("The -outval option requires a schema-aware processor", 2);
                }
                ++i;
                continue;
            }
            if (option.equals("p")) {
                ++i;
                if (value != null && !"on".equals(value) && !"off".equals(value)) {
                    this.badUsage(command, "-p option must be -p:on or -p:off");
                }
                if ("off".equals(value)) continue;
                this.config.setParameterizedURIResolver();
                this.useURLs = true;
                continue;
            }
            if (option.equals("pipe")) {
                ++i;
                if (!"push".equals(value) && !"pull".equals(value)) {
                    this.badUsage(command, "-pipe option must be -p:push or -p:pull");
                }
                if (!"pull".equals(value)) continue;
                this.pullMode = true;
                continue;
            }
            if (option.equals("projection")) {
                ++i;
                if (value != null && !"on".equals(value) && !"off".equals(value)) {
                    this.badUsage(command, "-projection option must be -projection:on or projection:off");
                }
                if ("off".equals(value)) continue;
                this.projection = true;
                continue;
            }
            if (option.equals("pull")) {
                ++i;
                this.pullMode = true;
                continue;
            }
            if (option.equals("r")) {
                ++i;
                if (value == null) {
                    if (args.length < i + 2) {
                        this.badUsage(command, "No URIResolver class after -r");
                    }
                    value = args[i++];
                }
                this.uriResolverClass = value;
                continue;
            }
            if (option.equals("repeat")) {
                ++i;
                if (value == null) {
                    this.badUsage(command, "No number after -repeat");
                    continue;
                }
                try {
                    this.repeat = Integer.parseInt(value);
                }
                catch (NumberFormatException err) {
                    this.badUsage(command, "Bad number after -repeat");
                }
                continue;
            }
            if (option.equals("s")) {
                ++i;
                if (value == null) {
                    if (args.length < i + 2) {
                        this.badUsage(command, "No source file name after -s");
                    }
                    value = args[i++];
                }
                this.sourceFileName = value;
                continue;
            }
            if (option.equals("sa")) {
                ++i;
                continue;
            }
            if (option.equals("snone")) {
                this.config.setStripsWhiteSpace(0);
                ++i;
                continue;
            }
            if (option.equals("sall")) {
                this.config.setStripsWhiteSpace(2);
                ++i;
                continue;
            }
            if (option.equals("signorable")) {
                this.config.setStripsWhiteSpace(1);
                ++i;
                continue;
            }
            if (option.equals("strip")) {
                ++i;
                if (value == null) {
                    value = "all";
                }
                if ("none".equals(value)) continue;
                if ("all".equals(value)) {
                    this.config.setStripsWhiteSpace(2);
                    continue;
                }
                if ("ignorable".equals(value)) {
                    this.config.setStripsWhiteSpace(1);
                    continue;
                }
                this.badUsage(command, "-strip must be none, all, or ignorable");
                continue;
            }
            if (option.equals("t")) {
                System.err.println(this.config.getProductTitle());
                System.err.println(Configuration.getPlatform().getPlatformVersion());
                this.config.setTiming(true);
                this.showTime = true;
                ++i;
                continue;
            }
            if (option.equals("tree")) {
                if ("linked".equals(value)) {
                    this.config.setTreeModel(0);
                } else if ("tiny".equals(value)) {
                    this.config.setTreeModel(1);
                } else {
                    this.badUsage(command, "-tree option must be 'linked' or 'tiny'");
                }
                ++i;
                continue;
            }
            if (option.equals("T")) {
                ++i;
                traceListener = value == null ? new XQueryTraceListener() : this.config.makeTraceListener(value);
                this.config.setTraceListener(traceListener);
                this.config.setLineNumbering(true);
                continue;
            }
            if (option.equals("TJ")) {
                ++i;
                this.config.setTraceExternalFunctions(true);
                continue;
            }
            if (option.equals("TL")) {
                if (args.length < i + 2) {
                    this.badUsage(command, "No TraceListener class specified");
                }
                traceListener = this.config.makeTraceListener(args[++i]);
                this.config.setTraceListener(traceListener);
                this.config.setLineNumbering(true);
                ++i;
                continue;
            }
            if (option.equals("u")) {
                this.useURLs = true;
                ++i;
                continue;
            }
            if (option.equals("untyped")) {
                this.config.setAllNodesUntyped(true);
                ++i;
                continue;
            }
            if (option.equals("v")) {
                this.config.setValidation(true);
                ++i;
                continue;
            }
            if (option.equals("val")) {
                if (!this.schemaAware) {
                    Query.quit("The -val option requires a schema-aware processor", 2);
                } else if (value == null || "strict".equals(value)) {
                    this.config.setSchemaValidationMode(1);
                } else if ("lax".equals(value)) {
                    this.config.setSchemaValidationMode(2);
                } else {
                    this.badUsage(command, "-val option must be 'strict' or 'lax'");
                }
                ++i;
                continue;
            }
            if (option.equals("vlax")) {
                if (this.schemaAware) {
                    this.config.setSchemaValidationMode(2);
                } else {
                    Query.quit("The -vlax option requires a schema-aware processor", 2);
                }
                ++i;
                continue;
            }
            if (option.equals("vw")) {
                if (this.schemaAware) {
                    this.config.setValidationWarnings(true);
                } else {
                    Query.quit("The -vw option requires a schema-aware processor", 2);
                }
                ++i;
                continue;
            }
            if (option.equals("wrap")) {
                if (value != null && !"on".equals(value) && !"off".equals(value)) {
                    this.badUsage(command, "-wrap option must be -wrap:on or -wrap:off");
                }
                if (!"off".equals(value)) {
                    this.wrap = true;
                }
                ++i;
                continue;
            }
            if (option.equals("x")) {
                ++i;
                this.config.setSourceParserClass(value);
                continue;
            }
            if (option.equals("xi")) {
                if (value != null && !"on".equals(value) && !"off".equals(value)) {
                    this.badUsage(command, "-xi option must be -xi:on or -xi:off");
                }
                if (!"off".equals(value)) {
                    this.config.setXIncludeAware(true);
                }
                ++i;
                continue;
            }
            if (option.equals("1.1")) {
                this.config.setXMLVersion(11);
                ++i;
                continue;
            }
            if (option.equals("xmlversion")) {
                ++i;
                if ("1.0".equals(value)) {
                    this.config.setXMLVersion(10);
                    continue;
                }
                if ("1.1".equals(value)) {
                    this.config.setXMLVersion(11);
                    continue;
                }
                this.badUsage(command, "-xmlversion must be 1.0 or 1.1");
                continue;
            }
            if (args[i].equals("-?")) {
                this.badUsage(command, "");
                continue;
            }
            if (args[i].equals("-")) {
                this.queryFileName = "-";
                ++i;
                continue;
            }
            this.badUsage(command, "Unknown option " + args[i]);
        }
        if (!"-".equals(this.queryFileName)) {
            if (args.length < i + 1) {
                this.badUsage(command, "No query file name");
            }
            this.queryFileName = args[i++];
        }
        for (int p = i; p < args.length; ++p) {
            String argvalue;
            String arg = args[p];
            int eq = arg.indexOf("=");
            if (eq < 1 || eq >= arg.length()) {
                this.badUsage(command, "Bad param=value pair on command line: " + arg);
            }
            String argname = arg.substring(0, eq);
            String string2 = argvalue = eq == arg.length() ? "" : arg.substring(eq + 1);
            if (argname.startsWith("!")) {
                outputProps.setProperty(argname.substring(1), argvalue);
                continue;
            }
            if (argname.startsWith("+")) {
                Object sources = Transform.loadDocuments(argvalue, this.useURLs, this.config, true);
                dynamicEnv.setParameter(argname.substring(1), sources);
                continue;
            }
            dynamicEnv.setParameter(argname, new UntypedAtomicValue(argvalue));
        }
    }

    protected Source processSourceFile(String sourceFileName, boolean useURLs) throws TransformerException {
        Source sourceInput;
        if (useURLs || sourceFileName.startsWith("http:") || sourceFileName.startsWith("file:")) {
            sourceInput = this.config.getURIResolver().resolve(sourceFileName, null);
            if (sourceInput == null) {
                sourceInput = this.config.getSystemURIResolver().resolve(sourceFileName, null);
            }
        } else if (sourceFileName.equals("-")) {
            sourceInput = new StreamSource(System.in);
        } else {
            File sourceFile = new File(sourceFileName);
            if (!sourceFile.exists()) {
                Query.quit("Source file " + sourceFile + " does not exist", 2);
            }
            if (Configuration.getPlatform().isJava()) {
                InputSource eis = new InputSource(sourceFile.toURI().toString());
                sourceInput = new SAXSource(eis);
            } else {
                sourceInput = new StreamSource(sourceFile.toURI().toString());
            }
        }
        return sourceInput;
    }

    protected XQueryExpression compileQuery(StaticQueryContext staticEnv, String queryFileName, boolean useURLs) throws XPathException, IOException {
        XQueryExpression exp;
        if (queryFileName.equals("-")) {
            InputStreamReader queryReader = new InputStreamReader(System.in);
            exp = staticEnv.compileQuery(queryReader);
        } else if (queryFileName.startsWith("{") && queryFileName.endsWith("}")) {
            String q = queryFileName.substring(1, queryFileName.length() - 1);
            exp = staticEnv.compileQuery(q);
        } else if (useURLs || queryFileName.startsWith("http:") || queryFileName.startsWith("file:")) {
            String[] locations;
            StreamSource[] sources;
            ModuleURIResolver resolver2 = staticEnv.getModuleURIResolver();
            if (resolver2 == null) {
                resolver2 = staticEnv.getConfiguration().getStandardModuleURIResolver();
            }
            if ((sources = resolver2.resolve(null, null, locations = new String[]{queryFileName})).length != 1 || !(sources[0] instanceof StreamSource)) {
                Query.quit("Module URI Resolver must return a single StreamSource", 2);
            }
            String queryText = QueryReader.readSourceQuery(sources[0], this.config.getNameChecker());
            exp = staticEnv.compileQuery(queryText);
        } else {
            FileInputStream queryStream = new FileInputStream(queryFileName);
            staticEnv.setBaseURI(new File(queryFileName).toURI().toString());
            exp = staticEnv.compileQuery(queryStream, null);
        }
        return exp;
    }

    protected void explain(XQueryExpression exp) throws FileNotFoundException, XPathException {
        OutputStream explainOutput = this.explainOutputFileName == null ? System.err : new FileOutputStream(new File(this.explainOutputFileName));
        Properties props = new Properties();
        props.setProperty("method", "xml");
        props.setProperty("indent", "yes");
        props.setProperty("{http://saxon.sf.net/}indent-spaces", "2");
        Receiver diag = this.config.getSerializerFactory().getReceiver(new StreamResult(explainOutput), this.config.makePipelineConfiguration(), props);
        ExpressionPresenter expressionPresenter = new ExpressionPresenter(this.config, diag);
        exp.explain(expressionPresenter);
    }

    protected void processSource(Source sourceInput, XQueryExpression exp, DynamicQueryContext dynamicEnv) throws XPathException {
        if (sourceInput != null) {
            if (this.showTime) {
                System.err.println("Processing " + sourceInput.getSystemId());
            }
            if (!exp.usesContextItem()) {
                System.err.println("Source document ignored - query does not access the context item");
                sourceInput = null;
            } else if (this.projection) {
                PathMap map = exp.getPathMap();
                PathMap.PathMapRoot contextRoot = map.getContextRoot();
                if (this.explain) {
                    System.err.println("DOCUMENT PROJECTION: PATH MAP");
                    map.diagnosticDump(System.err);
                }
                if (contextRoot != null) {
                    if (contextRoot.hasUnknownDependencies()) {
                        System.err.println("Document projection for the context document is not possible, because the query uses paths that defy analysis");
                    } else {
                        ProxyReceiver filter = this.config.makeDocumentProjector(contextRoot);
                        sourceInput = AugmentedSource.makeAugmentedSource(sourceInput);
                        ((AugmentedSource)sourceInput).addFilter(filter);
                    }
                } else {
                    System.err.println("Source document supplied, but query does not access the context item");
                }
            }
            if (sourceInput != null) {
                DocumentInfo doc = this.config.buildDocument(sourceInput);
                dynamicEnv.setContextItem(doc);
            }
        }
    }

    protected void runQuery(XQueryExpression exp, DynamicQueryContext dynamicEnv, OutputStream destination, Properties outputProps) throws XPathException, IOException {
        if (this.wrap && !this.pullMode) {
            SequenceIterator results = exp.iterator(dynamicEnv);
            DocumentInfo resultDoc = QueryResult.wrap(results, this.config);
            QueryResult.serialize(resultDoc, new StreamResult(destination), outputProps);
            destination.close();
        } else if (this.pullMode) {
            if (this.wrap) {
                outputProps.setProperty("{http://saxon.sf.net/}wrap-result-sequence", "yes");
            }
            outputProps.setProperty("method", "xml");
            outputProps.setProperty("indent", "yes");
            exp.pull(dynamicEnv, new StreamResult(destination), outputProps);
        } else {
            exp.run(dynamicEnv, new StreamResult(destination), outputProps);
        }
    }

    protected static void quit(String message, int code) {
        System.err.println(message);
        System.exit(code);
    }

    protected void badUsage(String name, String message) {
        if (!"".equals(message)) {
            System.err.println(message);
        }
        System.err.println(this.config.getProductTitle());
        System.err.println("Usage: " + name + " [options] query {param=value}...");
        System.err.println("Options: ");
        System.err.println("  -cr:classname         Use specified CollectionURIResolver class");
        System.err.println("  -dtd:on|off           Validate using DTD");
        System.err.println("  -expand:on|off        Expand defaults defined in schema/DTD");
        System.err.println("  -explain[:filename]   Display compiled expression tree");
        System.err.println("  -ext:[on|off]         Allow|Disallow external Java functions");
        System.err.println("  -l:on|off             Line numbering for source document");
        System.err.println("  -mr:classname         Use specified ModuleURIResolver class");
        System.err.println("  -o:filename           Send output to named file");
        System.err.println("  -outval:recover|fatal Handling of validation errors on result document");
        System.err.println("  -p                    Recognize Saxon file extensions and query parameters");
        System.err.println("  -pipe:push|pull       Execute internally in push or pull mode");
        System.err.println("  -projection:[on|off]  Use|Don't use source document projection");
        System.err.println("  -r:classname          Use URIResolver class");
        System.err.println("  -repeat:N             Repeat N times for performance measurement");
        System.err.println("  -s:file|URI           Provide initial context document");
        System.err.println("  -sa                   Schema-aware query (requires Saxon-SA)");
        System.err.println("  -strip:all|none|ignorable      Strip whitespace text nodes");
        System.err.println("  -t                    Display version and timing information");
        System.err.println("  -tree:tiny|linked     Select tree model");
        System.err.println("  -T[:classname]        Use TraceListener class");
        System.err.println("  -TJ                   Trace calls to external Java functions");
        System.err.println("  -u                    Names are URLs not filenames");
        System.err.println("  -val:strict|lax       Validate using schema");
        System.err.println("  -wrap:on|off          Wrap result sequence in XML elements");
        System.err.println("  -x:classname          Parser (XMLReader) used for source files");
        System.err.println("  -xi:on|off            Expand XInclude on all documents");
        System.err.println("  -xmlversion:1.0|1.1   Version of XML to be handled");
        System.err.println("  -?                    Display this message ");
        System.err.println("  param=value           Set query string parameter");
        System.err.println("  +param=value          Set query document parameter");
        System.err.println("  !option=value         Set serialization option");
        if ("".equals(message)) {
            System.exit(0);
        } else {
            System.exit(2);
        }
    }
}

