/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.sql.dictionary;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.catalog.IndexDescriptor;
import org.apache.derby.catalog.types.IndexDescriptorImpl;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.io.Formatable;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptorList;
import org.apache.derby.iapi.sql.execute.ExecIndexRow;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.ExecutionContext;
import org.apache.derby.iapi.sql.execute.ExecutionFactory;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.RowLocation;

public class IndexRowGenerator
implements IndexDescriptor,
Formatable {
    private IndexDescriptor id;
    private ExecutionFactory ef;

    public IndexRowGenerator(String string2, boolean bl, int[] nArray, boolean[] blArray, int n) {
        this.id = new IndexDescriptorImpl(string2, bl, false, nArray, blArray, n);
    }

    public IndexRowGenerator(String string2, boolean bl, boolean bl2, int[] nArray, boolean[] blArray, int n) {
        this.id = new IndexDescriptorImpl(string2, bl, bl2, nArray, blArray, n);
    }

    public IndexRowGenerator(IndexDescriptor indexDescriptor) {
        this.id = indexDescriptor;
    }

    public ExecIndexRow getIndexRowTemplate() {
        return this.getExecutionFactory().getIndexableRow(this.id.baseColumnPositions().length + 1);
    }

    public ExecIndexRow getNullIndexRow(ColumnDescriptorList columnDescriptorList, RowLocation rowLocation) throws StandardException {
        int[] nArray = this.id.baseColumnPositions();
        ExecIndexRow execIndexRow = this.getIndexRowTemplate();
        for (int i = 0; i < nArray.length; ++i) {
            DataTypeDescriptor dataTypeDescriptor = columnDescriptorList.elementAt(nArray[i] - 1).getType();
            execIndexRow.setColumn(i + 1, dataTypeDescriptor.getNull());
        }
        execIndexRow.setColumn(nArray.length + 1, rowLocation);
        return execIndexRow;
    }

    public void getIndexRow(ExecRow execRow, RowLocation rowLocation, ExecIndexRow execIndexRow, FormatableBitSet formatableBitSet) throws StandardException {
        int[] nArray = this.id.baseColumnPositions();
        int n = nArray.length;
        if (formatableBitSet == null) {
            for (int i = 0; i < n; ++i) {
                execIndexRow.setColumn(i + 1, execRow.getColumn(nArray[i]));
            }
        } else {
            for (int i = 0; i < n; ++i) {
                int n2 = nArray[i];
                int n3 = 0;
                for (int j = 1; j <= n2; ++j) {
                    if (!formatableBitSet.get(j)) continue;
                    ++n3;
                }
                execIndexRow.setColumn(i + 1, execRow.getColumn(n3));
            }
        }
        execIndexRow.setColumn(n + 1, rowLocation);
    }

    public int[] getColumnCollationIds(ColumnDescriptorList columnDescriptorList) throws StandardException {
        int[] nArray = this.id.baseColumnPositions();
        int[] nArray2 = new int[nArray.length + 1];
        for (int i = 0; i < nArray.length; ++i) {
            nArray2[i] = columnDescriptorList.elementAt(nArray[i] - 1).getType().getCollationType();
        }
        nArray2[nArray2.length - 1] = 0;
        return nArray2;
    }

    public IndexDescriptor getIndexDescriptor() {
        return this.id;
    }

    public IndexRowGenerator() {
    }

    public boolean isUniqueWithDuplicateNulls() {
        return this.id.isUniqueWithDuplicateNulls();
    }

    public boolean isUnique() {
        return this.id.isUnique();
    }

    public int[] baseColumnPositions() {
        return this.id.baseColumnPositions();
    }

    public int getKeyColumnPosition(int n) {
        return this.id.getKeyColumnPosition(n);
    }

    public int numberOfOrderedColumns() {
        return this.id.numberOfOrderedColumns();
    }

    public String indexType() {
        return this.id.indexType();
    }

    public String toString() {
        return this.id.toString();
    }

    public boolean isAscending(Integer n) {
        return this.id.isAscending(n);
    }

    public boolean isDescending(Integer n) {
        return this.id.isDescending(n);
    }

    public boolean[] isAscending() {
        return this.id.isAscending();
    }

    public void setBaseColumnPositions(int[] nArray) {
        this.id.setBaseColumnPositions(nArray);
    }

    public void setIsAscending(boolean[] blArray) {
        this.id.setIsAscending(blArray);
    }

    public void setNumberOfOrderedColumns(int n) {
        this.id.setNumberOfOrderedColumns(n);
    }

    public boolean equals(Object object) {
        return this.id.equals(object);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    private ExecutionFactory getExecutionFactory() {
        if (this.ef == null) {
            ExecutionContext executionContext = (ExecutionContext)ContextService.getContext("ExecutionContext");
            this.ef = executionContext.getExecutionFactory();
        }
        return this.ef;
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.id = (IndexDescriptor)objectInput.readObject();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.id);
    }

    public int getTypeFormatId() {
        return 268;
    }
}

