/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.bytecode;

import java.io.IOException;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.classfile.ClassHolder;
import org.apache.derby.iapi.services.classfile.ClassMember;
import org.apache.derby.iapi.services.compiler.LocalField;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.loader.ClassFactory;
import org.apache.derby.iapi.util.ByteArray;
import org.apache.derby.impl.services.bytecode.BCJava;
import org.apache.derby.impl.services.bytecode.BCLocalField;
import org.apache.derby.impl.services.bytecode.BCMethod;
import org.apache.derby.impl.services.bytecode.GClass;
import org.apache.derby.impl.services.bytecode.Type;

class BCClass
extends GClass {
    String limitMsg;
    protected ClassHolder classHold;
    protected String superClassName;
    protected String name;
    BCJava factory;
    final Type classType;

    public LocalField addField(String string2, String string3, int n) {
        Type type = this.factory.type(string2);
        ClassMember classMember = this.classHold.addMember(string3, type.vmName(), n);
        int n2 = this.classHold.addFieldReference(classMember);
        return new BCLocalField(type, n2);
    }

    public ByteArray getClassBytecode() throws StandardException {
        if (this.bytecode != null) {
            return this.bytecode;
        }
        try {
            this.bytecode = this.classHold.getFileFormat();
        }
        catch (IOException iOException) {
            throw StandardException.newException("XBCM1.S", iOException, (Object)this.getFullName());
        }
        this.classHold = null;
        if (this.limitMsg != null) {
            throw StandardException.newException("XBCM4.S", (Object)this.getFullName(), (Object)this.limitMsg);
        }
        return this.bytecode;
    }

    public String getName() {
        return this.name;
    }

    public MethodBuilder newMethodBuilder(int n, String string2, String string3) {
        return this.newMethodBuilder(n, string2, string3, null);
    }

    public MethodBuilder newMethodBuilder(int n, String string2, String string3, String[] stringArray) {
        BCMethod bCMethod = new BCMethod(this, string2, string3, n, stringArray, this.factory);
        return bCMethod;
    }

    public MethodBuilder newConstructorBuilder(int n) {
        return new BCMethod(this, "void", "<init>", n, null, this.factory);
    }

    String getSuperClassName() {
        return this.superClassName;
    }

    ClassHolder modify() {
        return this.classHold;
    }

    BCClass(ClassFactory classFactory, String string2, int n, String string3, String string4, BCJava bCJava) {
        super(classFactory, string2.concat(string3));
        this.name = string3;
        if (string4 == null) {
            string4 = "java.lang.Object";
        }
        this.superClassName = string4;
        this.classType = bCJava.type(this.getFullName());
        this.classHold = new ClassHolder(this.qualifiedName, bCJava.type((String)string4).vmNameSimple, n);
        this.factory = bCJava;
    }

    ClassFactory getClassFactory() {
        return this.cf;
    }

    void addLimitExceeded(BCMethod bCMethod, String string2, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.limitMsg != null) {
            stringBuffer.append(this.limitMsg);
            stringBuffer.append(", ");
        }
        stringBuffer.append("method:");
        stringBuffer.append(bCMethod.getName());
        stringBuffer.append(" ");
        stringBuffer.append(string2);
        stringBuffer.append(" (");
        stringBuffer.append(n2);
        stringBuffer.append(" > ");
        stringBuffer.append(n);
        stringBuffer.append(")");
        this.limitMsg = stringBuffer.toString();
    }

    void addLimitExceeded(String string2) {
        this.limitMsg = this.limitMsg != null ? this.limitMsg + ", " + string2 : string2;
    }
}

