/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.catalog;

import java.util.Properties;
import org.apache.derby.catalog.DefaultInfo;
import org.apache.derby.catalog.TypeDescriptor;
import org.apache.derby.catalog.UUID;
import org.apache.derby.catalog.types.DefaultInfoImpl;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.uuid.UUIDFactory;
import org.apache.derby.iapi.sql.dictionary.CatalogRowFactory;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDescriptorGenerator;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SystemColumn;
import org.apache.derby.iapi.sql.dictionary.TupleDescriptor;
import org.apache.derby.iapi.sql.dictionary.UniqueTupleDescriptor;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.ExecutionFactory;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.DataValueFactory;
import org.apache.derby.iapi.types.SQLChar;
import org.apache.derby.iapi.types.SQLInteger;
import org.apache.derby.iapi.types.SQLLongint;
import org.apache.derby.iapi.types.SQLVarchar;
import org.apache.derby.iapi.types.UserType;
import org.apache.derby.impl.sql.catalog.SystemColumnImpl;

public class SYSCOLUMNSRowFactory
extends CatalogRowFactory {
    static final String TABLENAME_STRING = "SYSCOLUMNS";
    protected static final int SYSCOLUMNS_COLUMN_COUNT = 9;
    protected static final int SYSCOLUMNS_TABLEID = 1;
    protected static final int SYSCOLUMNS_REFERENCEID = 1;
    protected static final int SYSCOLUMNS_COLUMNNAME = 2;
    protected static final int SYSCOLUMNS_COLUMNNUMBER = 3;
    protected static final int SYSCOLUMNS_COLUMNDATATYPE = 4;
    protected static final int SYSCOLUMNS_COLUMNDEFAULT = 5;
    protected static final int SYSCOLUMNS_COLUMNDEFAULTID = 6;
    protected static final int SYSCOLUMNS_AUTOINCREMENTVALUE = 7;
    protected static final int SYSCOLUMNS_AUTOINCREMENTSTART = 8;
    protected static final int SYSCOLUMNS_AUTOINCREMENTINC = 9;
    protected static final int SYSCOLUMNS_INDEX1_ID = 0;
    protected static final int SYSCOLUMNS_INDEX2_ID = 1;
    private static final boolean[] uniqueness = new boolean[]{true, false};
    private static final String[] uuids = new String[]{"8000001e-00d0-fd77-3ed8-000a0a0b1900", "80000029-00d0-fd77-3ed8-000a0a0b1900", "80000020-00d0-fd77-3ed8-000a0a0b1900", "6839c016-00d9-2829-dfcd-000a0a411400"};
    private static final int[][] indexColumnPositions = new int[][]{{1, 2}, {6}};

    SYSCOLUMNSRowFactory(UUIDFactory uUIDFactory, ExecutionFactory executionFactory, DataValueFactory dataValueFactory) {
        this(uUIDFactory, executionFactory, dataValueFactory, TABLENAME_STRING);
    }

    SYSCOLUMNSRowFactory(UUIDFactory uUIDFactory, ExecutionFactory executionFactory, DataValueFactory dataValueFactory, String string2) {
        super(uUIDFactory, executionFactory, dataValueFactory);
        this.initInfo(9, string2, indexColumnPositions, uniqueness, uuids);
    }

    public ExecRow makeRow(TupleDescriptor tupleDescriptor, TupleDescriptor tupleDescriptor2) throws StandardException {
        ColumnDescriptor columnDescriptor;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        Integer n = null;
        TypeDescriptor typeDescriptor = null;
        Object object = null;
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        long l4 = -1L;
        if (tupleDescriptor != null) {
            columnDescriptor = (ColumnDescriptor)tupleDescriptor;
            typeDescriptor = columnDescriptor.getType().getCatalogType();
            string4 = columnDescriptor.getReferencingUUID().toString();
            string2 = columnDescriptor.getColumnName();
            n = new Integer(columnDescriptor.getPosition());
            l = columnDescriptor.getAutoincStart();
            l2 = columnDescriptor.getAutoincInc();
            l3 = columnDescriptor.getAutoincValue();
            l4 = columnDescriptor.getAutoinc_create_or_modify_Start_Increment();
            object = columnDescriptor.getDefaultInfo() != null ? columnDescriptor.getDefaultInfo() : columnDescriptor.getDefaultValue();
            if (columnDescriptor.getDefaultUUID() != null) {
                string3 = columnDescriptor.getDefaultUUID().toString();
            }
        }
        ExecRow execRow = this.getExecutionFactory().getValueRow(9);
        execRow.setColumn(1, new SQLChar(string4));
        execRow.setColumn(2, new SQLVarchar(string2));
        execRow.setColumn(3, new SQLInteger(n));
        execRow.setColumn(4, new UserType(typeDescriptor));
        execRow.setColumn(5, new UserType(object));
        execRow.setColumn(6, new SQLChar(string3));
        if (l4 == 0L || l4 == 2L) {
            execRow.setColumn(7, new SQLLongint(l3));
            execRow.setColumn(8, new SQLLongint(l));
            execRow.setColumn(9, new SQLLongint(l2));
        } else if (l4 == 1L) {
            columnDescriptor = (ColumnDescriptor)tupleDescriptor;
            execRow.setColumn(7, new SQLLongint(l));
            execRow.setColumn(8, new SQLLongint(l));
            execRow.setColumn(9, new SQLLongint(columnDescriptor.getTableDescriptor().getColumnDescriptor(string2).getAutoincInc()));
        } else {
            execRow.setColumn(7, new SQLLongint());
            execRow.setColumn(8, new SQLLongint());
            execRow.setColumn(9, new SQLLongint());
        }
        return execRow;
    }

    public Properties getCreateHeapProperties() {
        Properties properties = new Properties();
        properties.put("derby.storage.pageSize", "4096");
        properties.put("derby.storage.pageReservedSpace", "0");
        properties.put("derby.storage.minimumRecordSize", "1");
        return properties;
    }

    public Properties getCreateIndexProperties(int n) {
        Properties properties = new Properties();
        properties.put("derby.storage.pageSize", "4096");
        return properties;
    }

    public TupleDescriptor buildDescriptor(ExecRow execRow, TupleDescriptor tupleDescriptor, DataDictionary dataDictionary) throws StandardException {
        DefaultInfoImpl defaultInfoImpl = null;
        DataValueDescriptor dataValueDescriptor = null;
        UUID uUID = null;
        UUID uUID2 = null;
        UUIDFactory uUIDFactory = this.getUUIDFactory();
        DataDescriptorGenerator dataDescriptorGenerator = dataDictionary.getDataDescriptorGenerator();
        uUID2 = tupleDescriptor != null ? ((UniqueTupleDescriptor)((Object)tupleDescriptor)).getUUID() : uUIDFactory.recreateUUID(execRow.getColumn(1).getString());
        Object object = execRow.getColumn(5).getObject();
        if (object instanceof DataValueDescriptor) {
            dataValueDescriptor = (DataValueDescriptor)object;
        } else if (object instanceof DefaultInfoImpl) {
            defaultInfoImpl = (DefaultInfoImpl)object;
            dataValueDescriptor = defaultInfoImpl.getDefaultValue();
        }
        String string2 = execRow.getColumn(6).getString();
        if (string2 != null) {
            uUID = uUIDFactory.recreateUUID(string2);
        }
        String string3 = execRow.getColumn(2).getString();
        int n = execRow.getColumn(3).getInt();
        TypeDescriptor typeDescriptor = (TypeDescriptor)execRow.getColumn(4).getObject();
        DataTypeDescriptor dataTypeDescriptor = DataTypeDescriptor.getType(typeDescriptor);
        long l = execRow.getColumn(7).getLong();
        long l2 = execRow.getColumn(8).getLong();
        long l3 = execRow.getColumn(9).getLong();
        DataValueDescriptor dataValueDescriptor2 = execRow.getColumn(8);
        l2 = dataValueDescriptor2.getLong();
        dataValueDescriptor2 = execRow.getColumn(9);
        l3 = dataValueDescriptor2.getLong();
        ColumnDescriptor columnDescriptor = new ColumnDescriptor(string3, n, dataTypeDescriptor, dataValueDescriptor, (DefaultInfo)defaultInfoImpl, uUID2, uUID, l2, l3, l);
        return columnDescriptor;
    }

    public int getPrimaryKeyIndexNumber() {
        return 0;
    }

    public SystemColumn[] buildColumnList() throws StandardException {
        return new SystemColumn[]{SystemColumnImpl.getUUIDColumn("REFERENCEID", false), SystemColumnImpl.getIdentifierColumn("COLUMNNAME", false), SystemColumnImpl.getColumn("COLUMNNUMBER", 4, false), SystemColumnImpl.getJavaColumn("COLUMNDATATYPE", "org.apache.derby.catalog.TypeDescriptor", false), SystemColumnImpl.getJavaColumn("COLUMNDEFAULT", "java.io.Serializable", true), SystemColumnImpl.getUUIDColumn("COLUMNDEFAULTID", true), SystemColumnImpl.getColumn("AUTOINCREMENTVALUE", -5, true), SystemColumnImpl.getColumn("AUTOINCREMENTSTART", -5, true), SystemColumnImpl.getColumn("AUTOINCREMENTINC", -5, true)};
    }
}

