/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.catalog;

import java.sql.Timestamp;
import java.util.GregorianCalendar;
import java.util.Properties;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.uuid.UUIDFactory;
import org.apache.derby.iapi.sql.dictionary.CatalogRowFactory;
import org.apache.derby.iapi.sql.dictionary.DataDescriptorGenerator;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SPSDescriptor;
import org.apache.derby.iapi.sql.dictionary.SystemColumn;
import org.apache.derby.iapi.sql.dictionary.TupleDescriptor;
import org.apache.derby.iapi.sql.execute.ExecPreparedStatement;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.ExecutionFactory;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.DataValueFactory;
import org.apache.derby.iapi.types.SQLBoolean;
import org.apache.derby.iapi.types.SQLChar;
import org.apache.derby.iapi.types.SQLTimestamp;
import org.apache.derby.iapi.types.SQLVarchar;
import org.apache.derby.iapi.types.UserType;
import org.apache.derby.impl.sql.catalog.SystemColumnImpl;

public class SYSSTATEMENTSRowFactory
extends CatalogRowFactory {
    static final String TABLENAME_STRING = "SYSSTATEMENTS";
    public static final int SYSSTATEMENTS_STMTID = 1;
    public static final int SYSSTATEMENTS_STMTNAME = 2;
    public static final int SYSSTATEMENTS_SCHEMAID = 3;
    public static final int SYSSTATEMENTS_TYPE = 4;
    public static final int SYSSTATEMENTS_VALID = 5;
    public static final int SYSSTATEMENTS_TEXT = 6;
    public static final int SYSSTATEMENTS_LASTCOMPILED = 7;
    public static final int SYSSTATEMENTS_COMPILATION_SCHEMAID = 8;
    public static final int SYSSTATEMENTS_USINGTEXT = 9;
    public static final int SYSSTATEMENTS_CONSTANTSTATE = 10;
    public static final int SYSSTATEMENTS_INITIALLY_COMPILABLE = 11;
    public static final int SYSSTATEMENTS_COLUMN_COUNT = 11;
    public static final int SYSSTATEMENTS_HIDDEN_COLUMN_COUNT = 2;
    protected static final int SYSSTATEMENTS_INDEX1_ID = 0;
    protected static final int SYSSTATEMENTS_INDEX2_ID = 1;
    private static final int[][] indexColumnPositions = new int[][]{{1}, {2, 3}};
    private static final boolean[] uniqueness = null;
    private static final String[] uuids = new String[]{"80000000-00d1-15f7-ab70-000a0a0b1500", "80000000-00d1-15fc-60b9-000a0a0b1500", "80000000-00d1-15fc-eda1-000a0a0b1500", "80000000-00d1-15fe-bdf8-000a0a0b1500"};

    SYSSTATEMENTSRowFactory(UUIDFactory uUIDFactory, ExecutionFactory executionFactory, DataValueFactory dataValueFactory) {
        super(uUIDFactory, executionFactory, dataValueFactory);
        this.initInfo(11, TABLENAME_STRING, indexColumnPositions, uniqueness, uuids);
    }

    public ExecRow makeSYSSTATEMENTSrow(boolean bl, SPSDescriptor sPSDescriptor) throws StandardException {
        String string2 = null;
        UUID uUID = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        ExecPreparedStatement execPreparedStatement = null;
        String string8 = null;
        boolean bl2 = true;
        Timestamp timestamp = null;
        boolean bl3 = true;
        if (sPSDescriptor != null) {
            string2 = sPSDescriptor.getName();
            uUID = sPSDescriptor.getUUID();
            string4 = sPSDescriptor.getSchemaDescriptor().getUUID().toString();
            string3 = uUID.toString();
            string6 = sPSDescriptor.getText();
            bl2 = sPSDescriptor.isValid();
            timestamp = sPSDescriptor.getCompileTime();
            string8 = sPSDescriptor.getTypeAsString();
            bl3 = sPSDescriptor.initiallyCompilable();
            execPreparedStatement = sPSDescriptor.getPreparedStatement(bl);
            string5 = sPSDescriptor.getCompSchemaId() != null ? sPSDescriptor.getCompSchemaId().toString() : null;
            string7 = sPSDescriptor.getUsingText();
        }
        ExecRow execRow = this.getExecutionFactory().getValueRow(11);
        execRow.setColumn(1, new SQLChar(string3));
        execRow.setColumn(2, new SQLVarchar(string2));
        execRow.setColumn(3, new SQLChar(string4));
        execRow.setColumn(4, new SQLChar(string8));
        execRow.setColumn(5, new SQLBoolean(bl2));
        execRow.setColumn(6, this.dvf.getLongvarcharDataValue(string6));
        execRow.setColumn(7, new SQLTimestamp(timestamp));
        execRow.setColumn(8, new SQLChar(string5));
        execRow.setColumn(9, this.dvf.getLongvarcharDataValue(string7));
        execRow.setColumn(10, new UserType(execPreparedStatement));
        execRow.setColumn(11, new SQLBoolean(bl3));
        return execRow;
    }

    public TupleDescriptor buildDescriptor(ExecRow execRow, TupleDescriptor tupleDescriptor, DataDictionary dataDictionary) throws StandardException {
        boolean bl;
        UUID uUID = null;
        Timestamp timestamp = null;
        ExecPreparedStatement execPreparedStatement = null;
        DataDescriptorGenerator dataDescriptorGenerator = dataDictionary.getDataDescriptorGenerator();
        DataValueDescriptor dataValueDescriptor = execRow.getColumn(1);
        String string2 = dataValueDescriptor.getString();
        UUID uUID2 = this.getUUIDFactory().recreateUUID(string2);
        dataValueDescriptor = execRow.getColumn(2);
        String string3 = dataValueDescriptor.getString();
        dataValueDescriptor = execRow.getColumn(3);
        String string4 = dataValueDescriptor.getString();
        UUID uUID3 = this.getUUIDFactory().recreateUUID(string4);
        dataValueDescriptor = execRow.getColumn(4);
        char c = dataValueDescriptor.getString().charAt(0);
        if (dataDictionary.isReadOnlyUpgrade()) {
            bl = false;
        } else {
            dataValueDescriptor = execRow.getColumn(5);
            bl = dataValueDescriptor.getBoolean();
        }
        dataValueDescriptor = execRow.getColumn(6);
        String string5 = dataValueDescriptor.getString();
        dataValueDescriptor = execRow.getColumn(7);
        timestamp = dataValueDescriptor.getTimestamp(new GregorianCalendar());
        dataValueDescriptor = execRow.getColumn(8);
        string2 = dataValueDescriptor.getString();
        if (string2 != null) {
            uUID = this.getUUIDFactory().recreateUUID(string2);
        }
        dataValueDescriptor = execRow.getColumn(9);
        String string6 = dataValueDescriptor.getString();
        if (bl) {
            dataValueDescriptor = execRow.getColumn(10);
            execPreparedStatement = (ExecPreparedStatement)dataValueDescriptor.getObject();
        }
        boolean bl2 = (dataValueDescriptor = execRow.getColumn(11)).isNull() ? true : dataValueDescriptor.getBoolean();
        SPSDescriptor sPSDescriptor = new SPSDescriptor(dataDictionary, string3, uUID2, uUID3, uUID, c, bl, string5, string6, timestamp, execPreparedStatement, bl2);
        return sPSDescriptor;
    }

    public ExecRow makeEmptyRow() throws StandardException {
        return this.makeSYSSTATEMENTSrow(false, null);
    }

    public SystemColumn[] buildColumnList() throws StandardException {
        return new SystemColumn[]{SystemColumnImpl.getUUIDColumn("STMTID", false), SystemColumnImpl.getIdentifierColumn("STMTNAME", false), SystemColumnImpl.getUUIDColumn("SCHEMAID", false), SystemColumnImpl.getIndicatorColumn("TYPE"), SystemColumnImpl.getColumn("VALID", 16, false), SystemColumnImpl.getColumn("TEXT", -1, false, 32700), SystemColumnImpl.getColumn("LASTCOMPILED", 93, true), SystemColumnImpl.getUUIDColumn("COMPILATIONSCHEMAID", true), SystemColumnImpl.getColumn("USINGTEXT", -1, true, 32700)};
    }

    public Properties getCreateHeapProperties() {
        Properties properties = new Properties();
        properties.put("derby.storage.pageSize", "2048");
        properties.put("derby.storage.pageReservedSpace", "0");
        properties.put("derby.storage.minimumRecordSize", "1");
        return properties;
    }
}

