/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.ResultSet;
import org.apache.derby.iapi.sql.execute.ExecPreparedStatement;
import org.apache.derby.iapi.sql.execute.NoPutResultSet;
import org.apache.derby.iapi.sql.execute.ResultSetStatistics;
import org.apache.derby.iapi.sql.execute.ResultSetStatisticsFactory;
import org.apache.derby.iapi.sql.execute.RunTimeStatistics;
import org.apache.derby.impl.sql.execute.AnyResultSet;
import org.apache.derby.impl.sql.execute.CurrentOfResultSet;
import org.apache.derby.impl.sql.execute.DeleteCascadeResultSet;
import org.apache.derby.impl.sql.execute.DeleteResultSet;
import org.apache.derby.impl.sql.execute.DeleteVTIResultSet;
import org.apache.derby.impl.sql.execute.DependentResultSet;
import org.apache.derby.impl.sql.execute.DistinctScalarAggregateResultSet;
import org.apache.derby.impl.sql.execute.DistinctScanResultSet;
import org.apache.derby.impl.sql.execute.GroupedAggregateResultSet;
import org.apache.derby.impl.sql.execute.HashJoinResultSet;
import org.apache.derby.impl.sql.execute.HashLeftOuterJoinResultSet;
import org.apache.derby.impl.sql.execute.HashScanResultSet;
import org.apache.derby.impl.sql.execute.HashTableResultSet;
import org.apache.derby.impl.sql.execute.IndexRowToBaseRowResultSet;
import org.apache.derby.impl.sql.execute.InsertResultSet;
import org.apache.derby.impl.sql.execute.InsertVTIResultSet;
import org.apache.derby.impl.sql.execute.LastIndexKeyResultSet;
import org.apache.derby.impl.sql.execute.MaterializedResultSet;
import org.apache.derby.impl.sql.execute.NestedLoopJoinResultSet;
import org.apache.derby.impl.sql.execute.NestedLoopLeftOuterJoinResultSet;
import org.apache.derby.impl.sql.execute.NormalizeResultSet;
import org.apache.derby.impl.sql.execute.OnceResultSet;
import org.apache.derby.impl.sql.execute.ProjectRestrictResultSet;
import org.apache.derby.impl.sql.execute.RowCountResultSet;
import org.apache.derby.impl.sql.execute.RowResultSet;
import org.apache.derby.impl.sql.execute.ScalarAggregateResultSet;
import org.apache.derby.impl.sql.execute.ScrollInsensitiveResultSet;
import org.apache.derby.impl.sql.execute.SetOpResultSet;
import org.apache.derby.impl.sql.execute.SortResultSet;
import org.apache.derby.impl.sql.execute.TableScanResultSet;
import org.apache.derby.impl.sql.execute.UnionResultSet;
import org.apache.derby.impl.sql.execute.UpdateResultSet;
import org.apache.derby.impl.sql.execute.VTIResultSet;
import org.apache.derby.impl.sql.execute.WindowResultSet;
import org.apache.derby.impl.sql.execute.rts.RealAnyResultSetStatistics;
import org.apache.derby.impl.sql.execute.rts.RealCurrentOfStatistics;
import org.apache.derby.impl.sql.execute.rts.RealDeleteCascadeResultSetStatistics;
import org.apache.derby.impl.sql.execute.rts.RealDeleteResultSetStatistics;
import org.apache.derby.impl.sql.execute.rts.RealDeleteVTIResultSetStatistics;
import org.apache.derby.impl.sql.execute.rts.RealDistinctScalarAggregateStatistics;
import org.apache.derby.impl.sql.execute.rts.RealDistinctScanStatistics;
import org.apache.derby.impl.sql.execute.rts.RealGroupedAggregateStatistics;
import org.apache.derby.impl.sql.execute.rts.RealHashJoinStatistics;
import org.apache.derby.impl.sql.execute.rts.RealHashLeftOuterJoinStatistics;
import org.apache.derby.impl.sql.execute.rts.RealHashScanStatistics;
import org.apache.derby.impl.sql.execute.rts.RealHashTableStatistics;
import org.apache.derby.impl.sql.execute.rts.RealIndexRowToBaseRowStatistics;
import org.apache.derby.impl.sql.execute.rts.RealInsertResultSetStatistics;
import org.apache.derby.impl.sql.execute.rts.RealInsertVTIResultSetStatistics;
import org.apache.derby.impl.sql.execute.rts.RealLastIndexKeyScanStatistics;
import org.apache.derby.impl.sql.execute.rts.RealMaterializedResultSetStatistics;
import org.apache.derby.impl.sql.execute.rts.RealNestedLoopJoinStatistics;
import org.apache.derby.impl.sql.execute.rts.RealNestedLoopLeftOuterJoinStatistics;
import org.apache.derby.impl.sql.execute.rts.RealNoRowsResultSetStatistics;
import org.apache.derby.impl.sql.execute.rts.RealNormalizeResultSetStatistics;
import org.apache.derby.impl.sql.execute.rts.RealOnceResultSetStatistics;
import org.apache.derby.impl.sql.execute.rts.RealProjectRestrictStatistics;
import org.apache.derby.impl.sql.execute.rts.RealRowCountStatistics;
import org.apache.derby.impl.sql.execute.rts.RealRowResultSetStatistics;
import org.apache.derby.impl.sql.execute.rts.RealScalarAggregateStatistics;
import org.apache.derby.impl.sql.execute.rts.RealScrollInsensitiveResultSetStatistics;
import org.apache.derby.impl.sql.execute.rts.RealSetOpResultSetStatistics;
import org.apache.derby.impl.sql.execute.rts.RealSortStatistics;
import org.apache.derby.impl.sql.execute.rts.RealTableScanStatistics;
import org.apache.derby.impl.sql.execute.rts.RealUnionResultSetStatistics;
import org.apache.derby.impl.sql.execute.rts.RealUpdateResultSetStatistics;
import org.apache.derby.impl.sql.execute.rts.RealVTIStatistics;
import org.apache.derby.impl.sql.execute.rts.RealWindowResultSetStatistics;
import org.apache.derby.impl.sql.execute.rts.RunTimeStatisticsImpl;

public class RealResultSetStatisticsFactory
implements ResultSetStatisticsFactory {
    public RunTimeStatistics getRunTimeStatistics(Activation activation, ResultSet resultSet, NoPutResultSet[] noPutResultSetArray) throws StandardException {
        ExecPreparedStatement execPreparedStatement = activation.getPreparedStatement();
        if (execPreparedStatement == null) {
            return null;
        }
        ResultSetStatistics resultSetStatistics = resultSet instanceof NoPutResultSet ? this.getResultSetStatistics((NoPutResultSet)resultSet) : this.getResultSetStatistics(resultSet);
        int n = noPutResultSetArray == null ? 0 : noPutResultSetArray.length;
        ResultSetStatistics[] resultSetStatisticsArray = new ResultSetStatistics[n];
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            if (noPutResultSetArray[i] == null || noPutResultSetArray[i].getPointOfAttachment() != -1) continue;
            resultSetStatisticsArray[i] = this.getResultSetStatistics(noPutResultSetArray[i]);
            bl = true;
        }
        if (!bl) {
            resultSetStatisticsArray = null;
        }
        return new RunTimeStatisticsImpl(execPreparedStatement.getSPSName(), activation.getCursorName(), execPreparedStatement.getSource(), execPreparedStatement.getCompileTimeInMillis(), execPreparedStatement.getParseTimeInMillis(), execPreparedStatement.getBindTimeInMillis(), execPreparedStatement.getOptimizeTimeInMillis(), execPreparedStatement.getGenerateTimeInMillis(), resultSet.getExecuteTime(), execPreparedStatement.getBeginCompileTimestamp(), execPreparedStatement.getEndCompileTimestamp(), resultSet.getBeginExecutionTimestamp(), resultSet.getEndExecutionTimestamp(), resultSetStatisticsArray, resultSetStatistics);
    }

    public ResultSetStatistics getResultSetStatistics(ResultSet resultSet) {
        if (!resultSet.returnsRows()) {
            return this.getNoRowsResultSetStatistics(resultSet);
        }
        if (resultSet instanceof NoPutResultSet) {
            return this.getResultSetStatistics((NoPutResultSet)resultSet);
        }
        return null;
    }

    public ResultSetStatistics getNoRowsResultSetStatistics(ResultSet resultSet) {
        RealNoRowsResultSetStatistics realNoRowsResultSetStatistics = null;
        if (resultSet instanceof InsertResultSet) {
            InsertResultSet insertResultSet = (InsertResultSet)resultSet;
            realNoRowsResultSetStatistics = new RealInsertResultSetStatistics((int)insertResultSet.rowCount, insertResultSet.constants.deferred, insertResultSet.constants.irgs.length, insertResultSet.userSpecifiedBulkInsert, insertResultSet.bulkInsertPerformed, insertResultSet.constants.lockMode == 7, insertResultSet.getExecuteTime(), this.getResultSetStatistics(insertResultSet.savedSource));
            insertResultSet.savedSource = null;
        } else if (resultSet instanceof InsertVTIResultSet) {
            InsertVTIResultSet insertVTIResultSet = (InsertVTIResultSet)resultSet;
            realNoRowsResultSetStatistics = new RealInsertVTIResultSetStatistics((int)insertVTIResultSet.rowCount, insertVTIResultSet.constants.deferred, insertVTIResultSet.getExecuteTime(), this.getResultSetStatistics(insertVTIResultSet.savedSource));
            insertVTIResultSet.savedSource = null;
        } else if (resultSet instanceof UpdateResultSet) {
            UpdateResultSet updateResultSet = (UpdateResultSet)resultSet;
            realNoRowsResultSetStatistics = new RealUpdateResultSetStatistics((int)updateResultSet.rowCount, updateResultSet.constants.deferred, updateResultSet.constants.irgs.length, updateResultSet.constants.lockMode == 7, updateResultSet.getExecuteTime(), this.getResultSetStatistics(updateResultSet.savedSource));
            updateResultSet.savedSource = null;
        } else if (resultSet instanceof DeleteCascadeResultSet) {
            DeleteCascadeResultSet deleteCascadeResultSet = (DeleteCascadeResultSet)resultSet;
            int n = deleteCascadeResultSet.dependentResultSets == null ? 0 : deleteCascadeResultSet.dependentResultSets.length;
            ResultSetStatistics[] resultSetStatisticsArray = new ResultSetStatistics[n];
            boolean bl = false;
            for (int i = 0; i < n; ++i) {
                if (deleteCascadeResultSet.dependentResultSets[i] == null) continue;
                resultSetStatisticsArray[i] = this.getResultSetStatistics(deleteCascadeResultSet.dependentResultSets[i]);
                bl = true;
            }
            if (!bl) {
                resultSetStatisticsArray = null;
            }
            realNoRowsResultSetStatistics = new RealDeleteCascadeResultSetStatistics((int)deleteCascadeResultSet.rowCount, deleteCascadeResultSet.constants.deferred, deleteCascadeResultSet.constants.irgs.length, deleteCascadeResultSet.constants.lockMode == 7, deleteCascadeResultSet.getExecuteTime(), this.getResultSetStatistics(deleteCascadeResultSet.savedSource), resultSetStatisticsArray);
            deleteCascadeResultSet.savedSource = null;
        } else if (resultSet instanceof DeleteResultSet) {
            DeleteResultSet deleteResultSet = (DeleteResultSet)resultSet;
            realNoRowsResultSetStatistics = new RealDeleteResultSetStatistics((int)deleteResultSet.rowCount, deleteResultSet.constants.deferred, deleteResultSet.constants.irgs.length, deleteResultSet.constants.lockMode == 7, deleteResultSet.getExecuteTime(), this.getResultSetStatistics(deleteResultSet.savedSource));
            deleteResultSet.savedSource = null;
        } else if (resultSet instanceof DeleteVTIResultSet) {
            DeleteVTIResultSet deleteVTIResultSet = (DeleteVTIResultSet)resultSet;
            realNoRowsResultSetStatistics = new RealDeleteVTIResultSetStatistics((int)deleteVTIResultSet.rowCount, deleteVTIResultSet.getExecuteTime(), this.getResultSetStatistics(deleteVTIResultSet.savedSource));
            deleteVTIResultSet.savedSource = null;
        }
        return realNoRowsResultSetStatistics;
    }

    public ResultSetStatistics getResultSetStatistics(NoPutResultSet noPutResultSet) {
        if (noPutResultSet instanceof ProjectRestrictResultSet) {
            ProjectRestrictResultSet projectRestrictResultSet = (ProjectRestrictResultSet)noPutResultSet;
            int n = projectRestrictResultSet.subqueryTrackingArray == null ? 0 : projectRestrictResultSet.subqueryTrackingArray.length;
            ResultSetStatistics[] resultSetStatisticsArray = new ResultSetStatistics[n];
            boolean bl = false;
            for (int i = 0; i < n; ++i) {
                if (projectRestrictResultSet.subqueryTrackingArray[i] == null || projectRestrictResultSet.subqueryTrackingArray[i].getPointOfAttachment() != projectRestrictResultSet.resultSetNumber) continue;
                resultSetStatisticsArray[i] = this.getResultSetStatistics(projectRestrictResultSet.subqueryTrackingArray[i]);
                bl = true;
            }
            if (!bl) {
                resultSetStatisticsArray = null;
            }
            return new RealProjectRestrictStatistics(projectRestrictResultSet.numOpens, projectRestrictResultSet.rowsSeen, projectRestrictResultSet.rowsFiltered, projectRestrictResultSet.constructorTime, projectRestrictResultSet.openTime, projectRestrictResultSet.nextTime, projectRestrictResultSet.closeTime, projectRestrictResultSet.resultSetNumber, projectRestrictResultSet.restrictionTime, projectRestrictResultSet.projectionTime, resultSetStatisticsArray, projectRestrictResultSet.restriction != null, projectRestrictResultSet.doesProjection, projectRestrictResultSet.optimizerEstimatedRowCount, projectRestrictResultSet.optimizerEstimatedCost, this.getResultSetStatistics(projectRestrictResultSet.source));
        }
        if (noPutResultSet instanceof RowCountResultSet) {
            RowCountResultSet rowCountResultSet = (RowCountResultSet)noPutResultSet;
            return new RealRowCountStatistics(rowCountResultSet.numOpens, rowCountResultSet.rowsSeen, rowCountResultSet.rowsFiltered, rowCountResultSet.constructorTime, rowCountResultSet.openTime, rowCountResultSet.nextTime, rowCountResultSet.closeTime, rowCountResultSet.resultSetNumber, rowCountResultSet.optimizerEstimatedRowCount, rowCountResultSet.optimizerEstimatedCost, this.getResultSetStatistics(rowCountResultSet.source));
        }
        if (noPutResultSet instanceof SortResultSet) {
            SortResultSet sortResultSet = (SortResultSet)noPutResultSet;
            return new RealSortStatistics(sortResultSet.numOpens, sortResultSet.rowsSeen, sortResultSet.rowsFiltered, sortResultSet.constructorTime, sortResultSet.openTime, sortResultSet.nextTime, sortResultSet.closeTime, sortResultSet.resultSetNumber, sortResultSet.rowsInput, sortResultSet.rowsReturned, sortResultSet.distinct, sortResultSet.isInSortedOrder, sortResultSet.sortProperties, sortResultSet.optimizerEstimatedRowCount, sortResultSet.optimizerEstimatedCost, this.getResultSetStatistics(sortResultSet.source));
        }
        if (noPutResultSet instanceof DistinctScalarAggregateResultSet) {
            DistinctScalarAggregateResultSet distinctScalarAggregateResultSet = (DistinctScalarAggregateResultSet)noPutResultSet;
            return new RealDistinctScalarAggregateStatistics(distinctScalarAggregateResultSet.numOpens, distinctScalarAggregateResultSet.rowsSeen, distinctScalarAggregateResultSet.rowsFiltered, distinctScalarAggregateResultSet.constructorTime, distinctScalarAggregateResultSet.openTime, distinctScalarAggregateResultSet.nextTime, distinctScalarAggregateResultSet.closeTime, distinctScalarAggregateResultSet.resultSetNumber, distinctScalarAggregateResultSet.rowsInput, distinctScalarAggregateResultSet.optimizerEstimatedRowCount, distinctScalarAggregateResultSet.optimizerEstimatedCost, this.getResultSetStatistics(distinctScalarAggregateResultSet.source));
        }
        if (noPutResultSet instanceof ScalarAggregateResultSet) {
            ScalarAggregateResultSet scalarAggregateResultSet = (ScalarAggregateResultSet)noPutResultSet;
            return new RealScalarAggregateStatistics(scalarAggregateResultSet.numOpens, scalarAggregateResultSet.rowsSeen, scalarAggregateResultSet.rowsFiltered, scalarAggregateResultSet.constructorTime, scalarAggregateResultSet.openTime, scalarAggregateResultSet.nextTime, scalarAggregateResultSet.closeTime, scalarAggregateResultSet.resultSetNumber, scalarAggregateResultSet.singleInputRow, scalarAggregateResultSet.rowsInput, scalarAggregateResultSet.optimizerEstimatedRowCount, scalarAggregateResultSet.optimizerEstimatedCost, this.getResultSetStatistics(scalarAggregateResultSet.source));
        }
        if (noPutResultSet instanceof GroupedAggregateResultSet) {
            GroupedAggregateResultSet groupedAggregateResultSet = (GroupedAggregateResultSet)noPutResultSet;
            return new RealGroupedAggregateStatistics(groupedAggregateResultSet.numOpens, groupedAggregateResultSet.rowsSeen, groupedAggregateResultSet.rowsFiltered, groupedAggregateResultSet.constructorTime, groupedAggregateResultSet.openTime, groupedAggregateResultSet.nextTime, groupedAggregateResultSet.closeTime, groupedAggregateResultSet.resultSetNumber, groupedAggregateResultSet.rowsInput, groupedAggregateResultSet.hasDistinctAggregate, groupedAggregateResultSet.isInSortedOrder, groupedAggregateResultSet.sortProperties, groupedAggregateResultSet.optimizerEstimatedRowCount, groupedAggregateResultSet.optimizerEstimatedCost, this.getResultSetStatistics(groupedAggregateResultSet.source));
        }
        if (noPutResultSet instanceof TableScanResultSet) {
            boolean bl = false;
            TableScanResultSet tableScanResultSet = (TableScanResultSet)noPutResultSet;
            String string2 = null;
            String string3 = null;
            String string4 = null;
            String string5 = null;
            String string6 = null;
            switch (tableScanResultSet.isolationLevel) {
                case 5: {
                    string4 = MessageService.getTextMessage("42Z80.U");
                    break;
                }
                case 4: {
                    string4 = MessageService.getTextMessage("42Z92");
                    break;
                }
                case 3: {
                    bl = true;
                }
                case 2: {
                    string4 = MessageService.getTextMessage("42Z81.U");
                    break;
                }
                case 1: {
                    string4 = MessageService.getTextMessage("42Z9A");
                }
            }
            string5 = tableScanResultSet.forUpdate ? MessageService.getTextMessage("42Z82.U") : (bl ? MessageService.getTextMessage("42Z83.U") : MessageService.getTextMessage("42Z84.U"));
            switch (tableScanResultSet.lockMode) {
                case 7: {
                    string6 = string5 + " " + MessageService.getTextMessage("42Z85.U");
                    break;
                }
                case 6: {
                    string6 = string5 + " " + MessageService.getTextMessage("42Z86.U");
                }
            }
            if (tableScanResultSet.indexName != null) {
                string2 = tableScanResultSet.startPositionString;
                if (string2 == null) {
                    string2 = tableScanResultSet.printStartPosition();
                }
                if ((string3 = tableScanResultSet.stopPositionString) == null) {
                    string3 = tableScanResultSet.printStopPosition();
                }
            }
            return new RealTableScanStatistics(tableScanResultSet.numOpens, tableScanResultSet.rowsSeen, tableScanResultSet.rowsFiltered, tableScanResultSet.constructorTime, tableScanResultSet.openTime, tableScanResultSet.nextTime, tableScanResultSet.closeTime, tableScanResultSet.resultSetNumber, tableScanResultSet.tableName, tableScanResultSet.userSuppliedOptimizerOverrides, tableScanResultSet.indexName, tableScanResultSet.isConstraint, TableScanResultSet.printQualifiers(tableScanResultSet.qualifiers), tableScanResultSet.getScanProperties(), string2, string3, string4, string6, tableScanResultSet.rowsPerRead, tableScanResultSet.coarserLock, tableScanResultSet.optimizerEstimatedRowCount, tableScanResultSet.optimizerEstimatedCost);
        }
        if (noPutResultSet instanceof LastIndexKeyResultSet) {
            LastIndexKeyResultSet lastIndexKeyResultSet = (LastIndexKeyResultSet)noPutResultSet;
            String string7 = null;
            String string8 = null;
            switch (lastIndexKeyResultSet.isolationLevel) {
                case 5: {
                    string7 = MessageService.getTextMessage("42Z80.U");
                    break;
                }
                case 4: {
                    string7 = MessageService.getTextMessage("42Z92");
                    break;
                }
                case 2: 
                case 3: {
                    string7 = MessageService.getTextMessage("42Z81.U");
                    break;
                }
                case 1: {
                    string7 = MessageService.getTextMessage("42Z9A");
                }
            }
            switch (lastIndexKeyResultSet.lockMode) {
                case 7: {
                    string8 = MessageService.getTextMessage("42Z87.U");
                    break;
                }
                case 6: {
                    string8 = MessageService.getTextMessage("42Z88.U");
                }
            }
            return new RealLastIndexKeyScanStatistics(lastIndexKeyResultSet.numOpens, lastIndexKeyResultSet.constructorTime, lastIndexKeyResultSet.openTime, lastIndexKeyResultSet.nextTime, lastIndexKeyResultSet.closeTime, lastIndexKeyResultSet.resultSetNumber, lastIndexKeyResultSet.tableName, lastIndexKeyResultSet.indexName, string7, string8, lastIndexKeyResultSet.optimizerEstimatedRowCount, lastIndexKeyResultSet.optimizerEstimatedCost);
        }
        if (noPutResultSet instanceof HashLeftOuterJoinResultSet) {
            HashLeftOuterJoinResultSet hashLeftOuterJoinResultSet = (HashLeftOuterJoinResultSet)noPutResultSet;
            return new RealHashLeftOuterJoinStatistics(hashLeftOuterJoinResultSet.numOpens, hashLeftOuterJoinResultSet.rowsSeen, hashLeftOuterJoinResultSet.rowsFiltered, hashLeftOuterJoinResultSet.constructorTime, hashLeftOuterJoinResultSet.openTime, hashLeftOuterJoinResultSet.nextTime, hashLeftOuterJoinResultSet.closeTime, hashLeftOuterJoinResultSet.resultSetNumber, hashLeftOuterJoinResultSet.rowsSeenLeft, hashLeftOuterJoinResultSet.rowsSeenRight, hashLeftOuterJoinResultSet.rowsReturned, hashLeftOuterJoinResultSet.restrictionTime, hashLeftOuterJoinResultSet.optimizerEstimatedRowCount, hashLeftOuterJoinResultSet.optimizerEstimatedCost, hashLeftOuterJoinResultSet.userSuppliedOptimizerOverrides, this.getResultSetStatistics(hashLeftOuterJoinResultSet.leftResultSet), this.getResultSetStatistics(hashLeftOuterJoinResultSet.rightResultSet), hashLeftOuterJoinResultSet.emptyRightRowsReturned);
        }
        if (noPutResultSet instanceof NestedLoopLeftOuterJoinResultSet) {
            NestedLoopLeftOuterJoinResultSet nestedLoopLeftOuterJoinResultSet = (NestedLoopLeftOuterJoinResultSet)noPutResultSet;
            return new RealNestedLoopLeftOuterJoinStatistics(nestedLoopLeftOuterJoinResultSet.numOpens, nestedLoopLeftOuterJoinResultSet.rowsSeen, nestedLoopLeftOuterJoinResultSet.rowsFiltered, nestedLoopLeftOuterJoinResultSet.constructorTime, nestedLoopLeftOuterJoinResultSet.openTime, nestedLoopLeftOuterJoinResultSet.nextTime, nestedLoopLeftOuterJoinResultSet.closeTime, nestedLoopLeftOuterJoinResultSet.resultSetNumber, nestedLoopLeftOuterJoinResultSet.rowsSeenLeft, nestedLoopLeftOuterJoinResultSet.rowsSeenRight, nestedLoopLeftOuterJoinResultSet.rowsReturned, nestedLoopLeftOuterJoinResultSet.restrictionTime, nestedLoopLeftOuterJoinResultSet.optimizerEstimatedRowCount, nestedLoopLeftOuterJoinResultSet.optimizerEstimatedCost, nestedLoopLeftOuterJoinResultSet.userSuppliedOptimizerOverrides, this.getResultSetStatistics(nestedLoopLeftOuterJoinResultSet.leftResultSet), this.getResultSetStatistics(nestedLoopLeftOuterJoinResultSet.rightResultSet), nestedLoopLeftOuterJoinResultSet.emptyRightRowsReturned);
        }
        if (noPutResultSet instanceof HashJoinResultSet) {
            HashJoinResultSet hashJoinResultSet = (HashJoinResultSet)noPutResultSet;
            return new RealHashJoinStatistics(hashJoinResultSet.numOpens, hashJoinResultSet.rowsSeen, hashJoinResultSet.rowsFiltered, hashJoinResultSet.constructorTime, hashJoinResultSet.openTime, hashJoinResultSet.nextTime, hashJoinResultSet.closeTime, hashJoinResultSet.resultSetNumber, hashJoinResultSet.rowsSeenLeft, hashJoinResultSet.rowsSeenRight, hashJoinResultSet.rowsReturned, hashJoinResultSet.restrictionTime, hashJoinResultSet.oneRowRightSide, hashJoinResultSet.optimizerEstimatedRowCount, hashJoinResultSet.optimizerEstimatedCost, hashJoinResultSet.userSuppliedOptimizerOverrides, this.getResultSetStatistics(hashJoinResultSet.leftResultSet), this.getResultSetStatistics(hashJoinResultSet.rightResultSet));
        }
        if (noPutResultSet instanceof NestedLoopJoinResultSet) {
            NestedLoopJoinResultSet nestedLoopJoinResultSet = (NestedLoopJoinResultSet)noPutResultSet;
            return new RealNestedLoopJoinStatistics(nestedLoopJoinResultSet.numOpens, nestedLoopJoinResultSet.rowsSeen, nestedLoopJoinResultSet.rowsFiltered, nestedLoopJoinResultSet.constructorTime, nestedLoopJoinResultSet.openTime, nestedLoopJoinResultSet.nextTime, nestedLoopJoinResultSet.closeTime, nestedLoopJoinResultSet.resultSetNumber, nestedLoopJoinResultSet.rowsSeenLeft, nestedLoopJoinResultSet.rowsSeenRight, nestedLoopJoinResultSet.rowsReturned, nestedLoopJoinResultSet.restrictionTime, nestedLoopJoinResultSet.oneRowRightSide, nestedLoopJoinResultSet.optimizerEstimatedRowCount, nestedLoopJoinResultSet.optimizerEstimatedCost, nestedLoopJoinResultSet.userSuppliedOptimizerOverrides, this.getResultSetStatistics(nestedLoopJoinResultSet.leftResultSet), this.getResultSetStatistics(nestedLoopJoinResultSet.rightResultSet));
        }
        if (noPutResultSet instanceof IndexRowToBaseRowResultSet) {
            IndexRowToBaseRowResultSet indexRowToBaseRowResultSet = (IndexRowToBaseRowResultSet)noPutResultSet;
            return new RealIndexRowToBaseRowStatistics(indexRowToBaseRowResultSet.numOpens, indexRowToBaseRowResultSet.rowsSeen, indexRowToBaseRowResultSet.rowsFiltered, indexRowToBaseRowResultSet.constructorTime, indexRowToBaseRowResultSet.openTime, indexRowToBaseRowResultSet.nextTime, indexRowToBaseRowResultSet.closeTime, indexRowToBaseRowResultSet.resultSetNumber, indexRowToBaseRowResultSet.indexName, indexRowToBaseRowResultSet.accessedHeapCols, indexRowToBaseRowResultSet.optimizerEstimatedRowCount, indexRowToBaseRowResultSet.optimizerEstimatedCost, this.getResultSetStatistics(indexRowToBaseRowResultSet.source));
        }
        if (noPutResultSet instanceof RowResultSet) {
            RowResultSet rowResultSet = (RowResultSet)noPutResultSet;
            return new RealRowResultSetStatistics(rowResultSet.numOpens, rowResultSet.rowsSeen, rowResultSet.rowsFiltered, rowResultSet.constructorTime, rowResultSet.openTime, rowResultSet.nextTime, rowResultSet.closeTime, rowResultSet.resultSetNumber, rowResultSet.rowsReturned, rowResultSet.optimizerEstimatedRowCount, rowResultSet.optimizerEstimatedCost);
        }
        if (noPutResultSet instanceof WindowResultSet) {
            WindowResultSet windowResultSet = (WindowResultSet)noPutResultSet;
            return new RealWindowResultSetStatistics(windowResultSet.numOpens, windowResultSet.rowsSeen, windowResultSet.rowsFiltered, windowResultSet.constructorTime, windowResultSet.openTime, windowResultSet.nextTime, windowResultSet.closeTime, windowResultSet.resultSetNumber, windowResultSet.optimizerEstimatedRowCount, windowResultSet.optimizerEstimatedCost, this.getResultSetStatistics(windowResultSet.source));
        }
        if (noPutResultSet instanceof SetOpResultSet) {
            SetOpResultSet setOpResultSet = (SetOpResultSet)noPutResultSet;
            return new RealSetOpResultSetStatistics(setOpResultSet.getOpType(), setOpResultSet.numOpens, setOpResultSet.rowsSeen, setOpResultSet.rowsFiltered, setOpResultSet.constructorTime, setOpResultSet.openTime, setOpResultSet.nextTime, setOpResultSet.closeTime, setOpResultSet.getResultSetNumber(), setOpResultSet.getRowsSeenLeft(), setOpResultSet.getRowsSeenRight(), setOpResultSet.getRowsReturned(), setOpResultSet.optimizerEstimatedRowCount, setOpResultSet.optimizerEstimatedCost, this.getResultSetStatistics(setOpResultSet.getLeftSourceInput()), this.getResultSetStatistics(setOpResultSet.getRightSourceInput()));
        }
        if (noPutResultSet instanceof UnionResultSet) {
            UnionResultSet unionResultSet = (UnionResultSet)noPutResultSet;
            return new RealUnionResultSetStatistics(unionResultSet.numOpens, unionResultSet.rowsSeen, unionResultSet.rowsFiltered, unionResultSet.constructorTime, unionResultSet.openTime, unionResultSet.nextTime, unionResultSet.closeTime, unionResultSet.resultSetNumber, unionResultSet.rowsSeenLeft, unionResultSet.rowsSeenRight, unionResultSet.rowsReturned, unionResultSet.optimizerEstimatedRowCount, unionResultSet.optimizerEstimatedCost, this.getResultSetStatistics(unionResultSet.source1), this.getResultSetStatistics(unionResultSet.source2));
        }
        if (noPutResultSet instanceof AnyResultSet) {
            AnyResultSet anyResultSet = (AnyResultSet)noPutResultSet;
            return new RealAnyResultSetStatistics(anyResultSet.numOpens, anyResultSet.rowsSeen, anyResultSet.rowsFiltered, anyResultSet.constructorTime, anyResultSet.openTime, anyResultSet.nextTime, anyResultSet.closeTime, anyResultSet.resultSetNumber, anyResultSet.subqueryNumber, anyResultSet.pointOfAttachment, anyResultSet.optimizerEstimatedRowCount, anyResultSet.optimizerEstimatedCost, this.getResultSetStatistics(anyResultSet.source));
        }
        if (noPutResultSet instanceof OnceResultSet) {
            OnceResultSet onceResultSet = (OnceResultSet)noPutResultSet;
            return new RealOnceResultSetStatistics(onceResultSet.numOpens, onceResultSet.rowsSeen, onceResultSet.rowsFiltered, onceResultSet.constructorTime, onceResultSet.openTime, onceResultSet.nextTime, onceResultSet.closeTime, onceResultSet.resultSetNumber, onceResultSet.subqueryNumber, onceResultSet.pointOfAttachment, onceResultSet.optimizerEstimatedRowCount, onceResultSet.optimizerEstimatedCost, this.getResultSetStatistics(onceResultSet.source));
        }
        if (noPutResultSet instanceof NormalizeResultSet) {
            NormalizeResultSet normalizeResultSet = (NormalizeResultSet)noPutResultSet;
            return new RealNormalizeResultSetStatistics(normalizeResultSet.numOpens, normalizeResultSet.rowsSeen, normalizeResultSet.rowsFiltered, normalizeResultSet.constructorTime, normalizeResultSet.openTime, normalizeResultSet.nextTime, normalizeResultSet.closeTime, normalizeResultSet.resultSetNumber, normalizeResultSet.optimizerEstimatedRowCount, normalizeResultSet.optimizerEstimatedCost, this.getResultSetStatistics(normalizeResultSet.source));
        }
        if (noPutResultSet instanceof MaterializedResultSet) {
            MaterializedResultSet materializedResultSet = (MaterializedResultSet)noPutResultSet;
            return new RealMaterializedResultSetStatistics(materializedResultSet.numOpens, materializedResultSet.rowsSeen, materializedResultSet.rowsFiltered, materializedResultSet.constructorTime, materializedResultSet.openTime, materializedResultSet.nextTime, materializedResultSet.closeTime, materializedResultSet.createTCTime, materializedResultSet.fetchTCTime, materializedResultSet.resultSetNumber, materializedResultSet.optimizerEstimatedRowCount, materializedResultSet.optimizerEstimatedCost, this.getResultSetStatistics(materializedResultSet.source));
        }
        if (noPutResultSet instanceof ScrollInsensitiveResultSet) {
            ScrollInsensitiveResultSet scrollInsensitiveResultSet = (ScrollInsensitiveResultSet)noPutResultSet;
            return new RealScrollInsensitiveResultSetStatistics(scrollInsensitiveResultSet.numOpens, scrollInsensitiveResultSet.rowsSeen, scrollInsensitiveResultSet.rowsFiltered, scrollInsensitiveResultSet.constructorTime, scrollInsensitiveResultSet.openTime, scrollInsensitiveResultSet.nextTime, scrollInsensitiveResultSet.closeTime, scrollInsensitiveResultSet.numFromHashTable, scrollInsensitiveResultSet.numToHashTable, scrollInsensitiveResultSet.resultSetNumber, scrollInsensitiveResultSet.optimizerEstimatedRowCount, scrollInsensitiveResultSet.optimizerEstimatedCost, this.getResultSetStatistics(scrollInsensitiveResultSet.source));
        }
        if (noPutResultSet instanceof CurrentOfResultSet) {
            CurrentOfResultSet currentOfResultSet = (CurrentOfResultSet)noPutResultSet;
            return new RealCurrentOfStatistics(currentOfResultSet.numOpens, currentOfResultSet.rowsSeen, currentOfResultSet.rowsFiltered, currentOfResultSet.constructorTime, currentOfResultSet.openTime, currentOfResultSet.nextTime, currentOfResultSet.closeTime, currentOfResultSet.resultSetNumber);
        }
        if (noPutResultSet instanceof HashScanResultSet) {
            boolean bl = false;
            HashScanResultSet hashScanResultSet = (HashScanResultSet)noPutResultSet;
            String string9 = null;
            String string10 = null;
            String string11 = null;
            String string12 = null;
            switch (hashScanResultSet.isolationLevel) {
                case 5: {
                    string11 = MessageService.getTextMessage("42Z80.U");
                    break;
                }
                case 4: {
                    string11 = MessageService.getTextMessage("42Z92");
                    break;
                }
                case 3: {
                    bl = true;
                }
                case 2: {
                    string11 = MessageService.getTextMessage("42Z81.U");
                }
            }
            string12 = hashScanResultSet.forUpdate ? MessageService.getTextMessage("42Z82.U") : (bl ? MessageService.getTextMessage("42Z83.U") : MessageService.getTextMessage("42Z84.U"));
            switch (hashScanResultSet.lockMode) {
                case 7: {
                    string12 = string12 + " " + MessageService.getTextMessage("42Z85.U");
                    break;
                }
                case 6: {
                    string12 = string12 + " " + MessageService.getTextMessage("42Z86.U");
                }
            }
            if (hashScanResultSet.indexName != null) {
                string9 = hashScanResultSet.startPositionString;
                if (string9 == null) {
                    string9 = hashScanResultSet.printStartPosition();
                }
                if ((string10 = hashScanResultSet.stopPositionString) == null) {
                    string10 = hashScanResultSet.printStopPosition();
                }
            }
            if (noPutResultSet instanceof DistinctScanResultSet) {
                return new RealDistinctScanStatistics(hashScanResultSet.numOpens, hashScanResultSet.rowsSeen, hashScanResultSet.rowsFiltered, hashScanResultSet.constructorTime, hashScanResultSet.openTime, hashScanResultSet.nextTime, hashScanResultSet.closeTime, hashScanResultSet.resultSetNumber, hashScanResultSet.tableName, hashScanResultSet.indexName, hashScanResultSet.isConstraint, hashScanResultSet.hashtableSize, hashScanResultSet.keyColumns, HashScanResultSet.printQualifiers(hashScanResultSet.scanQualifiers), HashScanResultSet.printQualifiers(hashScanResultSet.nextQualifiers), hashScanResultSet.getScanProperties(), string9, string10, string11, string12, hashScanResultSet.optimizerEstimatedRowCount, hashScanResultSet.optimizerEstimatedCost);
            }
            return new RealHashScanStatistics(hashScanResultSet.numOpens, hashScanResultSet.rowsSeen, hashScanResultSet.rowsFiltered, hashScanResultSet.constructorTime, hashScanResultSet.openTime, hashScanResultSet.nextTime, hashScanResultSet.closeTime, hashScanResultSet.resultSetNumber, hashScanResultSet.tableName, hashScanResultSet.indexName, hashScanResultSet.isConstraint, hashScanResultSet.hashtableSize, hashScanResultSet.keyColumns, HashScanResultSet.printQualifiers(hashScanResultSet.scanQualifiers), HashScanResultSet.printQualifiers(hashScanResultSet.nextQualifiers), hashScanResultSet.getScanProperties(), string9, string10, string11, string12, hashScanResultSet.optimizerEstimatedRowCount, hashScanResultSet.optimizerEstimatedCost);
        }
        if (noPutResultSet instanceof HashTableResultSet) {
            HashTableResultSet hashTableResultSet = (HashTableResultSet)noPutResultSet;
            int n = hashTableResultSet.subqueryTrackingArray == null ? 0 : hashTableResultSet.subqueryTrackingArray.length;
            ResultSetStatistics[] resultSetStatisticsArray = new ResultSetStatistics[n];
            boolean bl = false;
            for (int i = 0; i < n; ++i) {
                if (hashTableResultSet.subqueryTrackingArray[i] == null || hashTableResultSet.subqueryTrackingArray[i].getPointOfAttachment() != hashTableResultSet.resultSetNumber) continue;
                resultSetStatisticsArray[i] = this.getResultSetStatistics(hashTableResultSet.subqueryTrackingArray[i]);
                bl = true;
            }
            if (!bl) {
                resultSetStatisticsArray = null;
            }
            return new RealHashTableStatistics(hashTableResultSet.numOpens, hashTableResultSet.rowsSeen, hashTableResultSet.rowsFiltered, hashTableResultSet.constructorTime, hashTableResultSet.openTime, hashTableResultSet.nextTime, hashTableResultSet.closeTime, hashTableResultSet.resultSetNumber, hashTableResultSet.hashtableSize, hashTableResultSet.keyColumns, HashScanResultSet.printQualifiers(hashTableResultSet.nextQualifiers), hashTableResultSet.scanProperties, hashTableResultSet.optimizerEstimatedRowCount, hashTableResultSet.optimizerEstimatedCost, resultSetStatisticsArray, this.getResultSetStatistics(hashTableResultSet.source));
        }
        if (noPutResultSet instanceof VTIResultSet) {
            VTIResultSet vTIResultSet = (VTIResultSet)noPutResultSet;
            return new RealVTIStatistics(vTIResultSet.numOpens, vTIResultSet.rowsSeen, vTIResultSet.rowsFiltered, vTIResultSet.constructorTime, vTIResultSet.openTime, vTIResultSet.nextTime, vTIResultSet.closeTime, vTIResultSet.resultSetNumber, vTIResultSet.javaClassName, vTIResultSet.optimizerEstimatedRowCount, vTIResultSet.optimizerEstimatedCost);
        }
        if (noPutResultSet instanceof DependentResultSet) {
            boolean bl = false;
            DependentResultSet dependentResultSet = (DependentResultSet)noPutResultSet;
            String string13 = null;
            String string14 = null;
            String string15 = null;
            String string16 = null;
            String string17 = null;
            switch (dependentResultSet.isolationLevel) {
                case 5: {
                    string15 = MessageService.getTextMessage("42Z80.U");
                    break;
                }
                case 4: {
                    string15 = MessageService.getTextMessage("42Z92");
                    break;
                }
                case 3: {
                    bl = true;
                }
                case 2: {
                    string15 = MessageService.getTextMessage("42Z81.U");
                    break;
                }
                case 1: {
                    string15 = MessageService.getTextMessage("42Z9A");
                }
            }
            string16 = dependentResultSet.forUpdate ? MessageService.getTextMessage("42Z82.U") : (bl ? MessageService.getTextMessage("42Z83.U") : MessageService.getTextMessage("42Z84.U"));
            switch (dependentResultSet.lockMode) {
                case 7: {
                    string17 = string16 + " " + MessageService.getTextMessage("42Z85.U");
                    break;
                }
                case 6: {
                    string17 = string16 + " " + MessageService.getTextMessage("42Z86.U");
                }
            }
            string13 = dependentResultSet.startPositionString;
            if (string13 == null) {
                string13 = dependentResultSet.printStartPosition();
            }
            if ((string14 = dependentResultSet.stopPositionString) == null) {
                string14 = dependentResultSet.printStopPosition();
            }
            return new RealTableScanStatistics(dependentResultSet.numOpens, dependentResultSet.rowsSeen, dependentResultSet.rowsFiltered, dependentResultSet.constructorTime, dependentResultSet.openTime, dependentResultSet.nextTime, dependentResultSet.closeTime, dependentResultSet.resultSetNumber, dependentResultSet.tableName, null, dependentResultSet.indexName, dependentResultSet.isConstraint, dependentResultSet.printQualifiers(), dependentResultSet.getScanProperties(), string13, string14, string15, string17, dependentResultSet.rowsPerRead, dependentResultSet.coarserLock, dependentResultSet.optimizerEstimatedRowCount, dependentResultSet.optimizerEstimatedCost);
        }
        return null;
    }
}

