/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute.rts;

import java.util.Enumeration;
import java.util.Properties;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.services.io.FormatableProperties;
import org.apache.derby.iapi.sql.execute.xplain.XPLAINVisitor;
import org.apache.derby.iapi.util.PropertyUtil;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.impl.sql.catalog.XPLAINResultSetDescriptor;
import org.apache.derby.impl.sql.catalog.XPLAINScanPropsDescriptor;
import org.apache.derby.impl.sql.execute.rts.RealNoPutResultSetStatistics;
import org.apache.derby.impl.sql.execute.xplain.XPLAINUtil;

public class RealTableScanStatistics
extends RealNoPutResultSetStatistics {
    public boolean isConstraint;
    public boolean coarserLock;
    public int fetchSize;
    public String isolationLevel;
    public String tableName;
    public String userSuppliedOptimizerOverrides;
    public String indexName;
    public String lockString;
    public String qualifiers;
    public String startPosition;
    public String stopPosition;
    public FormatableProperties scanProperties;

    public RealTableScanStatistics(int n, int n2, int n3, long l, long l2, long l3, long l4, int n4, String string2, String string3, String string4, boolean bl, String string5, Properties properties, String string6, String string7, String string8, String string9, int n5, boolean bl2, double d, double d2) {
        super(n, n2, n3, l, l2, l3, l4, n4, d, d2);
        this.tableName = string2;
        this.userSuppliedOptimizerOverrides = string3;
        this.indexName = string4;
        this.isConstraint = bl;
        this.qualifiers = string5;
        this.scanProperties = new FormatableProperties();
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string10 = (String)enumeration.nextElement();
            this.scanProperties.put(string10, properties.get(string10));
        }
        this.startPosition = string6;
        this.stopPosition = string7;
        this.isolationLevel = string8;
        this.lockString = string9;
        this.fetchSize = n5;
        this.coarserLock = bl2;
    }

    public String getStatementExecutionPlanText(int n) {
        String string2 = "";
        Object var3_3 = null;
        this.initFormatInfo(n);
        if (this.userSuppliedOptimizerOverrides != null) {
            string2 = this.indent + MessageService.getTextMessage("43Y56.U", this.tableName, this.userSuppliedOptimizerOverrides);
            string2 = string2 + "\n";
        }
        string2 = this.indexName != null ? string2 + this.indent + MessageService.getTextMessage("43Y09.U", this.tableName, this.isConstraint ? "constraint" : "index", this.indexName) : string2 + this.indent + MessageService.getTextMessage("43Y10.U", this.tableName);
        string2 = string2 + " " + MessageService.getTextMessage("43X72.U", this.isolationLevel, this.lockString);
        if (this.coarserLock) {
            string2 = string2 + " (" + MessageService.getTextMessage("43Y11.U") + ")";
        }
        string2 = string2 + "\n";
        String string3 = this.indent + MessageService.getTextMessage("43X28.U") + ":\n" + PropertyUtil.sortProperties(this.scanProperties, this.subIndent);
        return string2 + this.indent + MessageService.getTextMessage("43X03.U") + " = " + this.numOpens + "\n" + this.indent + MessageService.getTextMessage("43X04.U") + " = " + this.rowsSeen + "\n" + this.indent + MessageService.getTextMessage("43X32.U") + " = " + this.rowsFiltered + "\n" + this.indent + MessageService.getTextMessage("43Y12.U") + " = " + this.fetchSize + "\n" + this.dumpTimeStats(this.indent, this.subIndent) + "\n" + (this.rowsSeen > 0 ? this.subIndent + MessageService.getTextMessage("43X33.U") + " = " + this.nextTime / (long)this.rowsSeen + "\n" : "") + "\n" + string3 + this.subIndent + MessageService.getTextMessage("43X34.U") + ":\n" + StringUtil.ensureIndent(this.startPosition, n + 2) + "\n" + this.subIndent + MessageService.getTextMessage("43X35.U") + ":\n" + StringUtil.ensureIndent(this.stopPosition, n + 2) + "\n" + this.subIndent + MessageService.getTextMessage("43Y13.U") + ":\n" + StringUtil.ensureIndent(this.qualifiers, n + 2) + "\n" + this.dumpEstimatedCosts(this.subIndent);
    }

    public String getScanStatisticsText(String string2, int n) {
        if (string2 == null || string2.equals(this.tableName)) {
            return this.getStatementExecutionPlanText(n);
        }
        return "";
    }

    public String toString() {
        return this.getStatementExecutionPlanText(0);
    }

    public String getNodeName() {
        return MessageService.getTextMessage(this.indexName == null ? "43X73.U" : "43X74.U");
    }

    public String getNodeOn() {
        if (this.indexName == null) {
            return MessageService.getTextMessage("43X75.U", this.tableName);
        }
        return MessageService.getTextMessage("43X38.U", this.tableName, this.indexName);
    }

    public void accept(XPLAINVisitor xPLAINVisitor) {
        xPLAINVisitor.setNumberOfChildren(0);
        xPLAINVisitor.visit(this);
    }

    public String getRSXplainType() {
        if (this.indexName != null) {
            return this.isConstraint ? "CONSTRAINTSCAN" : "INDEXSCAN";
        }
        return "TABLESCAN";
    }

    public String getRSXplainDetails() {
        if (this.indexName != null) {
            return (this.isConstraint ? "C: " : "I: ") + this.indexName;
        }
        return "T: " + this.tableName;
    }

    public Object getScanPropsDescriptor(Object object) {
        String string2;
        String string3;
        if (this.indexName != null) {
            if (this.isConstraint) {
                string3 = "C";
                string2 = this.indexName;
            } else {
                string3 = "I";
                string2 = this.indexName;
            }
        } else {
            string3 = "T";
            string2 = this.tableName;
        }
        String string4 = XPLAINUtil.getIsolationLevelCode(this.isolationLevel);
        XPLAINScanPropsDescriptor xPLAINScanPropsDescriptor = new XPLAINScanPropsDescriptor((UUID)object, string2, string3, null, string4, null, null, null, null, null, null, null, new Integer(this.fetchSize), this.startPosition, this.stopPosition, this.qualifiers, null, null, null);
        FormatableProperties formatableProperties = this.scanProperties;
        return XPLAINUtil.extractScanProps(xPLAINScanPropsDescriptor, formatableProperties);
    }

    public Object getResultSetDescriptor(Object object, Object object2, Object object3, Object object4, Object object5, Object object6) {
        String string2 = XPLAINUtil.getLockModeCode(this.lockString);
        String string3 = XPLAINUtil.getLockGranularityCode(this.lockString);
        return new XPLAINResultSetDescriptor((UUID)object, this.getRSXplainType(), this.getRSXplainDetails(), new Integer(this.numOpens), null, string2, string3, (UUID)object2, new Double(this.optimizerEstimatedRowCount), new Double(this.optimizerEstimatedCost), null, null, null, new Integer(this.rowsSeen), null, new Integer(this.rowsFiltered), new Integer(this.rowsSeen - this.rowsFiltered), null, null, (UUID)object3, (UUID)object4, (UUID)object5, (UUID)object6);
    }
}

