/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute.xplain;

import java.util.Properties;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.impl.sql.catalog.XPLAINScanPropsDescriptor;
import org.apache.derby.impl.sql.catalog.XPLAINSortPropsDescriptor;

public class XPLAINUtil {
    public static final String ISOLATION_READ_UNCOMMITED = "RU";
    public static final String ISOLATION_READ_COMMIT = "RC";
    public static final String ISOLATION_REPEAT_READ = "RR";
    public static final String ISOLATION_SERIALIZABLE = "SE";
    public static final String LOCK_MODE_EXCLUSIVE = "EX";
    public static final String LOCK_MODE_INSTANTENOUS_EXCLUSIVE = "IX";
    public static final String LOCK_MODE_SHARE = "SH";
    public static final String LOCK_MODE_INSTANTENOUS_SHARE = "IS";
    public static final String LOCK_GRANULARITY_TABLE = "T";
    public static final String LOCK_GRANULARITY_ROW = "R";
    public static final String OP_TABLESCAN = "TABLESCAN";
    public static final String OP_INDEXSCAN = "INDEXSCAN";
    public static final String OP_HASHSCAN = "HASHSCAN";
    public static final String OP_DISTINCTSCAN = "DISTINCTSCAN";
    public static final String OP_LASTINDEXKEYSCAN = "LASTINDEXKEYSCAN";
    public static final String OP_HASHTABLE = "HASHTABLE";
    public static final String OP_ROWIDSCAN = "ROWIDSCAN";
    public static final String OP_CONSTRAINTSCAN = "CONSTRAINTSCAN";
    public static final String OP_JOIN_NL = "NLJOIN";
    public static final String OP_JOIN_HASH = "HASHJOIN";
    public static final String OP_JOIN_NL_LO = "LONLJOIN";
    public static final String OP_JOIN_HASH_LO = "LOHASHJOIN";
    public static final String OP_UNION = "UNION";
    public static final String OP_SET = "SET";
    public static final String OP_SET_INTERSECT = "EXCEPT";
    public static final String OP_SET_EXCEPT = "INTERSECT";
    public static final String OP_INSERT = "INSERT";
    public static final String OP_UPDATE = "UPDATE";
    public static final String OP_DELETE = "DELETE";
    public static final String OP_CASCADE = "CASCADE";
    public static final String OP_VTI = "VTI";
    public static final String OP_BULK = "BULK";
    public static final String OP_DISTINCT = "DISTINCT";
    public static final String OP_NORMALIZE = "NORMALIZE";
    public static final String OP_ANY = "ANY";
    public static final String OP_SCROLL = "SCROLL";
    public static final String OP_MATERIALIZE = "MATERIALIZE";
    public static final String OP_ONCE = "ONCE";
    public static final String OP_VTI_RS = "VTI";
    public static final String OP_ROW = "ROW";
    public static final String OP_PROJECT = "PROJECTION";
    public static final String OP_FILTER = "FILTER";
    public static final String OP_AGGREGATE = "AGGREGATION";
    public static final String OP_PROJ_RESTRICT = "PROJECT-FILTER";
    public static final String OP_SORT = "SORT";
    public static final String OP_GROUP = "GROUPBY";
    public static final String OP_CURRENT_OF = "CURRENT-OF";
    public static final String OP_ROW_COUNT = "ROW-COUNT";
    public static final String OP_WINDOW = "WINDOW";
    public static final String SCAN_HEAP = "HEAP";
    public static final String SCAN_BTREE = "BTREE";
    public static final String SCAN_SORT = "SORT";
    public static final String SCAN_BITSET_ALL = "ALL";
    public static final String SELECT_STMT_TYPE = "S";
    public static final String SELECT_APPROXIMATE_STMT_TYPE = "SA";
    public static final String INSERT_STMT_TYPE = "I";
    public static final String UPDATE_STMT_TYPE = "U";
    public static final String DELETE_STMT_TYPE = "D";
    public static final String CALL_STMT_TYPE = "C";
    public static final String DDL_STMT_TYPE = "DDL";
    public static final String XPLAIN_ONLY = "O";
    public static final String XPLAIN_FULL = "F";
    public static final String SORT_EXTERNAL = "EX";
    public static final String SORT_INTERNAL = "IN";
    public static final String YES_CODE = "Y";
    public static final String NO_CODE = "N";

    public static String getYesNoCharFromBoolean(boolean bl) {
        if (bl) {
            return YES_CODE;
        }
        return NO_CODE;
    }

    public static String getHashKeyColumnNumberString(int[] nArray) {
        String string2;
        if (nArray.length == 1) {
            string2 = MessageService.getTextMessage("43X53.U") + " " + nArray[0];
        } else {
            string2 = MessageService.getTextMessage("43X54.U") + " (" + nArray[0];
            for (int i = 1; i < nArray.length; ++i) {
                string2 = string2 + "," + nArray[i];
            }
            string2 = string2 + ")";
        }
        return string2;
    }

    public static String getLockModeCode(String string2) {
        if ((string2 = string2.toUpperCase()).startsWith("EXCLUSIVE")) {
            return "EX";
        }
        if (string2.startsWith("SHARE")) {
            return LOCK_MODE_SHARE;
        }
        if (string2.startsWith("INSTANTANEOUS")) {
            int n;
            int n2 = "INSTANTANEOUS".length();
            String string3 = string2.substring(n2 + 1, n = string2.length());
            if (string3.startsWith("EXCLUSIVE")) {
                return LOCK_MODE_INSTANTENOUS_EXCLUSIVE;
            }
            if (string3.startsWith("SHARE")) {
                return LOCK_MODE_INSTANTENOUS_SHARE;
            }
            return null;
        }
        return null;
    }

    public static String getIsolationLevelCode(String string2) {
        if (string2 == null) {
            return null;
        }
        if (string2.equals(MessageService.getTextMessage("42Z80.U"))) {
            return ISOLATION_SERIALIZABLE;
        }
        if (string2.equals(MessageService.getTextMessage("42Z92"))) {
            return ISOLATION_REPEAT_READ;
        }
        if (string2.equals(MessageService.getTextMessage("42Z81.U"))) {
            return ISOLATION_READ_COMMIT;
        }
        if (string2.equals(MessageService.getTextMessage("42Z9A"))) {
            return ISOLATION_READ_UNCOMMITED;
        }
        return null;
    }

    public static String getLockGranularityCode(String string2) {
        if ((string2 = string2.toUpperCase()).endsWith("TABLE")) {
            return LOCK_GRANULARITY_TABLE;
        }
        return LOCK_GRANULARITY_ROW;
    }

    public static String getStatementType(String string2) {
        String string3 = "";
        String string4 = string2.toUpperCase().trim();
        if (string4.startsWith("CALL")) {
            string3 = CALL_STMT_TYPE;
        } else if (string4.startsWith("SELECT")) {
            string3 = string4.indexOf("~") > -1 ? SELECT_APPROXIMATE_STMT_TYPE : SELECT_STMT_TYPE;
        } else if (string4.startsWith(OP_DELETE)) {
            string3 = DELETE_STMT_TYPE;
        } else if (string4.startsWith(OP_INSERT)) {
            string3 = INSERT_STMT_TYPE;
        } else if (string4.startsWith(OP_UPDATE)) {
            string3 = UPDATE_STMT_TYPE;
        } else if (string4.startsWith("CREATE") || string4.startsWith("ALTER") || string4.startsWith("DROP")) {
            string3 = DDL_STMT_TYPE;
        }
        return string3;
    }

    public static XPLAINScanPropsDescriptor extractScanProps(XPLAINScanPropsDescriptor xPLAINScanPropsDescriptor, Properties properties) {
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        String string7;
        String string8 = "";
        String string9 = properties.getProperty(MessageService.getTextMessage("XSAJ0.U"));
        if (string9 != null) {
            if (string9.equalsIgnoreCase(MessageService.getTextMessage("XSAJG.U"))) {
                string8 = SCAN_HEAP;
            } else if (string9.equalsIgnoreCase(MessageService.getTextMessage("XSAJH.U"))) {
                string8 = "SORT";
            } else if (string9.equalsIgnoreCase(MessageService.getTextMessage("XSAJF.U"))) {
                string8 = SCAN_BTREE;
            }
        } else {
            string8 = null;
        }
        xPLAINScanPropsDescriptor.setScan_type(string8);
        String string10 = properties.getProperty(MessageService.getTextMessage("XSAJ1.U"));
        if (string10 != null) {
            xPLAINScanPropsDescriptor.setNo_visited_pages(new Integer(string10));
        }
        if ((string7 = properties.getProperty(MessageService.getTextMessage("XSAJ2.U"))) != null) {
            xPLAINScanPropsDescriptor.setNo_visited_rows(new Integer(string7));
        }
        if ((string6 = properties.getProperty(MessageService.getTextMessage("XSAJ4.U"))) != null) {
            xPLAINScanPropsDescriptor.setNo_qualified_rows(new Integer(string6));
        }
        if ((string5 = properties.getProperty(MessageService.getTextMessage("XSAJ5.U"))) != null) {
            xPLAINScanPropsDescriptor.setNo_fetched_columns(new Integer(string5));
        }
        if ((string4 = properties.getProperty(MessageService.getTextMessage("XSAJ3.U"))) != null) {
            xPLAINScanPropsDescriptor.setNo_visited_deleted_rows(new Integer(string4));
        }
        if ((string3 = properties.getProperty(MessageService.getTextMessage("XSAJ7.U"))) != null) {
            xPLAINScanPropsDescriptor.setBtree_height(new Integer(string3));
        }
        if ((string2 = properties.getProperty(MessageService.getTextMessage("XSAJ6.U"))) != null) {
            if (string2.equalsIgnoreCase(MessageService.getTextMessage("XSAJE.U"))) {
                xPLAINScanPropsDescriptor.setBitset_of_fetched_columns(SCAN_BITSET_ALL);
            } else {
                xPLAINScanPropsDescriptor.setBitset_of_fetched_columns(string2);
            }
        }
        return xPLAINScanPropsDescriptor;
    }

    public static XPLAINSortPropsDescriptor extractSortProps(XPLAINSortPropsDescriptor xPLAINSortPropsDescriptor, Properties properties) {
        String string2;
        String string3 = null;
        String string4 = properties.getProperty(MessageService.getTextMessage("XSAJ8.U"));
        if (string4 != null) {
            string3 = string4.equalsIgnoreCase(MessageService.getTextMessage("XSAJI.U")) ? "EX" : SORT_INTERNAL;
        }
        xPLAINSortPropsDescriptor.setSort_type(string3);
        String string5 = properties.getProperty(MessageService.getTextMessage("XSAJA.U"));
        if (string5 != null) {
            xPLAINSortPropsDescriptor.setNo_input_rows(new Integer(string5));
        }
        if ((string2 = properties.getProperty(MessageService.getTextMessage("XSAJB.U"))) != null) {
            xPLAINSortPropsDescriptor.setNo_output_rows(new Integer(string2));
        }
        if (string3 == "EX") {
            String string6;
            String string7 = properties.getProperty(MessageService.getTextMessage("XSAJC.U"));
            if (string7 != null) {
                xPLAINSortPropsDescriptor.setNo_merge_runs(new Integer(string7));
            }
            if ((string6 = properties.getProperty(MessageService.getTextMessage("XSAJD.U"))) != null) {
                xPLAINSortPropsDescriptor.setMerge_run_details(string6);
            }
        }
        return xPLAINSortPropsDescriptor;
    }

    public static Long getAVGNextTime(long l, long l2) {
        if (l2 == 0L) {
            return null;
        }
        if (l == 0L) {
            return new Long(0L);
        }
        return new Long(l / l2);
    }
}

