/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.jdbc;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Locale;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.derby.iapi.jdbc.JDBCBoot;
import org.apache.derby.impl.jdbc.Util;
import org.apache.derby.jdbc.InternalDriver;

public final class EmbeddedSimpleDataSource
implements DataSource {
    private String password;
    private String user;
    private String databaseName;
    private String dataSourceName;
    private String description;
    private String createDatabase;
    private String shutdownDatabase;
    private String connectionAttributes;
    private transient PrintWriter printer;
    private transient int loginTimeout;
    private transient InternalDriver driver;
    private transient String jdbcurl;

    public EmbeddedSimpleDataSource() {
        this.update();
    }

    public int getLoginTimeout() throws SQLException {
        return this.loginTimeout;
    }

    public void setLoginTimeout(int n) throws SQLException {
        this.loginTimeout = n;
    }

    public PrintWriter getLogWriter() throws SQLException {
        return this.printer;
    }

    public void setLogWriter(PrintWriter printWriter) throws SQLException {
        this.printer = printWriter;
    }

    public final synchronized void setDatabaseName(String string2) {
        this.databaseName = string2;
        this.update();
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public final void setDataSourceName(String string2) {
        this.dataSourceName = string2;
    }

    public final String getDataSourceName() {
        return this.dataSourceName;
    }

    public final void setDescription(String string2) {
        this.description = string2;
    }

    public final String getDescription() {
        return this.description;
    }

    public final void setUser(String string2) {
        this.user = string2;
    }

    public final String getUser() {
        return this.user;
    }

    public final void setPassword(String string2) {
        this.password = string2;
    }

    public final String getPassword() {
        return this.password;
    }

    public final void setCreateDatabase(String string2) {
        this.createDatabase = string2 != null && string2.toLowerCase(Locale.ENGLISH).equals("create") ? string2 : null;
    }

    public final String getCreateDatabase() {
        return this.createDatabase;
    }

    public final void setShutdownDatabase(String string2) {
        this.shutdownDatabase = string2 != null && string2.equalsIgnoreCase("shutdown") ? string2 : null;
    }

    public final String getShutdownDatabase() {
        return this.shutdownDatabase;
    }

    public final void setConnectionAttributes(String string2) {
        this.connectionAttributes = string2;
        this.update();
    }

    public final String getConnectionAttributes() {
        return this.connectionAttributes;
    }

    public final Connection getConnection() throws SQLException {
        return this.getConnection(this.getUser(), this.getPassword());
    }

    public final Connection getConnection(String string2, String string3) throws SQLException {
        Connection connection;
        Properties properties = new Properties();
        if (string2 != null) {
            properties.put("user", string2);
        }
        if (string3 != null) {
            properties.put("password", string3);
        }
        if (this.createDatabase != null) {
            properties.put("create", "true");
        }
        if (this.shutdownDatabase != null) {
            properties.put("shutdown", "true");
        }
        if ((connection = this.findDriver().connect(this.jdbcurl, properties, this.loginTimeout)) == null) {
            throw Util.generateCsSQLException("XCY00.S", (Object)"databaseName", this.getDatabaseName());
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InternalDriver findDriver() throws SQLException {
        String string2 = this.jdbcurl;
        if (this.driver == null || !this.driver.acceptsURL(string2)) {
            EmbeddedSimpleDataSource embeddedSimpleDataSource = this;
            synchronized (embeddedSimpleDataSource) {
                if (this.driver == null || !this.driver.acceptsURL(string2)) {
                    new JDBCBoot().boot("jdbc:derby:", new PrintWriter(System.err, true));
                    this.driver = InternalDriver.activeDriver();
                    if (this.driver == null) {
                        throw Util.generateCsSQLException("08006.C.8");
                    }
                }
            }
        }
        return this.driver;
    }

    private void update() {
        StringBuffer stringBuffer = new StringBuffer(64);
        stringBuffer.append("jdbc:derby:");
        String string2 = this.getDatabaseName();
        if (string2 != null) {
            string2 = string2.trim();
        }
        if (string2 == null || string2.length() == 0) {
            string2 = " ";
        }
        stringBuffer.append(string2);
        String string3 = this.getConnectionAttributes();
        if (string3 != null && (string3 = string3.trim()).length() != 0) {
            stringBuffer.append(';');
            stringBuffer.append(this.connectionAttributes);
        }
        this.jdbcurl = stringBuffer.toString();
    }
}

