/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.io;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.apache.jena.atlas.AtlasException;
import org.apache.jena.atlas.io.CharStream;
import org.apache.jena.atlas.io.CharStreamBuffered;
import org.apache.jena.atlas.io.CharStreamSequence;
import org.apache.jena.atlas.io.IO;

public final class PeekReader
extends Reader {
    private final CharStream source;
    private static final int PUSHBACK_SIZE = 10;
    static final byte CHAR0 = 0;
    private char[] pushbackChars;
    private int idxPushback;
    private int currChar = -2;
    private long posn;
    public static final int INIT_LINE = 1;
    public static final int INIT_COL = 1;
    private long colNum;
    private long lineNum;

    public static PeekReader make(Reader r) {
        if (r instanceof PeekReader) {
            return (PeekReader)r;
        }
        return PeekReader.make(r, 131072);
    }

    public static PeekReader make(Reader r, int bufferSize) {
        return new PeekReader(new CharStreamBuffered(r, bufferSize));
    }

    public static PeekReader makeUTF8(InputStream in) {
        Reader r = IO.asUTF8(in);
        PeekReader pr = PeekReader.make(r);
        int ch = pr.peekChar();
        if (ch == 65279) {
            pr.readChar();
        }
        return pr;
    }

    public static PeekReader makeASCII(InputStream in) {
        Reader r = IO.asASCII(in);
        return PeekReader.make(r);
    }

    public static PeekReader make(CharStream r) {
        return new PeekReader(r);
    }

    public static PeekReader readString(String string2) {
        return new PeekReader(new CharStreamSequence(string2));
    }

    public static PeekReader open(String filename) {
        try {
            FileInputStream in = new FileInputStream(filename);
            return PeekReader.makeUTF8(in);
        }
        catch (FileNotFoundException ex) {
            throw new AtlasException("File not found: " + filename);
        }
    }

    private PeekReader(CharStream stream) {
        this.source = stream;
        this.pushbackChars = new char[10];
        this.idxPushback = -1;
        this.colNum = 1L;
        this.lineNum = 1L;
        this.posn = 0L;
    }

    public long getLineNum() {
        return this.lineNum;
    }

    public long getColNum() {
        return this.colNum;
    }

    public long getPosition() {
        return this.posn;
    }

    public final int peekChar() {
        if (this.idxPushback >= 0) {
            return this.pushbackChars[this.idxPushback];
        }
        if (this.currChar == -2) {
            this.init();
        }
        return this.currChar;
    }

    private final void setCurrChar(int ch) {
        this.currChar = ch;
    }

    public final int readChar() {
        return this.nextChar();
    }

    public final void pushbackChar(int ch) {
        this.unreadChar(ch);
    }

    @Override
    public final void close() throws IOException {
        this.source.closeStream();
    }

    @Override
    public final int read() throws IOException {
        if (this.eof()) {
            return -1;
        }
        int x = this.readChar();
        return x;
    }

    @Override
    public final int read(char[] cbuf, int off, int len) throws IOException {
        if (this.eof()) {
            return -1;
        }
        for (int i = 0; i < len; ++i) {
            int ch = this.readChar();
            if (ch == -1) {
                return i == 0 ? -1 : i;
            }
            cbuf[i + off] = (char)ch;
        }
        return len;
    }

    public final boolean eof() {
        return this.peekChar() == -1;
    }

    private final void unreadChar(int ch) {
        if (this.idxPushback >= this.pushbackChars.length) {
            char[] pushbackChars2 = new char[this.pushbackChars.length * 2];
            System.arraycopy(this.pushbackChars, 0, pushbackChars2, 0, this.pushbackChars.length);
            this.pushbackChars = pushbackChars2;
        }
        if (ch == -1 || ch == -2) {
            IO.exception("Illegal character to push back: " + ch);
        }
        ++this.idxPushback;
        this.pushbackChars[this.idxPushback] = (char)ch;
    }

    private final void init() {
        this.advanceAndSet();
        if (this.currChar == -2) {
            this.setCurrChar(-1);
        }
    }

    private final void advanceAndSet() {
        int ch = this.source.advance();
        this.setCurrChar(ch);
    }

    private final int nextChar() {
        int ch = this.peekChar();
        if (ch == -1) {
            return -1;
        }
        if (this.idxPushback >= 0) {
            char ch2 = this.pushbackChars[this.idxPushback];
            --this.idxPushback;
            return ch2;
        }
        ++this.posn;
        if (ch == 10) {
            ++this.lineNum;
            this.colNum = 1L;
        } else {
            ++this.colNum;
        }
        this.advanceAndSet();
        return ch;
    }
}

