/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.swecommon20;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Level;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.stream.StreamSource;
import org.opengis.cite.swecommon20.SuiteAttribute;
import org.opengis.cite.swecommon20.TestRunArg;
import org.opengis.cite.swecommon20.util.TestSuiteLogger;
import org.opengis.cite.swecommon20.util.URIUtils;
import org.opengis.cite.swecommon20.util.ValidationUtils;
import org.opengis.cite.swecommon20.util.XMLUtils;
import org.testng.ISuite;
import org.testng.ISuiteListener;
import org.testng.Reporter;
import org.w3c.dom.Document;

public class SuiteFixtureListener
implements ISuiteListener {
    @Override
    public void onStart(ISuite suite) {
        this.processIUTParameter(suite);
        this.processXmlReference(suite);
        this.processSchematronSchema(suite);
    }

    @Override
    public void onFinish(ISuite suite) {
        Reporter.clear();
        Reporter.log("Test suite parameters:");
        Reporter.log(suite.getXmlSuite().getAllParameters().toString());
    }

    void processSuiteParameters(ISuite suite) {
        Map<String, String> params = suite.getXmlSuite().getParameters();
        TestSuiteLogger.log(Level.CONFIG, "Suite parameters\n" + params.toString());
        String iutParam = params.get(TestRunArg.IUT.toString());
        if (null == iutParam || iutParam.isEmpty()) {
            throw new IllegalArgumentException("Required test run parameter not found: " + TestRunArg.IUT.toString());
        }
        URI iutRef = URI.create(iutParam.trim());
        File entityFile = null;
        try {
            entityFile = URIUtils.dereferenceURI(iutRef);
        }
        catch (IOException iox) {
            throw new RuntimeException("Failed to dereference resource located at " + iutRef, iox);
        }
        Document iutDoc = null;
        try {
            iutDoc = URIUtils.parseURI(entityFile.toURI());
        }
        catch (Exception x) {
            throw new RuntimeException("Failed to parse resource retrieved from " + iutRef, x);
        }
        suite.setAttribute(SuiteAttribute.TEST_SUBJECT.getName(), iutDoc);
        if (TestSuiteLogger.isLoggable(Level.FINE)) {
            StringBuilder logMsg = new StringBuilder("Parsed resource retrieved from ");
            logMsg.append(iutRef).append("\n");
            logMsg.append(XMLUtils.writeNodeToString(iutDoc));
            TestSuiteLogger.log(Level.FINE, logMsg.toString());
        }
    }

    void processXmlReference(ISuite suite) {
        HashSet<URI> schemaURIs;
        block9: {
            Map<String, String> params = suite.getXmlSuite().getParameters();
            TestSuiteLogger.log(Level.CONFIG, String.format("Suite parameters:\n %s", params));
            schemaURIs = new HashSet<URI>();
            String xsdURI = params.get(TestRunArg.XSD.toString());
            if (null != xsdURI && !xsdURI.isEmpty()) {
                schemaURIs.add(URI.create(xsdURI));
                suite.setAttribute(SuiteAttribute.SCHEMA_LOC_SET.getName(), schemaURIs);
                return;
            }
            String xmlURI = params.get(TestRunArg.XML.toString());
            if (null == xmlURI || xmlURI.isEmpty()) {
                throw new IllegalArgumentException("Missing XML resource (document or application schema).");
            }
            File xmlFile = null;
            try {
                URI uriXml = URI.create(xmlURI);
                xmlFile = URIUtils.resolveURIAsFile(uriXml);
                if (null == xmlFile || !xmlFile.exists()) {
                    throw new IllegalArgumentException("Failed to dereference URI: " + xmlURI);
                }
                if (XMLUtils.isXMLSchema(xmlFile)) {
                    params.put(TestRunArg.XSD.toString(), xmlURI);
                    schemaURIs.add(URI.create(xmlURI));
                    break block9;
                }
                schemaURIs.addAll(ValidationUtils.extractSchemaReferences(new StreamSource(xmlFile), xmlURI));
                suite.setAttribute(SuiteAttribute.XML.getName(), xmlFile);
                Document iutDoc = null;
                try {
                    iutDoc = URIUtils.parseURI(uriXml);
                }
                catch (Exception x) {
                    throw new RuntimeException("Failed to parse resource retrieved from " + xmlURI, x);
                }
                suite.setAttribute(SuiteAttribute.TEST_SUBJECT.getName(), iutDoc);
                TestSuiteLogger.log(Level.FINE, "Wrote XML document to " + xmlFile.getAbsolutePath());
                suite.setAttribute(SuiteAttribute.TEST_SUBJECT_URI.getName(), URI.create(xmlURI));
            }
            catch (IOException iox) {
                throw new RuntimeException("Failed to read resource obtained from " + xmlURI, iox);
            }
            catch (XMLStreamException xse) {
                throw new RuntimeException("Failed to find schema reference in source: " + xmlFile.getAbsolutePath(), xse);
            }
        }
        suite.setAttribute(SuiteAttribute.SCHEMA_LOC_SET.getName(), schemaURIs);
        TestSuiteLogger.log(Level.FINE, String.format("Schema references: %s", schemaURIs));
    }

    void processSchematronSchema(ISuite suite) {
        Map<String, String> params = suite.getXmlSuite().getParameters();
        String schRef = params.get(TestRunArg.SCH.toString());
        if (schRef != null && !schRef.isEmpty()) {
            URI schURI = URI.create(params.get(TestRunArg.SCH.toString()));
            suite.setAttribute(SuiteAttribute.SCHEMATRON.getName(), schURI);
        }
    }

    void processIUTParameter(ISuite suite) {
        Map<String, String> params = suite.getXmlSuite().getParameters();
        String iutRef = params.get(TestRunArg.IUT.toString());
        if (null == iutRef || iutRef.isEmpty()) {
            return;
        }
        try {
            File iutFile = URIUtils.resolveURIAsFile(URI.create(iutRef));
            if (XMLUtils.isXMLSchema(iutFile)) {
                params.put(TestRunArg.XSD.toString(), iutRef);
            } else {
                params.put(TestRunArg.XML.toString(), iutRef);
            }
        }
        catch (Exception x) {
            throw new RuntimeException("Failed to read resource from " + iutRef, x);
        }
        params.remove(TestRunArg.IUT.toString());
    }
}

