/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.pattern;

import com.thaiopensource.relaxng.pattern.DataDerivFailure;
import com.thaiopensource.relaxng.pattern.DataDerivFunction;
import com.thaiopensource.relaxng.pattern.DataDerivType;
import com.thaiopensource.relaxng.pattern.InconsistentDataDerivType;
import com.thaiopensource.relaxng.pattern.Pattern;
import com.thaiopensource.relaxng.pattern.PatternMemo;
import com.thaiopensource.relaxng.pattern.SingleDataDerivType;
import com.thaiopensource.relaxng.pattern.ValidatorPatternBuilder;
import java.util.List;
import org.relaxng.datatype.ValidationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BlankDataDerivType
extends DataDerivType {
    private PatternMemo blankMemo;
    private PatternMemo nonBlankMemo;

    BlankDataDerivType() {
    }

    @Override
    PatternMemo dataDeriv(ValidatorPatternBuilder validatorPatternBuilder, Pattern pattern, String string2, ValidationContext validationContext, List<DataDerivFailure> list) {
        if (DataDerivFunction.isBlank(string2)) {
            if (this.blankMemo == null || list != null && this.blankMemo.isNotAllowed()) {
                this.blankMemo = super.dataDeriv(validatorPatternBuilder, pattern, string2, validationContext, list);
            }
            return this.blankMemo;
        }
        if (this.nonBlankMemo == null || list != null && this.nonBlankMemo.isNotAllowed()) {
            this.nonBlankMemo = super.dataDeriv(validatorPatternBuilder, pattern, string2, validationContext, list);
        }
        return this.nonBlankMemo;
    }

    @Override
    DataDerivType copy() {
        return new BlankDataDerivType();
    }

    @Override
    DataDerivType combine(DataDerivType dataDerivType) {
        if (dataDerivType instanceof BlankDataDerivType || dataDerivType instanceof SingleDataDerivType) {
            return this;
        }
        return InconsistentDataDerivType.getInstance();
    }
}

