/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.validate.picl;

import com.thaiopensource.util.Localizer;
import com.thaiopensource.validate.picl.InvalidPatternException;
import com.thaiopensource.validate.picl.NamespaceContext;
import com.thaiopensource.validate.picl.Pattern;
import com.thaiopensource.validate.picl.PatternBuilder;
import com.thaiopensource.xml.sax.ErrorHandlerImpl;
import com.thaiopensource.xml.util.Naming;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

class PatternParser {
    private final ErrorHandler eh;
    private final Localizer localizer;
    private String pattern;
    private int patternOffset;
    private int patternLength;
    private int currentToken;
    private int tokenStartOffset;
    private String tokenNamespaceUri;
    private String tokenLocalName;
    private final PatternBuilder builder = new PatternBuilder();
    private NamespaceContext namespaceContext;
    private final StringBuffer nameBuffer = new StringBuffer();
    private static final int TOKEN_EOF = 0;
    private static final int TOKEN_SLASH = 1;
    private static final int TOKEN_SLASH_SLASH = 2;
    private static final int TOKEN_CHOICE = 3;
    private static final int TOKEN_CHILD_AXIS = 4;
    private static final int TOKEN_ATTRIBUTE_AXIS = 5;
    private static final int TOKEN_DOT = 6;
    private static final int TOKEN_QNAME = 7;
    private static final int TOKEN_NCNAME_STAR = 8;
    private static final int TOKEN_STAR = 9;
    private Locator locator;

    PatternParser(ErrorHandler errorHandler, Localizer localizer) {
        this.eh = errorHandler;
        this.localizer = localizer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Pattern parse(String string2, Locator locator, NamespaceContext namespaceContext) throws SAXException, InvalidPatternException {
        this.pattern = string2;
        this.patternOffset = 0;
        this.patternLength = string2.length();
        this.locator = locator;
        this.namespaceContext = namespaceContext;
        try {
            do {
                this.parseChoice();
            } while (this.currentToken == 3);
            Pattern pattern = this.builder.createPattern();
            return pattern;
        }
        finally {
            this.builder.cleanup();
        }
    }

    private void parseChoice() throws SAXException, InvalidPatternException {
        block6: while (true) {
            this.parseStep();
            this.advance();
            switch (this.currentToken) {
                case 1: {
                    continue block6;
                }
                case 2: {
                    this.builder.addDescendantsOrSelf();
                    continue block6;
                }
                case 3: {
                    this.builder.alternative();
                    return;
                }
                case 0: {
                    return;
                }
            }
            break;
        }
        throw this.error("expected_step_connector");
    }

    private void parseStep() throws SAXException, InvalidPatternException {
        byte by;
        this.advance();
        switch (this.currentToken) {
            case 5: {
                by = 1;
                this.advance();
                break;
            }
            case 4: {
                by = 0;
                this.advance();
                break;
            }
            case 6: {
                return;
            }
            default: {
                by = 0;
            }
        }
        switch (this.currentToken) {
            case 7: {
                this.builder.addName(by, this.tokenNamespaceUri, this.tokenLocalName);
                break;
            }
            case 9: {
                this.builder.addAnyName(by);
                break;
            }
            case 8: {
                this.builder.addNsName(by, this.tokenNamespaceUri);
                break;
            }
            default: {
                throw this.error("expected_name_test");
            }
        }
    }

    private void advance() throws SAXException, InvalidPatternException {
        block8: while (true) {
            this.tokenStartOffset = ++this.patternOffset;
            if (this.patternOffset >= this.patternLength) {
                this.currentToken = 0;
                return;
            }
            char c = this.pattern.charAt(this.patternOffset);
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    continue block8;
                }
                case '.': {
                    ++this.patternOffset;
                    this.currentToken = 6;
                    return;
                }
                case '@': {
                    ++this.patternOffset;
                    this.currentToken = 5;
                    return;
                }
                case '|': {
                    ++this.patternOffset;
                    this.currentToken = 3;
                    return;
                }
                case '/': {
                    if (++this.patternOffset < this.patternLength && this.pattern.charAt(this.patternOffset) == '/') {
                        ++this.patternOffset;
                        this.currentToken = 2;
                    } else {
                        this.currentToken = 1;
                    }
                    return;
                }
                case '*': {
                    ++this.patternOffset;
                    this.currentToken = 9;
                    return;
                }
            }
            break;
        }
        String string2 = this.scanNCName("illegal_char");
        if ((string2.equals("child") || string2.equals("attribute")) && this.tryScanDoubleColon()) {
            this.currentToken = string2.charAt(0) == 'c' ? 4 : 5;
            return;
        }
        if (this.patternOffset < this.patternLength && this.pattern.charAt(this.patternOffset) == ':') {
            this.tokenNamespaceUri = this.expandPrefix(string2);
            ++this.patternOffset;
            if (this.patternOffset == this.patternLength) {
                throw this.error("expected_star_or_ncname");
            }
            if (this.pattern.charAt(this.patternOffset) == '*') {
                ++this.patternOffset;
                this.currentToken = 8;
                return;
            }
            this.tokenLocalName = this.scanNCName("expected_star_or_ncname");
            this.currentToken = 7;
            return;
        }
        this.tokenLocalName = string2;
        this.tokenNamespaceUri = this.namespaceContext.defaultPrefix();
        this.currentToken = 7;
    }

    private boolean tryScanDoubleColon() {
        block4: for (int i = this.patternOffset; i < this.patternLength; ++i) {
            switch (this.pattern.charAt(i)) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    continue block4;
                }
                case ':': {
                    if (++i < this.patternLength && this.pattern.charAt(i) == ':') {
                        this.patternOffset = i + 1;
                        return true;
                    }
                }
                default: {
                    return false;
                }
            }
        }
        return false;
    }

    private String expandPrefix(String string2) throws SAXException, InvalidPatternException {
        String string3 = this.namespaceContext.getNamespaceUri(string2);
        if (string3 == null) {
            throw this.error("unbound_prefix", string2);
        }
        return string3;
    }

    private String scanNCName(String string2) throws SAXException, InvalidPatternException {
        char c;
        if (!PatternParser.maybeNameStartChar(c = this.pattern.charAt(this.patternOffset++))) {
            throw this.error(string2);
        }
        this.nameBuffer.setLength(0);
        this.nameBuffer.append(c);
        while (this.patternOffset < this.patternLength && PatternParser.maybeNameChar(c = this.pattern.charAt(this.patternOffset))) {
            this.nameBuffer.append(c);
            ++this.patternOffset;
        }
        String string3 = this.nameBuffer.toString();
        if (!Naming.isNcname(string3)) {
            throw this.error("illegal_ncname", string3);
        }
        return string3;
    }

    private static boolean maybeNameStartChar(char c) {
        return c > '\u0080' || Character.isLetter(c) || c == '_';
    }

    private static boolean maybeNameChar(char c) {
        return c > '\u0080' || Character.isLetterOrDigit(c) || ".-_".indexOf(c) >= 0;
    }

    private InvalidPatternException error(String string2) throws SAXException {
        if (this.eh != null) {
            this.eh.error(new SAXParseException(this.addContext(this.localizer.message(string2)), this.locator));
        }
        return new InvalidPatternException();
    }

    private InvalidPatternException error(String string2, String string3) throws SAXException {
        if (this.eh != null) {
            this.eh.error(new SAXParseException(this.addContext(this.localizer.message(string2, string3)), this.locator));
        }
        return new InvalidPatternException();
    }

    private String addContext(String string2) {
        return this.localizer.message("context", new Object[]{string2, this.pattern.substring(0, this.tokenStartOffset), this.pattern.substring(this.tokenStartOffset, this.patternOffset), this.pattern.substring(this.patternOffset)});
    }

    public static void main(String[] stringArray) throws SAXException {
        PatternParser patternParser = new PatternParser(new ErrorHandlerImpl(), new Localizer(PatternParser.class));
        String[] stringArray2 = new String[]{"foo//bar", ".", ".//.//././././/foo", "foo:bar", "bar:*", "*", "/", "foo/bar|bar/baz", "foo/", "", ".//.", ".//", "foo / @ bar", "child::foo:bar", "attribute::baz"};
        NamespaceContext namespaceContext = new NamespaceContext(){

            public String getNamespaceUri(String string2) {
                return "http://" + string2;
            }

            public String defaultPrefix() {
                return "";
            }
        };
        for (int i = 0; i < stringArray2.length; ++i) {
            try {
                Pattern pattern = patternParser.parse(stringArray2[i], null, namespaceContext);
                System.out.println(stringArray2[i] + " => " + pattern.toString());
                continue;
            }
            catch (InvalidPatternException invalidPatternException) {
                // empty catch block
            }
        }
    }
}

