/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.xml.out;

import java.io.UnsupportedEncodingException;

public class CharRepertoire {
    private final byte[] allUnknown = new byte[256];
    private final byte[][] charTable = new byte[256][];
    private static final byte UNKNOWN = 0;
    private static final byte IN = 1;
    private static final byte OUT = -1;
    private final String enc;

    CharRepertoire(String string2) {
        this.enc = string2;
        for (int i = 0; i < this.charTable.length; ++i) {
            this.charTable[i] = this.allUnknown;
        }
    }

    public static CharRepertoire getInstance(String string2) throws UnsupportedEncodingException {
        "x".getBytes(string2);
        return new CharRepertoire(string2);
    }

    public final boolean contains(char c) {
        byte by = this.charTable[c >> 8][c & 0xFF];
        return by == 0 ? this.contains1(c) : by > 0;
    }

    private boolean contains1(char c) {
        int n = c >> 8;
        if (this.charTable[n] == this.allUnknown) {
            this.charTable[n] = new byte[256];
        }
        if (this.contains2(c)) {
            this.charTable[n][c & 0xFF] = 1;
            return true;
        }
        this.charTable[n][c & 0xFF] = -1;
        return false;
    }

    private boolean contains2(char c) {
        try {
            String string2 = new String(new String(new char[]{c}).getBytes(this.enc), this.enc);
            return string2.length() == 1 && string2.charAt(0) == c;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return false;
        }
    }

    public final boolean contains(char c, char c2) {
        try {
            String string2 = new String(new String(new char[]{c, c2}).getBytes(this.enc), this.enc);
            return string2.length() == 2 && string2.charAt(0) == c && string2.charAt(1) == c2;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return false;
        }
        catch (RuntimeException runtimeException) {
            return false;
        }
    }
}

