/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.diag;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.apache.derby.iapi.error.PublicAPI;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.ResultColumnDescriptor;
import org.apache.derby.iapi.sql.conn.ConnectionUtil;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.RoleClosureIterator;
import org.apache.derby.iapi.sql.dictionary.RoleGrantDescriptor;
import org.apache.derby.iapi.util.IdUtil;
import org.apache.derby.impl.jdbc.EmbedResultSetMetaData;
import org.apache.derby.vti.VTITemplate;

public class ContainedRoles
extends VTITemplate {
    RoleClosureIterator rci;
    String nextRole;
    boolean initialized;
    String role;
    boolean inverse;
    private static final ResultColumnDescriptor[] columnInfo = new ResultColumnDescriptor[]{EmbedResultSetMetaData.getResultColumnDescriptor("ROLEID", 12, false, 128)};
    private static final ResultSetMetaData metadata = new EmbedResultSetMetaData(columnInfo);

    public ContainedRoles(String string2, int n) throws SQLException {
        try {
            if (string2 != null) {
                this.role = IdUtil.parseSQLIdentifier(string2);
            }
            this.inverse = n != 0;
        }
        catch (StandardException standardException) {
            throw PublicAPI.wrapStandardException(standardException);
        }
    }

    public ContainedRoles(String string2) throws SQLException {
        this(string2, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean next() throws SQLException {
        try {
            if (!this.initialized) {
                this.initialized = true;
                LanguageConnectionContext languageConnectionContext = ConnectionUtil.getCurrentLCC();
                DataDictionary dataDictionary = languageConnectionContext.getDataDictionary();
                RoleGrantDescriptor roleGrantDescriptor = dataDictionary.getRoleDefinitionDescriptor(this.role);
                if (roleGrantDescriptor != null) {
                    languageConnectionContext.beginNestedTransaction(true);
                    try {
                        int n = dataDictionary.startReading(languageConnectionContext);
                        try {
                            this.rci = dataDictionary.createRoleClosureIterator(languageConnectionContext.getLastActivation().getTransactionController(), this.role, !this.inverse);
                        }
                        finally {
                            dataDictionary.doneReading(n, languageConnectionContext);
                        }
                    }
                    finally {
                        languageConnectionContext.commitNestedTransaction();
                    }
                }
            }
            return this.rci != null && (this.nextRole = this.rci.next()) != null;
        }
        catch (StandardException standardException) {
            throw PublicAPI.wrapStandardException(standardException);
        }
    }

    public void close() {
    }

    public ResultSetMetaData getMetaData() {
        return metadata;
    }

    public String getString(int n) throws SQLException {
        return this.nextRole;
    }
}

