/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.io;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.derby.impl.io.vfmem.DataStore;
import org.apache.derby.impl.io.vfmem.PathUtil;
import org.apache.derby.impl.io.vfmem.VirtualFile;
import org.apache.derby.io.StorageFactory;
import org.apache.derby.io.StorageFile;
import org.apache.derby.io.WritableStorageFactory;

public class VFMemoryStorageFactory
implements StorageFactory,
WritableStorageFactory {
    private static final Map DATABASES = new HashMap();
    private static final DataStore DUMMY_STORE = new DataStore("::DUMMY::");
    private String canonicalName;
    private StorageFile dataDirectory;
    private StorageFile tempDir;
    private DataStore dbData;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(String string2, String string3, String string4, String string5) throws IOException {
        if (string3 != null) {
            this.canonicalName = string2 != null && !new File(string3).isAbsolute() ? new File(string2, string3).getCanonicalPath() : new File(string3).getCanonicalPath();
            Map map = DATABASES;
            synchronized (map) {
                this.dbData = (DataStore)DATABASES.get(this.canonicalName);
                if (this.dbData != null && this.dbData.scheduledForDeletion()) {
                    DATABASES.remove(this.canonicalName);
                    this.dbData.purge();
                    this.dbDropCleanupInDummy(this.canonicalName);
                    this.dbData = null;
                }
                if (this.dbData == null) {
                    if (string5 != null) {
                        this.dbData = new DataStore(this.canonicalName);
                        DATABASES.put(this.canonicalName, this.dbData);
                    } else {
                        this.dbData = DUMMY_STORE;
                    }
                }
            }
            this.dataDirectory = new VirtualFile(this.canonicalName, this.dbData);
            this.tempDir = new VirtualFile(this.normalizePath(this.canonicalName, "tmp"), this.dbData);
        } else if (string2 != null) {
            String string6 = new File(string2).getCanonicalPath();
            this.dbData = DUMMY_STORE;
            this.dataDirectory = new VirtualFile(string6, this.dbData);
            this.tempDir = new VirtualFile(this.getSeparator() + "tmp", this.dbData);
        }
        if (string5 != null && this.tempDir != null && !this.tempDir.exists()) {
            this.tempDir.mkdirs();
            this.tempDir.limitAccessToOwner();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        if (this.dbData.scheduledForDeletion()) {
            DataStore dataStore;
            Map map = DATABASES;
            synchronized (map) {
                dataStore = (DataStore)DATABASES.remove(this.canonicalName);
                if (dataStore != null && dataStore == this.dbData) {
                    this.dbDropCleanupInDummy(this.canonicalName);
                }
            }
            if (dataStore != null && dataStore == this.dbData) {
                this.dbData.purge();
                this.dbData = null;
            }
        }
    }

    public String getCanonicalName() {
        return this.canonicalName;
    }

    public void setCanonicalName(String string2) {
        this.canonicalName = string2;
    }

    public StorageFile newStorageFile(String string2) {
        if (string2 == null) {
            return this.dataDirectory;
        }
        return new VirtualFile(this.normalizePath(string2), this.dbData);
    }

    public StorageFile newStorageFile(String string2, String string3) {
        return new VirtualFile(this.normalizePath(string2, string3), this.dbData);
    }

    public StorageFile newStorageFile(StorageFile storageFile, String string2) {
        return this.newStorageFile(storageFile == null ? null : storageFile.getPath(), string2);
    }

    public StorageFile getTempDir() {
        return this.tempDir;
    }

    public boolean isFast() {
        return true;
    }

    public boolean isReadOnlyDatabase() {
        return false;
    }

    public boolean supportsRandomAccess() {
        return true;
    }

    public int getStorageFactoryVersion() {
        return 1;
    }

    public StorageFile createTemporaryFile(String string2, String string3) {
        if (string3 == null) {
            string3 = ".tmp";
        }
        String string4 = string2 == null ? this.dbData.getTempFileCounter() + string3 : string2 + this.dbData.getTempFileCounter() + string3;
        return this.newStorageFile(this.tempDir, string4);
    }

    public char getSeparator() {
        return PathUtil.SEP;
    }

    public void sync(OutputStream outputStream, boolean bl) {
    }

    public boolean supportsWriteSync() {
        return true;
    }

    private String normalizePath(String string2, String string3) {
        if (string2 == null || string2.length() == 0) {
            string2 = this.dataDirectory.getPath();
        } else if (!new File(string2).isAbsolute()) {
            string2 = new File(this.dataDirectory.getPath(), string2).getPath();
        }
        return new File(string2, string3).getPath();
    }

    private String normalizePath(String string2) {
        if (string2 == null || string2.length() == 0) {
            return this.dataDirectory.getPath();
        }
        if (new File(string2).isAbsolute()) {
            return string2;
        }
        return new File(this.dataDirectory.getPath(), string2).getPath();
    }

    private void dbDropCleanupInDummy(String string2) {
        while (string2 != null && DUMMY_STORE.deleteEntry(string2)) {
            string2 = new File(string2).getParent();
        }
    }
}

