/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.LocalField;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.loader.ClassFactory;
import org.apache.derby.iapi.sql.compile.Optimizable;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.impl.sql.compile.AndNode;
import org.apache.derby.impl.sql.compile.BinaryComparisonOperatorNode;
import org.apache.derby.impl.sql.compile.BinaryListOperatorNode;
import org.apache.derby.impl.sql.compile.BinaryOperatorNode;
import org.apache.derby.impl.sql.compile.CastNode;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.ConstantNode;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.ParameterNode;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.ValueNode;

public final class InListOperatorNode
extends BinaryListOperatorNode {
    private boolean isOrdered;
    private boolean sortDescending;

    public void init(Object object, Object object2) {
        this.init(object, object2, "IN", "in");
    }

    public String toString() {
        return "";
    }

    protected InListOperatorNode shallowCopy() throws StandardException {
        InListOperatorNode inListOperatorNode = (InListOperatorNode)this.getNodeFactory().getNode(55, this.leftOperand, this.rightOperandList, this.getContextManager());
        inListOperatorNode.copyFields(this);
        if (this.isOrdered) {
            inListOperatorNode.markAsOrdered();
        }
        if (this.sortDescending) {
            inListOperatorNode.markSortDescending();
        }
        return inListOperatorNode;
    }

    public ValueNode preprocess(int n, FromList fromList, SubqueryList subqueryList, PredicateList predicateList) throws StandardException {
        super.preprocess(n, fromList, subqueryList, predicateList);
        if (this.rightOperandList.size() == 1) {
            BinaryComparisonOperatorNode binaryComparisonOperatorNode = (BinaryComparisonOperatorNode)this.getNodeFactory().getNode(41, this.leftOperand, (ValueNode)this.rightOperandList.elementAt(0), Boolean.FALSE, this.getContextManager());
            binaryComparisonOperatorNode.bindComparisonOperator();
            return binaryComparisonOperatorNode;
        }
        DataTypeDescriptor dataTypeDescriptor = this.getDominantType();
        int n2 = dataTypeDescriptor.getTypeId().typePrecedence();
        if (this.leftOperand.getTypeServices().getTypeId().typePrecedence() != n2 && !this.rightOperandList.allSamePrecendence(n2)) {
            CastNode castNode = (CastNode)this.getNodeFactory().getNode(60, this.leftOperand, dataTypeDescriptor, this.getContextManager());
            castNode.bindCastNodeOnly();
            this.leftOperand = castNode;
        }
        if (this.leftOperand instanceof ColumnReference && this.rightOperandList.containsOnlyConstantAndParamNodes()) {
            Object object;
            Object object2;
            ValueNode valueNode;
            Object object3;
            boolean bl = this.rightOperandList.containsAllConstantNodes();
            if (bl) {
                object3 = dataTypeDescriptor.getNull();
                this.rightOperandList.sortInAscendingOrder((DataValueDescriptor)object3);
                this.isOrdered = true;
                valueNode = (ValueNode)this.rightOperandList.elementAt(0);
                object2 = (ValueNode)this.rightOperandList.elementAt(this.rightOperandList.size() - 1);
                object = ((ConstantNode)valueNode).getValue();
                DataValueDescriptor dataValueDescriptor = ((ConstantNode)object2).getValue();
                if (object3.equals((DataValueDescriptor)object, dataValueDescriptor).equals(true)) {
                    BinaryComparisonOperatorNode binaryComparisonOperatorNode = (BinaryComparisonOperatorNode)this.getNodeFactory().getNode(41, this.leftOperand, valueNode, Boolean.FALSE, this.getContextManager());
                    binaryComparisonOperatorNode.bindComparisonOperator();
                    return binaryComparisonOperatorNode;
                }
            }
            object3 = (ValueNode)this.rightOperandList.elementAt(0);
            valueNode = (ParameterNode)this.getNodeFactory().getNode(88, new Integer(0), null, this.getContextManager());
            object2 = ((ValueNode)object3).getTypeServices();
            ((ParameterNode)valueNode).setType((DataTypeDescriptor)object2);
            ((ParameterNode)valueNode).setValueToGenerate((ValueNode)object3);
            object = (BinaryComparisonOperatorNode)this.getNodeFactory().getNode(41, this.leftOperand, valueNode, this, Boolean.FALSE, this.getContextManager());
            ((BinaryComparisonOperatorNode)object).bindComparisonOperator();
            return object;
        }
        return this;
    }

    private DataTypeDescriptor getDominantType() {
        DataTypeDescriptor dataTypeDescriptor = this.leftOperand.getTypeServices();
        TypeId typeId = dataTypeDescriptor.getTypeId();
        if (!this.rightOperandList.allSamePrecendence(typeId.typePrecedence())) {
            ClassFactory classFactory = this.getClassFactory();
            int n = this.rightOperandList.size();
            for (int i = 0; i < n; ++i) {
                ValueNode valueNode = (ValueNode)this.rightOperandList.elementAt(i);
                dataTypeDescriptor = dataTypeDescriptor.getDominantType(valueNode.getTypeServices(), classFactory);
            }
        }
        return dataTypeDescriptor;
    }

    ValueNode eliminateNots(boolean bl) throws StandardException {
        AndNode andNode = null;
        int n = this.rightOperandList.size();
        if (!bl) {
            return this;
        }
        ValueNode valueNode = this.leftOperand instanceof ColumnReference ? this.leftOperand.getClone() : this.leftOperand;
        BinaryComparisonOperatorNode binaryComparisonOperatorNode = (BinaryComparisonOperatorNode)this.getNodeFactory().getNode(47, valueNode, (ValueNode)this.rightOperandList.elementAt(0), Boolean.FALSE, this.getContextManager());
        binaryComparisonOperatorNode.bindComparisonOperator();
        BinaryOperatorNode binaryOperatorNode = binaryComparisonOperatorNode;
        for (int i = 1; i < n; ++i) {
            valueNode = this.leftOperand instanceof ColumnReference ? this.leftOperand.getClone() : this.leftOperand;
            BinaryComparisonOperatorNode binaryComparisonOperatorNode2 = (BinaryComparisonOperatorNode)this.getNodeFactory().getNode(47, valueNode, (ValueNode)this.rightOperandList.elementAt(i), Boolean.FALSE, this.getContextManager());
            binaryComparisonOperatorNode2.bindComparisonOperator();
            andNode = (AndNode)this.getNodeFactory().getNode(39, binaryOperatorNode, binaryComparisonOperatorNode2, this.getContextManager());
            andNode.postBindFixup();
            binaryOperatorNode = andNode;
        }
        return binaryOperatorNode;
    }

    public boolean selfReference(ColumnReference columnReference) throws StandardException {
        int n = this.rightOperandList.size();
        for (int i = 0; i < n; ++i) {
            ValueNode valueNode = (ValueNode)this.rightOperandList.elementAt(i);
            if (!valueNode.getTablesReferenced().get(columnReference.getTableNumber())) continue;
            return true;
        }
        return false;
    }

    public double selectivity(Optimizable optimizable) {
        return 0.3;
    }

    public void generateExpression(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        int n = this.rightOperandList.size();
        String string2 = "org.apache.derby.iapi.types.DataValueDescriptor";
        String string3 = "org.apache.derby.iapi.types.DataValueDescriptor";
        String string4 = "org.apache.derby.iapi.types.DataValueDescriptor[]";
        this.receiver = this.leftOperand;
        String string5 = this.getTypeCompiler().interfaceName();
        LocalField localField = this.generateListAsArray(expressionClassBuilder, methodBuilder);
        this.leftOperand.generateExpression(expressionClassBuilder, methodBuilder);
        methodBuilder.dup();
        methodBuilder.upCast(string3);
        methodBuilder.getField(localField);
        methodBuilder.push(this.isOrdered);
        methodBuilder.callMethod((short)185, string2, this.methodName, string5, 3);
    }

    protected LocalField generateListAsArray(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        int n = this.rightOperandList.size();
        LocalField localField = expressionClassBuilder.newFieldDeclaration(2, "org.apache.derby.iapi.types.DataValueDescriptor[]");
        MethodBuilder methodBuilder2 = expressionClassBuilder.getConstructor();
        methodBuilder2.pushNewArray("org.apache.derby.iapi.types.DataValueDescriptor", n);
        methodBuilder2.setField(localField);
        int n2 = 0;
        MethodBuilder methodBuilder3 = null;
        MethodBuilder methodBuilder4 = methodBuilder2;
        for (int i = 0; i < n; ++i) {
            MethodBuilder methodBuilder5;
            if (this.rightOperandList.elementAt(i) instanceof ConstantNode) {
                ++n2;
                if (methodBuilder4.statementNumHitLimit(1)) {
                    MethodBuilder methodBuilder6 = expressionClassBuilder.newGeneratedFun("void", 2);
                    methodBuilder4.pushThis();
                    methodBuilder4.callMethod((short)182, null, methodBuilder6.getName(), "void", 0);
                    if (methodBuilder4 != methodBuilder2) {
                        methodBuilder4.methodReturn();
                        methodBuilder4.complete();
                    }
                    methodBuilder4 = methodBuilder6;
                }
                methodBuilder5 = methodBuilder4;
            } else {
                if (methodBuilder3 == null) {
                    methodBuilder3 = expressionClassBuilder.newGeneratedFun("void", 4);
                }
                methodBuilder5 = methodBuilder3;
            }
            methodBuilder5.getField(localField);
            ((ValueNode)this.rightOperandList.elementAt(i)).generateExpression(expressionClassBuilder, methodBuilder5);
            methodBuilder5.upCast("org.apache.derby.iapi.types.DataValueDescriptor");
            methodBuilder5.setArrayElement(i);
        }
        if (methodBuilder4 != methodBuilder2) {
            methodBuilder4.methodReturn();
            methodBuilder4.complete();
        }
        if (methodBuilder3 != null) {
            methodBuilder3.methodReturn();
            methodBuilder3.complete();
            methodBuilder.pushThis();
            methodBuilder.callMethod((short)182, null, methodBuilder3.getName(), "void", 0);
        }
        return localField;
    }

    public void generateStartStopKey(boolean bl, boolean bl2, ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        int n;
        int n2;
        int n3 = this.leftOperand.getTypeId().getTypeFormatId();
        int n4 = this.leftOperand.getTypeServices().getPrecision();
        int n5 = this.leftOperand.getTypeServices().getScale();
        boolean bl3 = this.leftOperand.getTypeServices().isNullable();
        int n6 = this.leftOperand.getTypeServices().getMaximumWidth();
        int n7 = this.leftOperand.getTypeServices().getCollationType();
        int n8 = this.leftOperand.getTypeServices().getCollationDerivation();
        int n9 = this.leftOperand.getTypeId().isUserDefinedTypeId() ? this.leftOperand.getTypeId().getJDBCTypeId() : -1;
        int n10 = this.rightOperandList.size();
        int n11 = 0;
        if (n10 < 5) {
            n2 = 1;
            n = (n10 - 1) % 4 + 1;
        } else {
            n2 = (n10 - 5) / 3 + 2;
            n = (n10 - 5) % 3 + 1;
        }
        for (int i = 0; i < n2; ++i) {
            Object object;
            int n12;
            int n13 = i == n2 - 1 ? n : (i == 0 ? 4 : 3);
            for (n12 = 0; n12 < n13; ++n12) {
                object = (ValueNode)this.rightOperandList.elementAt(n11++);
                ((ValueNode)object).generateExpression(expressionClassBuilder, methodBuilder);
                methodBuilder.upCast("org.apache.derby.iapi.types.DataValueDescriptor");
            }
            n12 = i < n2 - 1 ? 0 : (i == 0 ? 4 - n : 3 - n);
            for (int j = 0; j < n12; ++j) {
                methodBuilder.pushNull("org.apache.derby.iapi.types.DataValueDescriptor");
            }
            methodBuilder.push(n3);
            methodBuilder.push(n9);
            methodBuilder.push(n4);
            methodBuilder.push(n5);
            methodBuilder.push(bl3);
            methodBuilder.push(n6);
            methodBuilder.push(n7);
            methodBuilder.push(n8);
            object = bl && bl2 || !bl && !bl2 ? "minValue" : "maxValue";
            methodBuilder.callMethod((short)184, "org.apache.derby.impl.sql.execute.BaseExpressionActivation", (String)object, "org.apache.derby.iapi.types.DataValueDescriptor", 12);
        }
    }

    protected void markAsOrdered() {
        this.isOrdered = true;
    }

    protected void markSortDescending() {
        this.sortDescending = true;
    }

    protected boolean isOrdered() {
        return this.isOrdered;
    }

    protected boolean sortDescending() {
        return this.sortDescending;
    }
}

