/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.DataDescriptorGenerator;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.impl.sql.execute.DDLConstantAction;

class CreateSchemaConstantAction
extends DDLConstantAction {
    private final String aid;
    private final String schemaName;

    CreateSchemaConstantAction(String string2, String string3) {
        this.schemaName = string2;
        this.aid = string3;
    }

    public String toString() {
        return "CREATE SCHEMA " + this.schemaName;
    }

    public void executeConstantAction(Activation activation) throws StandardException {
        TransactionController transactionController = activation.getLanguageConnectionContext().getTransactionExecute();
        this.executeConstantActionMinion(activation, transactionController);
    }

    public void executeConstantAction(Activation activation, TransactionController transactionController) throws StandardException {
        this.executeConstantActionMinion(activation, transactionController);
    }

    private void executeConstantActionMinion(Activation activation, TransactionController transactionController) throws StandardException {
        LanguageConnectionContext languageConnectionContext = activation.getLanguageConnectionContext();
        DataDictionary dataDictionary = languageConnectionContext.getDataDictionary();
        DataDescriptorGenerator dataDescriptorGenerator = dataDictionary.getDataDescriptorGenerator();
        SchemaDescriptor schemaDescriptor = dataDictionary.getSchemaDescriptor(this.schemaName, languageConnectionContext.getTransactionExecute(), false);
        if (schemaDescriptor != null && schemaDescriptor.getUUID() != null) {
            throw StandardException.newException("X0Y68.S", (Object)"Schema", (Object)this.schemaName);
        }
        UUID uUID = dataDictionary.getUUIDFactory().createUUID();
        String string2 = this.aid;
        if (string2 == null) {
            string2 = languageConnectionContext.getCurrentUserId(activation);
        }
        dataDictionary.startWriting(languageConnectionContext);
        schemaDescriptor = dataDescriptorGenerator.newSchemaDescriptor(this.schemaName, string2, uUID);
        dataDictionary.addDescriptor(schemaDescriptor, null, 3, false, transactionController);
    }
}

