/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.iapi.types.DataValueDescriptor;

class SetSchemaConstantAction
implements ConstantAction {
    private final String schemaName;
    private final int type;

    SetSchemaConstantAction(String string2, int n) {
        this.schemaName = string2;
        this.type = n;
    }

    public String toString() {
        return "SET SCHEMA " + (this.type == 1 ? "USER" : (this.type == 2 && this.schemaName == null ? "?" : this.schemaName));
    }

    public void executeConstantAction(Activation activation) throws StandardException {
        Object object;
        LanguageConnectionContext languageConnectionContext = activation.getLanguageConnectionContext();
        DataDictionary dataDictionary = languageConnectionContext.getDataDictionary();
        String string2 = this.schemaName;
        if (this.type == 2) {
            object = activation.getParameterValueSet();
            DataValueDescriptor dataValueDescriptor = object.getParameter(0);
            string2 = dataValueDescriptor.getString();
            if (string2 == null || string2.length() > 128) {
                throw StandardException.newException("42815.S.713", "CURRENT SCHEMA");
            }
        } else if (this.type == 1) {
            string2 = languageConnectionContext.getCurrentUserId(activation);
        }
        object = dataDictionary.getSchemaDescriptor(string2, languageConnectionContext.getTransactionExecute(), true);
        languageConnectionContext.setDefaultSchema(activation, (SchemaDescriptor)object);
    }
}

